/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.instutil.wizard;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.text.JTextComponent;

public class SelectAllOnFocusListener {
    private final JTextComponent fText;
    private SelectAllBehavior fSelectAllBehavior;
    private boolean fShouldSelectAll = true;

    public SelectAllOnFocusListener(JTextComponent jTextComponent, SelectAllBehavior selectAllBehavior) {
        this.fText = jTextComponent;
        this.fSelectAllBehavior = selectAllBehavior;
        this.createAndInstallListeners();
    }

    private void createAndInstallListeners() {
        FocusListener focusListener = this.createFocusListener();
        MouseListener mouseListener = this.createMouseListener();
        this.fText.addFocusListener(focusListener);
        this.fText.addMouseListener(mouseListener);
    }

    private MouseListener createMouseListener() {
        return new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                SelectAllOnFocusListener.this.fShouldSelectAll = SelectAllOnFocusListener.this.fSelectAllBehavior != SelectAllBehavior.KEYBOARD;
            }
        };
    }

    private FocusListener createFocusListener() {
        return new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                SelectAllOnFocusListener.this.doFocusGained();
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                SelectAllOnFocusListener.this.doFocusLost(focusEvent.isTemporary());
            }
        };
    }

    private void doFocusGained() {
        if (this.fShouldSelectAll && this.fText.getWidth() > 0 && this.fText.getHeight() > 0) {
            this.fText.selectAll();
        }
    }

    private void doFocusLost(boolean bl) {
        if (bl) {
            this.fShouldSelectAll = false;
        } else {
            this.fShouldSelectAll = true;
            this.fText.getCaret().setDot(0);
        }
    }

    public static enum SelectAllBehavior {
        ALWAYS,
        KEYBOARD;

    }
}

