/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.converter;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.converter.ObjectConverter;
import com.jidesoft.converter.ObjectConverterManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ArrayConverter
implements ObjectConverter {
    private String _separator;
    private int _size;
    private Class<?> _elementClass;
    private Class<?>[] _elementClasses;

    public ArrayConverter(String string, int n, Class<?> clazz) {
        this._separator = string;
        this._size = n;
        this._elementClass = clazz;
    }

    public ArrayConverter(String string, int n, Class<?>[] classArray) {
        if (string == null || string.trim().length() == 0) {
            throw new IllegalArgumentException("separator cannot be empty.");
        }
        if (classArray == null) {
            throw new IllegalArgumentException("elementClasses cannot be null.");
        }
        if (n != classArray.length) {
            throw new IllegalArgumentException("size must be equal to the length of elementClasses.");
        }
        this._separator = string;
        this._size = n;
        this._elementClasses = classArray;
    }

    public String arrayToString(Object[] objectArray, ConverterContext converterContext) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            stringBuffer.append(this.toString(i, object, converterContext));
            if (i == objectArray.length - 1) continue;
            stringBuffer.append(this._separator);
        }
        return new String(stringBuffer);
    }

    protected String toString(int n, Object object, ConverterContext converterContext) {
        return this._elementClass != null ? ObjectConverterManager.toString(object, this._elementClass, converterContext) : ObjectConverterManager.toString(object, this._elementClasses[n], converterContext);
    }

    public Object[] arrayFromString(String string, ConverterContext converterContext) {
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        String[] stringArray = string.split(this._separator);
        Object[] objectArray = new Object[this._size != -1 ? this._size : stringArray.length];
        for (int i = 0; i < objectArray.length && i < stringArray.length; ++i) {
            String string2 = stringArray[i].trim();
            objectArray[i] = this.fromString(i, string2, converterContext);
        }
        return objectArray;
    }

    protected Object fromString(int n, String string, ConverterContext converterContext) {
        return this._elementClass != null ? ObjectConverterManager.fromString(string, this._elementClass, converterContext) : ObjectConverterManager.fromString(string, this._elementClasses[n], converterContext);
    }

    public Class<?> getElementClass() {
        return this._elementClass;
    }
}

