/*
 * Decompiled with CFR 0.152.
 */
package org.h2.result;

import java.io.ByteArrayOutputStream;
import java.sql.SQLException;
import org.h2.constant.SysProperties;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.message.Message;
import org.h2.result.ResultExternal;
import org.h2.result.SortOrder;
import org.h2.store.DataHandler;
import org.h2.store.DataPage;
import org.h2.store.FileStore;
import org.h2.util.ObjectArray;
import org.h2.value.Value;

class ResultDiskBuffer
implements ResultExternal {
    private static final int READ_AHEAD = 128;
    private DataPage rowBuff;
    private FileStore file;
    private ObjectArray tapes;
    private ResultDiskTape mainTape;
    private SortOrder sort;
    private int columnCount;

    ResultDiskBuffer(Session session, SortOrder sortOrder, int n) throws SQLException {
        this.sort = sortOrder;
        this.columnCount = n;
        Database database = session.getDatabase();
        this.rowBuff = DataPage.create((DataHandler)database, 512);
        String string = session.getDatabase().createTempFile();
        this.file = session.getDatabase().openFile(string, "rw", false);
        this.file.setCheckedWriting(false);
        this.file.seek(48L);
        if (sortOrder != null) {
            this.tapes = new ObjectArray();
        } else {
            this.mainTape = new ResultDiskTape();
            this.mainTape.pos = 48L;
        }
    }

    public void addRows(ObjectArray objectArray) throws SQLException {
        if (this.sort != null) {
            this.sort.sort(objectArray);
        }
        DataPage dataPage = this.rowBuff;
        long l = this.file.getFilePointer();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = 0;
        int n2 = SysProperties.LARGE_RESULT_BUFFER_SIZE;
        for (int i = 0; i < objectArray.size(); ++i) {
            int n3;
            dataPage.reset();
            dataPage.writeInt(0);
            Value[] valueArray = (Value[])objectArray.get(i);
            for (n3 = 0; n3 < this.columnCount; ++n3) {
                dataPage.writeValue(valueArray[n3]);
            }
            dataPage.fillAligned();
            n3 = dataPage.length();
            dataPage.setInt(0, n3);
            dataPage.updateChecksum();
            if (n2 > 0) {
                byteArrayOutputStream.write(dataPage.getBytes(), 0, n3);
                if ((n += n3) <= n2) continue;
                byte[] byArray = byteArrayOutputStream.toByteArray();
                byteArrayOutputStream.reset();
                this.file.write(byArray, 0, byArray.length);
                n = 0;
                continue;
            }
            this.file.write(dataPage.getBytes(), 0, n3);
        }
        if (n > 0) {
            byte[] byArray = byteArrayOutputStream.toByteArray();
            this.file.write(byArray, 0, byArray.length);
        }
        if (this.sort != null) {
            ResultDiskTape resultDiskTape = new ResultDiskTape();
            resultDiskTape.start = l;
            resultDiskTape.end = this.file.getFilePointer();
            this.tapes.add(resultDiskTape);
        } else {
            this.mainTape.end = this.file.getFilePointer();
        }
    }

    public void done() throws SQLException {
        this.file.seek(48L);
        this.file.autoDelete();
    }

    public void reset() {
        if (this.sort != null) {
            for (int i = 0; i < this.tapes.size(); ++i) {
                ResultDiskTape resultDiskTape = this.getTape(i);
                resultDiskTape.pos = resultDiskTape.start;
                resultDiskTape.buffer = new ObjectArray();
            }
        } else {
            this.mainTape.pos = 48L;
        }
    }

    private void readRow(ResultDiskTape resultDiskTape) throws SQLException {
        int n = 16;
        DataPage dataPage = this.rowBuff;
        dataPage.reset();
        this.file.readFully(dataPage.getBytes(), 0, n);
        int n2 = dataPage.readInt();
        dataPage.checkCapacity(n2);
        if (n2 - n > 0) {
            this.file.readFully(dataPage.getBytes(), n, n2 - n);
        }
        dataPage.check(n2);
        resultDiskTape.pos += (long)n2;
        Value[] valueArray = new Value[this.columnCount];
        for (int i = 0; i < this.columnCount; ++i) {
            valueArray[i] = dataPage.readValue();
        }
        resultDiskTape.buffer.add(valueArray);
    }

    public Value[] next() throws SQLException {
        return this.sort != null ? this.nextSorted() : this.nextUnsorted();
    }

    private Value[] nextUnsorted() throws SQLException {
        this.file.seek(this.mainTape.pos);
        if (this.mainTape.buffer.size() == 0) {
            for (int i = 0; this.mainTape.pos < this.mainTape.end && i < 128; ++i) {
                this.readRow(this.mainTape);
            }
        }
        Value[] valueArray = (Value[])this.mainTape.buffer.get(0);
        this.mainTape.buffer.remove(0);
        return valueArray;
    }

    private Value[] nextSorted() throws SQLException {
        Value[] valueArray;
        int n = -1;
        for (int i = 0; i < this.tapes.size(); ++i) {
            valueArray = this.getTape(i);
            if (valueArray.buffer.size() == 0 && valueArray.pos < valueArray.end) {
                this.file.seek(valueArray.pos);
                for (int j = 0; valueArray.pos < valueArray.end && j < 128; ++j) {
                    this.readRow((ResultDiskTape)valueArray);
                }
            }
            if (valueArray.buffer.size() <= 0) continue;
            if (n == -1) {
                n = i;
                continue;
            }
            if (this.compareTapes((ResultDiskTape)valueArray, this.getTape(n)) >= 0) continue;
            n = i;
        }
        ResultDiskTape resultDiskTape = this.getTape(n);
        valueArray = (Value[])resultDiskTape.buffer.get(0);
        resultDiskTape.buffer.remove(0);
        return valueArray;
    }

    private ResultDiskTape getTape(int n) {
        return (ResultDiskTape)this.tapes.get(n);
    }

    private int compareTapes(ResultDiskTape resultDiskTape, ResultDiskTape resultDiskTape2) throws SQLException {
        Value[] valueArray = (Value[])resultDiskTape.buffer.get(0);
        Value[] valueArray2 = (Value[])resultDiskTape2.buffer.get(0);
        return this.sort.compare(valueArray, valueArray2);
    }

    protected void finalize() {
        if (!SysProperties.runFinalize) {
            return;
        }
        this.close();
    }

    public void close() {
        if (this.file != null) {
            this.file.closeAndDeleteSilently();
            this.file = null;
        }
    }

    public int removeRow(Value[] valueArray) {
        throw Message.getInternalError();
    }

    public boolean contains(Value[] valueArray) {
        throw Message.getInternalError();
    }

    public int addRow(Value[] valueArray) {
        throw Message.getInternalError();
    }

    static class ResultDiskTape {
        long start;
        long end;
        long pos;
        ObjectArray buffer = new ObjectArray();

        ResultDiskTape() {
        }
    }
}

