/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl;

import com.mathworks.mwswing.FilePatternFilter;
import com.mathworks.mwswing.MJFileChooserPerPlatform;
import com.mathworks.project.impl.model.FileSetFilter;
import java.awt.Component;
import java.io.File;
import java.util.List;

public abstract class FileChooser {
    private static boolean sFileShowChooser = true;

    public abstract File[] showOpenDialog();

    public abstract File showSaveDialog();

    public abstract void setMultiSelectionEnabled(boolean var1);

    public abstract void setAcceptAllFileFilterUsed(boolean var1);

    public static FileChooser create(Component component, String string, File file, boolean bl, List<FileSetFilter> list) {
        return new PlatformChooser(component, string, file, list, bl);
    }

    private static class PlatformChooser
    extends FileChooser {
        private final MJFileChooserPerPlatform fChooser;
        private final Component fParent;

        PlatformChooser(Component component, String string, File file, List<FileSetFilter> list, boolean bl) {
            this.fParent = component;
            this.fChooser = new MJFileChooserPerPlatform();
            this.fChooser.setDialogTitle(string);
            this.fChooser.setCurrentDirectory(file);
            this.fChooser.setMultiSelectionEnabled(true);
            if (bl) {
                this.fChooser.setFileSelectionMode(2);
            }
            for (FileSetFilter fileSetFilter : list) {
                this.fChooser.addChoosableFileFilter((FilePatternFilter)fileSetFilter);
            }
        }

        @Override
        public File[] showOpenDialog() {
            if (this.testSetMainFile(false)) {
                this.fChooser.showOpenDialog(this.fParent);
                File[] fileArray = this.fChooser.getState() == 0 ? this.fChooser.getSelectedFiles() : null;
                this.testSetMainFile(true);
                return fileArray;
            }
            return null;
        }

        @Override
        public File showSaveDialog() {
            this.fChooser.showSaveDialog(this.fParent);
            return this.fChooser.getState() == 0 ? this.fChooser.getSelectedFile() : null;
        }

        @Override
        public void setMultiSelectionEnabled(boolean bl) {
            this.fChooser.setMultiSelectionEnabled(bl);
        }

        @Override
        public void setAcceptAllFileFilterUsed(boolean bl) {
            this.fChooser.setAcceptAllFileFilterUsed(bl);
        }

        private synchronized boolean testSetMainFile(boolean bl) {
            boolean bl2 = sFileShowChooser;
            sFileShowChooser = bl;
            return bl2;
        }
    }
}

