/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.apps;

import com.mathworks.mvm.MvmSwingWorker;
import com.mathworks.mvm.context.MvmContext;
import com.mathworks.mvm.exec.FutureFevalResult;
import com.mathworks.mvm.exec.FutureResult;
import com.mathworks.mvm.exec.MatlabExecutor;
import com.mathworks.mvm.exec.MatlabFevalRequest;
import com.mathworks.project.api.Command;
import com.mathworks.project.api.CommandExecutionException;
import com.mathworks.project.api.CommandStatus;
import com.mathworks.project.api.WritableConfiguration;
import com.mathworks.project.api.XmlReader;
import com.mathworks.project.impl.BuiltInResources;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;

public class PackageCommand
implements Command {
    private WritableConfiguration fConfig;
    public static final String PARAM_GUID = "param.guid";

    public PackageCommand(File file, WritableConfiguration writableConfiguration, XmlReader xmlReader) {
        this.fConfig = writableConfiguration;
    }

    public void execute(final CommandStatus commandStatus) {
        Object object2;
        Writer writer = new Writer(){

            @Override
            public void write(char[] cArray, int n, int n2) throws IOException {
                commandStatus.printOutputLine(String.copyValueOf(cArray, n, n2));
            }

            @Override
            public void flush() throws IOException {
            }

            @Override
            public void close() throws IOException {
            }
        };
        PrintWriter printWriter = new PrintWriter(new Writer(){

            @Override
            public void write(char[] cArray, int n, int n2) throws IOException {
                commandStatus.printErrorLine(String.copyValueOf(cArray, n, n2));
            }

            @Override
            public void flush() throws IOException {
            }

            @Override
            public void close() throws IOException {
            }
        });
        if (this.fConfig.getFileSet("fileset.main").getFiles().isEmpty()) {
            commandStatus.printErrorLine(BuiltInResources.getString("main.file.not.specified"));
            return;
        }
        File file = (File)this.fConfig.getFileSet("fileset.main").getFiles().toArray()[0];
        Set set = this.fConfig.getFileSet("fileset.depfun").getFiles();
        Set set2 = this.fConfig.getFileSet("fileset.resources").getFiles();
        String[] stringArray = new String[1 + (set2 != null ? set2.size() : 0) + (set != null ? set.size() : 0)];
        int n = 0;
        stringArray[n++] = file.getAbsolutePath();
        if (set2 != null) {
            for (Object object2 : set2) {
                stringArray[n++] = ((File)object2).getAbsolutePath();
            }
        }
        if (set != null) {
            for (Object object2 : set) {
                stringArray[n++] = ((File)object2).getAbsolutePath();
            }
        }
        Object object3 = "";
        if (this.fConfig.getParamAsFile("param.screenshot") != null) {
            object3 = this.fConfig.getParamAsFile("param.screenshot").getAbsolutePath();
        }
        object2 = this.fConfig.getParamAsString("param.output");
        if (this.fConfig.getParamAsString(PARAM_GUID) == null || this.fConfig.getParamAsString(PARAM_GUID).trim().isEmpty()) {
            this.fConfig.setParamAsString(PARAM_GUID, UUID.randomUUID().toString());
        }
        MatlabFevalRequest matlabFevalRequest = new MatlabFevalRequest("appcreate.internal.packageapp", 0, writer, (Writer)printWriter, new Object[]{object2, file.getAbsolutePath(), stringArray, this.fConfig.getParamAsStringList("param.products.name").toArray(), this.fConfig.getParamAsStringList("param.products.version").toArray(), this.fConfig.getParamAsStringList("param.products.id").toArray(), this.fConfig.getParamAsStringList("param.platforms").toArray(), this.fConfig.getParamAsString("param.version"), this.fConfig.getParamAsString("param.summary"), this.fConfig.getParamAsString("param.description"), this.fConfig.getParamAsString("param.authnamewatermark"), this.fConfig.getParamAsString("param.email"), this.fConfig.getParamAsString("param.company"), "", object3, this.fConfig.getParamAsString(PARAM_GUID)});
        MatlabExecutor matlabExecutor = MvmContext.get().getExecutor();
        FutureFevalResult futureFevalResult = matlabExecutor.submit(matlabFevalRequest);
        MvmSwingWorker mvmSwingWorker = new MvmSwingWorker((FutureResult)futureFevalResult){

            protected void done() {
                try {
                    Object object = this.get();
                    commandStatus.printOutputLine(MessageFormat.format(BuiltInResources.getString("package.finished"), PackageCommand.this.fConfig.getParamAsString("param.output")));
                }
                catch (ExecutionException executionException) {
                    StackTraceElement[] stackTraceElementArray = executionException.getStackTrace();
                    commandStatus.printErrorLine(executionException.getLocalizedMessage());
                    for (StackTraceElement stackTraceElement : stackTraceElementArray) {
                        commandStatus.printErrorLine("\nError in <a href=\"matlab: opentoline('" + stackTraceElement.getFileName() + "'," + stackTraceElement.getLineNumber() + ",0)\">" + (stackTraceElement.getClassName().isEmpty() ? "" : stackTraceElement.getClassName() + ">") + stackTraceElement.getMethodName() + " at " + stackTraceElement.getLineNumber() + "</a>");
                    }
                    commandStatus.failed(new CommandExecutionException((Command)PackageCommand.this, executionException.getCause()));
                }
                commandStatus.finished();
            }
        };
        mvmSwingWorker.runWhenReady();
    }

    public void cancel() {
    }

    public String toString() {
        return BuiltInResources.getString("apps.package.started");
    }
}

