/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.engine;

import com.mathworks.project.api.Command;
import com.mathworks.project.api.CommandStatus;
import com.mathworks.project.api.DeploymentProcess;
import com.mathworks.project.api.DeploymentProcessMonitor;
import com.mathworks.project.api.InvalidProjectException;
import com.mathworks.project.api.Severity;
import com.mathworks.project.api.SubProcessType;
import com.mathworks.project.api.ValidationMessage;
import com.mathworks.project.api.XmlReader;
import com.mathworks.project.impl.engine.AntCommand;
import com.mathworks.project.impl.engine.CommandStatusImpl;
import com.mathworks.project.impl.engine.DeploymentProcessImpl;
import com.mathworks.project.impl.engine.DeploymentScriptWriter;
import com.mathworks.project.impl.engine.MatlabCommand;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.project.impl.model.DynamicFileReference;
import com.mathworks.project.impl.model.DynamicTargetScript;
import com.mathworks.project.impl.model.FileSetDefinition;
import com.mathworks.project.impl.model.FileSetInstance;
import com.mathworks.project.impl.model.GeneratedReferenceSet;
import com.mathworks.project.impl.model.PackageType;
import com.mathworks.project.impl.model.Project;
import com.mathworks.project.impl.model.ProjectManager;
import com.mathworks.project.impl.model.Target;
import com.mathworks.project.impl.model.WorkflowStep;
import com.mathworks.util.Holder;
import com.mathworks.util.Log;
import com.mathworks.util.Predicate;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class DeploymentEngine {
    private DeploymentEngine() {
    }

    public static DeploymentProcess createBuildProcess(Project project) throws InvalidProjectException {
        return DeploymentEngine.createProcess(project, SubProcessType.USER_REQUESTED_BUILD, null, null, null, "DeployTool Build Process", null, project.getConfiguration().getTargetKey().equals("target.mlapps"));
    }

    public static DeploymentProcess createPackageProcess(Project project, PackageType packageType, File file, Predicate<Project> predicate) throws InvalidProjectException {
        return DeploymentEngine.createProcess(project, SubProcessType.USER_REQUESTED_PACKAGE, null, packageType, file, "DeployTool Package Process", predicate, project.getConfiguration().getTargetKey().equals("target.mlapps"));
    }

    public static DeploymentProcess createCustomPackageProcess(Project project) throws InvalidProjectException {
        return DeploymentEngine.createProcess(project, SubProcessType.USER_REQUESTED_PACKAGE, null, null, null, "DeployTool Package Process", null, project.getConfiguration().getTargetKey().equals("target.mlapps"));
    }

    public static DeploymentProcess createWorkflowStepProcess(Project project, WorkflowStep workflowStep) throws InvalidProjectException {
        return DeploymentEngine.createProcess(project, SubProcessType.WORKFLOW_STEP, workflowStep, null, null, "DeployTool Workflow Step " + workflowStep.getKey(), null, project.getConfiguration().getTargetKey().equals("target.mlapps"));
    }

    private static DeploymentProcess createProcess(final Project project, SubProcessType subProcessType, WorkflowStep workflowStep, final PackageType packageType, final File file, String string, Predicate<Project> predicate, boolean bl) throws InvalidProjectException {
        final Configuration configuration = project.getConfiguration();
        final ArrayList<DynamicTargetScript> arrayList = new ArrayList<DynamicTargetScript>();
        final ArrayList<SubProcessType> arrayList2 = new ArrayList<SubProcessType>();
        DeploymentEngine.determineRequiredSubProcesses(project, subProcessType, workflowStep, arrayList2, arrayList, bl);
        DeploymentEngine.validate(project, arrayList2.get(0) == SubProcessType.USER_REQUESTED_PACKAGE);
        final DeploymentProcessImpl deploymentProcessImpl = new DeploymentProcessImpl(configuration, (SubProcessType)arrayList2.get(0));
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Holder holder = new Holder();
                holder.set((Object)false);
                Holder holder2 = new Holder();
                holder2.set((Object)false);
                ArrayList<Object> arrayList3 = new ArrayList<Object>();
                try {
                    for (int i = 0; i < arrayList.size(); ++i) {
                        Object object2;
                        DynamicTargetScript dynamicTargetScript = (DynamicTargetScript)arrayList.get(i);
                        SubProcessType subProcessType = (SubProcessType)arrayList2.get(i);
                        deploymentProcessImpl.setCurrentSubProcessType(subProcessType);
                        for (Object object2 : deploymentProcessImpl.getMonitors()) {
                            object2.subProcessStarted(subProcessType);
                        }
                        Object object3 = null;
                        object2 = null;
                        File file2 = null;
                        if (subProcessType == SubProcessType.USER_REQUESTED_PACKAGE) {
                            object3 = new GeneratedReferenceSet(project.getConfiguration());
                            arrayList3.add(object3);
                            object2 = packageType;
                            file2 = file;
                        }
                        DeploymentEngine.executeScript(project, deploymentProcessImpl, dynamicTargetScript, object3, (PackageType)object2, file2, (Holder<Boolean>)holder2, (Holder<Boolean>)holder);
                        if (((Boolean)holder2.get()).booleanValue() || ((Boolean)holder.get()).booleanValue()) break;
                    }
                    if (arrayList2.contains(SubProcessType.BUILD_OUTDATED) || arrayList2.contains(SubProcessType.BUILD_MISSING) || arrayList2.contains(SubProcessType.USER_REQUESTED_BUILD)) {
                        configuration.updateBuildChecksum();
                    }
                }
                catch (Exception exception) {
                    try {
                        Log.logException((Exception)exception);
                        holder.set((Object)((Boolean)holder2.get() == false ? 1 : 0));
                    }
                    catch (Throwable throwable) {
                        for (GeneratedReferenceSet generatedReferenceSet : arrayList3) {
                            try {
                                generatedReferenceSet.dispose();
                            }
                            catch (IOException iOException) {
                                Log.logException((Exception)iOException);
                            }
                        }
                        for (GeneratedReferenceSet generatedReferenceSet : deploymentProcessImpl.getMonitors()) {
                            if (((Boolean)holder.get()).booleanValue()) {
                                generatedReferenceSet.failed();
                                continue;
                            }
                            if (((Boolean)holder2.get()).booleanValue()) {
                                generatedReferenceSet.canceled();
                                continue;
                            }
                            generatedReferenceSet.finished();
                        }
                        throw throwable;
                    }
                    for (GeneratedReferenceSet generatedReferenceSet : arrayList3) {
                        try {
                            generatedReferenceSet.dispose();
                        }
                        catch (IOException iOException) {
                            Log.logException((Exception)iOException);
                        }
                    }
                    for (DeploymentProcessMonitor deploymentProcessMonitor : deploymentProcessImpl.getMonitors()) {
                        if (((Boolean)holder.get()).booleanValue()) {
                            deploymentProcessMonitor.failed();
                            continue;
                        }
                        if (((Boolean)holder2.get()).booleanValue()) {
                            deploymentProcessMonitor.canceled();
                            continue;
                        }
                        deploymentProcessMonitor.finished();
                    }
                }
                for (GeneratedReferenceSet generatedReferenceSet : arrayList3) {
                    try {
                        generatedReferenceSet.dispose();
                    }
                    catch (IOException iOException) {
                        Log.logException((Exception)iOException);
                    }
                }
                for (DeploymentProcessMonitor deploymentProcessMonitor : deploymentProcessImpl.getMonitors()) {
                    if (((Boolean)holder.get()).booleanValue()) {
                        deploymentProcessMonitor.failed();
                        continue;
                    }
                    if (((Boolean)holder2.get()).booleanValue()) {
                        deploymentProcessMonitor.canceled();
                        continue;
                    }
                    deploymentProcessMonitor.finished();
                }
            }
        });
        thread.setName(string);
        deploymentProcessImpl.setThread(thread);
        return deploymentProcessImpl;
    }

    private static void executeScript(Project project, DeploymentProcessImpl deploymentProcessImpl, DynamicTargetScript dynamicTargetScript, GeneratedReferenceSet generatedReferenceSet, PackageType packageType, File file, Holder<Boolean> holder, Holder<Boolean> holder2) {
        if (dynamicTargetScript == null) {
            return;
        }
        Script script = new Script();
        dynamicTargetScript.evaluate(project, generatedReferenceSet, script, packageType, file);
        Iterator<Command> iterator = script.getCommands().iterator();
        while (iterator.hasNext()) {
            Command command = iterator.next();
            CommandStatusImpl commandStatusImpl = deploymentProcessImpl.setCurrentCommand(command);
            try {
                command.execute((CommandStatus)commandStatusImpl);
                commandStatusImpl.waitForCompletion();
                if (commandStatusImpl.isCanceled()) {
                    holder.set((Object)true);
                }
                if (commandStatusImpl.getError() != null) {
                    holder2.set((Object)true);
                    break;
                }
            }
            catch (InterruptedException interruptedException) {
                holder.set((Object)true);
                break;
            }
            catch (Exception exception) {
                holder2.set((Object)true);
            }
            if (!deploymentProcessImpl.isCancelRequested() || !iterator.hasNext()) continue;
            holder.set((Object)true);
            break;
        }
    }

    private static void determineRequiredSubProcesses(Project project, SubProcessType subProcessType, WorkflowStep workflowStep, List<SubProcessType> list, List<DynamicTargetScript> list2, boolean bl) {
        Configuration configuration = project.getConfiguration();
        Target target = configuration.getTarget();
        boolean bl2 = subProcessType == SubProcessType.USER_REQUESTED_PACKAGE;
        list.add(subProcessType);
        if (bl2) {
            list2.add(target.getPackageScript());
        } else if (subProcessType == SubProcessType.WORKFLOW_STEP) {
            list2.add(workflowStep.getScript());
        } else {
            list2.add(target.getBuildScript());
        }
        if (bl2) {
            long l = Long.MAX_VALUE;
            boolean bl3 = configuration.isBuildChecksumOutdated();
            if (!bl3) {
                XmlReader xmlReader = project.getXslInput();
                for (DynamicFileReference dynamicFileReference : configuration.getTarget().getBuildDeliverables().evaluate(xmlReader)) {
                    if (!dynamicFileReference.isOptional() && !dynamicFileReference.getFile().exists()) {
                        bl = true;
                        bl3 = true;
                        break;
                    }
                    l = Math.min(dynamicFileReference.getFile().lastModified(), l);
                }
            }
            if (!bl3) {
                block1: for (FileSetDefinition fileSetDefinition : configuration.getTarget().getFileSets()) {
                    if (fileSetDefinition.getKey().equals("fileset.package")) continue;
                    FileSetInstance fileSetInstance = configuration.getFileSet(fileSetDefinition.getKey());
                    for (File file : fileSetInstance.getFiles()) {
                        if (file.lastModified() <= l) continue;
                        bl3 = true;
                        continue block1;
                    }
                }
            }
            if (bl) {
                list2.add(0, target.getBuildScript());
                list.add(0, SubProcessType.BUILD_MISSING);
            }
        }
    }

    private static void validate(Project project, boolean bl) throws InvalidProjectException {
        List<ValidationMessage> list = ProjectManager.validate(project, bl);
        for (ValidationMessage validationMessage : list) {
            if (validationMessage.getSeverity() != Severity.ERROR) continue;
            throw new InvalidProjectException(list);
        }
    }

    private static class Script
    implements DeploymentScriptWriter {
        private final List<Command> fCommands = new ArrayList<Command>();

        Script() {
        }

        Script(Script ... scriptArray) {
            for (Script script : scriptArray) {
                this.fCommands.addAll(script.getCommands());
            }
        }

        List<Command> getCommands() {
            return new ArrayList<Command>(this.fCommands);
        }

        @Override
        public void writeMatlabCommand(String string, boolean bl) {
            this.fCommands.add(new MatlabCommand(string, bl));
        }

        @Override
        public void writeAntScript(String string) {
            this.fCommands.add(new AntCommand(string));
        }

        @Override
        public void writeArbitraryCommand(Command command) {
            this.fCommands.add(command);
        }
    }
}

