/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.plugin;

import com.mathworks.project.impl.plugin.XpathEvaluator;
import com.mathworks.util.ReturnRunnable;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public final class SimpleExpression {
    private final List<Token> fCompiledTokens;

    private SimpleExpression(List<Token> list) {
        this.fCompiledTokens = new ArrayList<Token>(list);
    }

    public static <CompiledInputType, CompiledXPathType> SimpleExpression compile(String string, XpathEvaluator<CompiledInputType, CompiledXPathType> xpathEvaluator) {
        Token[] tokenArray = SimpleExpression.tokenize(string, xpathEvaluator);
        ArrayList<Token> arrayList = new ArrayList<Token>();
        SimpleExpression.compile(arrayList, string, tokenArray, 0, tokenArray.length - 1);
        return new SimpleExpression(arrayList);
    }

    public static <CompiledInputType, CompiledXPathType> String evaluate(String string, XpathEvaluator<CompiledInputType, CompiledXPathType> xpathEvaluator, CompiledInputType CompiledInputType) {
        SimpleExpression simpleExpression = SimpleExpression.compile(string, xpathEvaluator);
        return simpleExpression.evaluate(xpathEvaluator, CompiledInputType);
    }

    public <CompiledInputType, CompiledXPathType> String evaluate(XpathEvaluator<CompiledInputType, CompiledXPathType> xpathEvaluator, CompiledInputType CompiledInputType) {
        Stack<String> stack = new Stack<String>();
        for (Token token : this.fCompiledTokens) {
            token.getType().evaluate(token, stack, xpathEvaluator, CompiledInputType);
        }
        if (stack.empty()) {
            return "";
        }
        return (String)stack.pop();
    }

    private static void compile(List<Token> list, String string, Token[] tokenArray, int n, int n2) {
        if (n2 < n || tokenArray.length == 0 || n >= tokenArray.length || n < 0 || n2 < 0 || n2 >= tokenArray.length) {
            return;
        }
        if (n == n2) {
            list.add(tokenArray[n]);
            return;
        }
        if (n < n2 && tokenArray[n].getType() == TokenType.OPEN_PAREN && tokenArray[n2].getType() == TokenType.CLOSE_PAREN) {
            SimpleExpression.compile(list, string, tokenArray, n + 1, n2 - 1);
            return;
        }
        int n3 = 0;
        int n4 = -1;
        for (int i = n; i <= n2; ++i) {
            if (tokenArray[i].getType() == TokenType.OPEN_PAREN) {
                ++n3;
                continue;
            }
            if (tokenArray[i].getType() == TokenType.CLOSE_PAREN) {
                --n3;
                continue;
            }
            if (n3 != 0) continue;
            int n5 = tokenArray[i].getType().getOperatorPrecedence();
            if (tokenArray[i].getType().getOperatorPrecedence() < 0 || n4 >= 0 && n5 > tokenArray[n4].getType().getOperatorPrecedence()) continue;
            n4 = i;
        }
        if (n4 < 0) {
            throw new IllegalArgumentException("Invalid simple expression (an operator appears to be missing): " + string);
        }
        SimpleExpression.compile(list, string, tokenArray, n, n4 - 1);
        SimpleExpression.compile(list, string, tokenArray, n4 + 1, n2);
        list.add(tokenArray[n4]);
    }

    private static <CompiledInputType, CompiledXPathType> Token[] tokenize(String string, final XpathEvaluator<CompiledInputType, CompiledXPathType> xpathEvaluator) {
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<Token> arrayList = new ArrayList<Token>();
        char[] cArray = string.toCharArray();
        block0: for (int i = 0; i <= cArray.length; ++i) {
            if (i == cArray.length || Character.isWhitespace(cArray[i])) {
                SimpleExpression.flushLiteral(stringBuilder, arrayList);
                continue;
            }
            for (TokenType tokenType : TokenType.values()) {
                boolean bl;
                String string2;
                if (tokenType == TokenType.DUMMY) continue;
                String string3 = tokenType.getStaticForm();
                if (string3 != null) {
                    if (!SimpleExpression.matchForm(cArray, i, stringBuilder, tokenType.requiresSurroundingWhitespace(), string3)) continue;
                    SimpleExpression.flushLiteral(stringBuilder, arrayList);
                    if (tokenType.isUnary()) {
                        arrayList.add(new Token(TokenType.DUMMY, ""));
                    }
                    arrayList.add(new Token(tokenType, string3));
                    i += string3.length() - 1;
                    continue block0;
                }
                String string4 = tokenType.getOpenSentinel();
                final String string5 = SimpleExpression.getTextIfSentinelsPresent(cArray, i, stringBuilder, string4, string2 = tokenType.getCloseSentinel(), bl = tokenType.isGreedy());
                if (string5 == null) continue;
                SimpleExpression.flushLiteral(stringBuilder, arrayList);
                if (tokenType == TokenType.XPATH) {
                    ReturnRunnable returnRunnable = new ReturnRunnable<CompiledXPathType>(){

                        public CompiledXPathType run() {
                            return xpathEvaluator.compileXPath(string5);
                        }
                    };
                    arrayList.add(new Token(tokenType, string5, returnRunnable));
                } else {
                    arrayList.add(new Token(tokenType, string5));
                }
                i += string5.length() + string4.length() + string2.length() - 1;
                continue block0;
            }
            stringBuilder.append(cArray[i]);
        }
        return arrayList.toArray(new Token[arrayList.size()]);
    }

    private static void flushLiteral(StringBuilder stringBuilder, List<Token> list) {
        if (stringBuilder.toString().trim().length() > 0) {
            list.add(new Token(TokenType.LITERAL, stringBuilder.toString().trim()));
        }
        stringBuilder.setLength(0);
    }

    private static boolean matchForm(char[] cArray, int n, StringBuilder stringBuilder, boolean bl, String string) {
        int n2;
        if (bl) {
            int n3 = n2 = stringBuilder.toString().trim().length() > 0 || n + string.length() < cArray.length - 1 && !Character.isWhitespace(cArray[n + string.length()]) ? 1 : 0;
            if (n2 != 0) {
                return false;
            }
        }
        if (cArray.length - n < string.length()) {
            return false;
        }
        for (n2 = 0; n2 < string.length(); ++n2) {
            if (cArray[n + n2] == string.charAt(n2)) continue;
            return false;
        }
        return true;
    }

    private static String getTextIfSentinelsPresent(char[] cArray, int n, StringBuilder stringBuilder, String string, String string2, boolean bl) {
        if (SimpleExpression.matchForm(cArray, n, stringBuilder, false, string)) {
            int n2 = n + string.length();
            StringBuilder stringBuilder2 = new StringBuilder();
            for (int i = n2; i <= cArray.length; ++i) {
                if (i == cArray.length) {
                    return null;
                }
                if (SimpleExpression.matchForm(cArray, i, stringBuilder, false, string2)) {
                    if (!bl) {
                        return stringBuilder2.toString();
                    }
                    n2 = stringBuilder2.toString().length();
                }
                stringBuilder2.append(cArray[i]);
            }
            stringBuilder2.setLength(n2);
            return stringBuilder2.toString();
        }
        return null;
    }

    private static class Token {
        private Object fCompiledXpath;
        private ReturnRunnable<?> fLazyCompiledXpath;
        private final String fText;
        private final TokenType fType;

        Token(TokenType tokenType, String string) {
            this(tokenType, string, null);
        }

        Token(TokenType tokenType, String string, ReturnRunnable<?> returnRunnable) {
            this.fText = string;
            this.fType = tokenType;
            this.fLazyCompiledXpath = returnRunnable;
        }

        synchronized Object getCompiledXpath() {
            if (this.fCompiledXpath == null && this.fLazyCompiledXpath != null) {
                this.fCompiledXpath = this.fLazyCompiledXpath.run();
                this.fLazyCompiledXpath = null;
            }
            return this.fCompiledXpath;
        }

        String getText() {
            return this.fText;
        }

        TokenType getType() {
            return this.fType;
        }
    }

    private static enum TokenType {
        DUMMY("", -1){

            @Override
            <CompiledInputType, CompiledXPathType> void evaluate(Token token, Stack<String> stack, XpathEvaluator<CompiledInputType, CompiledXPathType> xpathEvaluator, CompiledInputType CompiledInputType) {
            }
        }
        ,
        XPATH("${", "}"){

            @Override
            <CompiledInputType, CompiledXPathType> void evaluate(Token token, Stack<String> stack, XpathEvaluator<CompiledInputType, CompiledXPathType> xpathEvaluator, CompiledInputType CompiledInputType) {
                stack.push(xpathEvaluator.evaluate(CompiledInputType, token.getCompiledXpath()));
            }
        }
        ,
        NOT_EQUALS("!=", 0){

            @Override
            <CompiledInputType, CompiledXPathType> void evaluate(Token token, Stack<String> stack, XpathEvaluator<CompiledInputType, CompiledXPathType> xpathEvaluator, CompiledInputType CompiledInputType) {
                String string = stack.pop();
                String string2 = stack.pop();
                stack.push(Boolean.toString(!string2.equals(string)));
            }
        }
        ,
        NOT("!", 100, true){

            @Override
            <CompiledInputType, CompiledXPathType> void evaluate(Token token, Stack<String> stack, XpathEvaluator<CompiledInputType, CompiledXPathType> xpathEvaluator, CompiledInputType CompiledInputType) {
                boolean bl = Boolean.parseBoolean(stack.pop());
                stack.push(Boolean.toString(!bl));
            }
        }
        ,
        OPEN_PAREN("(", -1){

            @Override
            <CompiledInputType, CompiledXPathType> void evaluate(Token token, Stack<String> stack, XpathEvaluator<CompiledInputType, CompiledXPathType> xpathEvaluator, CompiledInputType CompiledInputType) {
                throw new UnsupportedOperationException("Parentheses should not be left in compiled expressions.");
            }
        }
        ,
        CLOSE_PAREN(")", -1){

            @Override
            <CompiledInputType, CompiledXPathType> void evaluate(Token token, Stack<String> stack, XpathEvaluator<CompiledInputType, CompiledXPathType> xpathEvaluator, CompiledInputType CompiledInputType) {
                throw new UnsupportedOperationException("Parentheses should not be left in compiled expressions.");
            }
        }
        ,
        PATTERN_BINDER("/", "/", true){

            @Override
            <CompiledInputType, CompiledXPathType> void evaluate(Token token, Stack<String> stack, XpathEvaluator<CompiledInputType, CompiledXPathType> xpathEvaluator, CompiledInputType CompiledInputType) {
                stack.push(xpathEvaluator.evaluate(CompiledInputType, token.getText()));
            }
        }
        ,
        REPLACE("->", 1){

            @Override
            <CompiledInputType, CompiledXPathType> void evaluate(Token token, Stack<String> stack, XpathEvaluator<CompiledInputType, CompiledXPathType> xpathEvaluator, CompiledInputType CompiledInputType) {
                String string = stack.pop();
                String string2 = stack.pop();
                string = string.substring(1, string.length() - 1);
                int n = string.indexOf(47);
                String string3 = string.substring(0, n);
                String string4 = string.substring(n + 1);
                stack.push(string2.replaceAll(string3, string4));
            }
        }
        ,
        EQUALS("=", 0){

            @Override
            <CompiledInputType, CompiledXPathType> void evaluate(Token token, Stack<String> stack, XpathEvaluator<CompiledInputType, CompiledXPathType> xpathEvaluator, CompiledInputType CompiledInputType) {
                String string = stack.pop();
                String string2 = stack.pop();
                stack.push(Boolean.toString(string2.equals(string)));
            }
        }
        ,
        AND("and", 2){

            @Override
            <CompiledInputType, CompiledXPathType> void evaluate(Token token, Stack<String> stack, XpathEvaluator<CompiledInputType, CompiledXPathType> xpathEvaluator, CompiledInputType CompiledInputType) {
                boolean bl = Boolean.parseBoolean(stack.pop());
                boolean bl2 = Boolean.parseBoolean(stack.pop());
                stack.push(Boolean.toString(bl2 && bl));
            }
        }
        ,
        OR("or", 1){

            @Override
            <CompiledInputType, CompiledXPathType> void evaluate(Token token, Stack<String> stack, XpathEvaluator<CompiledInputType, CompiledXPathType> xpathEvaluator, CompiledInputType CompiledInputType) {
                boolean bl = Boolean.parseBoolean(stack.pop());
                boolean bl2 = Boolean.parseBoolean(stack.pop());
                stack.push(Boolean.toString(bl2 || bl));
            }
        }
        ,
        SYMBOLIC_AND("&&", 2){

            @Override
            <CompiledInputType, CompiledXPathType> void evaluate(Token token, Stack<String> stack, XpathEvaluator<CompiledInputType, CompiledXPathType> xpathEvaluator, CompiledInputType CompiledInputType) {
                AND.evaluate(token, stack, xpathEvaluator, CompiledInputType);
            }
        }
        ,
        SYMBOLIC_OR("||", 1){

            @Override
            <CompiledInputType, CompiledXPathType> void evaluate(Token token, Stack<String> stack, XpathEvaluator<CompiledInputType, CompiledXPathType> xpathEvaluator, CompiledInputType CompiledInputType) {
                OR.evaluate(token, stack, xpathEvaluator, CompiledInputType);
            }
        }
        ,
        PLUS("+", 1){

            @Override
            <CompiledInputType, CompiledXPathType> void evaluate(Token token, Stack<String> stack, XpathEvaluator<CompiledInputType, CompiledXPathType> xpathEvaluator, CompiledInputType CompiledInputType) {
                String string = stack.pop();
                String string2 = stack.pop();
                boolean bl = false;
                int n = 0;
                try {
                    n = Integer.parseInt(string2);
                    bl = true;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                boolean bl2 = false;
                int n2 = 0;
                if (bl) {
                    try {
                        n2 = Integer.parseInt(string);
                        bl2 = true;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (bl && bl2) {
                    stack.push(Integer.toString(n + n2));
                } else {
                    stack.push(string2 + string);
                }
            }
        }
        ,
        LITERAL("'", "'"){

            @Override
            <CompiledInputType, CompiledXPathType> void evaluate(Token token, Stack<String> stack, XpathEvaluator<CompiledInputType, CompiledXPathType> xpathEvaluator, CompiledInputType CompiledInputType) {
                stack.push(token.getText());
            }
        };

        private final boolean fUnary;
        private final boolean fGreedy;
        private final String fStaticForm;
        private final String fOpenSentinel;
        private final String fCloseSentinel;
        private final int fOperatorPrecedence;
        private final boolean fRequiresSurroundingWhitespace;

        private TokenType(String string2, int n2) {
            this(string2, n2, false);
        }

        private TokenType(String string2, int n2, boolean bl) {
            this.fUnary = bl;
            this.fStaticForm = string2;
            this.fOpenSentinel = null;
            this.fCloseSentinel = null;
            this.fGreedy = false;
            this.fOperatorPrecedence = n2;
            this.fRequiresSurroundingWhitespace = !TokenType.isSymbolic(string2);
        }

        private TokenType(String string2, String string3) {
            this(string2, string3, false);
        }

        private TokenType(String string2, String string3, boolean bl) {
            this.fGreedy = bl;
            this.fUnary = false;
            this.fOpenSentinel = string2;
            this.fCloseSentinel = string3;
            this.fStaticForm = null;
            this.fOperatorPrecedence = -1;
            this.fRequiresSurroundingWhitespace = false;
        }

        boolean isGreedy() {
            return this.fGreedy;
        }

        boolean isUnary() {
            return this.fUnary;
        }

        int getOperatorPrecedence() {
            return this.fOperatorPrecedence;
        }

        boolean requiresSurroundingWhitespace() {
            return this.fRequiresSurroundingWhitespace;
        }

        String getStaticForm() {
            return this.fStaticForm;
        }

        String getOpenSentinel() {
            return this.fOpenSentinel;
        }

        String getCloseSentinel() {
            return this.fCloseSentinel;
        }

        private static boolean isSymbolic(String string) {
            for (int i = 0; i < string.length(); ++i) {
                if (!Character.isLetter(string.charAt(i)) && !Character.isDigit(string.charAt(i))) continue;
                return false;
            }
            return true;
        }

        abstract <CompiledInputType, CompiledXPathType> void evaluate(Token var1, Stack<String> var2, XpathEvaluator<CompiledInputType, CompiledXPathType> var3, CompiledInputType var4);
    }
}

