/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.settingsui;

import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJHelpButton;
import com.mathworks.mwswing.MJTabbedPane;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.WindowUtils;
import com.mathworks.project.impl.BuiltInResources;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.project.impl.model.DynamicTargetAttribute;
import com.mathworks.project.impl.model.ParamSet;
import com.mathworks.project.impl.model.Project;
import com.mathworks.project.impl.model.Target;
import com.mathworks.project.impl.plugin.PluginManager;
import com.mathworks.project.impl.settingsui.ParamSetPanel;
import com.mathworks.project.impl.settingsui.SettingsTabbedPane;
import com.mathworks.util.PlatformInfo;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ProjectSettingsDialog {
    private final MJFrame fDialog;
    private final Project fProject;
    private final MJTabbedPane fTabs;
    private final MJButton fHelpButton;
    private final List<ParamSetPanel> fPanels;
    private final PropertyChangeListener fVisibilityChangeListener;
    private Component fFirstPanel;
    private static ProjectSettingsDialog sInstance;

    private ProjectSettingsDialog(Project project) {
        assert (project != null);
        assert (!project.getConfiguration().getTarget().getNonWorkflowParamSets().isEmpty());
        this.fProject = project;
        this.fDialog = new MJFrame();
        this.fDialog.setName("settings.dialog");
        CellConstraints cellConstraints = new CellConstraints();
        this.fTabs = new TabbedPane();
        this.fVisibilityChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (Configuration.isParamSetVisibilityChange(propertyChangeEvent)) {
                    ProjectSettingsDialog.this.rebuild();
                } else if (Configuration.isParamVisibilityChange(propertyChangeEvent)) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ProjectSettingsDialog.this.resize();
                        }
                    });
                }
            }
        };
        this.fTabs.setName("settings.tabs");
        this.fTabs.addComponentListener((ComponentListener)new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                ProjectSettingsDialog.this.resize();
            }
        });
        this.fPanels = new ArrayList<ParamSetPanel>();
        this.fProject.addPropertyChangeListener(this.fVisibilityChangeListener);
        this.rebuild();
        MJButton mJButton = new MJButton(BuiltInResources.getString("button.close"));
        mJButton.setName("settings.close");
        mJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProjectSettingsDialog.close();
            }
        });
        this.fHelpButton = new MJHelpButton();
        this.fHelpButton.setName("settings.help");
        this.fHelpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = ProjectSettingsDialog.this.fTabs.getSelectedIndex();
                if (n >= 0) {
                    Target target = ProjectSettingsDialog.this.fProject.getConfiguration().getTarget();
                    String string = PluginManager.resolveHelpMapPath(target.getHelpMapPath());
                    ParamSet paramSet = (ParamSet)ProjectSettingsDialog.this.getVisibleParamSets().get(n);
                    DynamicTargetAttribute dynamicTargetAttribute = paramSet.getHelpTopicKey();
                    MLHelpServices.cshDisplayTopic((Object)ProjectSettingsDialog.this.fDialog, (String)string, (String)ProjectSettingsDialog.this.fProject.getConfiguration().evaluateString(dynamicTargetAttribute));
                }
            }
        });
        this.fTabs.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                ProjectSettingsDialog.this.updateHelpEnabledState();
            }
        });
        this.updateHelpEnabledState();
        JPanel jPanel = PlatformInfo.isMacintosh() ? ButtonBarFactory.buildHelpBar((JButton)this.fHelpButton, (JButton)mJButton) : ButtonBarFactory.buildCloseHelpBar((JButton)mJButton, (JButton)this.fHelpButton);
        this.fDialog.setLayout((LayoutManager)new FormLayout("3dlu, fill:d:grow, 3dlu", "2dlu, fill:d:grow, 3dlu, fill:d, 3dlu"));
        this.fDialog.add((Component)this.fTabs, (Object)cellConstraints.xy(2, 2));
        this.fDialog.add((Component)jPanel, (Object)cellConstraints.xy(2, 4));
        this.fDialog.setTitle(BuiltInResources.getString("projectsettings.title"));
        this.fDialog.pack();
        Dimension dimension = this.fDialog.getPreferredSize();
        this.fDialog.setMinimumSize(dimension);
        this.setWidthToHeightRatio(1.25);
        WindowUtils.centerWindowOnParent((Window)this.fDialog);
        if (this.fFirstPanel != null) {
            this.fFirstPanel.requestFocus();
        }
        this.fDialog.addWindowListener((WindowListener)new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                ProjectSettingsDialog.close();
            }
        });
    }

    private void resize() {
        if (this.fDialog.getSize().getWidth() < this.fDialog.getPreferredSize().getWidth()) {
            this.fDialog.setSize((int)this.fDialog.getPreferredSize().getWidth(), this.fDialog.getHeight());
        }
        if (this.fDialog.getSize().getHeight() < this.fDialog.getPreferredSize().getHeight()) {
            this.fDialog.setSize(this.fDialog.getWidth(), (int)this.fDialog.getPreferredSize().getHeight());
        }
        Dimension dimension = this.fDialog.getPreferredSize();
        this.fDialog.setMinimumSize(dimension);
        this.setWidthToHeightRatio(1.25);
    }

    /*
     * WARNING - void declaration
     */
    private void rebuild() {
        void var3_7;
        this.fFirstPanel = null;
        HashMap<String, ParamSetPanel> hashMap = new HashMap<String, ParamSetPanel>();
        for (ParamSetPanel object2 : this.fPanels) {
            hashMap.put(object2.getParamSet().getKey(), object2);
        }
        int n = this.fTabs.getSelectedIndex();
        Object var3_5 = null;
        if (n > -1) {
            ParamSet paramSet = this.fPanels.get(n).getParamSet();
        }
        this.fPanels.clear();
        this.fTabs.removeAll();
        for (ParamSet paramSet : this.getVisibleParamSets()) {
            ParamSetPanel paramSetPanel = (ParamSetPanel)hashMap.get(paramSet.getKey());
            if (paramSetPanel != null) {
                hashMap.remove(paramSet.getKey());
            } else {
                paramSetPanel = new ParamSetPanel(this.fProject, paramSet, false, true);
            }
            this.fTabs.addTab(paramSet.getName(), paramSetPanel.getComponent());
            this.fPanels.add(paramSetPanel);
            if (this.fFirstPanel != null) continue;
            this.fFirstPanel = paramSetPanel.getComponent();
        }
        Object object = hashMap.values().iterator();
        while (object.hasNext()) {
            ParamSetPanel paramSetPanel = (ParamSetPanel)((Object)object.next());
            paramSetPanel.dispose();
        }
        if (var3_7 != null && (object = this.findVisibleParamSetByDisplayName(var3_7.getName())) != null) {
            this.fTabs.setSelectedIndex(this.getVisibleParamSets().indexOf(object));
        }
        this.fTabs.revalidate();
        this.fTabs.repaint();
    }

    private ParamSet findVisibleParamSetByDisplayName(String string) {
        for (ParamSet paramSet : this.getVisibleParamSets()) {
            if (!paramSet.getName().equals(string)) continue;
            return paramSet;
        }
        return null;
    }

    private List<ParamSet> getVisibleParamSets() {
        ArrayList<ParamSet> arrayList = new ArrayList<ParamSet>();
        for (ParamSet paramSet : this.fProject.getConfiguration().getTarget().getNonWorkflowParamSets()) {
            if (!this.fProject.getConfiguration().isParamSetVisible(paramSet.getKey())) continue;
            arrayList.add(paramSet);
        }
        return arrayList;
    }

    private void updateHelpEnabledState() {
        Target target = this.fProject.getConfiguration().getTarget();
        int n = this.fTabs.getSelectedIndex();
        this.fHelpButton.setEnabled(target.getHelpMapPath() != null && this.fTabs.getSelectedIndex() >= 0 && this.getVisibleParamSets().get(n).getHelpTopicKey() != null);
    }

    private Project getProject() {
        return this.fProject;
    }

    private MJFrame getDialog() {
        return this.fDialog;
    }

    public static void close() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (sInstance != null) {
                    sInstance.dispose();
                    sInstance = null;
                }
            }
        });
    }

    private void dispose() {
        for (ParamSetPanel paramSetPanel : this.fPanels) {
            paramSetPanel.dispose();
        }
        this.fProject.removePropertyChangeListener(this.fVisibilityChangeListener);
        this.getDialog().dispose();
    }

    public static void invoke(final Project project) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                assert (sInstance == null || sInstance.getProject().equals(project));
                if (sInstance == null) {
                    sInstance = new ProjectSettingsDialog(project);
                }
                sInstance.getDialog().setVisible(true);
            }
        });
    }

    private void setWidthToHeightRatio(double d) {
        int n;
        int n2 = this.fDialog.getWidth();
        if (n2 < (int)(d * (double)(n = this.fDialog.getHeight()))) {
            n2 = (int)(d * (double)n);
        } else {
            n = (int)((double)n2 / d);
        }
        if ((double)n > this.fDialog.getPreferredSize().getHeight() && n > 490) {
            n = (int)Math.max(490.0, this.fDialog.getPreferredSize().getHeight());
        }
        this.fDialog.setSize(n2, n);
    }

    private static class TabbedPane
    extends MJTabbedPane
    implements SettingsTabbedPane {
        private TabbedPane() {
        }

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            Dimension dimension2 = super.getMinimumSize();
            return new Dimension((int)Math.max(dimension.getWidth(), dimension2.getWidth()), (int)Math.max(dimension.getHeight(), dimension2.getHeight()));
        }

        @Override
        public void addTabChangeListener(ChangeListener changeListener) {
            this.getModel().addChangeListener(changeListener);
        }

        @Override
        public void removeTabChangeListener(ChangeListener changeListener) {
            this.getModel().removeChangeListener(changeListener);
        }
    }
}

