/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.search.lucene;

import com.mathworks.search.lucene.IndexLocation;
import java.io.File;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;

public class FileSystemIndexLocation
extends IndexLocation {
    private final Directory fDirectory;

    public FileSystemIndexLocation(String indexDir, boolean create) {
        this.fDirectory = FileSystemIndexLocation.buildDirectory(indexDir, create);
    }

    public FileSystemIndexLocation(File indexDir, boolean create) {
        this.fDirectory = FileSystemIndexLocation.buildDirectory(indexDir, create);
    }

    private static Directory buildDirectory(String directory, boolean create) {
        try {
            if (!create && !new File(directory).exists()) {
                create = true;
            }
            return FSDirectory.getDirectory((String)directory, (boolean)create);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Directory buildDirectory(File directory, boolean create) {
        try {
            if (!create && !directory.exists()) {
                create = true;
            }
            return FSDirectory.getDirectory((File)directory, (boolean)create);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public Directory getSearchDirectory() {
        return this.fDirectory;
    }
}

