/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.search.lucene;

import com.mathworks.search.SearchResult;
import java.io.IOException;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.Searcher;

class HitCollectorSearchResult
implements SearchResult {
    private final Searcher fSearcher;
    private final int fDocNum;
    private Document fDocument;
    private final float fScore;

    HitCollectorSearchResult(Searcher searcher, int docNum, float score) {
        this.fSearcher = searcher;
        this.fDocNum = docNum;
        this.fScore = score;
    }

    private Document getDocument() throws IOException {
        if (this.fDocument == null) {
            this.fDocument = this.fSearcher.doc(this.fDocNum);
        }
        return this.fDocument;
    }

    @Override
    public String getFieldValue(String fieldName) {
        try {
            return this.getDocument().get(fieldName);
        }
        catch (IOException ioe) {
            return null;
        }
    }

    @Override
    public float getScore() {
        return this.fScore;
    }
}

