/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.search.lucene;

import com.mathworks.search.IndexDocument;
import com.mathworks.search.Indexer;
import com.mathworks.search.SearchField;
import com.mathworks.search.SearchLanguage;
import com.mathworks.search.lucene.IndexLocation;
import com.mathworks.search.lucene.MWAnalyzer;
import java.io.IOException;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;

public class LuceneIndexer
implements Indexer {
    private final IndexLocation fLocation;
    private final SearchLanguage fLanguage;
    private final Analyzer fAnalyzer;
    private final boolean fOverwrite;
    private IndexWriter fWriter;

    public LuceneIndexer(IndexLocation location, SearchLanguage language) throws IOException {
        this(location, language, LuceneIndexer.getDefaultIndexAnalyzer(language));
    }

    public LuceneIndexer(IndexLocation location, SearchLanguage language, Analyzer analyzer) throws IOException {
        this(location, language, analyzer, true);
    }

    public LuceneIndexer(IndexLocation location, SearchLanguage language, Analyzer analyzer, boolean overwrite) throws IOException {
        this.fLocation = location;
        this.fLanguage = language;
        this.fAnalyzer = analyzer;
        this.fOverwrite = overwrite;
    }

    public static Analyzer getDefaultIndexAnalyzer(SearchLanguage language) {
        return new MWAnalyzer(language).getIndexAnalyzer();
    }

    Directory getLuceneDirectory() {
        return this.fLocation.getSearchDirectory();
    }

    @Override
    public void openIndex() throws IOException {
        Directory dir = this.getLuceneDirectory();
        boolean createIndex = !IndexReader.indexExists((Directory)dir) || this.fOverwrite;
        this.fWriter = new IndexWriter(this.getLuceneDirectory(), this.fAnalyzer, createIndex);
        this.fWriter.setUseCompoundFile(true);
        this.fWriter.setMaxFieldLength(Integer.MAX_VALUE);
    }

    @Override
    public synchronized void addDocument(IndexDocument document) throws IOException {
        Document luceneDoc = LuceneIndexer.createDocument(document.getIndexValues());
        luceneDoc.setBoost(document.getBoost());
        this.fWriter.addDocument(luceneDoc);
    }

    void addDirectories(Directory ... directories) throws IOException {
        this.fWriter.addIndexes(directories);
    }

    private static Document createDocument(Map<SearchField, String> fieldValues) {
        Document document = new Document();
        for (Map.Entry<SearchField, String> fieldInfo : fieldValues.entrySet()) {
            Field field = LuceneIndexer.createField(fieldInfo.getKey(), fieldInfo.getValue());
            document.add(field);
        }
        return document;
    }

    private static Field createField(SearchField field, String fieldText) {
        Field.Store store = field.isStored() ? Field.Store.YES : Field.Store.NO;
        Field.Index index = Field.Index.NO;
        if (field.isIndexed()) {
            index = field.isAnalyzed() ? Field.Index.TOKENIZED : Field.Index.UN_TOKENIZED;
        }
        return new Field(field.getFieldName(), fieldText, store, index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeIndex() throws IOException {
        try {
            this.fWriter.optimize();
        }
        finally {
            this.fWriter.getDirectory().close();
            this.fWriter.close();
        }
    }

    Analyzer getAnalyzer() {
        return this.fAnalyzer;
    }

    SearchLanguage getLanguage() {
        return this.fLanguage;
    }
}

