/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.search.lucene;

import com.mathworks.search.lucene.IndexLocation;
import com.mathworks.search.lucene.MWIndexSearcher;
import com.mathworks.search.lucene.MWSearcher;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.search.MultiSearcher;
import org.apache.lucene.search.Searchable;
import org.apache.lucene.search.Searcher;

class MWMultiSearcher
implements MWSearcher {
    private final MWIndexSearcher[] fIndexSearchers;
    private final MultiSearcher fSearcher;
    private final IndexReader fReader;

    MWMultiSearcher(IndexLocation ... locations) throws IOException {
        ArrayList<MWIndexSearcher> searchers = new ArrayList<MWIndexSearcher>();
        for (IndexLocation location : locations) {
            searchers.add(location.getSearcher());
        }
        this.fIndexSearchers = searchers.toArray(new MWIndexSearcher[searchers.size()]);
        this.fSearcher = new MultiSearcher((Searchable[])this.fIndexSearchers);
        ArrayList<IndexReader> readers = new ArrayList<IndexReader>();
        for (MWIndexSearcher searcher : this.fIndexSearchers) {
            readers.add(searcher.getIndexReader());
        }
        this.fReader = new MultiReader(readers.toArray(new IndexReader[readers.size()]));
    }

    @Override
    public IndexLocation getIndexForDocument(int docNum) {
        int subsearcher = this.fSearcher.subSearcher(docNum);
        MWIndexSearcher mwis = this.fIndexSearchers[subsearcher];
        return mwis.getIndexForDocument(docNum);
    }

    @Override
    public Searcher getSearcher() {
        return this.fSearcher;
    }

    @Override
    public IndexReader getReader() {
        return this.fReader;
    }

    @Override
    public void close() throws IOException {
        this.fSearcher.close();
    }
}

