/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.admincenter;

import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.toolbox.distcomp.admincenter.PackageInfo;
import com.mathworks.toolbox.distcomp.admincenter.services.model.ClientMonitor;
import com.mathworks.toolbox.distcomp.admincenter.services.model.ServiceRequestException;
import com.mathworks.toolbox.distcomp.admincenter.services.model.UpdateProgressListener;
import com.mathworks.toolbox.distcomp.admincenter.services.model.UpdateTimer;
import com.mathworks.toolbox.distcomp.logging.DistcompLevel;
import com.mathworks.toolbox.distcomp.ui.panel.StyleGuidePanel;
import com.mathworks.toolbox.distcomp.util.ResourceBundleUtilities;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Date;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;

public class StatusBar
extends StyleGuidePanel {
    static final Integer NEVER = 0;
    static final Integer[] TIMES = new Integer[]{NEVER, 30, 60, 120, 180, 240, 300};
    private static final ResourceBundleUtilities sRes = ResourceBundleUtilities.getInstance(StatusBar.class);
    private static final String UPDATE_NOW = sRes.getString("update.now", new Object[0]);
    private static final String UPDATING = sRes.getString("update.updating", new Object[0]);
    private UpdateTimer fUpdateTimer;

    public StatusBar(UpdateTimer updateTimer, final ClientMonitor clientMonitor) {
        this.fUpdateTimer = updateTimer;
        final JComboBox<Integer> jComboBox = new JComboBox<Integer>(TIMES);
        Integer n = this.fUpdateTimer.getFreqSeconds();
        jComboBox.setSelectedItem(n);
        jComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StatusBar.this.fUpdateTimer.setFreqSeconds((Integer)jComboBox.getSelectedItem());
            }
        });
        jComboBox.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                Integer n2 = (Integer)object;
                String string = StatusBar.getFrequencyString(n2);
                return super.getListCellRendererComponent((JList<?>)jList, string, n, bl, bl2);
            }
        });
        this.fUpdateTimer.addFrequencyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Integer n = StatusBar.this.fUpdateTimer.getFreqSeconds();
                jComboBox.setSelectedItem(n);
            }
        });
        MJLabel mJLabel = new MJLabel(sRes.getString("update.freq", new Object[0]));
        final MJButton mJButton = new MJButton();
        mJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    clientMonitor.startUpdate(true);
                }
                catch (ServiceRequestException serviceRequestException) {
                    serviceRequestException.printStackTrace();
                }
            }
        });
        mJButton.setText(UPDATE_NOW);
        mJButton.setEnabled(true);
        final MJLabel mJLabel2 = new MJLabel(sRes.getString("update.last_updated", new Date()));
        mJLabel2.setFont(new Font("Monospaced", 2, 12));
        mJLabel2.setText("");
        clientMonitor.addUpdateProgressListener(new UpdateProgressListener(){

            @Override
            public void updateStarted(boolean bl) {
                PackageInfo.LOGGER.log(DistcompLevel.THREE, "Received update started notification.");
                mJButton.setText(UPDATING);
                mJButton.setEnabled(false);
            }

            @Override
            public void updateFinished(boolean bl) {
                PackageInfo.LOGGER.log(DistcompLevel.THREE, "Received update finished notification.");
                mJLabel2.setText("");
                if (!clientMonitor.getServiceInfo().isEmpty() && !bl) {
                    mJLabel2.setText(sRes.getString("update.last_updated", new Date()));
                }
                mJButton.setText(UPDATE_NOW);
                mJButton.setEnabled(true);
            }

            @Override
            public void updateFinishing() {
            }
        });
        this.addLine((JComponent[][])new JComponent[][]{{mJLabel2, null, mJLabel, jComboBox, mJButton}}, 0, 1);
        this.setName("AdminCenter.StatusBar");
        jComboBox.setName("AdminCenter.FrequencyCombobox");
        mJButton.setName("AdminCenter.UpdateButton");
    }

    private static String getFrequencyString(int n) {
        if (n == NEVER) {
            return sRes.getString("update.never", new Object[0]);
        }
        int n2 = n / 60;
        if (n2 * 60 == n) {
            if (n2 == 1) {
                return sRes.getString("update.minute", new Object[0]);
            }
            return sRes.getString("update.minutes", n2);
        }
        return sRes.getString("update.seconds", n);
    }
}

