/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.admincenter.services.view;

import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.toolbox.distcomp.admincenter.services.action.ResponseHandler;
import com.mathworks.toolbox.distcomp.control.servicerequest.ServiceRequestResponse;
import com.mathworks.toolbox.distcomp.ui.DetailsDialog;
import com.mathworks.toolbox.distcomp.util.DistcompDiagnosticException;
import com.mathworks.toolbox.distcomp.util.ResourceBundleUtilities;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

class DefaultResponseHandler
implements ResponseHandler {
    private static final ResourceBundleUtilities sRes = ResourceBundleUtilities.getInstance(DefaultResponseHandler.class);

    DefaultResponseHandler() {
    }

    @Override
    public void handleResponses(ActionEvent actionEvent, Collection<ServiceRequestResponse> collection) {
        Status status = Status.SUCCESS;
        for (ServiceRequestResponse serviceRequestResponse : collection) {
            if (!serviceRequestResponse.wasSuccessful()) {
                status = Status.FAILURE;
                break;
            }
            if (serviceRequestResponse.getException() == null) continue;
            status = Status.WARNING;
        }
        if (status == Status.SUCCESS) {
            return;
        }
        List<ServiceRequestResponse> list = DefaultResponseHandler.getResponsesWithExceptions(collection);
        int n = list.size();
        String string = sRes.getString("DefaultResponseHandler.title", new Object[0]);
        String string2 = status == Status.FAILURE ? sRes.getString("DefaultResponseHandler.errormessage", n) : sRes.getString("DefaultResponseHandler.warnmessage", n);
        String string3 = DefaultResponseHandler.getDetailsForResponsesWithExceptions(status, list);
        int n2 = status == Status.FAILURE ? 0 : 2;
        DetailsDialog detailsDialog = new DetailsDialog(MJAbstractAction.getFrame((ActionEvent)actionEvent), string, string2, n2, string3);
        ((Window)((Object)detailsDialog)).setLocationRelativeTo(((Window)((Object)detailsDialog)).getOwner());
        ((Dialog)((Object)detailsDialog)).setResizable(true);
        ((Dialog)((Object)detailsDialog)).setVisible(true);
    }

    private static String getDetailsForResponsesWithExceptions(Status status, List<ServiceRequestResponse> list) {
        int n = list.size();
        assert (n > 0) : "There should be at least 1 error/warning message.";
        String string = "";
        for (int i = 0; i < n; ++i) {
            int n2 = i + 1;
            String string2 = status == Status.FAILURE ? "Error " + n2 + ":\n\n" : "Warning " + n2 + ":\n\n";
            string = string + string2 + DefaultResponseHandler.getDetailsFromEachResponse(list.get(i)) + "\n\n";
        }
        return string;
    }

    private static List<ServiceRequestResponse> getResponsesWithExceptions(Collection<ServiceRequestResponse> collection) {
        ArrayList<ServiceRequestResponse> arrayList = new ArrayList<ServiceRequestResponse>();
        for (ServiceRequestResponse serviceRequestResponse : collection) {
            if (serviceRequestResponse.getException() == null) continue;
            arrayList.add(serviceRequestResponse);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getDetailsFromEachResponse(ServiceRequestResponse serviceRequestResponse) {
        Appendable appendable;
        String string;
        String string2;
        DistcompDiagnosticException distcompDiagnosticException = null;
        Throwable throwable = serviceRequestResponse.getException();
        if (throwable instanceof DistcompDiagnosticException) {
            distcompDiagnosticException = (DistcompDiagnosticException)throwable;
        } else if (throwable.getCause() instanceof DistcompDiagnosticException) {
            distcompDiagnosticException = (DistcompDiagnosticException)throwable.getCause();
        }
        if (distcompDiagnosticException != null) {
            string2 = DefaultResponseHandler.getDiagnosticMessage(distcompDiagnosticException);
            string = DefaultResponseHandler.getDiagnosticDetails(distcompDiagnosticException);
        } else {
            string2 = sRes.getString("DefaultResponseHandler.message.default", new Object[0]);
            appendable = new StringWriter();
            PrintWriter printWriter = new PrintWriter((Writer)appendable);
            try {
                throwable.printStackTrace(printWriter);
            }
            finally {
                printWriter.close();
            }
            string = ((StringWriter)appendable).toString();
        }
        appendable = new StringBuilder();
        ((StringBuilder)appendable).append(string2).append("\n\n").append(string);
        return ((StringBuilder)appendable).toString();
    }

    private static String getDiagnosticDetails(DistcompDiagnosticException distcompDiagnosticException) {
        assert (distcompDiagnosticException != null) : "dde must not be null.";
        StringBuilder stringBuilder = new StringBuilder();
        Throwable throwable = distcompDiagnosticException;
        while ((throwable = throwable.getCause()) != null) {
            stringBuilder.append(DefaultResponseHandler.getErrorMessage(throwable));
            if (throwable.getCause() == null) continue;
            stringBuilder.append("\n========================\n\n").append(sRes.getString("DefaultResponseHandler.details.causedby", new Object[0])).append("   --->\n").append("============\n");
        }
        return stringBuilder.toString();
    }

    private static String getErrorMessage(Throwable throwable) {
        if (throwable instanceof DistcompDiagnosticException) {
            return DefaultResponseHandler.getDiagnosticMessage((DistcompDiagnosticException)throwable);
        }
        return throwable.getMessage();
    }

    private static String getDiagnosticMessage(DistcompDiagnosticException distcompDiagnosticException) {
        return sRes.getString(distcompDiagnosticException);
    }

    private static enum Status {
        SUCCESS,
        WARNING,
        FAILURE;

    }
}

