/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.admincenter.testing.infra.test;

import com.mathworks.toolbox.distcomp.admincenter.testing.infra.Node;
import com.mathworks.toolbox.distcomp.admincenter.testing.infra.dependency.AddressList;
import com.mathworks.toolbox.distcomp.admincenter.testing.infra.dependency.CanonicalHostname;
import com.mathworks.toolbox.distcomp.admincenter.testing.infra.dependency.Hostname;
import com.mathworks.toolbox.distcomp.admincenter.testing.infra.dependency.UseIPv6;
import com.mathworks.toolbox.distcomp.admincenter.testing.infra.test.ResolveHostname;
import com.mathworks.toolbox.distcomp.admincenter.testing.infra.test.ResolveHostnameResult;
import com.mathworks.toolbox.distcomp.admincenter.testing.infra.test.RunnableTest;
import com.mathworks.toolbox.distcomp.admincenter.testing.infra.test.Test;
import com.mathworks.toolbox.distcomp.admincenter.testing.infra.util.UnsetAttributeException;
import com.mathworks.toolbox.distcomp.admincenter.testing.shared.TestCategory;
import java.net.InetAddress;
import java.util.Collection;

public class ResolveHostnameTest
extends Test<ResolveHostnameResult>
implements Hostname.Consumer,
UseIPv6.Consumer,
Hostname.Provider,
AddressList.Provider,
CanonicalHostname.Provider {
    private String fHostname = null;
    private Boolean fUseIPv6 = null;
    private Collection<InetAddress> fAddressList = null;
    private String fCanonicalHostname = null;

    public ResolveHostnameTest(Node node, Node node2, TestCategory testCategory) {
        super(node, node2, testCategory);
    }

    @Override
    public RunnableTest<ResolveHostnameResult> createRunnableTest() throws UnsetAttributeException {
        if (this.fHostname == null) {
            throw new UnsetAttributeException("fHostname was still null");
        }
        if (this.fUseIPv6 == null) {
            throw new UnsetAttributeException("fUseIPv6 was still null");
        }
        return new ResolveHostname(this.fHostname, this.fUseIPv6, this.isLoopbackTest());
    }

    @Override
    public String getDescription() {
        if (this.fUseIPv6 == null || !this.fUseIPv6.booleanValue()) {
            return "ResolveHostname Test";
        }
        return "ResolveHostname Test (IPv6)";
    }

    @Override
    public void setHostname(String string) throws IllegalArgumentException {
        if (string == null) {
            throw this.getIllegalArgumentException(this, "Hostname was null.");
        }
        this.fHostname = string;
    }

    @Override
    public void setUseIPv6(Boolean bl) throws IllegalArgumentException {
        if (bl == null) {
            throw this.getIllegalArgumentException(this, "UseIPv6 was null.");
        }
        this.fUseIPv6 = bl;
    }

    @Override
    public Collection<InetAddress> getAddressList() {
        return this.fAddressList;
    }

    @Override
    public String getHostname() {
        return this.fHostname;
    }

    @Override
    public String getCanonicalHostname() {
        return this.fCanonicalHostname;
    }

    @Override
    public void onTestComplete(ResolveHostnameResult resolveHostnameResult) {
        this.fAddressList = resolveHostnameResult.getAddressList();
        this.fHostname = resolveHostnameResult.getHostname();
        this.fCanonicalHostname = resolveHostnameResult.getCanonicalHostname();
    }
}

