/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.auth.credentials.store;

import com.mathworks.toolbox.distcomp.auth.CryptoModule;
import com.mathworks.toolbox.distcomp.auth.credentials.CredentialCreationException;
import com.mathworks.toolbox.distcomp.auth.credentials.Credentials;
import com.mathworks.toolbox.distcomp.auth.credentials.NontransferableCredentials;
import com.mathworks.toolbox.distcomp.auth.credentials.TransferableCredentials;
import com.mathworks.toolbox.distcomp.auth.credentials.UserIdentity;
import com.mathworks.toolbox.distcomp.auth.credentials.store.CredentialProviderRemote;
import com.mathworks.toolbox.distcomp.auth.credentials.store.CredentialStore;
import com.mathworks.toolbox.distcomp.auth.credentials.store.CredentialStoreProxy;
import com.mathworks.toolbox.distcomp.auth.credentials.store.NoCredentialsException;
import com.mathworks.toolbox.distcomp.service.Exporter;
import java.rmi.RemoteException;

public final class CredentialProviderImpl<T extends Credentials>
implements CredentialProviderRemote {
    private final CredentialStore<T> fCredentialStore;
    private CredentialProviderRemote fStub = null;
    private final Exporter fExporter;

    public CredentialProviderImpl(CredentialStore<T> credentialStore, Exporter exporter) {
        this.fCredentialStore = credentialStore;
        this.fExporter = exporter;
    }

    public CredentialStoreProxy getProxy() throws RemoteException {
        if (this.fStub == null) {
            this.exportCredentialProvider();
        }
        return new CredentialStoreProxy(this.fStub);
    }

    private void exportCredentialProvider() throws RemoteException {
        this.fStub = (CredentialProviderRemote)this.fExporter.export(this);
    }

    public void unexport() {
        if (this.fStub != null) {
            this.fExporter.unexport(true);
            this.fStub = null;
        }
    }

    @Override
    public TransferableCredentials getCredentials(UserIdentity userIdentity, byte[] byArray, CryptoModule.Encryptor encryptor) throws CredentialCreationException, NoCredentialsException {
        T t = this.fCredentialStore.getCredentials(userIdentity);
        if (t instanceof TransferableCredentials) {
            return (TransferableCredentials)t;
        }
        boolean bl = !this.fExporter.isExportSecure();
        return ((NontransferableCredentials)t).prepare(bl, byArray, encryptor);
    }

    public CredentialStore<T> getCredentialStore() {
        return this.fCredentialStore;
    }
}

