/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.auth.modules;

import com.mathworks.toolbox.distcomp.auth.CryptoModule;
import com.mathworks.toolbox.distcomp.auth.Erasable;
import com.mathworks.toolbox.distcomp.auth.RemoteTrustModule;
import com.mathworks.toolbox.distcomp.auth.TrustModule;
import com.mathworks.toolbox.distcomp.auth.Trustee;
import com.mathworks.toolbox.distcomp.auth.credentials.AuthenticationToken;
import com.mathworks.toolbox.distcomp.auth.credentials.EncryptedAuthenticationToken;
import com.mathworks.toolbox.distcomp.auth.credentials.UserIdentity;
import com.mathworks.toolbox.distcomp.auth.credentials.store.CredentialProviderImpl;
import com.mathworks.toolbox.distcomp.auth.credentials.store.CredentialProviderLocal;
import com.mathworks.toolbox.distcomp.auth.credentials.store.SingleUserCredentialStore;
import com.mathworks.toolbox.distcomp.auth.modules.ModuleCreationException;
import com.mathworks.toolbox.distcomp.auth.modules.PackageInfo;
import com.mathworks.toolbox.distcomp.logging.DistcompLevel;
import com.mathworks.toolbox.distcomp.service.Exporter;
import com.mathworks.toolbox.distcomp.service.ExporterFactory;
import java.rmi.RemoteException;

public final class TrustModuleSSLImpl
implements TrustModule {
    private static final UserIdentity DUMMY_ID = new UserIdentity("dummy");
    private static final int PASSWORD_SIZE = 12;
    private final CryptoModule fCryptoModule;
    private final ExporterFactory fExporterFactory;

    public TrustModuleSSLImpl(CryptoModule cryptoModule, ExporterFactory exporterFactory) throws ModuleCreationException {
        this.fExporterFactory = exporterFactory;
        try {
            this.checkSecureCommunication(this.fExporterFactory.createExporter());
        }
        catch (IllegalStateException illegalStateException) {
            throw new ModuleCreationException("Unable to create trust module.", illegalStateException);
        }
        this.fCryptoModule = cryptoModule;
    }

    private void checkSecureCommunication(Exporter exporter) throws IllegalStateException {
        if (!exporter.isExportSecure()) {
            throw new IllegalStateException("Job scheduler services can only establish trust among themselves if they\ncan communicate securely.  Currently, secure communication is not enabled.\nYou need to switch it on in the mdce_def file.");
        }
    }

    @Override
    public RemoteTrustModule getRemoteTrustModule() {
        return new RemoteTrustModule(){

            @Override
            public Object provideEvidence(Object object) {
                try {
                    AuthenticationToken authenticationToken = (AuthenticationToken)((CredentialProviderLocal)object).getCredentials(DUMMY_ID, TrustModuleSSLImpl.this.fCryptoModule);
                    return authenticationToken.prepare();
                }
                catch (Throwable throwable) {
                    return throwable;
                }
            }
        };
    }

    @Override
    public boolean isTrusted(Trustee trustee) {
        String string;
        try {
            string = trustee.getName();
        }
        catch (RemoteException remoteException) {
            return false;
        }
        try {
            Exporter exporter = this.fExporterFactory.createExporter();
            this.checkSecureCommunication(exporter);
            Erasable erasable = new Erasable(this.fCryptoModule.createSalt(12));
            AuthenticationToken authenticationToken = new AuthenticationToken(DUMMY_ID, erasable);
            SingleUserCredentialStore<EncryptedAuthenticationToken> singleUserCredentialStore = new SingleUserCredentialStore<EncryptedAuthenticationToken>(authenticationToken.prepare());
            CredentialProviderImpl<EncryptedAuthenticationToken> credentialProviderImpl = new CredentialProviderImpl<EncryptedAuthenticationToken>(singleUserCredentialStore, exporter);
            Object object = trustee.provideEvidence(credentialProviderImpl.getProxy());
            credentialProviderImpl.unexport();
            if (object instanceof Throwable) {
                throw (Throwable)object;
            }
            AuthenticationToken authenticationToken2 = ((EncryptedAuthenticationToken)object).unpack();
            boolean bl = authenticationToken.equals(authenticationToken2);
            if (bl) {
                PackageInfo.LOGGER.log(DistcompLevel.FOUR, String.format("Established trust with worker %s.", string));
            } else {
                PackageInfo.LOGGER.log(DistcompLevel.TWO, String.format("Trust with worker %s could not be established. Authentication tokens do not match.", string));
            }
            return bl;
        }
        catch (Throwable throwable) {
            PackageInfo.LOGGER.log(DistcompLevel.TWO, String.format("Trust with worker %s could not be established.", string), throwable);
            return false;
        }
    }
}

