/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.clusteraccess;

import com.mathworks.toolbox.distcomp.clusteraccess.JobNotMirroredException;
import com.mathworks.toolbox.distcomp.clusteraccess.Logger;
import com.mathworks.toolbox.distcomp.clusteraccess.MirrorFilesInfo;
import com.mathworks.toolbox.distcomp.clusteraccess.SharedPath;
import com.mathworks.toolbox.distcomp.remote.CopyFromRemoteCommand;
import com.mathworks.toolbox.distcomp.remote.DispatchException;
import com.mathworks.toolbox.distcomp.remote.FileSystemManipulatorFuture;
import com.mathworks.toolbox.distcomp.remote.FulfillmentException;
import com.mathworks.toolbox.distcomp.remote.Future;
import com.mathworks.toolbox.distcomp.remote.ListFileAttributesCommand;
import com.mathworks.toolbox.distcomp.remote.ListFileAttributesFuture;
import com.mathworks.toolbox.distcomp.remote.NoSuchProtocolException;
import com.mathworks.toolbox.distcomp.remote.ParameterMap;
import com.mathworks.toolbox.distcomp.remote.ProtocolProvider;
import com.mathworks.toolbox.distcomp.remote.RemoteExecutionException;
import com.mathworks.toolbox.distcomp.remote.spi.FileSystemManipulator;
import com.mathworks.toolbox.distcomp.util.FileDeleter;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.io.FileUtils;

final class MirrorFilesHelper {
    private final MirrorFilesInfo fMirrorFilesInfo;
    private final String fHostname;
    private final ParameterMap fParameterMap;
    private final AtomicBoolean fReduceInterval = new AtomicBoolean(false);
    private final Lock fLock = new ReentrantLock();
    private final Condition fCompleted = this.fLock.newCondition();
    private final Map<SharedPath, ListFileAttributesFuture.FileAttributes> fStateFiles;
    private final Map<SharedPath, ListFileAttributesFuture.FileAttributes> fDataFiles;
    private boolean fCanceled = false;
    private Future fFuture = null;

    MirrorFilesHelper(MirrorFilesInfo mirrorFilesInfo, String string, ParameterMap parameterMap) {
        this.fMirrorFilesInfo = mirrorFilesInfo;
        this.fHostname = string;
        this.fParameterMap = parameterMap;
        this.fStateFiles = new LinkedHashMap<SharedPath, ListFileAttributesFuture.FileAttributes>();
        this.fDataFiles = new LinkedHashMap<SharedPath, ListFileAttributesFuture.FileAttributes>();
        Map<SharedPath, ListFileAttributesFuture.FileAttributes> map = MirrorFilesHelper.createLocalAttributeMap(mirrorFilesInfo);
        map.putAll(this.fMirrorFilesInfo.getSentFiles());
        Logger.LOGGER.finest(this.logPrefix() + "localFiles are " + map);
        for (SharedPath sharedPath : map.keySet()) {
            if (sharedPath.containsPath(this.fMirrorFilesInfo.getExcludeFromMirror())) continue;
            if (sharedPath.containsPath(this.fMirrorFilesInfo.getStateFilePaths())) {
                this.fStateFiles.put(sharedPath, map.get(sharedPath));
                continue;
            }
            if (!sharedPath.containsPath(this.fMirrorFilesInfo.getDataFilePaths())) continue;
            this.fDataFiles.put(sharedPath, map.get(sharedPath));
        }
        Logger.LOGGER.finest(this.logPrefix() + "local data files are " + this.fDataFiles);
        Logger.LOGGER.finest(this.logPrefix() + "local state files are " + this.fStateFiles);
    }

    private static Map<SharedPath, ListFileAttributesFuture.FileAttributes> createLocalAttributeMap(MirrorFilesInfo mirrorFilesInfo) {
        LinkedHashMap<SharedPath, ListFileAttributesFuture.FileAttributes> linkedHashMap = new LinkedHashMap<SharedPath, ListFileAttributesFuture.FileAttributes>();
        MirrorFilesHelper.recursiveFillLocalValueMapFor(mirrorFilesInfo.getLocalDataLocation(), linkedHashMap, mirrorFilesInfo);
        return linkedHashMap;
    }

    private static void recursiveFillLocalValueMapFor(File file, Map<SharedPath, ListFileAttributesFuture.FileAttributes> map, MirrorFilesInfo mirrorFilesInfo) {
        if (file.exists()) {
            Object object;
            long l = file.length();
            boolean bl = file.isDirectory();
            SharedPath sharedPath = new SharedPath(file, mirrorFilesInfo.getLocalDataLocation());
            String string = sharedPath.getRemotePath(mirrorFilesInfo.getRemoteDataLocation());
            if (!mirrorFilesInfo.getRemoteDataLocation().equals(string)) {
                object = new ListFileAttributesFuture.FileAttributes(string, l, 0L, bl, "localhost");
                map.put(sharedPath, (ListFileAttributesFuture.FileAttributes)object);
            }
            if (bl) {
                object = file.listFiles();
                if (object != null) {
                    for (File file2 : object) {
                        MirrorFilesHelper.recursiveFillLocalValueMapFor(file2, map, mirrorFilesInfo);
                    }
                } else {
                    Logger.LOGGER.warning(file.toString() + " is a directory but listFiles() returned null. Directory not traversed.");
                }
            }
        }
    }

    private MirrorFilesHelper(MirrorFilesHelper mirrorFilesHelper) {
        this.fMirrorFilesInfo = mirrorFilesHelper.fMirrorFilesInfo;
        this.fHostname = mirrorFilesHelper.fHostname;
        this.fParameterMap = mirrorFilesHelper.fParameterMap;
        this.fStateFiles = mirrorFilesHelper.copyStateFileMap();
        this.fDataFiles = mirrorFilesHelper.copyDataFileMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MirrorFilesHelper copy() {
        this.fLock.lock();
        try {
            MirrorFilesHelper mirrorFilesHelper = new MirrorFilesHelper(this);
            return mirrorFilesHelper;
        }
        finally {
            this.fLock.unlock();
        }
    }

    MirrorFilesInfo getJobFileInfo() {
        return this.fMirrorFilesInfo;
    }

    String getHostname() {
        return this.fHostname;
    }

    ParameterMap getParameterMap() {
        return this.fParameterMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putInStateFileMap(SharedPath sharedPath, ListFileAttributesFuture.FileAttributes fileAttributes) {
        this.fLock.lock();
        try {
            this.fStateFiles.put(sharedPath, fileAttributes);
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromStateFileMap(SharedPath sharedPath) {
        this.fLock.lock();
        try {
            this.fStateFiles.remove(sharedPath);
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putInDataFileMap(SharedPath sharedPath, ListFileAttributesFuture.FileAttributes fileAttributes) {
        this.fLock.lock();
        try {
            this.fDataFiles.put(sharedPath, fileAttributes);
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromDataFileMap(SharedPath sharedPath) {
        this.fLock.lock();
        try {
            this.fDataFiles.remove(sharedPath);
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<SharedPath, ListFileAttributesFuture.FileAttributes> copyStateFileMap() {
        this.fLock.lock();
        try {
            LinkedHashMap<SharedPath, ListFileAttributesFuture.FileAttributes> linkedHashMap = new LinkedHashMap<SharedPath, ListFileAttributesFuture.FileAttributes>(this.fStateFiles);
            return linkedHashMap;
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<SharedPath, ListFileAttributesFuture.FileAttributes> copyDataFileMap() {
        this.fLock.lock();
        try {
            LinkedHashMap<SharedPath, ListFileAttributesFuture.FileAttributes> linkedHashMap = new LinkedHashMap<SharedPath, ListFileAttributesFuture.FileAttributes>(this.fDataFiles);
            return linkedHashMap;
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancel() {
        this.fLock.lock();
        try {
            this.fCanceled = true;
            if (this.fFuture != null) {
                this.fFuture.cancel();
            }
            Logger.LOGGER.finest(this.logPrefix() + " fCompleted signaled");
            this.fCompleted.signalAll();
        }
        finally {
            this.fLock.unlock();
        }
        Logger.LOGGER.fine(this.logPrefix() + "Canceled");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean wasCanceled() {
        this.fLock.lock();
        try {
            boolean bl = this.fCanceled;
            return bl;
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean runChore() throws JobNotMirroredException {
        File file = null;
        try {
            file = this.createTempDir();
            MirrorResults mirrorResults = this.retrieveStateFiles(file);
            MirrorResults mirrorResults2 = this.retrieveDataFiles(file);
            if (!this.wasCanceled()) {
                this.commitRetrievedFiles(mirrorResults2, mirrorResults, file);
                boolean bl = true;
                return bl;
            }
            Logger.LOGGER.finest(this.logPrefix() + " canceled during run.");
            boolean bl = false;
            return bl;
        }
        finally {
            this.deleteTempDir(file);
        }
    }

    private void commitRetrievedFiles(MirrorResults mirrorResults, MirrorResults mirrorResults2, File file) throws JobNotMirroredException {
        if (this.fMirrorFilesInfo.deleteDataFiles()) {
            this.deleteFilesOnLocal(mirrorResults.getRemovedFiles());
        }
        this.stopTrackingFilesDeletedOnRemote(mirrorResults.getRemovedFiles(), false);
        this.moveFilesFromTempToLocal(file, mirrorResults.getChangedFiles(), false);
        if (this.fMirrorFilesInfo.deleteStateFiles()) {
            this.deleteFilesOnLocal(mirrorResults2.getRemovedFiles());
        }
        this.stopTrackingFilesDeletedOnRemote(mirrorResults2.getRemovedFiles(), true);
        this.moveFilesFromTempToLocal(file, mirrorResults2.getChangedFiles(), true);
        if (!(mirrorResults.getChangedFiles().isEmpty() && mirrorResults.getRemovedFiles().isEmpty() && mirrorResults2.getChangedFiles().isEmpty() && mirrorResults2.getRemovedFiles().isEmpty())) {
            this.requestReducedInterval();
        }
    }

    private File createTempDir() throws JobNotMirroredException {
        try {
            File file = com.mathworks.util.FileUtils.createUniqueTempDir((String)"fileMirror", (boolean)true);
            Logger.LOGGER.finer(this.logPrefix() + "Created " + file);
            return file;
        }
        catch (IOException iOException) {
            throw new JobNotMirroredException("Could not create temporary directory.", this.fMirrorFilesInfo.getJobId(), iOException);
        }
    }

    private void deleteTempDir(File file) {
        Logger.LOGGER.finest(this.logPrefix() + "Attempting to delete " + file);
        if (file != null) {
            FileDeleter.deleteFile(file);
        }
    }

    private MirrorResults retrieveStateFiles(File file) throws JobNotMirroredException {
        return this.retrieveFiles(file, this.fMirrorFilesInfo.getStateFilePaths(), this.fMirrorFilesInfo.getExcludeFromMirror(), this.copyStateFileMap());
    }

    private MirrorResults retrieveDataFiles(File file) throws JobNotMirroredException {
        return this.retrieveFiles(file, this.fMirrorFilesInfo.getDataFilePaths(), this.fMirrorFilesInfo.getExcludeFromMirror(), this.copyDataFileMap());
    }

    private MirrorResults retrieveFiles(File file, Set<SharedPath> set, Set<SharedPath> set2, Map<SharedPath, ListFileAttributesFuture.FileAttributes> map) throws JobNotMirroredException {
        Logger.LOGGER.finest(this.logPrefix() + "localFiles are " + map);
        if (!this.wasCanceled()) {
            MirrorResults mirrorResults = this.findRemoteFileInfo(set);
            Set<SharedPath> set3 = mirrorResults.getRemovedFiles();
            Logger.LOGGER.finest(this.logPrefix() + "removedFiles are " + set3);
            Set<SharedPath> set4 = this.findChangedFiles(map, mirrorResults.getChangedFiles());
            set4.remove(new SharedPath(""));
            this.removeExcluded(set4, set2);
            Logger.LOGGER.finest(this.logPrefix() + "will retrieve " + set4);
            set3.addAll(this.findRemovedFiles(map, mirrorResults.getChangedFiles()));
            Logger.LOGGER.finest(this.logPrefix() + "removedFiles are " + set3);
            MirrorResults mirrorResults2 = this.retrieveFiles(set4, file, set2);
            set3.addAll(mirrorResults2.getRemovedFiles());
            Logger.LOGGER.finest(this.logPrefix() + "removedFiles are " + set3);
            return new MirrorResults(mirrorResults2.getChangedFiles(), set3);
        }
        return new MirrorResults(Collections.<SharedPath, ListFileAttributesFuture.FileAttributes>emptyMap(), Collections.<SharedPath>emptySet());
    }

    private void removeExcluded(Set<SharedPath> set, Set<SharedPath> set2) {
        set.removeAll(set2);
        Iterator<SharedPath> iterator = set.iterator();
        while (iterator.hasNext()) {
            SharedPath sharedPath = iterator.next();
            if (!sharedPath.containsPath(set2)) continue;
            iterator.remove();
        }
    }

    private MirrorResults findRemoteFileInfo(Set<SharedPath> set) throws JobNotMirroredException {
        try {
            Set<String> set2 = SharedPath.sharedPathsToRemotePaths(set, this.fMirrorFilesInfo.getRemoteDataLocation());
            ListFileAttributesCommand listFileAttributesCommand = new ListFileAttributesCommand(set2);
            FileSystemManipulator fileSystemManipulator = this.getFileSystemManipulator();
            Logger.LOGGER.finest(this.logPrefix() + "looking for info on" + set);
            ListFileAttributesFuture listFileAttributesFuture = fileSystemManipulator.list(listFileAttributesCommand, this.fHostname, this.fParameterMap);
            this.setActiveFuture(listFileAttributesFuture);
            Map<SharedPath, ListFileAttributesFuture.FileAttributes> map = SharedPath.remotePathKeysToSharedPathKeys(listFileAttributesFuture.getFileAttributes(), this.fMirrorFilesInfo.getRemoteDataLocation());
            this.setActiveFuture(null);
            Logger.LOGGER.finest(this.logPrefix() + "got info on " + map);
            Set<SharedPath> set3 = SharedPath.remotePathsToSharedPaths(listFileAttributesFuture.getMissingFileNames(), this.fMirrorFilesInfo.getRemoteDataLocation());
            Logger.LOGGER.finest(this.logPrefix() + "findRemoteFileInfo removed was " + set3);
            return new MirrorResults(map, set3);
        }
        catch (DispatchException dispatchException) {
            throw new JobNotMirroredException(this.fMirrorFilesInfo.getJobId(), (RemoteExecutionException)dispatchException);
        }
        catch (FulfillmentException fulfillmentException) {
            throw new JobNotMirroredException(this.fMirrorFilesInfo.getJobId(), (RemoteExecutionException)fulfillmentException);
        }
        catch (InterruptedException interruptedException) {
            throw new JobNotMirroredException(this.fMirrorFilesInfo.getJobId(), interruptedException);
        }
    }

    private MirrorResults retrieveFiles(Set<SharedPath> set, File file, Set<SharedPath> set2) throws JobNotMirroredException {
        LinkedHashMap<SharedPath, ListFileAttributesFuture.FileAttributes> linkedHashMap = new LinkedHashMap<SharedPath, ListFileAttributesFuture.FileAttributes>();
        LinkedHashSet<SharedPath> linkedHashSet = new LinkedHashSet<SharedPath>();
        int n = set.size();
        while (!this.wasCanceled() && !set.isEmpty() && n > 0) {
            --n;
            SharedPath sharedPath = set.iterator().next();
            File file2 = sharedPath.getLocalPath(file);
            String string = sharedPath.getRemotePath(this.fMirrorFilesInfo.getRemoteDataLocation());
            this.createAncestorDirectoriesIfNeeded(file2);
            Set<String> set3 = SharedPath.sharedPathsToRemotePaths(set2, this.fMirrorFilesInfo.getRemoteDataLocation());
            CopyFromRemoteCommand copyFromRemoteCommand = new CopyFromRemoteCommand(file2, string, set3);
            FileSystemManipulator fileSystemManipulator = this.getFileSystemManipulator();
            try {
                FileSystemManipulatorFuture fileSystemManipulatorFuture = (FileSystemManipulatorFuture)fileSystemManipulator.copyFile(copyFromRemoteCommand, this.fHostname, this.fParameterMap);
                this.setActiveFuture(fileSystemManipulatorFuture);
                Logger.LOGGER.finest(this.logPrefix() + "created copyFuture for " + string);
                fileSystemManipulatorFuture.awaitEnd();
                this.setActiveFuture(null);
                Set<SharedPath> set4 = SharedPath.remotePathsToSharedPaths(fileSystemManipulatorFuture.getFileAttributes().keySet(), this.fMirrorFilesInfo.getRemoteDataLocation());
                Logger.LOGGER.finer(this.logPrefix() + "future retrieved " + set4);
                set.removeAll(set4);
                linkedHashMap.putAll(SharedPath.remotePathKeysToSharedPathKeys(fileSystemManipulatorFuture.getFileAttributes(), this.fMirrorFilesInfo.getRemoteDataLocation()));
                Set<SharedPath> set5 = SharedPath.remotePathsToSharedPaths(fileSystemManipulatorFuture.getMissingFileNames(), this.fMirrorFilesInfo.getRemoteDataLocation());
                set.removeAll(set5);
                linkedHashSet.addAll(set5);
                Logger.LOGGER.finest(this.logPrefix() + set.size() + " remain.");
            }
            catch (DispatchException dispatchException) {
                throw new JobNotMirroredException(this.fMirrorFilesInfo.getJobId(), (RemoteExecutionException)dispatchException);
            }
            catch (FulfillmentException fulfillmentException) {
                throw new JobNotMirroredException(this.fMirrorFilesInfo.getJobId(), (RemoteExecutionException)fulfillmentException);
            }
            catch (InterruptedException interruptedException) {
                throw new JobNotMirroredException(this.fMirrorFilesInfo.getJobId(), interruptedException);
            }
            finally {
                this.setActiveFuture(null);
            }
        }
        if (!this.wasCanceled() && !set.isEmpty()) {
            Logger.LOGGER.warning(this.logPrefix() + "Count limit used to stop the while loop. Unable to retrieve " + set);
        }
        Logger.LOGGER.finest(this.logPrefix() + "retrieved " + linkedHashMap.size());
        Logger.LOGGER.finest(this.logPrefix() + "retrieveFiles will remove " + linkedHashSet);
        return new MirrorResults(linkedHashMap, linkedHashSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setActiveFuture(Future future) {
        this.fLock.lock();
        try {
            this.fFuture = future;
        }
        finally {
            this.fLock.unlock();
        }
    }

    private FileSystemManipulator getFileSystemManipulator() {
        try {
            return (FileSystemManipulator)ProtocolProvider.getInstance().getProtocolByType("sftp");
        }
        catch (NoSuchProtocolException noSuchProtocolException) {
            AssertionError assertionError = new AssertionError((Object)"Someone's removed sftp from the ProtocolProvider");
            ((Throwable)((Object)assertionError)).initCause(noSuchProtocolException);
            throw assertionError;
        }
    }

    private Set<SharedPath> findChangedFiles(Map<SharedPath, ListFileAttributesFuture.FileAttributes> map, Map<SharedPath, ListFileAttributesFuture.FileAttributes> map2) {
        LinkedHashSet<SharedPath> linkedHashSet = new LinkedHashSet<SharedPath>();
        for (SharedPath sharedPath : map2.keySet()) {
            ListFileAttributesFuture.FileAttributes fileAttributes = map.get(sharedPath);
            Logger.LOGGER.finest("Looking for changes to " + sharedPath + " last attributes where " + fileAttributes);
            if (fileAttributes == null) {
                linkedHashSet.add(sharedPath);
                Logger.LOGGER.finest("Added to changed files because " + sharedPath + " did not exist in the local files.");
                continue;
            }
            ListFileAttributesFuture.FileAttributes fileAttributes2 = map2.get(sharedPath);
            if (!fileAttributes2.differentFileAttributes(fileAttributes)) continue;
            linkedHashSet.add(sharedPath);
            Logger.LOGGER.finest("Added to changed files because " + sharedPath + " had different attributes.");
        }
        return linkedHashSet;
    }

    private Set<SharedPath> findRemovedFiles(Map<SharedPath, ListFileAttributesFuture.FileAttributes> map, Map<SharedPath, ListFileAttributesFuture.FileAttributes> map2) {
        Logger.LOGGER.finest(this.logPrefix() + "findRemovedFiles from " + map.keySet());
        Logger.LOGGER.finest(this.logPrefix() + "findRemovedFiles using " + map2.keySet());
        LinkedHashSet<SharedPath> linkedHashSet = new LinkedHashSet<SharedPath>(map.keySet());
        linkedHashSet.removeAll(map2.keySet());
        Logger.LOGGER.finest(this.logPrefix() + "findRemovedFiles will remove " + linkedHashSet);
        return linkedHashSet;
    }

    private void createAncestorDirectoriesIfNeeded(File file) {
        File file2 = file.getParentFile();
        if (!file2.exists()) {
            boolean bl = file2.mkdirs();
            if (bl) {
                Logger.LOGGER.finer(this.logPrefix() + "created ancestor directories for " + file);
            } else {
                Logger.LOGGER.warning(this.logPrefix() + "could not create ancestor directories for " + file);
            }
        }
    }

    private void deleteFilesOnLocal(Set<SharedPath> set) {
        Logger.LOGGER.finest(this.logPrefix() + "To delete " + set);
        for (SharedPath sharedPath : set) {
            File file = sharedPath.getLocalPath(this.fMirrorFilesInfo.getLocalDataLocation());
            boolean bl = FileDeleter.deleteFile(file);
            if (bl) {
                Logger.LOGGER.finer(this.logPrefix() + "Deleted " + file);
                continue;
            }
            Logger.LOGGER.warning(this.logPrefix() + "Could not delete " + file + " immediately.");
        }
    }

    private void stopTrackingFilesDeletedOnRemote(Set<SharedPath> set, boolean bl) {
        Logger.LOGGER.finest(this.logPrefix() + set + " deleted from remote and no longer tracked");
        for (SharedPath sharedPath : set) {
            if (bl) {
                this.removeFromStateFileMap(sharedPath);
                continue;
            }
            this.removeFromDataFileMap(sharedPath);
        }
    }

    private void moveFilesFromTempToLocal(File file, Map<SharedPath, ListFileAttributesFuture.FileAttributes> map, boolean bl) throws JobNotMirroredException {
        Logger.LOGGER.finest(this.logPrefix() + "moveFilesFromTempToLocal called with " + map.size());
        for (SharedPath sharedPath : map.keySet()) {
            File file2 = sharedPath.getLocalPath(file);
            File file3 = sharedPath.getLocalPath(this.fMirrorFilesInfo.getLocalDataLocation());
            this.createAncestorDirectoriesIfNeeded(file3);
            if (file2.isDirectory()) {
                boolean bl2;
                if (file3.exists()) {
                    if (file3.isDirectory()) {
                        this.putInFileMap(sharedPath, map.get(sharedPath), bl);
                    } else {
                        bl2 = FileDeleter.deleteFile(file3);
                        if (bl2) {
                            Logger.LOGGER.finer(this.logPrefix() + "Deleted " + file3);
                        }
                        if (!bl2) {
                            Logger.LOGGER.warning(this.logPrefix() + "Could not delete " + file3 + " immediately.");
                        }
                    }
                }
                if (file3.exists()) continue;
                bl2 = file3.mkdir();
                if (bl2) {
                    this.putInFileMap(sharedPath, map.get(sharedPath), bl);
                    Logger.LOGGER.finer(this.logPrefix() + "Created " + file3);
                    continue;
                }
                Logger.LOGGER.warning(this.logPrefix() + "Could not create " + file3);
                continue;
            }
            if (file2.isFile()) {
                try {
                    FileUtils.copyFile((File)file2, (File)file3);
                }
                catch (IOException iOException) {
                    throw new JobNotMirroredException(this.logPrefix() + "Failed to move " + file2 + " to " + file3, this.fMirrorFilesInfo.getJobId(), iOException);
                }
                Logger.LOGGER.finer(this.logPrefix() + "Moved " + file2 + " to " + file3);
                this.putInFileMap(sharedPath, map.get(sharedPath), bl);
                continue;
            }
            Logger.LOGGER.warning(this.logPrefix() + file2.toString() + " is not a file or a directory");
        }
        Logger.LOGGER.finest(this.logPrefix() + "moveFilesFromTempToLocal completed with " + map.size());
    }

    private void putInFileMap(SharedPath sharedPath, ListFileAttributesFuture.FileAttributes fileAttributes, boolean bl) {
        if (bl) {
            this.putInStateFileMap(sharedPath, fileAttributes);
            Logger.LOGGER.finest(this.logPrefix() + "Added " + sharedPath + " to " + this.fStateFiles);
        } else {
            this.putInDataFileMap(sharedPath, fileAttributes);
            Logger.LOGGER.finest(this.logPrefix() + "Added " + sharedPath + " to " + this.fDataFiles);
        }
    }

    private void requestReducedInterval() {
        this.fReduceInterval.set(true);
    }

    boolean getAndResetReduceInterval() {
        return this.fReduceInterval.getAndSet(false);
    }

    String logPrefix() {
        return "Mirror files for job " + this.fMirrorFilesInfo.getJobId() + " on " + this.fHostname + ": ";
    }

    private static final class MirrorResults {
        private final Map<SharedPath, ListFileAttributesFuture.FileAttributes> fChangedFiles;
        private final Set<SharedPath> fRemovedFiles;

        MirrorResults(Map<SharedPath, ListFileAttributesFuture.FileAttributes> map, Set<SharedPath> set) {
            this.fChangedFiles = map;
            this.fRemovedFiles = set;
        }

        Map<SharedPath, ListFileAttributesFuture.FileAttributes> getChangedFiles() {
            return this.fChangedFiles;
        }

        Set<SharedPath> getRemovedFiles() {
            return this.fRemovedFiles;
        }
    }
}

