/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.control;

import com.mathworks.toolbox.distcomp.control.ClusterLogsConfigParser;
import com.mathworks.toolbox.distcomp.control.ControlStartStopConfigParser;
import com.mathworks.toolbox.distcomp.control.MDCSCommand;
import com.mathworks.toolbox.distcomp.control.StatusConfigParser;
import com.mathworks.toolbox.distcomp.util.ConfigFileWrapper;
import net.jini.config.ConfigurationException;

public class CommandConfigParser {
    public static final String REMOTE_COMMAND_TYPE = "remoteCommandType";
    public static final String REMOTE_HOSTNAME = "remoteHostname";
    public static final String REMOTE_COMMAND_PORT = "remoteCommandPort";
    public static final String VERBOSITY = "verbosity";
    public static final String JOBMANAGER_REMOTE_COMMAND_TYPE = "jobmanager";
    public static final String LOOKUP_REMOTE_COMMAND_TYPE = "lookup";
    public static final String WORKER_REMOTE_COMMAND_TYPE = "worker";
    public static final String NODE_STATUS = "nodestatus";
    public static final String CLUSTER_LOGS = "clusterlogs";

    public static MDCSCommand createMDCSCommand(ConfigFileWrapper configFileWrapper) throws ConfigurationException {
        String string = configFileWrapper.getNonEmptyStringEntry(REMOTE_COMMAND_TYPE);
        if (string.equals(JOBMANAGER_REMOTE_COMMAND_TYPE) || string.equals(LOOKUP_REMOTE_COMMAND_TYPE) || string.equals(WORKER_REMOTE_COMMAND_TYPE)) {
            return ControlStartStopConfigParser.createStartStopCommand(configFileWrapper);
        }
        if (string.equals(NODE_STATUS)) {
            return StatusConfigParser.createStatusCommand(configFileWrapper);
        }
        if (string.equals(CLUSTER_LOGS)) {
            return ClusterLogsConfigParser.createClusterLogsCommand(configFileWrapper);
        }
        throw new ConfigurationException("Cannot create the command for " + string + ".");
    }

    public static String getRemoteHostname(ConfigFileWrapper configFileWrapper) throws ConfigurationException {
        return configFileWrapper.getNonEmptyStringEntry(REMOTE_HOSTNAME);
    }

    public static int getRemotePort(ConfigFileWrapper configFileWrapper) throws ConfigurationException {
        int n = configFileWrapper.getIntEntry(REMOTE_COMMAND_PORT);
        return n;
    }

    public static boolean isVerbose(ConfigFileWrapper configFileWrapper) throws ConfigurationException {
        boolean bl = false;
        return configFileWrapper.getBooleanEntry(VERBOSITY, bl);
    }
}

