/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.control;

import com.mathworks.toolbox.distcomp.auth.modules.SignatureModuleKeyPairImpl;
import com.mathworks.toolbox.distcomp.control.ConfigRunner;
import com.mathworks.toolbox.distcomp.control.ControlStartStopProcess;
import com.mathworks.toolbox.distcomp.control.ControlStartStopProcessInfo;
import com.mathworks.toolbox.distcomp.control.servicerequest.Host;
import com.mathworks.toolbox.distcomp.util.AdminUserRegistrar;
import com.mathworks.toolbox.distcomp.util.RemoteSystemProperty;
import com.mathworks.toolbox.distcomp.util.WarningAndNoteInfo;
import java.security.PublicKey;

public final class ControlJobmanager
extends ControlStartStopProcess {
    private static final long serialVersionUID = 1L;
    private static final SignatureModuleKeyPairImpl SIGNATURE_MODULE = new SignatureModuleKeyPairImpl();
    private ControlJobmanagerInfo fInfo;
    private RemoteSystemProperty fLookupHosts = new RemoteSystemProperty("com.mathworks.toolbox.distcomp.lookup_hosts", "JOB_MANAGER_LOOKUP_NOT_SPECIFIED");
    private boolean fRegisterAdminUser = true;
    private final transient AdminUserRegistrar fAdminUserRegistrar;
    private final PublicKey fPublicKey;

    @Override
    protected String getDefaultServiceName() {
        return System.getProperty("com.mathworks.toolbox.distcomp.default_jobmanager_name", "");
    }

    public void setAdminPassword(char[] cArray) {
        this.fAdminUserRegistrar.setAdminPassword(cArray);
    }

    public void setGraphical(boolean bl) {
        this.fAdminUserRegistrar.setGraphical(bl);
    }

    @Override
    protected void afterRun() throws AdminUserRegistrar.RegistrationException {
        if (this.isStarting() && this.fRegisterAdminUser) {
            this.fAdminUserRegistrar.findJobManagerAndAddAdmin();
        }
    }

    @Override
    protected void preRunSetup(WarningAndNoteInfo warningAndNoteInfo) {
        super.preRunSetup(warningAndNoteInfo);
        if (this.isStarting()) {
            SignatureModuleKeyPairImpl.writePublicKeyToProperties(this.fPublicKey);
            this.prepareLookupHostsForExport();
            this.fLookupHosts.exportValueIfNeeded();
        }
    }

    @Override
    protected void postRunTeardown() {
        if (this.isStarting()) {
            this.fLookupHosts.restoreValueIfNeeded();
        }
        super.postRunTeardown();
    }

    public ControlJobmanager(ConfigRunner configRunner, boolean bl, String string, String string2, Host host, int n) {
        super(configRunner, bl, string, string2);
        this.fInfo = new ControlJobmanagerInfo();
        String string3 = host.getHostname() + ":" + n;
        this.fAdminUserRegistrar = new AdminUserRegistrar(this.getServiceName(), string3, SIGNATURE_MODULE.getSigner());
        this.fPublicKey = this.isStarting() ? SIGNATURE_MODULE.getPublicKey() : null;
    }

    public void setLookupHosts(String string) {
        if (string != null && string.length() > 0) {
            this.fLookupHosts.setValue(string);
        }
    }

    @Override
    public ControlStartStopProcessInfo getInfo() {
        return this.fInfo;
    }

    private void prepareLookupHostsForExport() {
        boolean bl;
        boolean bl2 = bl = !"JOB_MANAGER_LOOKUP_NOT_SPECIFIED".equals(this.fLookupHosts.getValue());
        if (bl) {
            return;
        }
        String string = System.getProperty("com.mathworks.toolbox.distcomp.lookup_hosts", "");
        boolean bl3 = "MDCE_LOOKUP_NOT_SPECIFIED".equals(string);
        if (bl3) {
            String string2 = System.getProperty("com.mathworks.toolbox.distcomp.hostname", "");
            this.fLookupHosts.setValue(string2);
        } else {
            this.fLookupHosts.setValue(null);
        }
    }

    public void registerAdminUser(boolean bl) {
        this.fRegisterAdminUser = bl;
    }

    private class ControlJobmanagerInfo
    extends ControlStartStopProcessInfo {
        private static final long serialVersionUID = 1L;

        private ControlJobmanagerInfo() {
        }

        @Override
        public String getStartSuccessDescription() {
            return "Started the job manager " + this.getServiceName() + " on the host " + this.getRemoteHostname() + ".";
        }

        @Override
        public String getStopSuccessDescription() {
            return "Stopped the job manager " + this.getServiceName() + " on the host " + this.getRemoteHostname() + ".";
        }

        @Override
        public String getPreStartDescription() {
            return "Contacting the mdce service on the host " + this.getRemoteHostname() + "\n" + "to start a job manager process.";
        }

        @Override
        public String getPreStopDescription() {
            return "Contacting the mdce service on the host " + this.getRemoteHostname() + "\n" + "to stop a job manager process.";
        }

        @Override
        public String getStartNotNeededDescription() {
            return "Did not have to start the job manager " + this.getServiceName() + " on the host\n" + this.getRemoteHostname() + ".";
        }

        @Override
        public String getStopNotNeededDescription() {
            return "Did not have to stop the job manager " + this.getServiceName() + " on the host\n" + this.getRemoteHostname() + ".";
        }
    }
}

