/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.control;

import com.mathworks.toolbox.distcomp.control.ConfigRunner;
import com.mathworks.toolbox.distcomp.control.ControlExceptionFactory;
import com.mathworks.toolbox.distcomp.control.ServiceType;
import com.mathworks.toolbox.distcomp.jobmanager.JobManager;
import com.mathworks.toolbox.distcomp.service.DistcompService;
import com.mathworks.toolbox.distcomp.util.ActivationAdminWrapper;
import com.mathworks.toolbox.distcomp.util.ActivationSystemFinder;
import com.mathworks.toolbox.distcomp.util.ConfigFileWrapper;
import com.mathworks.toolbox.distcomp.util.DistcompDiagnosticException;
import com.mathworks.toolbox.distcomp.util.ErrorPrinterImpl;
import com.mathworks.toolbox.distcomp.util.WarningAndNoteInfo;
import com.sun.jini.start.DestroySharedGroup;
import com.sun.jini.system.FileSystem;
import java.io.File;
import java.rmi.RemoteException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Stopper
implements ConfigRunner {
    private static final long serialVersionUID = 1L;
    private static final ControlExceptionFactory<ErrorKey> ERROR_FACTORY = new ControlExceptionFactory();

    public static boolean isDirectory(String string) {
        File file = new File(string);
        return file.isDirectory();
    }

    private static boolean shouldStop(String string, ActivationAdminWrapper activationAdminWrapper) {
        if (ServiceType.isLookup(string)) {
            JobManager[] jobManagerArray = activationAdminWrapper.getJobManagers();
            return jobManagerArray == null || jobManagerArray.length == 0;
        }
        return true;
    }

    private static void verifyServiceIsRunning(String string, String string2, ActivationAdminWrapper activationAdminWrapper) throws DistcompDiagnosticException {
        DistcompDiagnosticException distcompDiagnosticException = null;
        ErrorKey errorKey = null;
        if (ServiceType.isJobManager(string)) {
            if (!activationAdminWrapper.hasJobManager(string2)) {
                errorKey = ErrorKey.PROBLEM_STOPPING_JM;
                distcompDiagnosticException = ERROR_FACTORY.diagnoseWithServiceName(null, ErrorKey.JM_NOT_RUNNING, string2);
            }
        } else if (ServiceType.isLookup(string)) {
            if (!activationAdminWrapper.hasLookup()) {
                errorKey = ErrorKey.PROBLEM_STOPPING_LOOKUP;
                distcompDiagnosticException = ERROR_FACTORY.diagnose(null, ErrorKey.LOOKUP_NOT_RUNNING, new Object[0]);
            }
        } else if (ServiceType.isWorker(string)) {
            if (!activationAdminWrapper.hasWorker(string2)) {
                errorKey = ErrorKey.PROBLEM_STOPPING_WORKER;
                distcompDiagnosticException = ERROR_FACTORY.diagnoseWithServiceName(null, ErrorKey.WORKER_NOT_RUNNING, string2);
            }
        } else {
            errorKey = ErrorKey.PROBLEM_STOPPING;
            distcompDiagnosticException = ERROR_FACTORY.diagnoseWithServiceType(null, ErrorKey.UNKNOWN_SERVICE_TYPE, string);
            throw ERROR_FACTORY.diagnoseWithServiceType(distcompDiagnosticException, errorKey, string);
        }
        if (distcompDiagnosticException != null) {
            throw ERROR_FACTORY.diagnose(distcompDiagnosticException, errorKey, new Object[0]);
        }
    }

    public static void verifySharedVMDirExists(String string, String string2) throws DistcompDiagnosticException {
        if (string == null) {
            return;
        }
        if (!Stopper.isDirectory(string)) {
            DistcompDiagnosticException distcompDiagnosticException = ERROR_FACTORY.diagnoseWithDirPath(null, ErrorKey.SHARED_VM_DIR_DOES_NOT_EXIST, string);
            ErrorKey errorKey = null;
            switch (ServiceType.getServiceType(string2)) {
                case JOBMANAGER: {
                    errorKey = ErrorKey.PROBLEM_STOPPING_JM;
                    break;
                }
                case LOOKUP: {
                    errorKey = ErrorKey.PROBLEM_STOPPING_LOOKUP;
                    break;
                }
                case PHOENIX: {
                    errorKey = ErrorKey.PROBLEM_STOPPING_PHOENIX;
                    break;
                }
                case WORKER: {
                    errorKey = ErrorKey.PROBLEM_STOPPING_WORKER;
                }
            }
            assert (errorKey != null);
            throw ERROR_FACTORY.diagnose(distcompDiagnosticException, errorKey, new Object[0]);
        }
    }

    public static void addWarningsIfPersistenceDirDoesNotExist(WarningAndNoteInfo warningAndNoteInfo, String string) {
        if (string == null) {
            return;
        }
        if (!Stopper.isDirectory(string)) {
            warningAndNoteInfo.addWarning(Stopper.msgPersistenceDirDoesNotExist(string));
        }
    }

    private static void cleanupService(String string, String string2, ActivationAdminWrapper activationAdminWrapper) {
        DistcompService distcompService = ServiceType.isJobManager(string) ? activationAdminWrapper.getJobManager(string2) : (ServiceType.isWorker(string) ? activationAdminWrapper.getWorker(string2) : null);
        if (distcompService != null) {
            try {
                distcompService.prepareForShutdown();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    private static void cleanDirectoryTryManyTimes(String string) throws DistcompDiagnosticException {
        boolean bl = false;
        boolean bl2 = true;
        long l = System.currentTimeMillis();
        long l2 = 0L;
        while (!bl && l2 + 5000L <= 60000L) {
            try {
                FileSystem.destroy((File)new File(string), (boolean)bl2);
                System.out.println(Stopper.msgCleanedCheckpointData(string));
                bl = true;
                break;
            }
            catch (Exception exception) {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                l2 = System.currentTimeMillis() - l;
            }
        }
        if (!bl) {
            throw ERROR_FACTORY.diagnoseWithDirPath(null, ErrorKey.COULD_NOT_CLEAN_CHECKPT_DATA, string);
        }
    }

    private static String msgCleanedCheckpointData(String string) {
        return "Deleted checkpoint data in: " + string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean run(WarningAndNoteInfo warningAndNoteInfo, String[] stringArray) throws Exception {
        ConfigFileWrapper configFileWrapper = new ConfigFileWrapper(stringArray);
        String string = configFileWrapper.getStringEntry("serviceType");
        String string2 = configFileWrapper.getStringEntry("act_sys_host");
        int n = configFileWrapper.getIntEntry("act_sys_port");
        ActivationSystemFinder activationSystemFinder = new ActivationSystemFinder(string2, n);
        activationSystemFinder.verifySystemTryOnce();
        String string3 = System.getProperty("com.mathworks.toolbox.distcomp.servicename");
        ActivationAdminWrapper activationAdminWrapper = new ActivationAdminWrapper(string2, n);
        activationAdminWrapper.verifyAdminTryManyTimes();
        if (!Stopper.shouldStop(string, activationAdminWrapper)) {
            return false;
        }
        String string4 = configFileWrapper.getStringEntry("sharedVM_log");
        String string5 = configFileWrapper.getStringEntry("persistenceDirectory");
        String string6 = System.getProperty("com.mathworks.toolbox.distcomp.clean_checkpoint_info");
        boolean bl = "true".equals(string6) && (Stopper.isDirectory(string4) || Stopper.isDirectory(string5));
        try {
            Stopper.verifyServiceIsRunning(string, string3, activationAdminWrapper);
            Stopper.verifySharedVMDirExists(string4, string);
            Stopper.addWarningsIfPersistenceDirDoesNotExist(warningAndNoteInfo, string5);
            try {
                Stopper.cleanupService(string, string3, activationAdminWrapper);
                DestroySharedGroup.main((String[])stringArray);
            }
            catch (Throwable throwable) {
                throw Stopper.getUndiagnosedException(string, throwable);
            }
        }
        catch (Exception exception) {
            if (!bl) {
                throw exception;
            }
        }
        finally {
            if (bl) {
                Stopper.cleanDirectoryTryManyTimes(string4);
                Stopper.cleanDirectoryTryManyTimes(string5);
            }
        }
        return true;
    }

    public static void killService(String[] stringArray) {
        Logger logger = Logger.getLogger("com.sun.jini.start.service.starter");
        Level level = logger.getLevel();
        logger.setLevel(Level.OFF);
        try {
            DestroySharedGroup.main((String[])stringArray);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        logger.setLevel(level);
    }

    public static void main(String[] stringArray) {
        ErrorPrinterImpl errorPrinterImpl = new ErrorPrinterImpl();
        try {
            Stopper stopper = new Stopper();
            WarningAndNoteInfo warningAndNoteInfo = new WarningAndNoteInfo();
            stopper.run(warningAndNoteInfo, stringArray);
            warningAndNoteInfo.printAllWarningsAndNotesToSystemOut();
        }
        catch (Exception exception) {
            errorPrinterImpl.printError(exception);
        }
    }

    private static Exception getUndiagnosedException(String string, Throwable throwable) {
        switch (ServiceType.getServiceType(string)) {
            case JOBMANAGER: {
                return ERROR_FACTORY.createFormattableException(throwable, ErrorKey.FAILED_TO_STOP_JM, new Object[0]);
            }
            case LOOKUP: {
                return ERROR_FACTORY.createFormattableException(throwable, ErrorKey.FAILED_TO_STOP_LOOKUP, new Object[0]);
            }
            case WORKER: {
                return ERROR_FACTORY.createFormattableException(throwable, ErrorKey.FAILED_TO_STOP_WORKER, new Object[0]);
            }
        }
        return ERROR_FACTORY.createFormattableException(throwable, ErrorKey.FAILED_TO_STOP, string);
    }

    private static String msgPersistenceDirDoesNotExist(String string) {
        return "The directory\n" + string + "\ndoes not exist.\n" + "Will not be able to resume the process state when you start " + "it again.";
    }

    private static enum ErrorKey {
        PROBLEM_STOPPING,
        PROBLEM_STOPPING_JM,
        PROBLEM_STOPPING_LOOKUP,
        PROBLEM_STOPPING_WORKER,
        PROBLEM_STOPPING_PHOENIX,
        JM_NOT_RUNNING,
        LOOKUP_NOT_RUNNING,
        WORKER_NOT_RUNNING,
        UNKNOWN_SERVICE_TYPE,
        SHARED_VM_DIR_DOES_NOT_EXIST,
        COULD_NOT_CLEAN_CHECKPT_DATA,
        FAILED_TO_STOP,
        FAILED_TO_STOP_JM,
        FAILED_TO_STOP_LOOKUP,
        FAILED_TO_STOP_WORKER;

    }
}

