/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.control.serviceinfo;

import com.mathworks.toolbox.distcomp.control.ServiceType;
import com.mathworks.toolbox.distcomp.control.serviceinfo.NodeServiceInfo;
import com.mathworks.toolbox.distcomp.control.serviceinfo.ServiceStatus;
import com.mathworks.toolbox.distcomp.control.serviceinfo.WorkerConnectionStatus;
import com.mathworks.toolbox.distcomp.control.servicerequest.Host;
import com.mathworks.toolbox.distcomp.worker.RegistrationInfo;
import com.mathworks.toolbox.distcomp.worker.WorkerNodeInfo;

public class WorkerServiceInfo
extends NodeServiceInfo<WorkerNodeInfo> {
    private static final long serialVersionUID = 452034296962539095L;
    private static final ServiceType sServiceType = ServiceType.WORKER;
    private Boolean fBusy;
    private Boolean fHasConnection;
    private boolean fConnectedToJM;
    private String fJobManagerName;
    private String fJobManagerHostName;
    private String fFileDependenciesDir;
    private String fWorkDir;
    private Boolean fIsRegistered;

    public WorkerServiceInfo(WorkerNodeInfo workerNodeInfo, Host host) {
        super(workerNodeInfo, host);
        this.fBusy = workerNodeInfo.isBusy();
        this.fConnectedToJM = workerNodeInfo.isConnectedToJM();
        this.fJobManagerName = workerNodeInfo.getJobManagerNameInConfiguration();
        String string = workerNodeInfo.getJobManagerHostName();
        if (string != null && string.length() > 0) {
            this.fHasConnection = true;
            this.fJobManagerHostName = string;
        } else {
            this.fHasConnection = false;
            this.fJobManagerHostName = workerNodeInfo.getJobManagerHostNameInConfiguration();
        }
        this.fFileDependenciesDir = workerNodeInfo.getFileDependenciesDir();
        this.fWorkDir = workerNodeInfo.getWorkDir();
        RegistrationInfo registrationInfo = workerNodeInfo.getRegistrationInfo();
        this.fIsRegistered = registrationInfo == null ? Boolean.valueOf(false) : Boolean.valueOf(registrationInfo.isRegistered());
    }

    public WorkerServiceInfo(String string, Host host) {
        super(string, host, null, ServiceStatus.STOPPED);
        this.fBusy = null;
        this.fConnectedToJM = false;
        this.fJobManagerName = null;
        this.fJobManagerHostName = null;
        this.fFileDependenciesDir = null;
        this.fWorkDir = null;
        this.fIsRegistered = false;
    }

    public Boolean isBusy() {
        return this.fBusy;
    }

    public WorkerConnectionStatus getWorkerConnectionStatus() {
        if (this.getStatus() != ServiceStatus.RUNNING) {
            return null;
        }
        if (this.isConnectedToJM()) {
            if (this.isRegistered()) {
                return WorkerConnectionStatus.CONNECTED;
            }
            return WorkerConnectionStatus.FAILEDTOREGISTER;
        }
        if (this.fHasConnection.booleanValue()) {
            return WorkerConnectionStatus.LOSTCONNECTION;
        }
        return WorkerConnectionStatus.FAILED2CONNECT;
    }

    public String getJobManagerName() {
        return this.fJobManagerName;
    }

    public String getJobManagerHostName() {
        return this.fJobManagerHostName;
    }

    @Override
    public String toString() {
        String string = "Worker:     " + super.toString();
        if (this.getStatus() == ServiceStatus.RUNNING) {
            String string2 = this.isBusy() != false ? "busy" : "idle";
            String string3 = this.getJobManagerHostName();
            string = string + " | " + string3 + " | " + string2 + " | " + (Object)((Object)this.getWorkerConnectionStatus()) + " | " + this.getJobManagerName() + " | " + this.getJobManagerHostName();
        }
        return string;
    }

    public String getFileDependenciesDir() {
        return this.fFileDependenciesDir;
    }

    public String getWorkDir() {
        return this.fWorkDir;
    }

    @Override
    protected ServiceType getServiceType() {
        return sServiceType;
    }

    private boolean isConnectedToJM() {
        return this.fConnectedToJM;
    }

    private boolean isRegistered() {
        return this.fIsRegistered == null ? true : this.fIsRegistered;
    }
}

