/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.control.servicerequest;

import com.mathworks.toolbox.distcomp.control.ConfigRunner;
import com.mathworks.toolbox.distcomp.control.ControlStartStopProcess;
import com.mathworks.toolbox.distcomp.control.MDCSCommand;
import com.mathworks.toolbox.distcomp.control.MDCSCommandResults;
import com.mathworks.toolbox.distcomp.control.MDCSFuture;
import com.mathworks.toolbox.distcomp.control.Starter;
import com.mathworks.toolbox.distcomp.control.Stopper;
import com.mathworks.toolbox.distcomp.control.servicerequest.Host;
import com.mathworks.toolbox.distcomp.control.servicerequest.ServiceAction;
import com.mathworks.toolbox.distcomp.control.servicerequest.ServiceRequest;
import com.mathworks.toolbox.distcomp.control.servicerequest.ServiceRequestResponse;
import java.util.LinkedList;
import java.util.List;

public abstract class ControlServiceRequest
extends ServiceRequest {
    private List<MDCSCommand> fRemoteCommands;

    public ControlServiceRequest(String string, Host host, ServiceAction serviceAction) {
        super(string, host, serviceAction);
    }

    public List<MDCSCommand> getRemoteCommands() {
        if (this.fRemoteCommands == null) {
            this.fRemoteCommands = this.createRemoteCommands();
        }
        return this.fRemoteCommands;
    }

    @Override
    public ServiceRequestResponse call() {
        try {
            for (MDCSCommand mDCSCommand : this.getRemoteCommands()) {
                try {
                    MDCSFuture mDCSFuture = (MDCSFuture)this.execute(mDCSCommand);
                    MDCSCommandResults mDCSCommandResults = mDCSFuture.getResults();
                }
                catch (Throwable throwable) {
                    String string = this.throwIfNecessary(throwable);
                }
            }
            return new ServiceRequestResponse(this, true, null, null);
        }
        catch (Throwable throwable) {
            return this.failedToExecute(throwable);
        }
    }

    @Override
    public ServiceRequestResponse failedToExecute(Throwable throwable) {
        return new ServiceRequestResponse(this, false, throwable, null);
    }

    protected String throwIfNecessary(Throwable throwable) throws Throwable {
        throw throwable;
    }

    private List<MDCSCommand> createRemoteCommands() {
        LinkedList<MDCSCommand> linkedList = new LinkedList<MDCSCommand>();
        for (ServiceAction serviceAction : this.getAction().getAtomicActions()) {
            boolean bl = serviceAction.isStarting();
            ConfigRunner configRunner = bl ? new Starter() : new Stopper();
            ControlStartStopProcess controlStartStopProcess = this.getControlCommand(bl, configRunner);
            controlStartStopProcess.setClean(serviceAction.needsCheckpointCleaning());
            controlStartStopProcess.getInfo().setIsStarting(bl);
            controlStartStopProcess.getInfo().setRemoteHostname(this.getHostName());
            linkedList.add(controlStartStopProcess);
        }
        return linkedList;
    }

    protected abstract ControlStartStopProcess getControlCommand(boolean var1, ConfigRunner var2);
}

