/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.local;

import com.mathworks.toolbox.distcomp.local.AbstractLocalCommand;
import com.mathworks.toolbox.distcomp.local.LocalConstants;
import com.mathworks.toolbox.distcomp.local.TokenChangeCommand;
import com.mathworks.toolbox.distcomp.local.TokenManager;
import com.mathworks.toolbox.distcomp.util.PausableThreadPoolExecutor;
import com.mathworks.toolbox.distcomp.util.ProcessBuilderUtils;
import com.mathworks.toolbox.distcomp.util.concurrent.DaemonThreadFactory;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

public class LocalScheduler {
    private static LocalScheduler sLocalScheduler = null;
    private static int sFACTORY_MAX_NUM_WORKERS = 12;
    private TokenManager fTokenManager = new TokenManager(12);
    private CommandDelayer fCommandDelayer = new CommandDelayer();
    private PausableThreadPoolExecutor fDispatchExecutor = new PausableThreadPoolExecutor(12, 12, (long)LocalConstants.sLOCAL_THREAD_LIFETIME, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new DaemonThreadFactory(LocalScheduler.class.getSimpleName()));
    private ConcurrentHashMap<UUID, AbstractLocalCommand> fCommandMap = new ConcurrentHashMap();
    private int fMaximumNumberOfWorkers;

    public static void setFactoryMaxNumWorkers(int n) {
        if (n > 12 || n < 1) {
            throw new IllegalStateException("Incorrect number of licenses requested");
        }
        sFACTORY_MAX_NUM_WORKERS = n;
    }

    public static LocalScheduler getInstance() {
        if (sLocalScheduler == null) {
            sLocalScheduler = new LocalScheduler();
            sLocalScheduler.setMaximumNumberOfWorkers(sFACTORY_MAX_NUM_WORKERS);
        }
        return sLocalScheduler;
    }

    public int getMaximumNumberOfWorkers() {
        return this.fMaximumNumberOfWorkers;
    }

    public void setMaximumNumberOfWorkers(int n) {
        if (n > 12) {
            throw new IllegalStateException("Too many licenses requested");
        }
        this.fMaximumNumberOfWorkers = n;
        TokenChangeCommand.getNewInstance(this.fTokenManager, n).submit();
    }

    public int getNumberOfAvailableLicenses() {
        return this.fTokenManager.getNumberOfAvailableTokens();
    }

    public TokenManager.SemaphoreToken acquire(int n) throws InterruptedException {
        return this.fTokenManager.acquire(n);
    }

    public TokenManager.SemaphoreToken acquire(int n, int n2) throws InterruptedException {
        return this.fTokenManager.acquire(n, n2);
    }

    public void pause() {
        this.fDispatchExecutor.pause();
    }

    public synchronized void resume() {
        this.fDispatchExecutor.resume();
    }

    Future<Object> submit(AbstractLocalCommand abstractLocalCommand) {
        return this.fDispatchExecutor.submit(abstractLocalCommand);
    }

    void addCommand(UUID uUID, AbstractLocalCommand abstractLocalCommand) {
        this.fCommandMap.put(uUID, abstractLocalCommand);
    }

    public AbstractLocalCommand getCommand(UUID uUID) {
        return this.fCommandMap.get(uUID);
    }

    boolean removeCommand(UUID uUID) {
        return this.fCommandMap.remove(uUID) != null;
    }

    public AbstractLocalCommand[] getAllCommands() {
        return this.fCommandMap.values().toArray(new AbstractLocalCommand[0]);
    }

    private CommandDelayer getDelayer() {
        return this.fCommandDelayer;
    }

    public void delayBeforeStart() throws InterruptedException {
        this.getDelayer().delayBeforeStart();
    }

    public void setCommandDelay(long l) {
        this.getDelayer().setDelay(l);
    }

    public long getCommandDelay() {
        return this.getDelayer().getDelay();
    }

    public ProcessBuilderUtils.Delayer getDelayerForProcessConstruction() {
        return this.getDelayer();
    }

    private static class CommandDelayer
    implements ProcessBuilderUtils.Delayer {
        private long fDelay = 0L;
        private long fLastCommandTime = -1L;
        private ReentrantLock fLock = new ReentrantLock();

        private CommandDelayer() {
        }

        @Override
        public void delay() throws InterruptedException {
            this.delayBeforeStart();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void delayBeforeStart() throws InterruptedException {
            block9: {
                if (this.fDelay == 0L) {
                    return;
                }
                this.fLock.lockInterruptibly();
                try {
                    Object object;
                    if (this.fLastCommandTime <= 0L) break block9;
                    Object object2 = object = new Object();
                    synchronized (object2) {
                        long l = this.fDelay - (System.currentTimeMillis() - this.fLastCommandTime);
                        while (l > 0L) {
                            if (l > 0L) {
                                object.wait(l);
                            }
                            l = this.fDelay - (System.currentTimeMillis() - this.fLastCommandTime);
                        }
                    }
                }
                finally {
                    this.fLastCommandTime = System.currentTimeMillis();
                    this.fLock.unlock();
                }
            }
        }

        void setDelay(long l) {
            this.fDelay = l;
        }

        long getDelay() {
            return this.fDelay;
        }
    }
}

