/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.mjs.client;

import com.mathworks.toolbox.distcomp.auth.AuthorisationContext;
import com.mathworks.toolbox.distcomp.auth.SignatureModule;
import com.mathworks.toolbox.distcomp.auth.credentials.AuthenticationToken;
import com.mathworks.toolbox.distcomp.auth.credentials.UserIdentity;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.CredentialConsumerFactory;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.NoCredentialsEnteredException;
import com.mathworks.toolbox.distcomp.auth.credentials.store.CredentialStore;
import com.mathworks.toolbox.distcomp.distcompobjects.ListenerInfo;
import com.mathworks.toolbox.distcomp.jobmanager.JobManagerAuthorisationContext;
import com.mathworks.toolbox.distcomp.jobmanager.JobManagerLocal;
import com.mathworks.toolbox.distcomp.jobmanager.WorkerRegistration;
import com.mathworks.toolbox.distcomp.mjs.MJSException;
import com.mathworks.toolbox.distcomp.mjs.client.ClientJobAccess;
import com.mathworks.toolbox.distcomp.mjs.client.ClientParallelJobAccess;
import com.mathworks.toolbox.distcomp.mjs.client.ClientTaskAccess;
import com.mathworks.toolbox.distcomp.mjs.client.ClientWorkUnitAccess;
import com.mathworks.toolbox.distcomp.pmode.shared.ServerSocketAcceptInfo;
import com.mathworks.toolbox.distcomp.pmode.shared.ServerSocketConnectInfo;
import com.mathworks.toolbox.distcomp.service.DistcompServiceInfo;
import com.mathworks.toolbox.distcomp.service.NodeInfo;
import com.mathworks.toolbox.distcomp.uddadaptor.MatlabEventAdaptor;
import com.mathworks.toolbox.distcomp.util.concurrent.CancellingExecutor;
import com.mathworks.toolbox.distcomp.util.concurrent.FileOutputStreamUsingTask;
import com.mathworks.toolbox.distcomp.worker.Worker;
import com.mathworks.toolbox.distcomp.worker.WorkerProperties;
import com.mathworks.toolbox.distcomp.workunit.JobIDAndMLType;
import com.mathworks.toolbox.distcomp.workunit.JobInfo;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import net.jini.id.Uuid;

public final class JobManagerClient {
    private final JobManagerLocal fJobManager;
    private final JobManagerAuthorisationContext fAuthorisationContext;

    public JobManagerClient(JobManagerLocal jobManagerLocal) {
        this.fJobManager = jobManagerLocal;
        CredentialConsumerFactory credentialConsumerFactory = CredentialConsumerFactory.getDefault();
        this.fAuthorisationContext = new JobManagerAuthorisationContext(jobManagerLocal, credentialConsumerFactory);
    }

    public JobManagerClient(JobManagerLocal jobManagerLocal, CredentialConsumerFactory credentialConsumerFactory, CredentialStore<AuthenticationToken> credentialStore) {
        this.fJobManager = jobManagerLocal;
        this.fAuthorisationContext = new JobManagerAuthorisationContext(jobManagerLocal, credentialConsumerFactory, credentialStore);
    }

    private JobManagerClient(JobManagerLocal jobManagerLocal, JobManagerAuthorisationContext jobManagerAuthorisationContext) {
        this.fJobManager = jobManagerLocal;
        this.fAuthorisationContext = jobManagerAuthorisationContext;
    }

    public JobManagerClient createNewClient(JobManagerLocal jobManagerLocal) {
        JobManagerAuthorisationContext jobManagerAuthorisationContext = this.fAuthorisationContext.createNew(jobManagerLocal);
        return new JobManagerClient(jobManagerLocal, jobManagerAuthorisationContext);
    }

    public JobManagerLocal getJobManager() {
        return this.fJobManager;
    }

    public Future<?> getClusterLogs(String string) throws IOException, MJSException {
        CancellingExecutor cancellingExecutor = new CancellingExecutor(1, 1, 1L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        File file = new File(string);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        Future<Object> future = cancellingExecutor.submit(new FileOutputStreamUsingTask<Object>((OutputStream)bufferedOutputStream, file){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object call() throws IOException, MJSException {
                boolean bl = false;
                try {
                    JobManagerClient.this.fJobManager.getClusterLogs(JobManagerClient.this.fAuthorisationContext, this.getOutputStream());
                    bl = true;
                }
                catch (NoCredentialsEnteredException noCredentialsEnteredException) {
                }
                finally {
                    this.getOutputStream().close();
                    if (!bl) {
                        this.getFile().delete();
                    }
                }
                return null;
            }
        });
        cancellingExecutor.shutdown();
        return future;
    }

    public void setClusterLogLevel(int n) throws RemoteException, MJSException {
        if (n >= 0) {
            this.fJobManager.setClusterLogLevel(this.fAuthorisationContext, n);
        }
    }

    public int getClusterLogLevel() throws RemoteException, MJSException {
        return this.fJobManager.getClusterLogLevel();
    }

    public Uuid getID() {
        return this.fJobManager.getID();
    }

    public Uuid createJob(JobInfo jobInfo) throws RemoteException, MJSException {
        return this.fJobManager.createJob(this.fAuthorisationContext, jobInfo);
    }

    public Uuid createParallelJob(JobInfo jobInfo) throws RemoteException, MJSException {
        return this.fJobManager.createParallelJob(this.fAuthorisationContext, jobInfo);
    }

    public Uuid createMatlabPoolJob(JobInfo jobInfo, byte[] byArray, byte[] byArray2) throws RemoteException, MJSException {
        return this.fJobManager.createMatlabPoolJob(this.fAuthorisationContext, jobInfo, byArray, byArray2);
    }

    public JobIDAndMLType[] getJobs() throws RemoteException {
        return this.fJobManager.getJobs();
    }

    public JobIDAndMLType[][] getJobs(int[] nArray) throws RemoteException {
        return this.fJobManager.getJobs(nArray);
    }

    public void pauseQueue() throws RemoteException, MJSException {
        this.fJobManager.pauseQueue();
    }

    public void resumeQueue() throws RemoteException, MJSException {
        this.fJobManager.resumeQueue();
    }

    public ClientJobAccess getJobAccess() throws RemoteException, MJSException {
        return new ClientJobAccess(this.fJobManager.getJobAccess(), (AuthorisationContext)this.fAuthorisationContext);
    }

    public ClientParallelJobAccess getParallelJobAccess() throws RemoteException, MJSException {
        return new ClientParallelJobAccess(this.fJobManager.getParallelJobAccess(), (AuthorisationContext)this.fAuthorisationContext);
    }

    public ClientTaskAccess getTaskAccess() throws RemoteException, MJSException {
        return new ClientTaskAccess(this.fJobManager.getTaskAccess(), (AuthorisationContext)this.fAuthorisationContext);
    }

    public int getNumIdleWorkers() throws RemoteException {
        return this.fJobManager.getNumIdleWorkers();
    }

    public int getNumBusyWorkers() throws RemoteException {
        return this.fJobManager.getNumBusyWorkers();
    }

    public Worker[] getIdleWorkers() throws RemoteException {
        return this.fJobManager.getIdleWorkers();
    }

    public Worker[] getBusyWorkers() throws RemoteException {
        return this.fJobManager.getBusyWorkers();
    }

    public WorkerProperties[] getIdleWorkerProperties() throws RemoteException {
        return this.fJobManager.getIdleWorkerProperties();
    }

    public WorkerProperties[] getBusyWorkerProperties() throws RemoteException {
        return this.fJobManager.getBusyWorkerProperties();
    }

    public WorkerRegistration getWorkerRegistration() throws RemoteException {
        return this.fJobManager.getWorkerRegistration();
    }

    public String getLookupURL() throws RemoteException {
        return this.fJobManager.getLookupURL();
    }

    public int getSecurityLevel() throws RemoteException {
        return this.fJobManager.getSecurityLevel();
    }

    public void promote(Uuid uuid) throws RemoteException {
        this.fJobManager.promote(uuid);
    }

    public void demote(Uuid uuid) throws RemoteException {
        this.fJobManager.demote(uuid);
    }

    public void removeWorker(Uuid uuid) throws RemoteException {
        this.fJobManager.removeWorker(uuid);
    }

    public boolean allowClientPasswordCache() throws RemoteException {
        return this.fJobManager.allowClientPasswordCache();
    }

    public String[] getAllHostAddresses() throws RemoteException {
        return this.fJobManager.getAllHostAddresses();
    }

    public String getHostName() throws RemoteException {
        return this.fJobManager.getHostName();
    }

    public String getName() throws RemoteException {
        return this.fJobManager.getName();
    }

    public String getClusterMatlabRoot() throws RemoteException {
        return this.fJobManager.getMatlabRoot();
    }

    public int getState() throws RemoteException {
        return this.fJobManager.getState();
    }

    public DistcompServiceInfo getServiceInfo() throws RemoteException {
        return this.fJobManager.getServiceInfo();
    }

    public NodeInfo getNodeInfo() throws RemoteException {
        return this.fJobManager.getNodeInfo();
    }

    public void prepareForShutdown() throws RemoteException {
        this.fJobManager.prepareForShutdown();
    }

    public boolean isUsingSecureCommunication() throws RemoteException {
        return this.fJobManager.isUsingSecureCommunication();
    }

    public void attachToListenableObject(ClientWorkUnitAccess clientWorkUnitAccess, Uuid[] uuidArray) throws RemoteException, MJSException {
        this.fJobManager.attachToListenableObject(clientWorkUnitAccess.getAccessLocal(), uuidArray);
    }

    public ListenerInfo[] createListenerInfoArrayForAllEvents() throws IOException {
        return this.fJobManager.createListenerInfoArrayForAllEvents();
    }

    public void detachFromListenableObject(ClientWorkUnitAccess clientWorkUnitAccess, Uuid[] uuidArray) throws RemoteException, MJSException {
        this.fJobManager.detachFromListenableObject(clientWorkUnitAccess.getAccessLocal(), uuidArray);
    }

    public void addEventAdaptor(MatlabEventAdaptor matlabEventAdaptor) throws MJSException {
        this.fJobManager.addEventAdaptor(matlabEventAdaptor);
    }

    public void removeEventAdaptor(MatlabEventAdaptor matlabEventAdaptor) {
        this.fJobManager.removeEventAdaptor(matlabEventAdaptor);
    }

    public ServerSocketConnectInfo getBrokerServerSocketConnectInfo() {
        return this.fJobManager.getBrokerServerSocketConnectInfo();
    }

    public ServerSocketAcceptInfo getWorkerAcceptInfoTemplate() {
        return this.fJobManager.getWorkerAcceptInfoTemplate();
    }

    public void changeCredentialsOfExistingUser(UserIdentity userIdentity) throws MJSException, RemoteException {
        this.fJobManager.changeCredentialsOfExistingUser(this.fAuthorisationContext, userIdentity);
    }

    public void addAdminUser(SignatureModule.Signer signer) throws MJSException, RemoteException {
        this.fJobManager.addAdminUser(this.fAuthorisationContext, signer);
    }

    public boolean requireWebLicensing() throws RemoteException {
        return this.fJobManager.requireWebLicensing();
    }

    public void dispose() {
        this.fJobManager.dispose();
    }

    public UserIdentity promptForIdentity(String string) throws MJSException, RemoteException {
        return this.fAuthorisationContext.promptForIdentity(string);
    }

    public void setCurrentUser(UserIdentity userIdentity) throws MJSException, RemoteException {
        this.fAuthorisationContext.setCurrentUser(userIdentity);
    }

    public UserIdentity getCurrentUser() {
        return this.fAuthorisationContext.getCurrentUser();
    }

    public void revokeAuthentication(UserIdentity userIdentity) {
        this.fAuthorisationContext.revokeAuthentication(userIdentity);
    }

    public CredentialStore<AuthenticationToken> getCredentialStore() {
        return this.fAuthorisationContext.getCredentialStore();
    }

    public void setCredentialConsumerFactory(CredentialConsumerFactory credentialConsumerFactory) {
        this.fAuthorisationContext.setCredentialConsumerFactory(credentialConsumerFactory);
    }

    public CredentialConsumerFactory getCredentialConsumerFactory() {
        return this.fAuthorisationContext.getCredentialConsumerFactory();
    }

    public Object createMemento() {
        return this.fAuthorisationContext.createMemento();
    }

    public void restoreFromMemento(Object object) {
        this.fAuthorisationContext.restoreFromMemento(object);
    }

    public String toString() {
        return "JobManagerClient{fJobManager=" + this.fJobManager + ", fAuthorisationContext=" + this.fAuthorisationContext + '}';
    }
}

