/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.parallelui;

import com.jidesoft.swing.StyledLabel;
import com.mathworks.mlservices.MLEditorServices;
import com.mathworks.mlwidgets.shortcuts.ShortcutEditor;
import com.mathworks.mlwidgets.shortcuts.ShortcutUtils;
import com.mathworks.mwswing.ChildAction;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.mwswing.MJTable;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.datatransfer.MJClipboard;
import com.mathworks.mwswing.datatransfer.MJDragCursorUtilities;
import com.mathworks.toolbox.distcomp.parallelui.Actions;
import com.mathworks.toolbox.distcomp.parallelui.OutputCollection;
import com.mathworks.toolbox.distcomp.parallelui.OutputComponent;
import com.mathworks.toolbox.distcomp.parallelui.ParallelCommandWindow;
import com.mathworks.toolbox.distcomp.parallelui.ParallelUI;
import com.mathworks.toolbox.distcomp.parallelui.Prompt;
import com.mathworks.toolbox.distcomp.parallelui.TextStyleInfo;
import com.mathworks.toolbox.distcomp.parallelui.Utilities;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.action.AbstractCopyAction;
import com.mathworks.widgets.action.AbstractCutAction;
import com.mathworks.widgets.action.AbstractUndoAction;
import com.mathworks.widgets.desk.DTMenuMergeTag;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.StringSelection;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

class CommandHistoryTable
extends MJTable
implements Actions.Contributor {
    private ParallelCommandWindow fCommandWindow;
    private OutputComponent fOutputComponent;
    private int fLastEvaluateCount;
    private boolean fEvaluationEnabled = true;
    private DragSource fDragSource;
    private String fLongestPrompt;
    private int fRepeatColumnIndex = 0;
    private int fPromptColumnIndex = 1;
    private int fCommandColumnIndex = 2;
    private MouseListener fMouseListener = new LocalMouseListener();
    private MJAbstractAction fUndoAction = new UndoAction();
    private MJAbstractAction fCutAction = new CutAction();
    private MJAbstractAction fCopyAction = new CopyAction();
    private MJAbstractAction fDeleteAction = new DeleteAction();
    private MJAbstractAction fSelectAllAction = new SelectAllAction();
    private MJAbstractAction fClearAction = new ClearAction();
    private MJAbstractAction fEvaluateAction = new EvaluateAction();
    private MJAbstractAction fShowOutputAction = new ShowOutputAction();
    private MJAbstractAction fCreateMFileAction = new CreateMFileAction();
    private MJAbstractAction fCreateShortcutAction = new CreateShortcutAction();
    private static final ImageIcon ERROR_ICON = new ImageIcon(CommandHistoryTable.class.getResource("resources/error.gif"));
    private static final int REPEAT_COLUMN = 0;
    private static final int PROMPT_COLUMN = 1;
    private static final int COMMAND_COLUMN = 2;
    private static final int MAX_REPEAT_DISPLAYED = 9;

    CommandHistoryTable(ParallelCommandWindow parallelCommandWindow, OutputCollection outputCollection, OutputComponent outputComponent, Actions actions, int n, boolean bl) {
        super(outputCollection.getTableModel());
        this.fCommandWindow = parallelCommandWindow;
        this.fOutputComponent = outputComponent;
        this.fLongestPrompt = Prompt.getLongestString(n);
        this.setFocusable(false);
        this.setTableHeader(null);
        this.setShowGrid(false);
        this.setRightSelectionEnabled(true);
        this.setCellViewerEnabled(true);
        TableColumn tableColumn = this.getColumnModel().getColumn(this.fRepeatColumnIndex);
        tableColumn.setResizable(false);
        tableColumn.setCellRenderer(new RepeatRenderer());
        TableColumn tableColumn2 = this.getColumnModel().getColumn(this.fPromptColumnIndex);
        if (bl) {
            tableColumn2.setResizable(false);
            tableColumn2.setCellRenderer(new PromptRenderer());
        } else {
            this.getColumnModel().removeColumn(tableColumn2);
            this.fPromptColumnIndex = -1;
            --this.fCommandColumnIndex;
        }
        TableColumn tableColumn3 = this.getColumnModel().getColumn(this.fCommandColumnIndex);
        tableColumn3.setCellRenderer(new CommandRenderer());
        this.addMouseListener(this.fMouseListener);
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                CommandHistoryTable.this.updateActions();
            }
        });
        this.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                if (tableModelEvent.getType() == 1) {
                    CommandHistoryTable.this.scrollToBottom();
                }
                OutputCollection.CommandTableModel commandTableModel = (OutputCollection.CommandTableModel)CommandHistoryTable.this.getModel();
                CommandHistoryTable.this.fUndoAction.setEnabled(commandTableModel.anythingToUndo());
            }
        });
        actions.registerContribution(Actions.Type.UNDO, this);
        actions.registerContribution(Actions.Type.DELETE, this);
        actions.registerContribution(Actions.Type.CLEAR_HISTORY, this);
        this.enableDragHandling(true);
        this.fDragSource = new DragSource();
        DragListener dragListener = new DragListener();
        new DropTarget((Component)((Object)this), dragListener);
        this.fDragSource.createDefaultDragGestureRecognizer((Component)((Object)this), 3, dragListener);
    }

    public void addNotify() {
        super.addNotify();
        this.scrollToBottom();
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.fCommandWindow != null) {
            this.updateColumnWidths();
            this.updateRowHeight();
        }
    }

    void suspendEvaluation() {
        this.fEvaluationEnabled = false;
        this.fEvaluateAction.setEnabled(false);
    }

    void resumeEvaluation() {
        this.fEvaluationEnabled = true;
        this.fEvaluateAction.setEnabled(this.getSelectedRowCount() > 0);
    }

    @Override
    public Action getAction(Actions.Type type) {
        switch (type) {
            case UNDO: {
                return this.fUndoAction;
            }
            case DELETE: {
                return this.fDeleteAction;
            }
            case CLEAR_HISTORY: {
                return this.fClearAction;
            }
        }
        return null;
    }

    @Override
    public Component getActionFocusComponent() {
        return null;
    }

    public Dimension getPreferredScrollableViewportSize() {
        Dimension dimension = super.getPreferredScrollableViewportSize();
        Dimension dimension2 = this.getPreferredSize();
        if (dimension2.height < dimension.height) {
            dimension.height = dimension2.height;
        }
        return dimension;
    }

    MouseListener getContextMouseListener() {
        return this.fMouseListener;
    }

    int getRepeatColumnWidth() {
        return this.getColumnModel().getColumn(this.fRepeatColumnIndex).getPreferredWidth();
    }

    int getPromptColumnWidth() {
        if (this.fPromptColumnIndex < 0) {
            return 0;
        }
        return this.getColumnModel().getColumn(this.fPromptColumnIndex).getPreferredWidth();
    }

    private void updateColumnWidths() {
        if (this.fPromptColumnIndex >= 0) {
            TableColumn tableColumn = this.getColumnModel().getColumn(this.fRepeatColumnIndex);
            TableCellRenderer tableCellRenderer = tableColumn.getCellRenderer();
            Component component = tableCellRenderer.getTableCellRendererComponent((JTable)((Object)this), new Integer(10), false, false, 0, 0);
            Dimension dimension = component.getPreferredSize();
            tableColumn.setMaxWidth(dimension.width);
            tableColumn.setPreferredWidth(dimension.width);
            tableColumn = this.getColumnModel().getColumn(this.fPromptColumnIndex);
            tableCellRenderer = tableColumn.getCellRenderer();
            component = tableCellRenderer.getTableCellRendererComponent((JTable)((Object)this), this.fLongestPrompt, false, false, 0, 0);
            dimension = component.getPreferredSize();
            int n = dimension.width + 2 + dimension.height / 10;
            tableColumn.setMaxWidth(n);
            tableColumn.setPreferredWidth(n);
        } else {
            TableColumn tableColumn = this.getColumnModel().getColumn(this.fRepeatColumnIndex);
            PromptRenderer promptRenderer = new PromptRenderer();
            Component component = promptRenderer.getTableCellRendererComponent((JTable)((Object)this), this.fLongestPrompt, false, false, 0, 0);
            Dimension dimension = component.getPreferredSize();
            tableColumn.setMaxWidth(dimension.width);
            tableColumn.setPreferredWidth(dimension.width);
        }
    }

    private void updateRowHeight() {
        PromptRenderer promptRenderer = new PromptRenderer();
        Component component = promptRenderer.getTableCellRendererComponent((JTable)((Object)this), "P_", false, false, 0, 0);
        Dimension dimension = component.getPreferredSize();
        this.setRowHeight(dimension.height);
    }

    int rowOfPreviousMatch(String string, boolean bl) {
        int n = this.getSelectionModel().getMinSelectionIndex();
        if (n == -1) {
            n = this.getRowCount();
        }
        TableModel tableModel = this.getModel();
        if (string.length() == 0) {
            for (int i = n - 1; i >= 0; --i) {
                if (!bl && ((OutputCollection.CommandRecord)tableModel.getValueAt(i, 2)).isComment()) continue;
                return i;
            }
            return -1;
        }
        for (int i = n - 1; i >= 0; --i) {
            if (!((OutputCollection.CommandRecord)tableModel.getValueAt(i, 2)).matches(string)) continue;
            return i;
        }
        return -1;
    }

    int rowOfNextMatch(String string, boolean bl) {
        int n = this.getSelectionModel().getMaxSelectionIndex();
        if (n == -1) {
            return -1;
        }
        TableModel tableModel = this.getModel();
        if (string.length() == 0) {
            for (int i = n + 1; i < tableModel.getRowCount(); ++i) {
                if (!bl && ((OutputCollection.CommandRecord)tableModel.getValueAt(i, 2)).isComment()) continue;
                return i;
            }
            return -1;
        }
        for (int i = n + 1; i < tableModel.getRowCount(); ++i) {
            if (!((OutputCollection.CommandRecord)tableModel.getValueAt(i, 2)).matches(string)) continue;
            return i;
        }
        return -1;
    }

    String getCommand(int n) {
        return this.getModel().getValueAt(n, 2).toString();
    }

    int getLastEvaluateCount() {
        return this.fLastEvaluateCount;
    }

    void setLastEvaluateCount(int n) {
        this.fLastEvaluateCount = n;
    }

    void scrollToBottom() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JScrollBar jScrollBar;
                JScrollPane jScrollPane = (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, (Component)((Object)CommandHistoryTable.this));
                if (jScrollPane != null && (jScrollBar = jScrollPane.getVerticalScrollBar()) != null) {
                    int n = jScrollBar.getMaximum() - jScrollBar.getModel().getExtent();
                    jScrollBar.setValue(n);
                }
            }
        });
    }

    void scrollToTop() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JScrollBar jScrollBar;
                JScrollPane jScrollPane = (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, (Component)((Object)CommandHistoryTable.this));
                if (jScrollPane != null && (jScrollBar = jScrollPane.getVerticalScrollBar()) != null) {
                    jScrollBar.setValue(jScrollBar.getMinimum());
                }
            }
        });
    }

    String getSelectedString() {
        if (this.getSelectedRowCount() == 0) {
            return "";
        }
        int[] nArray = this.getSelectedRows();
        StringBuilder stringBuilder = new StringBuilder();
        TableModel tableModel = this.getModel();
        for (int i = 0; i < nArray.length; ++i) {
            stringBuilder.append(tableModel.getValueAt(nArray[i], 2).toString());
            stringBuilder.append('\n');
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.setLength(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }

    void cutSelectedCommands() {
        this.copySelectedCommands();
        this.deleteSelectedCommands();
    }

    void copySelectedCommands() {
        if (this.getSelectedRowCount() == 0) {
            return;
        }
        String string = this.getSelectedString();
        if (string.length() > 0) {
            MJClipboard.getMJClipboard().setContents(string, null);
            if (PlatformInfo.isXWindows()) {
                MJClipboard.getMJClipboard().setXSelectionContents(string);
            }
        }
    }

    void deleteSelectedCommands() {
        if (this.getSelectedRowCount() == 0) {
            return;
        }
        OutputCollection.CommandTableModel commandTableModel = (OutputCollection.CommandTableModel)this.getModel();
        commandTableModel.delete(this.getSelectedRows());
        this.clearSelection();
    }

    void evaluateSelectedCommands() {
        if (this.getSelectedRowCount() == 0) {
            return;
        }
        int[] nArray = this.getSelectedRows();
        TableModel tableModel = this.getModel();
        String[] stringArray = new String[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            OutputCollection.CommandRecord commandRecord = (OutputCollection.CommandRecord)tableModel.getValueAt(nArray[i], 2);
            stringArray[i] = commandRecord.toString();
        }
        this.fCommandWindow.evaluate(stringArray);
        this.setLastEvaluateCount(nArray.length);
    }

    private void updateActions() {
        boolean bl = this.getSelectedRowCount() > 0;
        this.fCutAction.setEnabled(bl);
        this.fCopyAction.setEnabled(bl);
        this.fDeleteAction.setEnabled(bl);
        this.fEvaluateAction.setEnabled(this.fEvaluationEnabled && bl);
        this.fShowOutputAction.setEnabled(bl);
        this.fCreateMFileAction.setEnabled(bl);
        this.fCreateShortcutAction.setEnabled(bl);
        if (bl) {
            int n = this.getSelectionModel().getMinSelectionIndex();
            OutputCollection.CommandRecord commandRecord = (OutputCollection.CommandRecord)this.getModel().getValueAt(n, 2);
            this.fShowOutputAction.setEnabled(commandRecord.isOutputAvailable());
        }
    }

    private static class CommandRenderer
    extends StyledLabel
    implements TableCellRenderer {
        CommandRenderer() {
            this.setOpaque(true);
            this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 0));
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            OutputCollection.CommandRecord commandRecord = (OutputCollection.CommandRecord)object;
            String string = commandRecord.getCommandString();
            this.setText(string);
            TextStyleInfo textStyleInfo = null;
            if (bl) {
                this.setForeground(jTable.getSelectionForeground());
                this.setBackground(jTable.getSelectionBackground());
            } else {
                this.setForeground(jTable.getForeground());
                this.setBackground(jTable.getBackground());
                textStyleInfo = commandRecord.getStyleInfo();
            }
            if (textStyleInfo == null) {
                this.clearStyleRanges();
            } else {
                this.setStyleRanges(commandRecord.getStyleInfo().getStyleRanges());
            }
            this.setFont(jTable.getFont());
            return this;
        }
    }

    private static class PromptRenderer
    extends DefaultTableCellRenderer {
        PromptRenderer() {
            this.setOpaque(false);
            this.setHorizontalAlignment(4);
            this.setIconTextGap(0);
            this.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 4));
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setText(object.toString());
            this.setFont(jTable.getFont());
            return this;
        }
    }

    private static class RepeatRenderer
    extends DefaultTableCellRenderer {
        RepeatRenderer() {
            this.setOpaque(false);
            this.setIconTextGap(0);
            this.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            int n3 = (Integer)object;
            if (n3 < 0) {
                this.setText(null);
                this.setIcon(ERROR_ICON);
            } else {
                this.setIcon(null);
                if (n3 <= 1) {
                    this.setText(null);
                } else {
                    this.setText(n3 + "x");
                }
            }
            return this;
        }
    }

    private class DragListener
    implements DragGestureListener,
    DragSourceListener,
    DropTargetListener {
        private DragListener() {
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
            if (CommandHistoryTable.this.getSelectedRowCount() == 0) {
                return;
            }
            String string = CommandHistoryTable.this.getSelectedString();
            if (string == null || string.length() == 0) {
                return;
            }
            StringSelection stringSelection = new StringSelection(string);
            CommandHistoryTable.this.fDragSource.startDrag(dragGestureEvent, MJDragCursorUtilities.getCursor((int)1), MJDragCursorUtilities.getMacImageToDrag(), new Point(0, 0), stringSelection, this);
        }

        @Override
        public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
            Cursor cursor = dragSourceDragEvent.getDragSourceContext().getCursor();
            if (dragSourceDragEvent.getUserAction() != 1 || !cursor.equals(MJDragCursorUtilities.getCursor((int)1))) {
                Cursor cursor2 = MJDragCursorUtilities.getCursor((int)1);
                dragSourceDragEvent.getDragSourceContext().setCursor(cursor2);
            }
        }

        @Override
        public void dragExit(DragSourceEvent dragSourceEvent) {
            dragSourceEvent.getDragSourceContext().setCursor(MJDragCursorUtilities.getCursor((int)7563));
        }

        @Override
        public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
            this.dragEnter(dragSourceDragEvent);
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
        }

        @Override
        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        }

        @Override
        public void dragExit(DropTargetEvent dropTargetEvent) {
        }

        @Override
        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            dropTargetDragEvent.rejectDrag();
        }

        @Override
        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            dropTargetDropEvent.rejectDrop();
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        }
    }

    private class LocalMouseListener
    extends MouseAdapter {
        private LocalMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.showPopupMenu(mouseEvent);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.showPopupMenu(mouseEvent);
            } else if (mouseEvent.getClickCount() == 2 && CommandHistoryTable.this.fEvaluationEnabled) {
                CommandHistoryTable.this.evaluateSelectedCommands();
            }
        }

        private void showPopupMenu(MouseEvent mouseEvent) {
            ChildAction childAction = new ChildAction((Action)CommandHistoryTable.this.fUndoAction);
            childAction.setName(ParallelUI.sRes.getString("action.UndoDelete"));
            ChildAction childAction2 = new ChildAction((Action)CommandHistoryTable.this.fDeleteAction);
            childAction2.setName(ParallelUI.sRes.getString("action.DeleteSelection"));
            MJPopupMenu mJPopupMenu = new MJPopupMenu();
            mJPopupMenu.add((Action)childAction);
            mJPopupMenu.addSeparator();
            mJPopupMenu.add((Action)CommandHistoryTable.this.fCutAction);
            mJPopupMenu.add((Action)CommandHistoryTable.this.fCopyAction);
            mJPopupMenu.add((Action)CommandHistoryTable.this.fSelectAllAction);
            mJPopupMenu.addSeparator();
            mJPopupMenu.add((Action)CommandHistoryTable.this.fEvaluateAction);
            mJPopupMenu.add((Action)CommandHistoryTable.this.fShowOutputAction);
            mJPopupMenu.add((Action)((Object)new ToggleErrorAction(CommandHistoryTable.this.rowAtPoint(mouseEvent.getPoint()))));
            mJPopupMenu.add((Action)CommandHistoryTable.this.fCreateMFileAction);
            mJPopupMenu.addSeparator();
            mJPopupMenu.add((Action)childAction2);
            mJPopupMenu.add((Action)CommandHistoryTable.this.fClearAction);
            mJPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    private class ToggleErrorAction
    extends MJAbstractAction {
        OutputCollection.CommandRecord iCommandRecord;
        Rectangle iUpdateRect;

        ToggleErrorAction(int n) {
            String string = "action.SetErrorStatus";
            if (n == -1) {
                this.setEnabled(false);
            } else {
                this.iCommandRecord = (OutputCollection.CommandRecord)CommandHistoryTable.this.getModel().getValueAt(n, 2);
                string = this.iCommandRecord.causedError() ? "action.ClearErrorStatus" : "action.SetErrorStatus";
                this.iUpdateRect = CommandHistoryTable.this.getCellRect(n, 0, false);
            }
            this.setName(ParallelUI.sRes.getString(string));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.iCommandRecord.setCausedError(!this.iCommandRecord.causedError());
            CommandHistoryTable.this.repaint(this.iUpdateRect);
        }
    }

    private class CreateShortcutAction
    extends MJAbstractAction {
        CreateShortcutAction() {
            super(ParallelUI.sRes.getString("action.CreateShortcut"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ShortcutEditor.invoke(null, (String)CommandHistoryTable.this.getSelectedString(), (String)ShortcutUtils.getDefaultToolbarCategoryName());
        }
    }

    private class CreateMFileAction
    extends MJAbstractAction {
        CreateMFileAction() {
            super(ParallelUI.sRes.getString("action.CreateMFile"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MLEditorServices.getEditorApplication().newEditor(CommandHistoryTable.this.getSelectedString());
        }
    }

    private class ShowOutputAction
    extends MJAbstractAction {
        ShowOutputAction() {
            super(ParallelUI.sRes.getString("action.ShowOutput"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = CommandHistoryTable.this.getSelectionModel().getMinSelectionIndex();
            if (n != -1) {
                CommandHistoryTable.this.fOutputComponent.showCorrespondingOutput((OutputCollection.CommandRecord)CommandHistoryTable.this.getModel().getValueAt(n, 2));
            }
        }
    }

    private class EvaluateAction
    extends MJAbstractAction {
        EvaluateAction() {
            super(ParallelUI.sRes.getString("action.EvaluateSelection"));
            this.setAccelerator(Utilities.getEvalStroke());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CommandHistoryTable.this.evaluateSelectedCommands();
            CommandHistoryTable.this.clearSelection();
        }
    }

    private class ClearAction
    extends MJAbstractAction {
        ClearAction() {
            super(ParallelUI.sRes.getString("action.ClearCommandHistory"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            OutputCollection.CommandTableModel commandTableModel = (OutputCollection.CommandTableModel)CommandHistoryTable.this.getModel();
            int[] nArray = new int[commandTableModel.getRowCount()];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = i;
            }
            commandTableModel.delete(nArray);
        }
    }

    private class SelectAllAction
    extends MJAbstractAction {
        SelectAllAction() {
            super(MJUtilities.intlString((String)"action.SelectAll"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CommandHistoryTable.this.selectAll();
        }
    }

    private class DeleteAction
    extends MJAbstractAction {
        DeleteAction() {
            super(ParallelUI.sRes.getString("action.DeleteHistorySelection"));
            DTMenuMergeTag.DELETE.setTag((Action)((Object)this));
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CommandHistoryTable.this.deleteSelectedCommands();
        }
    }

    private class CopyAction
    extends AbstractCopyAction {
        CopyAction() {
            this.clearKeyBinding();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CommandHistoryTable.this.copySelectedCommands();
        }
    }

    private class CutAction
    extends AbstractCutAction {
        private CutAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CommandHistoryTable.this.cutSelectedCommands();
        }
    }

    private class UndoAction
    extends AbstractUndoAction {
        UndoAction() {
            this.clearKeyBinding();
            this.setName(ParallelUI.sRes.getString("action.UndoHistoryDelete"));
            DTMenuMergeTag.UNDO.setTag((Action)((Object)this));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            OutputCollection.CommandTableModel commandTableModel = (OutputCollection.CommandTableModel)CommandHistoryTable.this.getModel();
            commandTableModel.undoLastDeletion();
            CommandHistoryTable.this.clearSelection();
            this.setEnabled(commandTableModel.anythingToUndo());
        }
    }
}

