/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode;

import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabMCR;
import com.mathworks.toolbox.distcomp.logging.DistcompLevel;
import com.mathworks.toolbox.distcomp.nativedmatlab.ProcessManipulation;
import com.mathworks.toolbox.distcomp.pmode.DebugUtils;
import com.mathworks.toolbox.distcomp.pmode.PackageInfo;
import com.mathworks.toolbox.distcomp.pmode.SessionConstants;
import com.mathworks.toolbox.distcomp.pmode.SyncBoolean;
import com.mathworks.toolbox.distcomp.util.MatlabRefStore;

class LabFinishSessionWithMonitoring
implements Runnable {
    private SyncBoolean fHasOrderlyShutdownCompleted = new SyncBoolean(false);
    private Thread fWatchdog = new Thread(this);

    public static LabFinishSessionWithMonitoring create() {
        LabFinishSessionWithMonitoring labFinishSessionWithMonitoring = new LabFinishSessionWithMonitoring();
        labFinishSessionWithMonitoring.init();
        return labFinishSessionWithMonitoring;
    }

    private LabFinishSessionWithMonitoring() {
    }

    private void init() {
        this.fWatchdog.start();
    }

    private void onFinishSessionCompleted(int n, Object object) {
        if (Matlab.getExecutionStatus((int)n) == 0) {
            PackageInfo.LOGGER.log(DistcompLevel.TWO, "FinishSession was successful.");
            this.fHasOrderlyShutdownCompleted.setValueGetOldValue(true);
        } else {
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "FinishSession was not successful.  It finished with execution status " + Matlab.getExecutionStatus((int)n) + ".");
        }
        this.fWatchdog.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        DebugUtils.interruptMatlabClearDebugState();
        PackageInfo.LOGGER.log(DistcompLevel.TWO, "Finishing interactive session by running the command distcomp.stopInteractiveLab;");
        MatlabMCR matlabMCR = MatlabRefStore.getMatlabRef();
        matlabMCR.eval("distcomp.stopInteractiveLab;", new CompletionObserver(){

            public void completed(int n, Object object) {
                LabFinishSessionWithMonitoring.this.onFinishSessionCompleted(n, object);
            }
        });
        int n = SessionConstants.sLAB_WAIT_FOR_QUIT_BEFORE_SIGTERM;
        PackageInfo.LOGGER.log(DistcompLevel.THREE, "ShutdownMonitor waiting for " + n + " milliseconds.");
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.fHasOrderlyShutdownCompleted.getValue()) {
            return;
        }
        PackageInfo.LOGGER.log(DistcompLevel.ONE, "Shutdown timeout has expired.  Killing the lab.");
        try {
            ProcessManipulation processManipulation = new ProcessManipulation();
            processManipulation.sendSIGTERM();
            try {
                Thread.sleep(SessionConstants.sLAB_WAIT_FOR_SIGTERMSIGKILL);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            processManipulation.sendSIGKILL();
            try {
                Thread.sleep(SessionConstants.sLAB_WAIT_FOR_SIGTERMSIGKILL);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        finally {
            System.exit(1);
        }
    }
}

