/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode.io.broker;

import com.mathworks.toolbox.distcomp.pmode.io.broker.BrokerClientInfo;
import com.mathworks.toolbox.distcomp.pmode.shared.AcceptInfo;
import com.mathworks.toolbox.distcomp.pmode.shared.AcceptorSecurityDescription;
import com.mathworks.toolbox.distcomp.pmode.shared.ServerSocketAcceptInfo;
import java.io.Serializable;
import java.util.UUID;

public final class BrokeredAcceptInfo
implements AcceptInfo,
Serializable {
    private final UUID fGroupUuid;
    private final BrokerClientInfo fBrokerClientInfo;
    private final long fBrokeredConnectAcceptorInterval;
    private final long fBrokeredConnectAcceptorTimeout;
    private final ServerSocketAcceptInfo fRemoteAcceptInfo;

    public BrokeredAcceptInfo(UUID uUID, BrokerClientInfo brokerClientInfo, long l, long l2, ServerSocketAcceptInfo serverSocketAcceptInfo) {
        this.fGroupUuid = uUID;
        this.fBrokerClientInfo = brokerClientInfo;
        this.fBrokeredConnectAcceptorInterval = l;
        this.fBrokeredConnectAcceptorTimeout = l2;
        this.fRemoteAcceptInfo = serverSocketAcceptInfo;
    }

    @Override
    public UUID getGroupUUID() {
        return this.fGroupUuid;
    }

    @Override
    public AcceptorSecurityDescription getAcceptorSecurityDescription() {
        return this.fRemoteAcceptInfo.getAcceptorSecurityDescription();
    }

    @Override
    public long getHandShakeTimeout() {
        return this.fBrokeredConnectAcceptorTimeout;
    }

    @Override
    public String getLogString() {
        return this.getClass().getSimpleName() + " using " + this.fBrokerClientInfo.getLogString() + " for group " + this.fGroupUuid;
    }

    @Override
    public boolean peersConnectingAsGroupShareBarrier() {
        return true;
    }

    BrokerClientInfo getBrokerClientInfo() {
        return this.fBrokerClientInfo;
    }

    public long getBrokeredConnectAcceptorInterval() {
        return this.fBrokeredConnectAcceptorInterval;
    }

    public long getBrokeredConnectAcceptorTimeout() {
        return this.fBrokeredConnectAcceptorTimeout;
    }

    public ServerSocketAcceptInfo getRemoteAcceptInfo() {
        return this.fRemoteAcceptInfo;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        BrokeredAcceptInfo brokeredAcceptInfo = (BrokeredAcceptInfo)object;
        if (this.fBrokeredConnectAcceptorInterval != brokeredAcceptInfo.fBrokeredConnectAcceptorInterval) {
            return false;
        }
        if (this.fBrokeredConnectAcceptorTimeout != brokeredAcceptInfo.fBrokeredConnectAcceptorTimeout) {
            return false;
        }
        if (!this.fBrokerClientInfo.equals(brokeredAcceptInfo.fBrokerClientInfo)) {
            return false;
        }
        if (!this.fGroupUuid.equals(brokeredAcceptInfo.fGroupUuid)) {
            return false;
        }
        return this.fRemoteAcceptInfo.equals(brokeredAcceptInfo.fRemoteAcceptInfo);
    }

    public int hashCode() {
        int n = this.fGroupUuid.hashCode();
        n = 31 * n + this.fBrokerClientInfo.hashCode();
        n = 31 * n + (int)(this.fBrokeredConnectAcceptorInterval ^ this.fBrokeredConnectAcceptorInterval >>> 32);
        n = 31 * n + (int)(this.fBrokeredConnectAcceptorTimeout ^ this.fBrokeredConnectAcceptorTimeout >>> 32);
        n = 31 * n + this.fRemoteAcceptInfo.hashCode();
        return n;
    }

    public String toString() {
        return "BrokeredAcceptInfo{fGroupUuid=" + this.fGroupUuid + ", fBrokerClientInfo=" + this.fBrokerClientInfo + ", fBrokeredConnectAcceptorInterval=" + this.fBrokeredConnectAcceptorInterval + ", fBrokeredConnectAcceptorTimeout=" + this.fBrokeredConnectAcceptorTimeout + ", fRemoteAcceptInfoTemplate=" + this.fRemoteAcceptInfo + '}';
    }
}

