/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode.shared;

import com.mathworks.toolbox.distcomp.util.securesocket.SSLSocketChannel;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.ByteChannel;
import java.nio.channels.SocketChannel;

final class ByteChannelHelper {
    private ByteChannelHelper() {
    }

    static InetSocketAddress extractRemoteAddress(ByteChannel byteChannel) {
        if (byteChannel instanceof SocketChannel) {
            SocketChannel socketChannel = (SocketChannel)byteChannel;
            Socket socket = socketChannel.socket();
            if (socket != null) {
                return (InetSocketAddress)socket.getRemoteSocketAddress();
            }
            throw new IllegalStateException(byteChannel.toString() + "'s socket is not available");
        }
        if (byteChannel instanceof SSLSocketChannel) {
            SSLSocketChannel sSLSocketChannel = (SSLSocketChannel)byteChannel;
            return sSLSocketChannel.getRemoteSocketAddress();
        }
        throw new IllegalStateException("byteChannel is neither a SocketChannel nor a SSLSocketChannel but is an unexpected type: " + byteChannel.getClass());
    }

    static InetSocketAddress extractLocalAddress(ByteChannel byteChannel) {
        if (byteChannel instanceof SocketChannel) {
            SocketChannel socketChannel = (SocketChannel)byteChannel;
            Socket socket = socketChannel.socket();
            if (socket != null) {
                return (InetSocketAddress)socket.getLocalSocketAddress();
            }
            throw new IllegalStateException(byteChannel.toString() + "'s socket is not available");
        }
        if (byteChannel instanceof SSLSocketChannel) {
            SSLSocketChannel sSLSocketChannel = (SSLSocketChannel)byteChannel;
            return sSLSocketChannel.getLocalSocketAddress();
        }
        throw new IllegalStateException("byteChannel is neither a SocketChannel nor a SSLSocketChannel but is an unexpected type: " + byteChannel.getClass());
    }
}

