/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.remote;

import com.mathworks.toolbox.distcomp.control.remoteprotocol.scremote.client.PeerOrLocalShellSender;
import com.mathworks.toolbox.distcomp.remote.Command;
import com.mathworks.toolbox.distcomp.remote.CopyCommand;
import com.mathworks.toolbox.distcomp.remote.NoMatchingProtocolException;
import com.mathworks.toolbox.distcomp.remote.NoSuchProtocolException;
import com.mathworks.toolbox.distcomp.remote.ShellCommand;
import com.mathworks.toolbox.distcomp.remote.TunnelCommand;
import com.mathworks.toolbox.distcomp.remote.spi.Protocol;
import com.mathworks.toolbox.distcomp.remote.spi.plugin.JSchCopier;
import com.mathworks.toolbox.distcomp.remote.spi.plugin.JSchSFTPCopier;
import com.mathworks.toolbox.distcomp.remote.spi.plugin.JSchShellSender;
import com.mathworks.toolbox.distcomp.remote.spi.plugin.JSchTunneler;
import com.mathworks.toolbox.distcomp.remote.spi.plugin.RcpCopier;
import com.mathworks.toolbox.distcomp.remote.spi.plugin.RshShellSender;
import com.mathworks.toolbox.distcomp.remote.spi.plugin.WindowsRcpCopier;
import com.mathworks.toolbox.distcomp.remote.util.PathUtils;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ProtocolProvider {
    private static final ProtocolProvider INSTANCE = new ProtocolProvider();
    private LazyProtocolMap fProtocolSetByCommand = new LazyProtocolMap();

    private ProtocolProvider() {
        PathUtils.Platform platform = PathUtils.Platform.getLocal();
        if (platform.getPlatformType().isWindows()) {
            this.registerProtocol(ShellCommand.class, PeerOrLocalShellSender.class);
        }
        this.registerProtocol(ShellCommand.class, RshShellSender.class);
        this.registerProtocol(ShellCommand.class, JSchShellSender.class);
        if (platform.getPlatformType().isWindows()) {
            this.registerProtocol(CopyCommand.class, WindowsRcpCopier.class);
        } else {
            this.registerProtocol(CopyCommand.class, RcpCopier.class);
        }
        this.registerProtocol(CopyCommand.class, JSchSFTPCopier.class);
        this.registerProtocol(CopyCommand.class, JSchCopier.class);
        this.registerProtocol(TunnelCommand.class, JSchTunneler.class);
    }

    public static ProtocolProvider getInstance() {
        return INSTANCE;
    }

    public synchronized void registerProtocol(Class<? extends Command> clazz, Class<? extends Protocol> clazz2) {
        this.fProtocolSetByCommand.put(clazz, clazz2);
    }

    public Set<Protocol> getAllAvailableProtocols() {
        return this.fProtocolSetByCommand.getAllProtocols();
    }

    List<Protocol> getProtocolsForCommand(Class<? extends Command> clazz) throws NoMatchingProtocolException {
        LinkedHashSet<Protocol> linkedHashSet = new LinkedHashSet<Protocol>();
        linkedHashSet.addAll(this.getRegisteredProtocols(clazz));
        return new LinkedList<Protocol>(linkedHashSet);
    }

    public List<String> getProtocolTypes() {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (Protocol protocol : this.fProtocolSetByCommand.getAllProtocols()) {
            linkedHashSet.add(protocol.getProtocolType());
        }
        return new LinkedList<String>(linkedHashSet);
    }

    public List<String> getProtocolTypes(Class<? extends Command> clazz) throws NoMatchingProtocolException {
        assert (clazz != null);
        LinkedList<String> linkedList = new LinkedList<String>();
        for (Protocol protocol : this.getRegisteredProtocols(clazz)) {
            linkedList.add(protocol.getProtocolType());
        }
        return linkedList;
    }

    public Protocol getProtocolByType(String string) throws NoSuchProtocolException {
        for (Protocol protocol : this.fProtocolSetByCommand.getAllProtocols()) {
            if (!protocol.getProtocolType().equals(string)) continue;
            return protocol;
        }
        throw new NoSuchProtocolException(string);
    }

    public Class<? extends Command> getCommandClassByProtocolType(String string) throws NoSuchProtocolException {
        Protocol protocol = this.getProtocolByType(string);
        return protocol.getCommandClass();
    }

    private List<Protocol> getRegisteredProtocols(Class<? extends Command> clazz) throws NoMatchingProtocolException {
        LinkedHashSet<Protocol> linkedHashSet = new LinkedHashSet<Protocol>();
        for (Class<? extends Command> clazz2 : ProtocolProvider.getInterfacesAndClasses(clazz)) {
            if (!this.fProtocolSetByCommand.containsKey(clazz2)) continue;
            linkedHashSet.addAll(this.fProtocolSetByCommand.get(clazz2));
        }
        if (linkedHashSet.isEmpty()) {
            throw new NoMatchingProtocolException(clazz);
        }
        return new LinkedList<Protocol>(linkedHashSet);
    }

    static List<Class<? extends Command>> getInterfacesAndClasses(Class<? extends Command> clazz) {
        LinkedHashSet<Class<Command>> linkedHashSet = new LinkedHashSet<Class<Command>>();
        LinkedList linkedList = new LinkedList();
        linkedList.add(clazz);
        while (!linkedList.isEmpty()) {
            Class clazz2 = (Class)linkedList.remove(0);
            if (clazz2 == null || !Command.class.isAssignableFrom(clazz2)) continue;
            linkedHashSet.add(clazz2.asSubclass(Command.class));
            linkedList.add(clazz2.getSuperclass());
            linkedList.addAll(Arrays.asList(clazz2.getInterfaces()));
        }
        return new LinkedList<Class<? extends Command>>(linkedHashSet);
    }

    private static final class LazyProtocolMap {
        private Map<Class<? extends Command>, LinkedHashSet<Class<? extends Protocol>>> fProtocolClassSetByCommandClass = new LinkedHashMap<Class<? extends Command>, LinkedHashSet<Class<? extends Protocol>>>();
        private Map<Class<? extends Protocol>, Protocol> fProtocolInstances = new LinkedHashMap<Class<? extends Protocol>, Protocol>();

        public void put(Class<? extends Command> clazz, Class<? extends Protocol> clazz2) {
            LinkedHashSet<Class<? extends Protocol>> linkedHashSet = this.fProtocolClassSetByCommandClass.get(clazz);
            LinkedList<Class<? extends Protocol>> linkedList = linkedHashSet == null ? new LinkedList<Class<? extends Protocol>>() : new LinkedList<Class<? extends Protocol>>(linkedHashSet);
            linkedList.addFirst(clazz2);
            this.fProtocolClassSetByCommandClass.put(clazz, new LinkedHashSet(linkedList));
        }

        public Set<Protocol> get(Class<? extends Command> clazz) {
            if (!this.fProtocolClassSetByCommandClass.containsKey(clazz)) {
                return null;
            }
            LinkedHashSet<Protocol> linkedHashSet = new LinkedHashSet<Protocol>();
            for (Class clazz2 : this.fProtocolClassSetByCommandClass.get(clazz)) {
                linkedHashSet.add(this.getProtocol(clazz2));
            }
            return linkedHashSet;
        }

        private Protocol getProtocol(Class<? extends Protocol> clazz) {
            if (!this.fProtocolInstances.containsKey(clazz)) {
                try {
                    this.fProtocolInstances.put(clazz, clazz.newInstance());
                }
                catch (InstantiationException instantiationException) {
                    throw new ProtocolCreationException(clazz, instantiationException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new ProtocolCreationException(clazz, illegalAccessException);
                }
            }
            return this.fProtocolInstances.get(clazz);
        }

        public boolean containsKey(Class<? extends Command> clazz) {
            return this.fProtocolClassSetByCommandClass.containsKey(clazz);
        }

        public Set<Protocol> getAllProtocols() {
            LinkedHashSet<Protocol> linkedHashSet = new LinkedHashSet<Protocol>();
            for (LinkedHashSet<Class<? extends Protocol>> linkedHashSet2 : this.fProtocolClassSetByCommandClass.values()) {
                for (Class clazz : linkedHashSet2) {
                    linkedHashSet.add(this.getProtocol(clazz));
                }
            }
            return linkedHashSet;
        }

        public static final class ProtocolCreationException
        extends RuntimeException {
            private ProtocolCreationException(Class<? extends Protocol> clazz, Throwable throwable) {
                super("Cannot create an instance of protocol " + clazz.getSimpleName() + ".", throwable);
            }
        }
    }
}

