/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.remote.cli;

import com.mathworks.toolbox.distcomp.control.remoteprotocol.scremote.Log;
import com.mathworks.toolbox.distcomp.pmode.PackageInfo;
import com.mathworks.toolbox.distcomp.remote.Command;
import com.mathworks.toolbox.distcomp.remote.Credential;
import com.mathworks.toolbox.distcomp.remote.CredentialDescription;
import com.mathworks.toolbox.distcomp.remote.CredentialParameter;
import com.mathworks.toolbox.distcomp.remote.Environment;
import com.mathworks.toolbox.distcomp.remote.I18nRemoteExecutionException;
import com.mathworks.toolbox.distcomp.remote.Logger;
import com.mathworks.toolbox.distcomp.remote.NoMatchingProtocolException;
import com.mathworks.toolbox.distcomp.remote.NoSuchProtocolException;
import com.mathworks.toolbox.distcomp.remote.Parameter;
import com.mathworks.toolbox.distcomp.remote.ParameterMap;
import com.mathworks.toolbox.distcomp.remote.ParameterSet;
import com.mathworks.toolbox.distcomp.remote.Password;
import com.mathworks.toolbox.distcomp.remote.ProtocolProvider;
import com.mathworks.toolbox.distcomp.remote.RemoteExecutionException;
import com.mathworks.toolbox.distcomp.remote.RemoteExecutor;
import com.mathworks.toolbox.distcomp.remote.cli.CommandFactory;
import com.mathworks.toolbox.distcomp.remote.cli.CommandLineParserErrorCode;
import com.mathworks.toolbox.distcomp.remote.cli.CommandSpecifier;
import com.mathworks.toolbox.distcomp.remote.cli.EnvironmentFactory;
import com.mathworks.toolbox.distcomp.remote.cli.FactoryRegistry;
import com.mathworks.toolbox.distcomp.remote.cli.GlobalParameter;
import com.mathworks.toolbox.distcomp.remote.cli.HelpPrinter;
import com.mathworks.toolbox.distcomp.remote.cli.I18nCommandCreationException;
import com.mathworks.toolbox.distcomp.remote.cli.I18nInternalStateException;
import com.mathworks.toolbox.distcomp.remote.cli.ResourceHandler;
import com.mathworks.toolbox.distcomp.remote.spi.Protocol;
import com.mathworks.toolbox.distcomp.remote.util.PathUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;

public final class CommandLineParser {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String SCRIPT_NAME = System.getProperty("scriptname");
    private static final String COMMAND_TYPE_PROPERTY = System.getProperty("commandtype");
    private FactoryRegistry fRegistry;
    private ResourceHandler fHandler;
    private LinkedList<String> fCommandLine;
    private String fCommandType = null;
    private String fProtocolType = null;
    private Class<? extends Command> fCommandClass;
    private List<String> fHostnames;
    private Boolean fIsQuiet;
    private final CommandSpecifier fCommandSpecifier = new CommandSpecifier();

    CommandLineParser(String[] stringArray, FactoryRegistry factoryRegistry, ResourceHandler resourceHandler) {
        Logger.LOGGER.fine("Command line is " + Arrays.toString(stringArray));
        this.fRegistry = factoryRegistry;
        this.fHandler = resourceHandler;
        this.fCommandLine = new LinkedList<String>(Arrays.asList(stringArray));
        this.parse();
    }

    CommandSpecifier getCommandSpecifier() {
        return this.fCommandSpecifier;
    }

    List<String> getHostnames() {
        return this.fHostnames;
    }

    boolean isQuiet() {
        return Boolean.TRUE.equals(this.fIsQuiet);
    }

    private void parse() {
        Boolean bl = null;
        try {
            File file = this.extractParameterFromCommandLine(this.fCommandLine, GlobalParameter.LOG);
            if (file != null) {
                CommandLineParser.enableLogging(file);
            }
            this.fIsQuiet = this.extractParameterFromCommandLine(this.fCommandLine, GlobalParameter.QUIET);
            bl = this.extractParameterFromCommandLine(this.fCommandLine, GlobalParameter.HELP);
            this.parseProtocol(this.fCommandLine);
            if (COMMAND_TYPE_PROPERTY == null) {
                this.parseFirstArgument(this.fCommandLine);
            } else if (this.fRegistry.isCommandTypeRegistered(COMMAND_TYPE_PROPERTY)) {
                this.fCommandType = COMMAND_TYPE_PROPERTY;
            } else {
                throw new InvalidCommandTypeException(COMMAND_TYPE_PROPERTY);
            }
            if (Boolean.TRUE.equals(bl)) {
                this.printHelpAndExit(null, true);
            }
            this.discoverCommandClass(this.fProtocolType, this.fCommandType);
            this.parseHostnames(this.fCommandLine);
            this.parseCredential(this.fCommandLine);
            this.parseProtocolParameterMap(this.fCommandLine);
            this.parseCommand(this.fCommandLine);
        }
        catch (RemoteExecutionException remoteExecutionException) {
            this.printHelpAndExit(remoteExecutionException, Boolean.TRUE.equals(bl));
        }
    }

    private static void enableLogging(File file) {
        StreamHandler streamHandler;
        Formatter formatter = new Formatter(){

            @Override
            public String format(LogRecord logRecord) {
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                printWriter.append(logRecord.getMessage());
                Throwable throwable = logRecord.getThrown();
                if (throwable != null) {
                    printWriter.println();
                    throwable.printStackTrace(printWriter);
                }
                StringBuilder stringBuilder = new StringBuilder();
                for (String string : stringWriter.toString().split(LINE_SEPARATOR)) {
                    stringBuilder.append(String.format("%-6s | %s | %s%s", logRecord.getLevel(), new Date(logRecord.getMillis()).toString(), string, LINE_SEPARATOR));
                }
                return stringBuilder.toString();
            }
        };
        if (file.toString().equals("")) {
            streamHandler = new ConsoleHandler();
            streamHandler.setFormatter(formatter);
        } else {
            try {
                boolean bl = true;
                FileOutputStream fileOutputStream = new FileOutputStream(file, bl);
                streamHandler = new StreamHandler(fileOutputStream, formatter);
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("Unable to open log file " + file, iOException);
            }
        }
        streamHandler.setLevel(Level.ALL);
        Logger.LOGGER.addHandler(streamHandler);
        Log.LOGGER.addHandler(streamHandler);
        PackageInfo.LOGGER.addHandler(streamHandler);
        System.out.println("Logging enabled");
    }

    private void parseFirstArgument(LinkedList<String> linkedList) throws MalformedCommandException, NoSuchProtocolException {
        if (linkedList.isEmpty()) {
            this.printHelpAndExit(null, true);
        }
        if (linkedList.getFirst().startsWith("-")) {
            throw new MalformedCommandException();
        }
        String string = linkedList.removeFirst();
        if (this.fRegistry.isCommandTypeRegistered(string)) {
            this.fCommandType = string;
        } else {
            this.setProtocolType(string);
        }
    }

    private void printHelpAndExit(RemoteExecutionException remoteExecutionException, boolean bl) {
        HelpPrinter helpPrinter = new HelpPrinter(this.fRegistry, this.fHandler, SCRIPT_NAME);
        helpPrinter.printHelpAndExit(remoteExecutionException, this.fCommandType, this.fProtocolType, bl);
    }

    private void parseProtocol(LinkedList<String> linkedList) throws InvalidParameterException, NoSuchProtocolException {
        String string = this.extractParameterFromCommandLine(linkedList, GlobalParameter.PROTOCOL);
        if (this.fProtocolType == null && string != null) {
            this.setProtocolType(string);
        }
    }

    private void setProtocolType(String string) throws NoSuchProtocolException {
        this.fProtocolType = string;
        Protocol protocol = ProtocolProvider.getInstance().getProtocolByType(this.fProtocolType);
        this.fCommandSpecifier.setProtocol(protocol);
    }

    private void discoverCommandClass(String string, String string2) throws InvalidParameterException, NoMatchingProtocolException, NoSuchProtocolException {
        if (string2 == null) {
            if (string == null) {
                throw new UnsetFieldException();
            }
            this.fCommandClass = ProtocolProvider.getInstance().getCommandClassByProtocolType(string);
        } else {
            this.fCommandClass = this.fRegistry.getCommandClassByType(string2);
            if (this.fCommandClass == null) {
                throw new UnsetCommandException(string2, this.fRegistry);
            }
            if (string != null) {
                this.checkProtocolTypeMatchesCommandClass(string, this.fCommandClass);
            }
        }
    }

    private void checkProtocolTypeMatchesCommandClass(String string, Class<? extends Command> clazz) throws InvalidParameterException, NoMatchingProtocolException {
        List<String> list = ProtocolProvider.getInstance().getProtocolTypes(clazz);
        if (!list.contains(string)) {
            throw new InvalidParameterProtocolTypeException(GlobalParameter.PROTOCOL, string, this.fHandler, list);
        }
    }

    private void parseHostnames(LinkedList<String> linkedList) throws InvalidParameterException, MissingParameterException {
        String[] stringArray = this.extractParameterFromCommandLine(linkedList, GlobalParameter.REMOTE_HOST);
        if (stringArray == null) {
            throw new MissingParameterException(GlobalParameter.REMOTE_HOST, this.fHandler);
        }
        this.fHostnames = Arrays.asList(stringArray);
    }

    private void parseProtocolParameterMap(LinkedList<String> linkedList) throws InvalidParameterException, NoMatchingProtocolException {
        ParameterSet parameterSet = this.fCommandSpecifier.getProtocol() == null ? RemoteExecutor.getParameterSetForRecommendedProtocol(this.fCommandClass) : this.fCommandSpecifier.getProtocol().getParameterSet();
        ParameterMap parameterMap = this.extractParametersFromCommandLine(linkedList, parameterSet);
        this.fCommandSpecifier.setProtocolParameterMap(parameterMap);
    }

    private void parseCredential(LinkedList<String> linkedList) throws InvalidParameterException, NoMatchingProtocolException {
        ParameterMap parameterMap;
        Protocol protocol = this.fCommandSpecifier.getProtocol();
        if (protocol == null) {
            Logger.LOGGER.finest("No protocol defined in parseCredential.");
            return;
        }
        if (!protocol.getParameterSet().hasCredentialParameter()) {
            Logger.LOGGER.finest("No credential required by" + protocol + "  in parseCredential");
            return;
        }
        CredentialParameter credentialParameter = protocol.getParameterSet().getCredentialParameter();
        this.fCommandSpecifier.setCredentialParameter(credentialParameter);
        CredentialDescription credentialDescription = null;
        int n = 0;
        for (CredentialDescription credentialDescription2 : credentialParameter.getPossibleCredentialDescriptions()) {
            int n2 = this.getNumberOfMatchingParameters(linkedList, credentialDescription2.getParameterSet());
            if (n2 <= n) continue;
            credentialDescription = credentialDescription2;
            n = n2;
        }
        if (credentialDescription != null) {
            parameterMap = this.extractParametersFromCommandLine(linkedList, credentialDescription.getParameterSet());
            Logger.LOGGER.finest("Credential " + credentialDescription + " inferred in parseCredential");
        } else {
            credentialDescription = protocol.getParameterSet().getCredentialParameter().getDefaultCredentialDescription();
            parameterMap = new ParameterMap();
            Logger.LOGGER.finest("Credential " + credentialDescription + " selected as default in parseCredential");
        }
        this.fCommandSpecifier.setCredentialDescription(credentialDescription);
        this.fCommandSpecifier.setCredentialParameterMap(parameterMap);
    }

    private int getNumberOfMatchingParameters(LinkedList<String> linkedList, ParameterSet parameterSet) throws InvalidParameterException {
        ParameterMap parameterMap = this.extractParametersFromCommandLine(new LinkedList<String>(linkedList), parameterSet);
        return parameterMap.size();
    }

    private void parseCommand(LinkedList<String> linkedList) throws I18nCommandCreationException, InvalidParameterException {
        PathUtils.Separator separator;
        CommandFactory<?> commandFactory = this.fRegistry.getFactoryByCommandClass(this.fCommandClass);
        PathUtils.PlatformType platformType = this.extractParameterFromCommandLine(linkedList, GlobalParameter.REMOTE_PLATFORM_TYPE);
        Boolean bl = this.extractParameterFromCommandLine(linkedList, GlobalParameter.USE_BACKSLASH);
        PathUtils.Separator separator2 = separator = Boolean.TRUE.equals(bl) ? PathUtils.Separator.BACKSLASH : PathUtils.Separator.SLASH;
        if (platformType != null && bl == null) {
            separator = platformType.getDefaultSeparator();
        }
        commandFactory.setRemotePlatform(new PathUtils.Platform(platformType, separator));
        Logger.LOGGER.finest("CommandFactory parameter set is " + commandFactory.getParameterSet());
        ParameterMap parameterMap = this.extractParametersFromCommandLine(linkedList, commandFactory.getParameterSet());
        ParameterMap parameterMap2 = this.fCommandSpecifier.getProtocolParameterMap();
        ParameterMap parameterMap3 = parameterMap2.createCopyRetaining(commandFactory.getParameterSet());
        parameterMap3.putAll(parameterMap);
        Logger.LOGGER.finest("commandParameterMap is " + parameterMap3);
        Object obj = commandFactory.createCommand(parameterMap3, linkedList);
        this.fCommandSpecifier.setCommand((Command)obj);
    }

    private ParameterMap extractParametersFromCommandLine(LinkedList<String> linkedList, ParameterSet parameterSet) throws InvalidParameterException {
        ParameterMap parameterMap = new ParameterMap();
        for (Parameter<?> parameter : parameterSet.getParameters()) {
            if (parameter instanceof CredentialParameter) continue;
            this.extractAndPutIntoMap(linkedList, parameter, parameterMap);
        }
        return parameterMap;
    }

    private <V> void extractAndPutIntoMap(LinkedList<String> linkedList, Parameter<V> parameter, ParameterMap parameterMap) throws InvalidParameterException {
        V v = this.extractParameterFromCommandLine(linkedList, parameter);
        if (v != null) {
            parameterMap.put(parameter, v);
        }
    }

    private <V> V extractParameterFromCommandLine(LinkedList<String> linkedList, Parameter<V> parameter) throws InvalidParameterException {
        this.renameKeyInCommandLine(linkedList, parameter);
        return this.findParameterInCommandLine(linkedList, parameter);
    }

    private void renameKeyInCommandLine(LinkedList<String> linkedList, Parameter<?> parameter) {
        int n = linkedList.indexOf(this.fHandler.getResourceKey(parameter));
        if (n > -1) {
            linkedList.set(n, parameter.toString());
        }
    }

    private <V> V findParameterInCommandLine(List<String> list, Parameter<V> parameter) throws InvalidParameterException {
        String string = parameter.toString();
        int n = list.indexOf(string);
        if (n < 0) {
            return null;
        }
        list.remove(n);
        String string2 = "";
        if (list.size() > n && !list.get(n).startsWith("-")) {
            string2 = list.remove(n);
        }
        return CommandLineParser.parseValue(parameter, string2, this.fHandler);
    }

    static <V> V parseValue(Parameter<V> parameter, String string, ResourceHandler resourceHandler) throws InvalidParameterException {
        if (parameter.getValueClass().equals(String.class)) {
            return parameter.getValueClass().cast(string);
        }
        if (parameter.getValueClass().equals(Integer.class)) {
            try {
                return parameter.getValueClass().cast(Integer.valueOf(string));
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidParameterNumberFormatException(parameter, string, resourceHandler);
            }
        }
        if (parameter.getValueClass().equals(String[].class)) {
            return parameter.getValueClass().cast(string.split(","));
        }
        if (parameter.getValueClass().equals(Boolean.class)) {
            return parameter.getValueClass().cast(true);
        }
        if (parameter.getValueClass().equals(File.class)) {
            return parameter.getValueClass().cast(new File(string));
        }
        if (parameter.getValueClass().equals(Password.class)) {
            return parameter.getValueClass().cast(new Password(string.getBytes()));
        }
        if (parameter.getValueClass().equals(Environment.class)) {
            boolean bl = true;
            try {
                return parameter.getValueClass().cast(EnvironmentFactory.create(string, bl));
            }
            catch (IOException iOException) {
                throw new InvalidParameterIOException(parameter, string, resourceHandler, iOException);
            }
        }
        if (Credential.class.isAssignableFrom(parameter.getValueClass())) {
            throw new AttemptToParseCredentialException(parameter.getValueClass());
        }
        if (parameter.getValueClass().isEnum()) {
            try {
                return parameter.getValueClass().cast(CommandLineParser.valueOf(parameter.getValueClass(), string));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new InvalidParameterValueClassException(parameter, string, resourceHandler, illegalArgumentException);
            }
        }
        throw new UnparseableTypeException(parameter.getValueClass());
    }

    private static <T> T valueOf(Class<T> clazz, String string) {
        T[] TArray;
        assert (clazz.isEnum());
        for (T t : TArray = clazz.getEnumConstants()) {
            if (!t.toString().equalsIgnoreCase(string)) continue;
            return t;
        }
        throw new IllegalArgumentException("No enum const " + clazz.getSimpleName() + "." + string + "; available: " + new LinkedList<T>(Arrays.asList(clazz.getEnumConstants())));
    }

    private static final class InvalidParameterValueClassException
    extends InvalidParameterException {
        InvalidParameterValueClassException(Parameter<?> parameter, String string, ResourceHandler resourceHandler, IllegalArgumentException illegalArgumentException) {
            super(CommandLineParserErrorCode.InvalidParameterValueClass, parameter, string, resourceHandler, illegalArgumentException);
        }

        @Override
        protected Object[] getMessageArguments() {
            return new Object[]{this.getValueString(), this.getParameterString(), this.getCause().getMessage()};
        }
    }

    private static final class InvalidParameterIOException
    extends InvalidParameterException {
        InvalidParameterIOException(Parameter<?> parameter, String string, ResourceHandler resourceHandler, IOException iOException) {
            super(CommandLineParserErrorCode.InvalidParameterIO, parameter, string, resourceHandler, iOException);
        }

        @Override
        protected Object[] getMessageArguments() {
            return new Object[]{this.getValueString(), this.getParameterString(), this.getCause().getMessage()};
        }
    }

    private static final class InvalidParameterNumberFormatException
    extends InvalidParameterException {
        InvalidParameterNumberFormatException(Parameter<?> parameter, String string, ResourceHandler resourceHandler) {
            super(CommandLineParserErrorCode.InvalidParameterNumberFormat, (Parameter)parameter, string, resourceHandler);
        }

        @Override
        protected Object[] getMessageArguments() {
            return new Object[]{this.getValueString(), this.getParameterString()};
        }
    }

    private static final class InvalidParameterProtocolTypeException
    extends InvalidParameterException {
        private final List<?> fAvailable;

        InvalidParameterProtocolTypeException(Parameter<?> parameter, String string, ResourceHandler resourceHandler, List<?> list) {
            super(CommandLineParserErrorCode.InvalidParameterProtocolType, (Parameter)parameter, string, resourceHandler);
            this.fAvailable = list;
        }

        @Override
        protected Object[] getMessageArguments() {
            return new Object[]{this.getValueString(), this.getParameterString(), this.fAvailable};
        }
    }

    public static abstract class InvalidParameterException
    extends CommandLineParserException {
        private final String fValue;
        private final ResourceHandler fHandler;
        private final Parameter<?> fParameter;

        private InvalidParameterException(CommandLineParserErrorCode commandLineParserErrorCode, Parameter<?> parameter, String string, ResourceHandler resourceHandler) {
            super(commandLineParserErrorCode);
            this.fValue = string;
            this.fHandler = resourceHandler;
            this.fParameter = parameter;
        }

        private InvalidParameterException(CommandLineParserErrorCode commandLineParserErrorCode, Parameter<?> parameter, String string, ResourceHandler resourceHandler, Throwable throwable) {
            super(commandLineParserErrorCode, throwable);
            this.fValue = string;
            this.fHandler = resourceHandler;
            this.fParameter = parameter;
        }

        protected String getValueString() {
            return this.fValue;
        }

        protected String getParameterString() {
            return this.fHandler.getResourceKey(this.fParameter);
        }
    }

    private static final class InvalidCommandTypeException
    extends I18nInternalStateException {
        private final String fCommandType;

        InvalidCommandTypeException(String string) {
            super(CommandLineParserErrorCode.InvalidCommandType);
            this.fCommandType = string;
        }

        @Override
        protected Object[] getMessageArguments() {
            return new Object[]{this.fCommandType};
        }
    }

    public static final class UnsetCommandException
    extends I18nInternalStateException {
        private final String fCommandType;
        private final Set<String> fListCommandType;
        private final FactoryRegistry fRegistry;

        UnsetCommandException(String string, FactoryRegistry factoryRegistry) {
            super(CommandLineParserErrorCode.UnsetCommand);
            this.fCommandType = string;
            this.fRegistry = factoryRegistry;
            this.fListCommandType = this.fRegistry.getCommandTypes();
        }

        @Override
        protected Object[] getMessageArguments() {
            return new Object[]{this.fCommandType, this.fListCommandType};
        }
    }

    private static final class UnsetFieldException
    extends I18nInternalStateException {
        private static final Object[] OBJECTS = new Object[0];

        UnsetFieldException() {
            super(CommandLineParserErrorCode.UnsetField);
        }

        @Override
        protected Object[] getMessageArguments() {
            return OBJECTS;
        }
    }

    private static final class AttemptToParseCredentialException
    extends I18nInternalStateException {
        private final Class<?> fType;

        AttemptToParseCredentialException(Class<?> clazz) {
            super(CommandLineParserErrorCode.AttemptToParseCredential);
            this.fType = clazz;
        }

        @Override
        protected Object[] getMessageArguments() {
            return new Object[]{this.fType.getSimpleName()};
        }
    }

    private static final class UnparseableTypeException
    extends I18nInternalStateException {
        private final Class<?> fType;

        UnparseableTypeException(Class<?> clazz) {
            super(CommandLineParserErrorCode.UnparseableType);
            this.fType = clazz;
        }

        @Override
        protected Object[] getMessageArguments() {
            return new Object[]{this.fType.getSimpleName()};
        }
    }

    private static final class MissingParameterException
    extends CommandLineParserException {
        private final ResourceHandler fHandler;
        private final Parameter<?> fMissingParameter;
        private final String fMissingParameterString;

        MissingParameterException(Parameter<?> parameter, ResourceHandler resourceHandler) {
            super(CommandLineParserErrorCode.MissingParameter);
            this.fMissingParameter = parameter;
            this.fHandler = resourceHandler;
            this.fMissingParameterString = this.fHandler.getResourceKey(this.fMissingParameter);
        }

        @Override
        protected Object[] getMessageArguments() {
            return new Object[]{this.fMissingParameterString};
        }
    }

    private static final class MalformedCommandException
    extends CommandLineParserException {
        private static final Object[] OBJECTS = new Object[0];

        MalformedCommandException() {
            super(CommandLineParserErrorCode.MalformedCommand);
        }

        @Override
        protected Object[] getMessageArguments() {
            return OBJECTS;
        }
    }

    public static abstract class CommandLineParserException
    extends I18nRemoteExecutionException {
        private CommandLineParserException(CommandLineParserErrorCode commandLineParserErrorCode) {
            super(commandLineParserErrorCode, RemoteExecutionException.ErrorCode.STARTOP);
        }

        private CommandLineParserException(CommandLineParserErrorCode commandLineParserErrorCode, Throwable throwable) {
            super(commandLineParserErrorCode, RemoteExecutionException.ErrorCode.STARTOP, throwable);
        }
    }
}

