/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.remote.spi.plugin;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.mathworks.toolbox.distcomp.remote.Credential;
import com.mathworks.toolbox.distcomp.remote.CredentialException;
import com.mathworks.toolbox.distcomp.remote.DispatchException;
import com.mathworks.toolbox.distcomp.remote.IdentityFileCredential;
import com.mathworks.toolbox.distcomp.remote.IdentityFileCredentialDescription;
import com.mathworks.toolbox.distcomp.remote.Logger;
import com.mathworks.toolbox.distcomp.remote.ParameterMap;
import com.mathworks.toolbox.distcomp.remote.Password;
import com.mathworks.toolbox.distcomp.remote.PasswordCredential;
import com.mathworks.toolbox.distcomp.remote.PasswordCredentialDescription;
import com.mathworks.toolbox.distcomp.remote.ProtocolDispatchException;
import com.mathworks.toolbox.distcomp.remote.spi.LeaseMonitor;
import com.mathworks.toolbox.distcomp.remote.spi.LeaseMonitorFactory;
import com.mathworks.toolbox.distcomp.remote.spi.LeaseSource;
import com.mathworks.toolbox.distcomp.remote.spi.plugin.JSchLeasableSession;
import com.mathworks.toolbox.distcomp.remote.spi.plugin.SshParameter;
import java.io.File;

public final class JSchSessionLeaseSource {
    public static final LeaseSource<JSchLeasableSession> INSTANCE = new LeaseSource<JSchLeasableSession>(new JSchLeaseSessionMonitorFactory());
    private static final int CHANNEL_LIMIT = 10;

    private static int getIdleSecondsBeforeDisconnect(ParameterMap parameterMap) {
        int n = SshParameter.IDLE_SECONDS_BEFORE_DISCONNECT.getSuggestedValue();
        if (parameterMap.containsKey(SshParameter.IDLE_SECONDS_BEFORE_DISCONNECT)) {
            n = parameterMap.get(SshParameter.IDLE_SECONDS_BEFORE_DISCONNECT);
        }
        return n;
    }

    private static JSchLeasableSession getJSchLeasableSession(String string, ParameterMap parameterMap) throws ProtocolDispatchException {
        String string2 = string + ": ";
        try {
            Session session = JSchSessionLeaseSource.createJSchSession(string, parameterMap);
            return new JSchLeasableSession(session);
        }
        catch (CredentialException credentialException) {
            throw new ProtocolDispatchException(string2 + " could not connect session.", (Throwable)credentialException);
        }
    }

    private static Session createJSchSession(String string, ParameterMap parameterMap) throws CredentialException, ProtocolDispatchException {
        Object object;
        Object object2;
        Session session;
        Object object3;
        Credential credential;
        String string2 = string + ": ";
        JSch.setLogger((com.jcraft.jsch.Logger)new JSchToJavaLogger(string2));
        JSch jSch = new JSch();
        int n = SshParameter.PORT.getSuggestedValue();
        if (parameterMap.containsKey(SshParameter.PORT)) {
            n = parameterMap.get(SshParameter.PORT);
        }
        if ((credential = parameterMap.get(SshParameter.SSH_CREDENTIAL)) instanceof PasswordCredential) {
            object3 = (PasswordCredential)credential;
            String string3 = ((PasswordCredential)object3).getParameterMap().get(PasswordCredentialDescription.USERNAME);
            session = JSchSessionLeaseSource.createSession(string3, string, n, jSch);
            object2 = ((PasswordCredential)object3).getParameterMap().get(PasswordCredentialDescription.PASSWORD);
            if (object2 == null) {
                throw new CredentialException("Password is null.");
            }
            session.setPassword(((Password)object2).getPassword());
        } else if (credential instanceof IdentityFileCredential) {
            object3 = (IdentityFileCredential)credential;
            String string4 = ((IdentityFileCredential)object3).getParameterMap().get(IdentityFileCredentialDescription.USERNAME);
            session = JSchSessionLeaseSource.createSession(string4, string, n, jSch);
            object2 = ((IdentityFileCredential)object3).getParameterMap().get(IdentityFileCredentialDescription.IDENTITY_FILE);
            object = null;
            Password password = ((IdentityFileCredential)object3).getParameterMap().get(IdentityFileCredentialDescription.PASSPHRASE);
            if (password != null) {
                object = password.getPassword();
            }
            try {
                jSch.addIdentity(((File)object2).getAbsolutePath(), object);
            }
            catch (JSchException jSchException) {
                throw new CredentialException("Exception while setting identity file credentials", jSchException, (Credential)object3);
            }
        } else {
            throw new CredentialException("Do not recognise " + credential);
        }
        object3 = parameterMap.get(SshParameter.KNOWN_HOSTS);
        if (object3 != null) {
            try {
                jSch.setKnownHosts(((File)object3).toString());
            }
            catch (JSchException jSchException) {
                throw new ProtocolDispatchException("Problem setting known hosts to " + object3, (Throwable)jSchException);
            }
        }
        boolean bl = false;
        if (parameterMap.containsKey(SshParameter.STRICT_HOST_KEY_CHECKING)) {
            bl = parameterMap.get(SshParameter.STRICT_HOST_KEY_CHECKING);
        }
        object = "no";
        if (bl) {
            object = "yes";
        }
        session.setConfig("StrictHostKeyChecking", (String)object);
        return session;
    }

    private static Session createSession(String string, String string2, int n, JSch jSch) throws ProtocolDispatchException {
        try {
            return jSch.getSession(string, string2, n);
        }
        catch (JSchException jSchException) {
            throw new ProtocolDispatchException("Can not create ssh session, " + jSchException.getLocalizedMessage(), (Throwable)jSchException);
        }
    }

    static LeaseMonitor<JSchLeasableSession> createForTunnelFuture(String string, ParameterMap parameterMap) throws DispatchException {
        JSchLeaseSessionMonitorFactory jSchLeaseSessionMonitorFactory = new JSchLeaseSessionMonitorFactory();
        LeaseSource<JSchLeasableSession> leaseSource = null;
        return jSchLeaseSessionMonitorFactory.newLeaseMonitor(string, parameterMap, leaseSource);
    }

    private static final class JSchToJavaLogger
    implements com.jcraft.jsch.Logger {
        private final String fLogIdString;

        JSchToJavaLogger(String string) {
            this.fLogIdString = string;
        }

        public boolean isEnabled(int n) {
            return true;
        }

        public void log(int n, String string) {
            switch (n) {
                case 1: {
                    Logger.LOGGER.finest(this.fLogIdString + string);
                    break;
                }
                case 2: {
                    Logger.LOGGER.fine(this.fLogIdString + string);
                    break;
                }
                default: {
                    Logger.LOGGER.finest(this.fLogIdString + string);
                    assert (false) : "JSch added log level " + n;
                    Logger.LOGGER.warning("New log level from JSch: " + n + " " + string);
                }
            }
        }
    }

    private static final class JSchLeaseSessionMonitorFactory
    implements LeaseMonitorFactory<JSchLeasableSession> {
        private JSchLeaseSessionMonitorFactory() {
        }

        @Override
        public LeaseMonitor<JSchLeasableSession> newLeaseMonitor(String string, ParameterMap parameterMap, LeaseSource<JSchLeasableSession> leaseSource) throws DispatchException {
            JSchLeasableSession jSchLeasableSession = JSchSessionLeaseSource.getJSchLeasableSession(string, parameterMap);
            int n = JSchSessionLeaseSource.getIdleSecondsBeforeDisconnect(parameterMap);
            return new LeaseMonitor<JSchLeasableSession>(jSchLeasableSession, leaseSource, string, parameterMap, 10, n);
        }
    }
}

