/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.remote.util;

import com.mathworks.toolbox.distcomp.remote.Logger;
import com.mathworks.toolbox.distcomp.remote.util.BufferedFileInputStream;
import com.mathworks.toolbox.distcomp.remote.util.SingleStreamRedirector;
import com.mathworks.toolbox.distcomp.remote.util.StreamRedirector;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;

public final class OutputRedirector {
    private final boolean fUseStreamRedirector;
    private final String fOutPrefix;
    private final String fErrPrefix;
    private final InputStream fStdout;
    private final InputStream fStderr;
    private final SingleStreamRedirector fStdoutRedirect;
    private final SingleStreamRedirector fStderrRedirect;
    private final StreamRedirector.RedirectionPair fSRStdoutRedirect;
    private final StreamRedirector.RedirectionPair fSRStderrRedirect;
    private AtomicBoolean fIsClosed = new AtomicBoolean(false);

    public OutputRedirector(InputStream inputStream, InputStream inputStream2, OutputStream outputStream, OutputStream outputStream2, String string, String string2) {
        this.fUseStreamRedirector = inputStream instanceof BufferedFileInputStream;
        this.fOutPrefix = string;
        this.fErrPrefix = string2;
        this.fStdout = inputStream;
        this.fStderr = inputStream2;
        if (this.fUseStreamRedirector) {
            assert (inputStream2 instanceof BufferedFileInputStream) : "stdout is a " + inputStream.getClass() + ", stderr is a " + inputStream2.getClass();
            this.fStdoutRedirect = null;
            this.fStderrRedirect = null;
            this.fSRStdoutRedirect = StreamRedirector.getInstance().addRedirect(this.fStdout, outputStream, this.fOutPrefix);
            this.fSRStderrRedirect = StreamRedirector.getInstance().addRedirect(this.fStderr, outputStream2, this.fErrPrefix);
        } else {
            assert (!(inputStream2 instanceof BufferedFileInputStream)) : "stdout is a " + inputStream.getClass() + ", stderr is a " + inputStream2.getClass();
            this.fStdoutRedirect = new SingleStreamRedirector(this.fStdout, outputStream, this.fOutPrefix);
            this.fStderrRedirect = new SingleStreamRedirector(this.fStderr, outputStream2, this.fErrPrefix);
            this.fSRStdoutRedirect = null;
            this.fSRStderrRedirect = null;
            Thread thread = new Thread((Runnable)this.fStderrRedirect, "OutputRedirector.stdErrThread " + string);
            thread.start();
            Thread thread2 = new Thread((Runnable)this.fStdoutRedirect, "OutputRedirector.stdOutThread " + string2);
            thread2.start();
        }
    }

    public OutputRedirector(InputStream inputStream, InputStream inputStream2, OutputStream outputStream, OutputStream outputStream2) {
        this(inputStream, inputStream2, outputStream, outputStream2, null, null);
    }

    public void awaitEndOfRedirects() throws InterruptedException {
        if (!this.fUseStreamRedirector) {
            this.fStdoutRedirect.awaitEof();
            this.fStderrRedirect.awaitEof();
        }
    }

    public boolean isRunning() {
        boolean bl;
        boolean bl2;
        if (this.fUseStreamRedirector) {
            bl2 = StreamRedirector.getInstance().containsRedirect(this.fSRStderrRedirect);
            bl = StreamRedirector.getInstance().containsRedirect(this.fSRStdoutRedirect);
        } else {
            bl2 = !this.fStderrRedirect.isAtEoF();
            boolean bl3 = bl = !this.fStdoutRedirect.isAtEoF();
        }
        if (bl2 != bl) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("stderr is ");
            if (!bl2) {
                stringBuilder.append("not ");
            }
            stringBuilder.append("running and stdout is ");
            if (!bl) {
                stringBuilder.append("not ");
            }
            stringBuilder.append("running");
            Logger.LOGGER.warning(this.fErrPrefix + stringBuilder.toString());
            return true;
        }
        return bl;
    }

    public void close() {
        if (this.fUseStreamRedirector) {
            StreamRedirector.getInstance().removeRedirect(this.fSRStderrRedirect);
            StreamRedirector.getInstance().removeRedirect(this.fSRStdoutRedirect);
        }
        try {
            this.fStderr.close();
        }
        catch (IOException iOException) {
            Logger.LOGGER.log(Level.WARNING, this.fErrPrefix + "failed to close stderr stream", iOException);
        }
        try {
            this.fStdout.close();
        }
        catch (IOException iOException) {
            Logger.LOGGER.log(Level.WARNING, this.fOutPrefix + "failed to close stdout stream", iOException);
        }
        this.fIsClosed.set(true);
    }
}

