/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.storage;

import com.mathworks.toolbox.distcomp.jobmanager.PackageInfo;
import com.mathworks.toolbox.distcomp.logging.DistcompLevel;
import com.mathworks.toolbox.distcomp.storage.Cache;
import com.mathworks.toolbox.distcomp.storage.CachedPreparedStatement;
import com.mathworks.toolbox.distcomp.storage.DataNotFoundException;
import com.mathworks.toolbox.distcomp.storage.DataStorageException;
import com.mathworks.toolbox.distcomp.storage.DatabaseConnectionPool;
import com.mathworks.toolbox.distcomp.storage.DatabaseStorage;
import com.mathworks.toolbox.distcomp.storage.JobNotFoundException;
import com.mathworks.toolbox.distcomp.storage.StorageException;
import com.mathworks.toolbox.distcomp.storage.StorageInitException;
import com.mathworks.toolbox.distcomp.storage.TaskNotFoundException;
import com.mathworks.toolbox.distcomp.storage.WorkUnitNotFoundException;
import com.mathworks.toolbox.distcomp.util.BufferedStreamCopier;
import com.mathworks.toolbox.distcomp.util.ErrorPrinterImpl;
import com.mathworks.toolbox.distcomp.workunit.JobIDAndMLType;
import com.mathworks.toolbox.distcomp.workunit.JobImpl;
import com.mathworks.toolbox.distcomp.workunit.TaskImpl;
import com.mathworks.toolbox.distcomp.workunit.WorkUnitImpl;
import com.mathworks.toolbox.distcomp.workunit.WorkUnitInitializer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Vector;
import java.util.concurrent.Semaphore;
import net.jini.id.Uuid;
import net.jini.id.UuidFactory;

public class H2DatabaseStorage
extends DatabaseStorage {
    private static final String SEQUENCE_NAME = "seq_key";
    private static final String JOB_SEQUENCE_NAME = "job_seq_key";
    private static final String QUOTED_SEQUENCE_NAME = "'seq_key'";
    private static final String QUOTED_JOB_SEQUENCE_NAME = "'job_seq_key'";
    private static final String TASK_TABLE_NAME = "task_table";
    private static final String JOB_TABLE_NAME = "job_table";
    private static final String DATA_TABLE_NAME = "data_table";
    private Semaphore fDataTableWriteLock = new Semaphore(1, true);
    private transient SelectTaskById fSelectTaskById;
    private transient SelectTasksByState fSelectTasksByState;
    private transient SelectTasksByJobId fSelectTasksByJobId;
    private transient CountTasksByJobId fCountTasksByJobId;
    private transient CountTasksByJobIdAndState fCountTasksByJobIdAndState;
    private transient CountTasksByJobIdAndBeforeState fCountTasksByJobIdAndBeforeState;
    private transient SelectTasksByJobIdAndState fSelectTasksByJobIdAndState;
    private transient SelectTasksByJobIdAndArrayOfStates fSelectTasksByJobIdAndArrayOfStates;
    private transient SelectNumberOfTasksByJobIdAndState fSelectNumberOfTasksByJobIdAndState;
    private transient SelectTasksByJobIdAndBeforeState fSelectTasksByJobIdAndBeforeState;
    private transient SelectDataById fSelectDataById;
    private transient SelectJobById fSelectJobById;
    private transient SelectJobsByState fSelectJobsByState;
    private transient SelectJobsByJobStateWithTasksInState fSelectJobsByJobStateWithTasksInState;
    private transient SelectJobsAndTypesByState fSelectJobsAndTypesByState;
    private transient SelectJobsAndTypesByArrayOfStates fSelectJobsAndTypesByArrayOfStates;
    private transient SelectFirstJobByState fSelectFirstJobByState;
    private transient SelectJobsAndTypes fSelectJobsAndTypes;
    private transient SelectPreviousQueuedJob fSelectPreviousQueuedJob;
    private transient SelectNextQueuedJob fSelectNextQueuedJob;
    private transient NextSeqNum fNextSeqNum;
    private transient NextJobSeqNum fNextJobSeqNum;
    private transient InsertData fInsertData;
    private transient CopyData fCopyData;
    private transient UpdateData fUpdateData;
    private transient AppendToData fAppendToData;
    private transient DeleteDataForJobAndTasks fDeleteDataForJobAndTasks;
    private transient DeleteDataForTask fDeleteDataForTask;
    private transient DeleteData fDeleteData;
    private transient InsertTask fInsertTask;
    private transient UpdateTask fUpdateTask;
    private transient DeleteTask fDeleteTask;
    private transient DeleteTasksByJobId fDeleteTasksByJobId;
    private transient InsertJob fInsertJob;
    private transient UpdateJob fUpdateJob;
    private transient DeleteJob fDeleteJob;
    private transient Connection fConn;
    private transient DatabaseConnectionPool fDatabaseConnectionPool;
    private final transient Cache<Uuid, WorkUnitImpl> fWorkUnitCache;
    private transient WorkUnitInitializer fWorkUnitInitializer;

    public H2DatabaseStorage(Cache<Uuid, WorkUnitImpl> cache, DatabaseConnectionPool databaseConnectionPool) throws StorageInitException {
        this.fWorkUnitCache = cache;
        this.fDatabaseConnectionPool = databaseConnectionPool;
        this.fConn = databaseConnectionPool.openConnectionToDatabase();
        assert (this.fConn != null) : "Exceeded maximum number of connections to the database";
        this.initializeStatements();
    }

    @Override
    public void setWorkUnitInitializer(WorkUnitInitializer workUnitInitializer) {
        this.fWorkUnitInitializer = workUnitInitializer;
    }

    private void initializeStatements() {
        this.fSelectTaskById = new SelectTaskById();
        this.fSelectTasksByState = new SelectTasksByState();
        this.fSelectTasksByJobId = new SelectTasksByJobId();
        this.fSelectTasksByJobIdAndState = new SelectTasksByJobIdAndState();
        this.fSelectTasksByJobIdAndArrayOfStates = new SelectTasksByJobIdAndArrayOfStates();
        this.fSelectNumberOfTasksByJobIdAndState = new SelectNumberOfTasksByJobIdAndState();
        this.fSelectTasksByJobIdAndBeforeState = new SelectTasksByJobIdAndBeforeState();
        this.fSelectJobById = new SelectJobById();
        this.fSelectJobsByState = new SelectJobsByState();
        this.fSelectJobsByJobStateWithTasksInState = new SelectJobsByJobStateWithTasksInState();
        this.fSelectJobsAndTypesByState = new SelectJobsAndTypesByState();
        this.fSelectJobsAndTypesByArrayOfStates = new SelectJobsAndTypesByArrayOfStates();
        this.fSelectJobsAndTypes = new SelectJobsAndTypes();
        this.fSelectFirstJobByState = new SelectFirstJobByState();
        this.fSelectDataById = new SelectDataById();
        this.fSelectPreviousQueuedJob = new SelectPreviousQueuedJob();
        this.fSelectNextQueuedJob = new SelectNextQueuedJob();
        this.fCountTasksByJobId = new CountTasksByJobId();
        this.fCountTasksByJobIdAndState = new CountTasksByJobIdAndState();
        this.fCountTasksByJobIdAndBeforeState = new CountTasksByJobIdAndBeforeState();
        this.fNextSeqNum = new NextSeqNum();
        this.fNextJobSeqNum = new NextJobSeqNum();
        this.fInsertData = new InsertData();
        this.fInsertTask = new InsertTask();
        this.fInsertJob = new InsertJob();
        this.fCopyData = new CopyData();
        this.fUpdateData = new UpdateData();
        this.fUpdateTask = new UpdateTask();
        this.fUpdateJob = new UpdateJob();
        this.fAppendToData = new AppendToData();
        this.fDeleteData = new DeleteData();
        this.fDeleteDataForJobAndTasks = new DeleteDataForJobAndTasks();
        this.fDeleteDataForTask = new DeleteDataForTask();
        this.fDeleteTask = new DeleteTask();
        this.fDeleteTasksByJobId = new DeleteTasksByJobId();
        this.fDeleteJob = new DeleteJob();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws StorageException {
        this.fWorkUnitCache.lock();
        try {
            this.fWorkUnitCache.clear();
        }
        finally {
            this.fWorkUnitCache.unlock();
        }
        this.fDatabaseConnectionPool.closeConnection(this.fConn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getCacheSize() {
        this.fWorkUnitCache.lock();
        try {
            int n = this.fWorkUnitCache.size();
            return n;
        }
        finally {
            this.fWorkUnitCache.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Uuid putJob(JobImpl jobImpl) {
        if (jobImpl == null) {
            return null;
        }
        Uuid uuid = jobImpl.getID();
        this.fWorkUnitCache.lock();
        try {
            try {
                this.fWorkUnitInitializer.initializeJob(jobImpl);
                this.fInsertJob.execute(jobImpl);
                WorkUnitImpl workUnitImpl = this.fWorkUnitCache.put(uuid, jobImpl);
                assert (workUnitImpl == null) : "Reuse of a jobID Uuid in putJob.";
            }
            catch (SQLException sQLException) {
                new ErrorPrinterImpl().printError("Unable to write a Job object to the job manager database", sQLException);
            }
        }
        finally {
            this.fWorkUnitCache.unlock();
        }
        return uuid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Uuid putTask(TaskImpl taskImpl) {
        if (taskImpl == null) {
            return null;
        }
        Uuid uuid = taskImpl.getID();
        this.fWorkUnitCache.lock();
        try {
            try {
                this.fWorkUnitInitializer.initializeTask(taskImpl);
                this.fInsertTask.execute(taskImpl);
                WorkUnitImpl workUnitImpl = this.fWorkUnitCache.put(uuid, taskImpl);
                assert (workUnitImpl == null) : "Reuse of a taskID Uuid in putTask.";
            }
            catch (SQLException sQLException) {
                new ErrorPrinterImpl().printError("Unable to write a Task object to the job manager database", sQLException);
            }
        }
        finally {
            this.fWorkUnitCache.unlock();
        }
        return uuid;
    }

    @Override
    public void putJobData(Uuid uuid, Uuid uuid2, InputStream inputStream, int n) throws DataStorageException {
        if (uuid == null || uuid2 == null) {
            return;
        }
        try {
            this.fInsertData.execute(uuid, uuid2, inputStream, n);
        }
        catch (SQLException sQLException) {
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "Failed to write job data to the H2 database", sQLException);
            throw new DataStorageException("Unable to write data to the job manager database", sQLException.getCause());
        }
    }

    @Override
    public void putTaskData(Uuid uuid, Uuid uuid2, Uuid uuid3, InputStream inputStream, int n) throws DataStorageException {
        if (uuid == null || uuid2 == null || uuid3 == null) {
            return;
        }
        try {
            this.fInsertData.execute(uuid, uuid2, uuid3, inputStream, n);
        }
        catch (SQLException sQLException) {
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "Failed to write task data to the H2 database", sQLException);
            throw new DataStorageException("Unable to write data to the job manager database", sQLException.getCause());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WorkUnitImpl readWorkUnit(Uuid uuid) throws WorkUnitNotFoundException {
        if (uuid == null) {
            throw new WorkUnitNotFoundException("WorkUnit ID was null");
        }
        this.fWorkUnitCache.lock();
        try {
            WorkUnitImpl workUnitImpl = this.fWorkUnitCache.get(uuid);
            if (workUnitImpl != null) {
                WorkUnitImpl workUnitImpl2 = workUnitImpl;
                return workUnitImpl2;
            }
            try {
                workUnitImpl = this.readTask(uuid);
            }
            catch (TaskNotFoundException taskNotFoundException) {
                try {
                    workUnitImpl = this.readJob(uuid);
                }
                catch (JobNotFoundException jobNotFoundException) {
                    throw new WorkUnitNotFoundException("WorkUnit not retrieved successfully from the job manager database");
                }
            }
            WorkUnitImpl workUnitImpl3 = this.fWorkUnitCache.put(uuid, workUnitImpl);
            assert (workUnitImpl3 == null) : "Unexpected not-null object found in cache in readWorkUnit.";
            WorkUnitImpl workUnitImpl4 = workUnitImpl;
            return workUnitImpl4;
        }
        finally {
            this.fWorkUnitCache.unlock();
        }
    }

    private JobImpl readJob(Uuid uuid) throws JobNotFoundException {
        JobImpl jobImpl;
        try {
            jobImpl = this.fSelectJobById.execute(uuid);
            if (jobImpl == null) {
                throw new JobNotFoundException();
            }
        }
        catch (SQLException sQLException) {
            new ErrorPrinterImpl().printError("Job not retrieved successfully from the job manager database", sQLException);
            throw new JobNotFoundException();
        }
        this.fWorkUnitInitializer.initializeJob(jobImpl);
        return jobImpl;
    }

    private TaskImpl readTask(Uuid uuid) throws TaskNotFoundException {
        TaskImpl taskImpl;
        try {
            taskImpl = this.fSelectTaskById.execute(uuid);
            if (taskImpl == null) {
                throw new TaskNotFoundException();
            }
        }
        catch (SQLException sQLException) {
            new ErrorPrinterImpl().printError("Task not retrieved successfully from the job manager database", sQLException);
            throw new TaskNotFoundException();
        }
        this.fWorkUnitInitializer.initializeTask(taskImpl);
        return taskImpl;
    }

    @Override
    public byte[] readData(Uuid uuid) throws DataStorageException {
        byte[] byArray;
        assert (uuid != null) : "cannot read null data";
        try {
            byArray = this.fSelectDataById.execute(uuid);
        }
        catch (SQLException sQLException) {
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "Failed to read data from H2 database", sQLException);
            throw new DataStorageException("Unable to read data from the job manager database", sQLException.getCause());
        }
        return byArray;
    }

    @Override
    public int readData(Uuid uuid, OutputStream outputStream, int n) throws DataStorageException {
        int n2;
        assert (uuid != null) : "cannot read null data";
        try {
            n2 = this.fSelectDataById.execute(uuid, outputStream, n);
        }
        catch (SQLException sQLException) {
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "Failed to read data from H2 database", sQLException);
            throw new DataStorageException("Error reading data from database", sQLException.getCause());
        }
        catch (IOException iOException) {
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "Failed to read data from H2 database", iOException);
            throw new DataStorageException("Error reading data from database", iOException);
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateWorkUnit(WorkUnitImpl workUnitImpl) {
        this.fWorkUnitCache.lock();
        try {
            int n = 0;
            if (workUnitImpl instanceof JobImpl) {
                n = this.updateJob((JobImpl)workUnitImpl);
            } else if (workUnitImpl instanceof TaskImpl) {
                n = this.updateTask((TaskImpl)workUnitImpl);
            }
            if (n > 0) {
                this.fWorkUnitCache.put(workUnitImpl.getID(), workUnitImpl);
            }
        }
        finally {
            this.fWorkUnitCache.unlock();
        }
    }

    private int updateJob(JobImpl jobImpl) {
        try {
            return this.fUpdateJob.execute(jobImpl);
        }
        catch (SQLException sQLException) {
            new ErrorPrinterImpl().printError("Job could not be updated in the job manager database", sQLException);
            return 0;
        }
    }

    private int updateTask(TaskImpl taskImpl) {
        try {
            return this.fUpdateTask.execute(taskImpl);
        }
        catch (SQLException sQLException) {
            new ErrorPrinterImpl().printError("Task could not be updated in the job manager database", sQLException);
            return 0;
        }
    }

    @Override
    public void updateData(Uuid uuid, InputStream inputStream, int n) throws DataStorageException {
        if (uuid == null) {
            return;
        }
        try {
            this.fUpdateData.execute(uuid, inputStream, n);
        }
        catch (SQLException sQLException) {
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "Failed to update data in the H2 database", sQLException);
            throw new DataStorageException("Unable to update data in the job manager database", sQLException.getCause());
        }
    }

    @Override
    public void appendToData(Uuid uuid, InputStream inputStream, int n) throws DataStorageException {
        if (uuid == null) {
            return;
        }
        try {
            this.fAppendToData.execute(uuid, inputStream, n);
        }
        catch (SQLException sQLException) {
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "Failed to append to data in the H2 database", sQLException);
            throw new DataStorageException("Unable to append to data in the job manager database", sQLException.getCause());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeJob(Uuid uuid) {
        if (uuid == null) {
            return;
        }
        try {
            this.fWorkUnitCache.lock();
            try {
                Uuid[] uuidArray = this.fSelectTasksByJobId.execute(uuid);
                this.fDeleteTasksByJobId.execute(uuid);
                this.fDeleteJob.execute(uuid);
                for (Uuid uuid2 : uuidArray) {
                    this.fWorkUnitCache.remove(uuid2);
                }
                this.fWorkUnitCache.remove(uuid);
            }
            finally {
                this.fWorkUnitCache.unlock();
            }
        }
        catch (SQLException sQLException) {
            new ErrorPrinterImpl().printError("Job not removed from the job manager database", sQLException);
        }
    }

    @Override
    public void removeDataForJobAndTasks(Uuid uuid) throws DataStorageException {
        if (uuid == null) {
            return;
        }
        try {
            this.fDeleteDataForJobAndTasks.execute(uuid);
        }
        catch (SQLException sQLException) {
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "Failed to delete data for job in the H2 database", sQLException);
            throw new DataStorageException("Failed to delete data for job", sQLException.getCause());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTask(Uuid uuid) {
        if (uuid == null) {
            return;
        }
        try {
            this.fWorkUnitCache.lock();
            try {
                this.fDeleteTask.execute(uuid);
                this.fWorkUnitCache.remove(uuid);
            }
            finally {
                this.fWorkUnitCache.unlock();
            }
            this.fDeleteDataForTask.execute(uuid);
        }
        catch (SQLException sQLException) {
            new ErrorPrinterImpl().printError("Task not removed from the job manager database", sQLException);
        }
    }

    @Override
    public void removeData(Uuid uuid) throws DataStorageException {
        assert (uuid != null) : "cannot remove null data";
        try {
            this.fDeleteData.execute(uuid);
        }
        catch (SQLException sQLException) {
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "Failed to remove data from the H2 database", sQLException);
            throw new DataStorageException("Failed to remove data for work unit from the job manager database", sQLException.getCause());
        }
    }

    @Override
    public Uuid copyData(Uuid uuid) throws DataStorageException {
        assert (uuid != null) : "cannot copy null data";
        try {
            Uuid uuid2 = UuidFactory.generate();
            this.fCopyData.execute(uuid, uuid2);
            return uuid2;
        }
        catch (SQLException sQLException) {
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "Failed to copy data in the H2 database", sQLException);
            throw new DataStorageException("Unable to copy data", sQLException.getCause());
        }
    }

    @Override
    public Uuid[] readTasksByState(int n) {
        Uuid[] uuidArray = new Uuid[]{};
        try {
            uuidArray = this.fSelectTasksByState.execute(n);
        }
        catch (SQLException sQLException) {
            new ErrorPrinterImpl().printError("Unable to a read Task IDs from the job manager database", sQLException);
        }
        return uuidArray;
    }

    @Override
    public Uuid[] readTasksByJobID(Uuid uuid) {
        Uuid[] uuidArray = new Uuid[]{};
        if (uuid == null) {
            return uuidArray;
        }
        try {
            uuidArray = this.fSelectTasksByJobId.execute(uuid);
        }
        catch (SQLException sQLException) {
            new ErrorPrinterImpl().printError("Unable to a read Task IDs from the job manager database", sQLException);
        }
        return uuidArray;
    }

    @Override
    public Uuid[][] readTasksByJobIDAndState(Uuid uuid, int[] nArray) {
        Uuid[][] uuidArray = new Uuid[nArray.length][0];
        if (uuid == null) {
            return uuidArray;
        }
        try {
            if (nArray.length == 1) {
                uuidArray[0] = this.fSelectTasksByJobIdAndState.execute(uuid, nArray[0]);
            } else {
                uuidArray = this.fSelectTasksByJobIdAndArrayOfStates.execute(uuid, nArray);
            }
        }
        catch (SQLException sQLException) {
            new ErrorPrinterImpl().printError("Unable to a read Task IDs from the job manager database", sQLException);
        }
        return uuidArray;
    }

    @Override
    public Uuid[] readTasksByJobIDAndState(Uuid uuid, int n, int n2) {
        Uuid[] uuidArray = new Uuid[]{};
        if (uuid == null || n2 < 1) {
            return uuidArray;
        }
        try {
            uuidArray = this.fSelectNumberOfTasksByJobIdAndState.execute(uuid, n, n2);
        }
        catch (SQLException sQLException) {
            new ErrorPrinterImpl().printError("Unable to a read a Task ID from the job manager database", sQLException);
        }
        return uuidArray;
    }

    @Override
    public Uuid[] readTasksByJobIDAndBeforeState(Uuid uuid, int n) {
        Uuid[] uuidArray = new Uuid[]{};
        if (uuid == null) {
            return uuidArray;
        }
        try {
            uuidArray = this.fSelectTasksByJobIdAndBeforeState.execute(uuid, n);
        }
        catch (SQLException sQLException) {
            new ErrorPrinterImpl().printError("Unable to a read Task IDs from the job manager database", sQLException);
        }
        return uuidArray;
    }

    @Override
    public int countTasksByJobID(Uuid uuid) {
        int n = 0;
        try {
            n = this.fCountTasksByJobId.execute(uuid);
        }
        catch (SQLException sQLException) {
            new ErrorPrinterImpl().printError("Unable to count the Tasks in the job manager database", sQLException);
        }
        return n;
    }

    @Override
    public int countTasksByJobIDAndState(Uuid uuid, int n) {
        int n2 = 0;
        try {
            n2 = this.fCountTasksByJobIdAndState.execute(uuid, n);
        }
        catch (SQLException sQLException) {
            new ErrorPrinterImpl().printError("Unable to count the Tasks in the job manager database", sQLException);
        }
        return n2;
    }

    @Override
    public int countTasksByJobIDAndBeforeState(Uuid uuid, int n) {
        int n2 = 0;
        try {
            n2 = this.fCountTasksByJobIdAndBeforeState.execute(uuid, n);
        }
        catch (SQLException sQLException) {
            new ErrorPrinterImpl().printError("Unable to count the Tasks in the job manager database", sQLException);
        }
        return n2;
    }

    @Override
    public Uuid[] readJobsByState(int n) {
        Uuid[] uuidArray = new Uuid[]{};
        try {
            uuidArray = this.fSelectJobsByState.execute(n);
        }
        catch (SQLException sQLException) {
            new ErrorPrinterImpl().printError("Unable to read Job IDs from the job manager database", sQLException);
        }
        return uuidArray;
    }

    @Override
    public Uuid[] readJobsByJobStateWithTasksInState(int n, int n2) {
        Uuid[] uuidArray = new Uuid[]{};
        try {
            uuidArray = this.fSelectJobsByJobStateWithTasksInState.execute(n, n2);
        }
        catch (SQLException sQLException) {
            new ErrorPrinterImpl().printError("Unable to read Job IDs from the job manager database", sQLException);
        }
        return uuidArray;
    }

    @Override
    public JobIDAndMLType[] readJobsAndTypes() {
        JobIDAndMLType[] jobIDAndMLTypeArray = new JobIDAndMLType[]{};
        try {
            jobIDAndMLTypeArray = this.fSelectJobsAndTypes.execute();
        }
        catch (SQLException sQLException) {
            new ErrorPrinterImpl().printError("Unable to read Job IDs and Types from the job manager database", sQLException);
        }
        return jobIDAndMLTypeArray;
    }

    @Override
    public JobIDAndMLType[][] readJobsAndTypesByState(int[] nArray) {
        JobIDAndMLType[][] jobIDAndMLTypeArray = new JobIDAndMLType[nArray.length][0];
        try {
            if (nArray.length == 1) {
                jobIDAndMLTypeArray[0] = this.fSelectJobsAndTypesByState.execute(nArray[0]);
            } else {
                jobIDAndMLTypeArray = this.fSelectJobsAndTypesByArrayOfStates.execute(nArray);
            }
        }
        catch (SQLException sQLException) {
            new ErrorPrinterImpl().printError("Unable to read Job IDs and Types from the job manager database", sQLException);
        }
        return jobIDAndMLTypeArray;
    }

    @Override
    public Uuid readFirstJobByState(int n) {
        Uuid uuid = null;
        try {
            uuid = this.fSelectFirstJobByState.execute(n);
        }
        catch (SQLException sQLException) {
            new ErrorPrinterImpl().printError("Unable to read a Job ID from the job manager database", sQLException);
        }
        return uuid;
    }

    @Override
    public Uuid readPreviousQueuedJob(long l) {
        Uuid uuid = null;
        try {
            uuid = this.fSelectPreviousQueuedJob.execute(l);
        }
        catch (SQLException sQLException) {
            new ErrorPrinterImpl().printError("Unable to read a Job ID from the job manager database", sQLException);
        }
        return uuid;
    }

    @Override
    public Uuid readNextQueuedJob(long l) {
        Uuid uuid = null;
        try {
            uuid = this.fSelectNextQueuedJob.execute(l);
        }
        catch (SQLException sQLException) {
            new ErrorPrinterImpl().printError("Unable to read a Job ID from the job manager database", sQLException);
        }
        return uuid;
    }

    @Override
    public long nextJobQueueNum() {
        long l = -1L;
        try {
            l = this.fNextSeqNum.execute();
        }
        catch (SQLException sQLException) {
            new ErrorPrinterImpl().printError("Unable to obtain a new sequence number from the database", sQLException);
        }
        return l;
    }

    @Override
    public long nextJobNum() {
        long l = -1L;
        try {
            l = this.fNextJobSeqNum.execute();
        }
        catch (SQLException sQLException) {
            new ErrorPrinterImpl().printError("Unable to obtain a unique job number from the database", sQLException);
        }
        return l;
    }

    class NextJobSeqNum
    extends CachedPreparedStatement {
        private static final String SQL_STRING = "SELECT NEXTVAL('job_seq_key')";

        public NextJobSeqNum() {
            super(SQL_STRING);
        }

        public long execute() throws SQLException {
            PreparedStatement preparedStatement = this.getStatement(H2DatabaseStorage.this.fConn);
            ResultSet resultSet = preparedStatement.executeQuery();
            resultSet.next();
            long l = resultSet.getLong(1);
            resultSet.close();
            this.releaseStatement(preparedStatement);
            return l;
        }
    }

    class NextSeqNum
    extends CachedPreparedStatement {
        private static final String SQL_STRING = "SELECT NEXTVAL('seq_key')";

        public NextSeqNum() {
            super(SQL_STRING);
        }

        public long execute() throws SQLException {
            PreparedStatement preparedStatement = this.getStatement(H2DatabaseStorage.this.fConn);
            ResultSet resultSet = preparedStatement.executeQuery();
            resultSet.next();
            long l = resultSet.getLong(1);
            resultSet.close();
            this.releaseStatement(preparedStatement);
            return l;
        }
    }

    class DeleteTasksByJobId
    extends CachedPreparedStatement {
        private static final String SQL_STRING = "DELETE FROM task_table WHERE jobid = ?";

        public DeleteTasksByJobId() {
            super(SQL_STRING);
        }

        public int execute(Uuid uuid) throws SQLException {
            PreparedStatement preparedStatement = this.getStatement(H2DatabaseStorage.this.fConn);
            preparedStatement.setString(1, uuid.toString());
            int n = preparedStatement.executeUpdate();
            this.releaseStatement(preparedStatement);
            return n;
        }
    }

    class DeleteTask
    extends CachedPreparedStatement {
        private static final String SQL_STRING = "DELETE FROM task_table WHERE taskid = ?";

        public DeleteTask() {
            super(SQL_STRING);
        }

        public int execute(Uuid uuid) throws SQLException {
            PreparedStatement preparedStatement = this.getStatement(H2DatabaseStorage.this.fConn);
            preparedStatement.setString(1, uuid.toString());
            int n = preparedStatement.executeUpdate();
            this.releaseStatement(preparedStatement);
            return n;
        }
    }

    class DeleteJob
    extends CachedPreparedStatement {
        private static final String SQL_STRING = "DELETE FROM job_table WHERE jobid = ?";

        public DeleteJob() {
            super(SQL_STRING);
        }

        public int execute(Uuid uuid) throws SQLException {
            PreparedStatement preparedStatement = this.getStatement(H2DatabaseStorage.this.fConn);
            preparedStatement.setString(1, uuid.toString());
            int n = preparedStatement.executeUpdate();
            this.releaseStatement(preparedStatement);
            return n;
        }
    }

    class DeleteData
    extends CachedPreparedStatement {
        private static final String SQL_STRING = "DELETE FROM data_table WHERE dataid = ?";

        public DeleteData() {
            super(SQL_STRING);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int execute(Uuid uuid) throws SQLException {
            int n;
            PreparedStatement preparedStatement = this.getStatement(H2DatabaseStorage.this.fConn);
            preparedStatement.setString(1, uuid.toString());
            H2DatabaseStorage.this.fDataTableWriteLock.acquireUninterruptibly();
            try {
                n = preparedStatement.executeUpdate();
            }
            finally {
                H2DatabaseStorage.this.fDataTableWriteLock.release();
            }
            this.releaseStatement(preparedStatement);
            return n;
        }
    }

    class DeleteDataForTask
    extends CachedPreparedStatement {
        private static final String SQL_STRING = "DELETE FROM data_table WHERE taskid = ?";

        public DeleteDataForTask() {
            super(SQL_STRING);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int execute(Uuid uuid) throws SQLException {
            int n;
            PreparedStatement preparedStatement = this.getStatement(H2DatabaseStorage.this.fConn);
            preparedStatement.setString(1, uuid.toString());
            H2DatabaseStorage.this.fDataTableWriteLock.acquireUninterruptibly();
            try {
                n = preparedStatement.executeUpdate();
            }
            finally {
                H2DatabaseStorage.this.fDataTableWriteLock.release();
            }
            this.releaseStatement(preparedStatement);
            return n;
        }
    }

    class DeleteDataForJobAndTasks
    extends CachedPreparedStatement {
        private static final String SQL_STRING = "DELETE FROM data_table WHERE jobid = ?";

        public DeleteDataForJobAndTasks() {
            super(SQL_STRING);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int execute(Uuid uuid) throws SQLException {
            int n;
            PreparedStatement preparedStatement = this.getStatement(H2DatabaseStorage.this.fConn);
            preparedStatement.setString(1, uuid.toString());
            H2DatabaseStorage.this.fDataTableWriteLock.acquireUninterruptibly();
            try {
                n = preparedStatement.executeUpdate();
            }
            finally {
                H2DatabaseStorage.this.fDataTableWriteLock.release();
            }
            this.releaseStatement(preparedStatement);
            return n;
        }
    }

    class AppendToData
    extends CachedPreparedStatement {
        private static final String SQL_STRING = "UPDATE data_table SET data = data || ? WHERE dataid = ?";

        public AppendToData() {
            super(SQL_STRING);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int execute(Uuid uuid, InputStream inputStream, int n) throws SQLException {
            int n2;
            PreparedStatement preparedStatement = this.getStatement(H2DatabaseStorage.this.fConn);
            preparedStatement.setBinaryStream(1, inputStream, n);
            preparedStatement.setString(2, uuid.toString());
            H2DatabaseStorage.this.fDataTableWriteLock.acquireUninterruptibly();
            try {
                n2 = preparedStatement.executeUpdate();
            }
            finally {
                H2DatabaseStorage.this.fDataTableWriteLock.release();
            }
            this.releaseStatement(preparedStatement);
            return n2;
        }
    }

    class UpdateData
    extends CachedPreparedStatement {
        private static final String SQL_STRING = "UPDATE data_table SET data = ? WHERE dataid = ?";

        public UpdateData() {
            super(SQL_STRING);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int execute(Uuid uuid, byte[] byArray) throws SQLException {
            int n;
            PreparedStatement preparedStatement = this.getStatement(H2DatabaseStorage.this.fConn);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            preparedStatement.setBinaryStream(1, (InputStream)byteArrayInputStream, byArray.length);
            preparedStatement.setString(2, uuid.toString());
            H2DatabaseStorage.this.fDataTableWriteLock.acquireUninterruptibly();
            try {
                n = preparedStatement.executeUpdate();
            }
            finally {
                H2DatabaseStorage.this.fDataTableWriteLock.release();
            }
            this.releaseStatement(preparedStatement);
            return n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int execute(Uuid uuid, InputStream inputStream, int n) throws SQLException {
            int n2;
            PreparedStatement preparedStatement = this.getStatement(H2DatabaseStorage.this.fConn);
            preparedStatement.setBinaryStream(1, inputStream, n);
            preparedStatement.setString(2, uuid.toString());
            H2DatabaseStorage.this.fDataTableWriteLock.acquireUninterruptibly();
            try {
                n2 = preparedStatement.executeUpdate();
            }
            finally {
                H2DatabaseStorage.this.fDataTableWriteLock.release();
            }
            this.releaseStatement(preparedStatement);
            return n2;
        }
    }

    class UpdateJob
    extends CachedPreparedStatement {
        private static final String SQL_STRING = "UPDATE job_table SET job = ?, state = ?, queuenum = ? WHERE jobid = ?";

        public UpdateJob() {
            super(SQL_STRING);
        }

        public int execute(JobImpl jobImpl) throws SQLException {
            PreparedStatement preparedStatement = this.getStatement(H2DatabaseStorage.this.fConn);
            preparedStatement.setObject(1, jobImpl);
            preparedStatement.setInt(2, jobImpl.getState());
            preparedStatement.setLong(3, jobImpl.getQueueNum());
            preparedStatement.setString(4, jobImpl.getID().toString());
            int n = preparedStatement.executeUpdate();
            this.releaseStatement(preparedStatement);
            return n;
        }
    }

    class UpdateTask
    extends CachedPreparedStatement {
        private static final String SQL_STRING = "UPDATE task_table SET task = ?, state = ? WHERE taskid = ?";

        public UpdateTask() {
            super(SQL_STRING);
        }

        public int execute(TaskImpl taskImpl) throws SQLException {
            PreparedStatement preparedStatement = this.getStatement(H2DatabaseStorage.this.fConn);
            preparedStatement.setObject(1, taskImpl);
            preparedStatement.setInt(2, taskImpl.getState());
            preparedStatement.setString(3, taskImpl.getID().toString());
            int n = preparedStatement.executeUpdate();
            this.releaseStatement(preparedStatement);
            return n;
        }
    }

    class CopyData
    extends CachedPreparedStatement {
        private static final String SQL_STRING = "INSERT INTO data_table (seqnum, jobid, taskid, dataid, data) SELECT NEXTVAL('seq_key'), jobid, taskid, ?, data FROM data_table WHERE dataid = ? ORDER BY seqnum";

        public CopyData() {
            super(SQL_STRING);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(Uuid uuid, Uuid uuid2) throws SQLException {
            PreparedStatement preparedStatement = this.getStatement(H2DatabaseStorage.this.fConn);
            preparedStatement.setString(1, uuid2.toString());
            preparedStatement.setString(2, uuid.toString());
            H2DatabaseStorage.this.fDataTableWriteLock.acquireUninterruptibly();
            try {
                preparedStatement.executeUpdate();
            }
            finally {
                H2DatabaseStorage.this.fDataTableWriteLock.release();
            }
            this.releaseStatement(preparedStatement);
        }
    }

    class InsertData
    extends CachedPreparedStatement {
        private static final String SQL_STRING = "INSERT INTO data_table VALUES(NEXTVAL('seq_key'),?,?,?,?)";

        public InsertData() {
            super(SQL_STRING);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int execute(Uuid uuid, Uuid uuid2, InputStream inputStream, int n) throws SQLException {
            PreparedStatement preparedStatement = this.getStatement(H2DatabaseStorage.this.fConn);
            try {
                preparedStatement.setString(1, uuid.toString());
                preparedStatement.setNull(2, 0);
                preparedStatement.setString(3, uuid2.toString());
                preparedStatement.setBinaryStream(4, inputStream, n);
                int n2 = this.execute(preparedStatement);
                return n2;
            }
            finally {
                this.releaseStatement(preparedStatement);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int execute(Uuid uuid, Uuid uuid2, Uuid uuid3, InputStream inputStream, int n) throws SQLException {
            PreparedStatement preparedStatement = this.getStatement(H2DatabaseStorage.this.fConn);
            try {
                preparedStatement.setString(1, uuid.toString());
                preparedStatement.setString(2, uuid2.toString());
                preparedStatement.setString(3, uuid3.toString());
                preparedStatement.setBinaryStream(4, inputStream, n);
                int n2 = this.execute(preparedStatement);
                return n2;
            }
            finally {
                this.releaseStatement(preparedStatement);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int execute(PreparedStatement preparedStatement) throws SQLException {
            int n;
            H2DatabaseStorage.this.fDataTableWriteLock.acquireUninterruptibly();
            try {
                n = preparedStatement.executeUpdate();
            }
            finally {
                H2DatabaseStorage.this.fDataTableWriteLock.release();
            }
            return n;
        }
    }

    class InsertJob
    extends CachedPreparedStatement {
        private static final String SQL_STRING = "INSERT INTO job_table VALUES(NEXTVAL('seq_key'),?,?,?,?,?)";

        public InsertJob() {
            super(SQL_STRING);
        }

        public int execute(JobImpl jobImpl) throws SQLException {
            int n = jobImpl.getJobMLType();
            PreparedStatement preparedStatement = this.getStatement(H2DatabaseStorage.this.fConn);
            preparedStatement.setLong(1, jobImpl.getQueueNum());
            preparedStatement.setString(2, jobImpl.getID().toString());
            preparedStatement.setInt(3, jobImpl.getState());
            preparedStatement.setInt(4, n);
            preparedStatement.setObject(5, jobImpl);
            int n2 = preparedStatement.executeUpdate();
            this.releaseStatement(preparedStatement);
            return n2;
        }
    }

    class InsertTask
    extends CachedPreparedStatement {
        private static final String SQL_STRING = "INSERT INTO task_table VALUES(NEXTVAL('seq_key'),?,?,?,?)";

        public InsertTask() {
            super(SQL_STRING);
        }

        public int execute(TaskImpl taskImpl) throws SQLException {
            PreparedStatement preparedStatement = this.getStatement(H2DatabaseStorage.this.fConn);
            preparedStatement.setString(1, taskImpl.getJob().toString());
            preparedStatement.setInt(2, taskImpl.getState());
            preparedStatement.setString(3, taskImpl.getID().toString());
            preparedStatement.setObject(4, taskImpl);
            int n = preparedStatement.executeUpdate();
            this.releaseStatement(preparedStatement);
            return n;
        }
    }

    class CountTasksByJobIdAndBeforeState
    extends CachedPreparedStatement {
        private static final String SQL_STRING = "SELECT COUNT(*) FROM task_table WHERE jobid = ? AND state < ?";

        public CountTasksByJobIdAndBeforeState() {
            super(SQL_STRING);
        }

        public int execute(Uuid uuid, int n) throws SQLException {
            PreparedStatement preparedStatement = this.getStatement(H2DatabaseStorage.this.fConn);
            preparedStatement.setString(1, uuid.toString());
            preparedStatement.setInt(2, n);
            ResultSet resultSet = preparedStatement.executeQuery();
            int n2 = 0;
            if (resultSet.next()) {
                n2 = resultSet.getInt(1);
            }
            resultSet.close();
            this.releaseStatement(preparedStatement);
            return n2;
        }
    }

    class CountTasksByJobIdAndState
    extends CachedPreparedStatement {
        private static final String SQL_STRING = "SELECT COUNT(*) FROM task_table WHERE jobid = ? AND state = ?";

        public CountTasksByJobIdAndState() {
            super(SQL_STRING);
        }

        public int execute(Uuid uuid, int n) throws SQLException {
            PreparedStatement preparedStatement = this.getStatement(H2DatabaseStorage.this.fConn);
            preparedStatement.setString(1, uuid.toString());
            preparedStatement.setInt(2, n);
            ResultSet resultSet = preparedStatement.executeQuery();
            int n2 = 0;
            if (resultSet.next()) {
                n2 = resultSet.getInt(1);
            }
            resultSet.close();
            this.releaseStatement(preparedStatement);
            return n2;
        }
    }

    class CountTasksByJobId
    extends CachedPreparedStatement {
        private static final String SQL_STRING = "SELECT COUNT(*) FROM task_table WHERE jobid = ?";

        public CountTasksByJobId() {
            super(SQL_STRING);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int execute(Uuid uuid) throws SQLException {
            PreparedStatement preparedStatement = this.getStatement(H2DatabaseStorage.this.fConn);
            preparedStatement.setString(1, uuid.toString());
            ResultSet resultSet = null;
            try {
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    int n = resultSet.getInt(1);
                    return n;
                }
                int n = 0;
                return n;
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
                this.releaseStatement(preparedStatement);
            }
        }
    }

    class SelectDataById
    extends CachedPreparedStatement {
        private static final String SQL_STRING = "SELECT data FROM data_table WHERE dataid = ? ORDER BY seqnum";

        public SelectDataById() {
            super(SQL_STRING);
        }

        public byte[] execute(Uuid uuid) throws SQLException, DataNotFoundException {
            PreparedStatement preparedStatement = this.getStatement(H2DatabaseStorage.this.fConn);
            preparedStatement.setString(1, uuid.toString());
            ResultSet resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) {
                throw new DataNotFoundException("Data not found in database");
            }
            Blob blob = resultSet.getBlob(1);
            byte[] byArray = blob.getBytes(1L, (int)blob.length());
            resultSet.close();
            this.releaseStatement(preparedStatement);
            return byArray;
        }

        public int execute(Uuid uuid, OutputStream outputStream, int n) throws SQLException, IOException, DataNotFoundException {
            PreparedStatement preparedStatement = this.getStatement(H2DatabaseStorage.this.fConn);
            preparedStatement.setString(1, uuid.toString());
            ResultSet resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) {
                throw new DataNotFoundException("Data not found in database");
            }
            InputStream inputStream = resultSet.getBinaryStream(1);
            int n2 = (int)BufferedStreamCopier.copyStreams(inputStream, outputStream, n);
            resultSet.close();
            this.releaseStatement(preparedStatement);
            return n2;
        }
    }

    class SelectJobsAndTypes
    extends CachedPreparedStatement {
        private static final String SQL_STRING = "SELECT jobid, type FROM job_table ORDER BY seqnum";

        public SelectJobsAndTypes() {
            super(SQL_STRING);
        }

        public JobIDAndMLType[] execute() throws SQLException {
            PreparedStatement preparedStatement = this.getStatement(H2DatabaseStorage.this.fConn);
            ResultSet resultSet = preparedStatement.executeQuery();
            Vector<JobIDAndMLType> vector = new Vector<JobIDAndMLType>();
            while (resultSet.next()) {
                vector.add(new JobIDAndMLType(UuidFactory.create((String)resultSet.getString(1)), resultSet.getInt(2)));
            }
            resultSet.close();
            this.releaseStatement(preparedStatement);
            return vector.toArray(new JobIDAndMLType[vector.size()]);
        }
    }

    class SelectNextQueuedJob
    extends CachedPreparedStatement {
        private static final String SQL_STRING = "SELECT jobid FROM job_table WHERE state = ? AND queuenum > ? ORDER BY queuenum, seqnum";

        public SelectNextQueuedJob() {
            super(SQL_STRING);
        }

        public Uuid execute(long l) throws SQLException {
            int n = 1;
            PreparedStatement preparedStatement = this.getStatement(H2DatabaseStorage.this.fConn);
            preparedStatement.setInt(1, n);
            preparedStatement.setLong(2, l);
            ResultSet resultSet = preparedStatement.executeQuery();
            Uuid uuid = null;
            if (resultSet.next()) {
                uuid = UuidFactory.create((String)resultSet.getString(1));
            }
            resultSet.close();
            this.releaseStatement(preparedStatement);
            return uuid;
        }
    }

    class SelectPreviousQueuedJob
    extends CachedPreparedStatement {
        private static final String SQL_STRING = "SELECT jobid FROM job_table WHERE state = ? AND queuenum < ? ORDER BY queuenum, seqnum";

        public SelectPreviousQueuedJob() {
            super(SQL_STRING);
        }

        public Uuid execute(long l) throws SQLException {
            int n = 1;
            PreparedStatement preparedStatement = this.getStatement(H2DatabaseStorage.this.fConn);
            preparedStatement.setInt(1, n);
            preparedStatement.setLong(2, l);
            ResultSet resultSet = preparedStatement.executeQuery();
            Uuid uuid = null;
            while (resultSet.next()) {
                uuid = UuidFactory.create((String)resultSet.getString(1));
            }
            resultSet.close();
            this.releaseStatement(preparedStatement);
            return uuid;
        }
    }

    class SelectJobsAndTypesByArrayOfStates
    extends CachedPreparedStatement {
        private static final String SQL_STRING = "SELECT jobid, type, state FROM job_table ORDER BY state, queuenum, seqnum";

        public SelectJobsAndTypesByArrayOfStates() {
            super(SQL_STRING);
        }

        public JobIDAndMLType[][] execute(int[] nArray) throws SQLException {
            int n;
            PreparedStatement preparedStatement = this.getStatement(H2DatabaseStorage.this.fConn);
            ResultSet resultSet = preparedStatement.executeQuery();
            HashMap<Integer, Vector<JobIDAndMLType>> hashMap = new HashMap<Integer, Vector<JobIDAndMLType>>();
            for (n = 0; n < nArray.length; ++n) {
                hashMap.put(nArray[n], new Vector());
            }
            int[] nArray2 = new int[nArray.length];
            System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
            Arrays.sort(nArray2);
            while (resultSet.next()) {
                n = resultSet.getInt(3);
                if (Arrays.binarySearch(nArray2, n) < 0) continue;
                Vector<JobIDAndMLType> vector = hashMap.get(n);
                vector.add(new JobIDAndMLType(UuidFactory.create((String)resultSet.getString(1)), resultSet.getInt(2)));
            }
            resultSet.close();
            this.releaseStatement(preparedStatement);
            return this.createJobAndTypesArray(nArray, hashMap);
        }

        private JobIDAndMLType[][] createJobAndTypesArray(int[] nArray, HashMap<Integer, Vector<JobIDAndMLType>> hashMap) {
            JobIDAndMLType[][] jobIDAndMLTypeArray = new JobIDAndMLType[nArray.length][];
            for (int i = 0; i < nArray.length; ++i) {
                Vector<JobIDAndMLType> vector = hashMap.get(nArray[i]);
                jobIDAndMLTypeArray[i] = vector != null ? vector.toArray(new JobIDAndMLType[vector.size()]) : new JobIDAndMLType[0];
            }
            return jobIDAndMLTypeArray;
        }
    }

    class SelectJobsAndTypesByState
    extends CachedPreparedStatement {
        private static final String SQL_STRING = "SELECT jobid, type FROM job_table WHERE state = ? ORDER BY seqnum";

        public SelectJobsAndTypesByState() {
            super(SQL_STRING);
        }

        public JobIDAndMLType[] execute(int n) throws SQLException {
            PreparedStatement preparedStatement = this.getStatement(H2DatabaseStorage.this.fConn);
            preparedStatement.setInt(1, n);
            ResultSet resultSet = preparedStatement.executeQuery();
            Vector<JobIDAndMLType> vector = new Vector<JobIDAndMLType>();
            while (resultSet.next()) {
                vector.add(new JobIDAndMLType(UuidFactory.create((String)resultSet.getString(1)), resultSet.getInt(2)));
            }
            resultSet.close();
            this.releaseStatement(preparedStatement);
            return vector.toArray(new JobIDAndMLType[vector.size()]);
        }
    }

    class SelectJobsByJobStateWithTasksInState
    extends CachedPreparedStatement {
        private static final String SQL_STRING = "SELECT task_table.jobid  FROM task_table INNER JOIN job_table ON task_table.jobid = job_table.jobid WHERE job_table.state = ? AND task_table.state = ? ORDER BY task_table.seqnum";

        public SelectJobsByJobStateWithTasksInState() {
            super(SQL_STRING);
        }

        public Uuid[] execute(int n, int n2) throws SQLException {
            PreparedStatement preparedStatement = this.getStatement(H2DatabaseStorage.this.fConn);
            preparedStatement.setInt(1, n);
            preparedStatement.setInt(2, n2);
            ResultSet resultSet = preparedStatement.executeQuery();
            Vector<Uuid> vector = new Vector<Uuid>();
            while (resultSet.next()) {
                vector.add(UuidFactory.create((String)resultSet.getString(1)));
            }
            resultSet.close();
            this.releaseStatement(preparedStatement);
            return vector.toArray(new Uuid[vector.size()]);
        }
    }

    class SelectJobsByState
    extends CachedPreparedStatement {
        private static final String SQL_STRING = "SELECT jobid FROM job_table WHERE state = ? ORDER BY seqnum";

        public SelectJobsByState() {
            super(SQL_STRING);
        }

        public Uuid[] execute(int n) throws SQLException {
            PreparedStatement preparedStatement = this.getStatement(H2DatabaseStorage.this.fConn);
            preparedStatement.setInt(1, n);
            ResultSet resultSet = preparedStatement.executeQuery();
            Vector<Uuid> vector = new Vector<Uuid>();
            while (resultSet.next()) {
                vector.add(UuidFactory.create((String)resultSet.getString(1)));
            }
            resultSet.close();
            this.releaseStatement(preparedStatement);
            return vector.toArray(new Uuid[vector.size()]);
        }
    }

    class SelectJobById
    extends CachedPreparedStatement {
        private static final String SQL_STRING = "SELECT job FROM job_table WHERE jobid = ? ORDER BY seqnum";

        public SelectJobById() {
            super(SQL_STRING);
        }

        public JobImpl execute(Uuid uuid) throws SQLException {
            PreparedStatement preparedStatement = this.getStatement(H2DatabaseStorage.this.fConn);
            preparedStatement.setString(1, uuid.toString());
            ResultSet resultSet = preparedStatement.executeQuery();
            JobImpl jobImpl = null;
            if (resultSet.next()) {
                jobImpl = (JobImpl)resultSet.getObject(1);
            }
            resultSet.close();
            this.releaseStatement(preparedStatement);
            return jobImpl;
        }
    }

    class SelectFirstJobByState
    extends CachedPreparedStatement {
        private static final String SQL_STRING = "SELECT jobid FROM job_table WHERE state = ? ORDER BY queuenum, seqnum";

        public SelectFirstJobByState() {
            super(SQL_STRING);
        }

        public Uuid execute(int n) throws SQLException {
            PreparedStatement preparedStatement = this.getStatement(H2DatabaseStorage.this.fConn);
            preparedStatement.setInt(1, n);
            ResultSet resultSet = preparedStatement.executeQuery();
            Uuid uuid = null;
            if (resultSet.next()) {
                uuid = UuidFactory.create((String)resultSet.getString(1));
            }
            resultSet.close();
            this.releaseStatement(preparedStatement);
            return uuid;
        }
    }

    class SelectTasksByJobIdAndBeforeState
    extends CachedPreparedStatement {
        private static final String SQL_STRING = "SELECT taskid FROM task_table WHERE jobid = ? AND state < ? ORDER BY seqnum";

        public SelectTasksByJobIdAndBeforeState() {
            super(SQL_STRING);
        }

        public Uuid[] execute(Uuid uuid, int n) throws SQLException {
            PreparedStatement preparedStatement = this.getStatement(H2DatabaseStorage.this.fConn);
            preparedStatement.setString(1, uuid.toString());
            preparedStatement.setInt(2, n);
            ResultSet resultSet = preparedStatement.executeQuery();
            Vector<Uuid> vector = new Vector<Uuid>();
            while (resultSet.next()) {
                vector.add(UuidFactory.create((String)resultSet.getString(1)));
            }
            resultSet.close();
            this.releaseStatement(preparedStatement);
            return vector.toArray(new Uuid[vector.size()]);
        }
    }

    class SelectNumberOfTasksByJobIdAndState
    extends CachedPreparedStatement {
        private static final String SQL_STRING = "SELECT taskid FROM task_table WHERE jobid = ? AND state = ? ORDER BY seqnum";

        public SelectNumberOfTasksByJobIdAndState() {
            super(SQL_STRING);
        }

        public Uuid[] execute(Uuid uuid, int n, int n2) throws SQLException {
            PreparedStatement preparedStatement = this.getStatement(H2DatabaseStorage.this.fConn);
            preparedStatement.setString(1, uuid.toString());
            preparedStatement.setInt(2, n);
            ResultSet resultSet = preparedStatement.executeQuery();
            Vector<Uuid> vector = new Vector<Uuid>();
            while (resultSet.next() && vector.size() < n2) {
                vector.add(UuidFactory.create((String)resultSet.getString(1)));
            }
            resultSet.close();
            this.releaseStatement(preparedStatement);
            return vector.toArray(new Uuid[vector.size()]);
        }
    }

    class SelectTasksByJobIdAndArrayOfStates
    extends CachedPreparedStatement {
        private static final String SQL_STRING = "SELECT taskid, state FROM task_table WHERE jobid = ? ORDER BY seqnum";

        public SelectTasksByJobIdAndArrayOfStates() {
            super(SQL_STRING);
        }

        public Uuid[][] execute(Uuid uuid, int[] nArray) throws SQLException {
            PreparedStatement preparedStatement = this.getStatement(H2DatabaseStorage.this.fConn);
            preparedStatement.setString(1, uuid.toString());
            ResultSet resultSet = preparedStatement.executeQuery();
            Arrays.sort(nArray);
            HashMap<Integer, Vector<Uuid>> hashMap = new HashMap<Integer, Vector<Uuid>>();
            for (int n : nArray) {
                hashMap.put(n, new Vector());
            }
            while (resultSet.next()) {
                int n = resultSet.getInt(2);
                if (Arrays.binarySearch(nArray, n) == -1) continue;
                Vector<Uuid> vector = hashMap.get(n);
                vector.add(UuidFactory.create((String)resultSet.getString(1)));
            }
            resultSet.close();
            this.releaseStatement(preparedStatement);
            return this.createArrayOfUuids(nArray, hashMap);
        }

        private Uuid[][] createArrayOfUuids(int[] nArray, HashMap<Integer, Vector<Uuid>> hashMap) {
            Uuid[][] uuidArrayArray = new Uuid[nArray.length][];
            for (int i = 0; i < nArray.length; ++i) {
                Vector<Uuid> vector = hashMap.get(nArray[i]);
                uuidArrayArray[i] = vector != null ? vector.toArray(new Uuid[vector.size()]) : new Uuid[0];
            }
            return uuidArrayArray;
        }
    }

    class SelectTasksByJobIdAndState
    extends CachedPreparedStatement {
        private static final String SQL_STRING = "SELECT taskid FROM task_table WHERE jobid = ? AND state = ? ORDER BY seqnum";

        public SelectTasksByJobIdAndState() {
            super(SQL_STRING);
        }

        public Uuid[] execute(Uuid uuid, int n) throws SQLException {
            PreparedStatement preparedStatement = this.getStatement(H2DatabaseStorage.this.fConn);
            preparedStatement.setString(1, uuid.toString());
            preparedStatement.setInt(2, n);
            ResultSet resultSet = preparedStatement.executeQuery();
            Vector<Uuid> vector = new Vector<Uuid>();
            while (resultSet.next()) {
                Uuid uuid2 = UuidFactory.create((String)resultSet.getString(1));
                vector.add(uuid2);
            }
            resultSet.close();
            this.releaseStatement(preparedStatement);
            return vector.toArray(new Uuid[vector.size()]);
        }
    }

    class SelectTasksByState
    extends CachedPreparedStatement {
        private static final String SQL_STRING = "SELECT taskid FROM task_table WHERE state = ? ORDER BY seqnum";

        public SelectTasksByState() {
            super(SQL_STRING);
        }

        public Uuid[] execute(int n) throws SQLException {
            PreparedStatement preparedStatement = this.getStatement(H2DatabaseStorage.this.fConn);
            preparedStatement.setInt(1, n);
            ResultSet resultSet = preparedStatement.executeQuery();
            Vector<Uuid> vector = new Vector<Uuid>();
            while (resultSet.next()) {
                Uuid uuid = UuidFactory.create((String)resultSet.getString(1));
                vector.add(uuid);
            }
            resultSet.close();
            this.releaseStatement(preparedStatement);
            return vector.toArray(new Uuid[vector.size()]);
        }
    }

    class SelectTasksByJobId
    extends CachedPreparedStatement {
        private static final String SQL_STRING = "SELECT taskid FROM task_table WHERE jobid = ? ORDER BY seqnum";

        public SelectTasksByJobId() {
            super(SQL_STRING);
        }

        public Uuid[] execute(Uuid uuid) throws SQLException {
            PreparedStatement preparedStatement = this.getStatement(H2DatabaseStorage.this.fConn);
            preparedStatement.setString(1, uuid.toString());
            ResultSet resultSet = preparedStatement.executeQuery();
            Vector<Uuid> vector = new Vector<Uuid>();
            while (resultSet.next()) {
                vector.add(UuidFactory.create((String)resultSet.getString(1)));
            }
            resultSet.close();
            this.releaseStatement(preparedStatement);
            return vector.toArray(new Uuid[vector.size()]);
        }
    }

    class SelectTaskById
    extends CachedPreparedStatement {
        private static final String SQL_STRING = "SELECT task FROM task_table WHERE taskid = ? ORDER BY seqnum";

        public SelectTaskById() {
            super(SQL_STRING);
        }

        public TaskImpl execute(Uuid uuid) throws SQLException {
            PreparedStatement preparedStatement = this.getStatement(H2DatabaseStorage.this.fConn);
            preparedStatement.setString(1, uuid.toString());
            ResultSet resultSet = preparedStatement.executeQuery();
            TaskImpl taskImpl = null;
            if (resultSet.next()) {
                taskImpl = (TaskImpl)resultSet.getObject(1);
            }
            resultSet.close();
            this.releaseStatement(preparedStatement);
            return taskImpl;
        }
    }
}

