/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.ui.desk;

import com.mathworks.desktop.attr.Attribute;
import com.mathworks.desktop.overlay.OverlayManager;
import com.mathworks.desktop.overlay.OverlayManagers;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJMenu;
import com.mathworks.mwswing.MJMenuItem;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.toolbox.distcomp.ui.profile.ProfileManagerUI;
import com.mathworks.toolbox.distcomp.ui.profile.model.MatlabProfileManager;
import com.mathworks.toolbox.distcomp.ui.profile.model.Profile;
import com.mathworks.toolbox.distcomp.ui.profile.model.ProfileManager;
import com.mathworks.toolbox.distcomp.ui.profile.model.ValidationManager;
import com.mathworks.toolbox.distcomp.ui.resources.icons.ParallelIcon;
import com.mathworks.toolstrip.components.PopupListener;
import com.mathworks.toolstrip.components.popups.ListActionEvent;
import com.mathworks.toolstrip.components.popups.ListActionListener;
import com.mathworks.toolstrip.components.popups.ListItem;
import com.mathworks.toolstrip.components.popups.ListStyle;
import com.mathworks.toolstrip.components.popups.PopupList;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.login.LoginDialogConsumer;
import com.mathworks.widgets.login.ValidationConsumer;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class ProfileDesktopMenuProvider {
    private static ProfileManagerUI sProfileManagerUI;
    private static ProfileManager sProfileManager;
    private static PropertyChangeListener sPropertyChangeListener;
    private static final ResourceBundle sRes;
    private static final ResourceBundle sResUI;
    private static final String DISCOVER_TRAILING_SPACE = "                       ";
    private static final String SET_DEFAULT_TRAILING_SPACE = "                ";

    private ProfileDesktopMenuProvider() {
    }

    static void populate(MJMenu mJMenu) {
        block3: {
            try {
                JMenu jMenu = ProfileDesktopMenuProvider.getSetDefaultProfileMenu();
                JMenuItem jMenuItem = ProfileDesktopMenuProvider.getLaunchProfileManagerMenuItem();
                mJMenu.add((JMenuItem)jMenu);
                mJMenu.add(jMenuItem);
                ProfileDesktopMenuProvider.addPropertyChangeListeners(jMenu);
                if (PlatformInfo.isMacintosh()) {
                    ProfileDesktopMenuProvider.enableMacDynamicMenuWorkaround(mJMenu, jMenu);
                }
            }
            catch (Exception exception) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError((Object)exception);
            }
        }
    }

    static void populate(PopupList popupList) {
        ProfileDesktopMenuProvider.addSelectProfileSubMenuList(popupList);
        ListItem listItem = ProfileDesktopMenuProvider.addItemToPopupList(popupList, "ParallelMenu.DiscoverCluster", sRes.getString("DiscoverCluster.Title"), ListStyle.ICON_TEXT_DESCRIPTION, ProfileDesktopMenuProvider.createDiscoverClustersAction());
        listItem.getAttributes().setAttribute((Attribute)ListItem.DESCRIPTION, (Object)(sRes.getString("DiscoverCluster.Description") + DISCOVER_TRAILING_SPACE));
        ListItem listItem2 = ProfileDesktopMenuProvider.addItemToPopupList(popupList, "ParallelMenu.LaunchProfileManager", sResUI.getString("hometab.parallel.profilemanager.label"), ListStyle.SINGLE_LINE_DESCRIPTION, ProfileDesktopMenuProvider.createLaunchProfileManagerUIAction());
        listItem2.getAttributes().setAttribute((Attribute)ListItem.DESCRIPTION, (Object)sResUI.getString("hometab.parallel.profilemanager.description"));
        listItem2.getAttributes().setAttribute((Attribute)ListItem.HAS_SEPARATOR, (Object)true);
    }

    private static void addPropertyChangeListeners(final JMenu jMenu) {
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (PlatformInfo.isMacintosh() && propertyChangeEvent.getPropertyName().equals("Initialized")) {
                    jMenu.setEnabled(true);
                }
                if (propertyChangeEvent.getPropertyName().equals("Initialized") || propertyChangeEvent.getPropertyName().equals("ProfileAdded") || propertyChangeEvent.getPropertyName().equals("ProfileRenamed") || propertyChangeEvent.getPropertyName().equals("ProfileRemoved") || propertyChangeEvent.getPropertyName().equals("DefaultProfileChanged")) {
                    MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ProfileDesktopMenuProvider.updateDefaultProfileMenu(jMenu);
                        }
                    });
                }
            }
        };
        ProfileDesktopMenuProvider.getProfileManager().addPropertyChangeListener(propertyChangeListener);
        sPropertyChangeListener = propertyChangeListener;
    }

    private static void enableMacDynamicMenuWorkaround(final MJMenu mJMenu, JMenu jMenu) {
        if (!ProfileDesktopMenuProvider.getProfileManager().isInitialized()) {
            jMenu.setEnabled(false);
            mJMenu.addMenuListener(new MenuListener(){

                @Override
                public void menuSelected(MenuEvent menuEvent) {
                    ProfileDesktopMenuProvider.initializeProfileManagerIfNecessary();
                    mJMenu.removeMenuListener((MenuListener)this);
                }

                @Override
                public void menuDeselected(MenuEvent menuEvent) {
                }

                @Override
                public void menuCanceled(MenuEvent menuEvent) {
                }
            });
        }
    }

    private static JMenuItem getImportProfileMenuItem() {
        return new MJMenuItem((Action)ProfileDesktopMenuProvider.createImportProfileAction());
    }

    private static MJAbstractAction createImportProfileAction() {
        return new MJAbstractAction(sResUI.getString("parallelmenu.importprofile.menuitem.label")){

            public void actionPerformed(ActionEvent actionEvent) {
                ProfileDesktopMenuProvider.showProfileManagerUI();
                ProfileDesktopMenuProvider.getProfileManagerUI().showImportProfileDialog();
            }
        };
    }

    private static JMenuItem getLaunchProfileManagerMenuItem() {
        return new MJMenuItem((Action)ProfileDesktopMenuProvider.createLaunchProfileManagerUIAction());
    }

    private static MJAbstractAction createLaunchProfileManagerUIAction() {
        return new MJAbstractAction(sResUI.getString("parallelmenu.profilemanager.menuitem.label")){

            public void actionPerformed(ActionEvent actionEvent) {
                ProfileDesktopMenuProvider.showProfileManagerUI();
            }
        };
    }

    private static JMenu getSetDefaultProfileMenu() {
        MJMenu mJMenu = new MJMenu(sResUI.getString("parallelmenu.setdefault.menuitem.label")){

            public void dispose() {
                super.dispose();
                if (sPropertyChangeListener != null) {
                    ProfileDesktopMenuProvider.getProfileManager().removePropertyChangeListener(sPropertyChangeListener);
                    sPropertyChangeListener = null;
                }
            }
        };
        if (!ProfileDesktopMenuProvider.getProfileManager().isInitialized()) {
            mJMenu.addMenuListener(new MenuListener((JMenu)mJMenu){
                final /* synthetic */ JMenu val$defaultProfileMenu;
                {
                    this.val$defaultProfileMenu = jMenu;
                }

                @Override
                public void menuSelected(MenuEvent menuEvent) {
                    ProfileDesktopMenuProvider.initializeProfileManagerIfNecessary();
                    this.val$defaultProfileMenu.removeMenuListener(this);
                }

                @Override
                public void menuDeselected(MenuEvent menuEvent) {
                }

                @Override
                public void menuCanceled(MenuEvent menuEvent) {
                }
            });
        }
        if (ProfileDesktopMenuProvider.getProfileManager().isInitialized()) {
            ProfileDesktopMenuProvider.updateDefaultProfileMenu((JMenu)mJMenu);
        } else {
            mJMenu.add((JMenuItem)new MJMenuItem(sResUI.getString("parallelmenu.updating.menuitem.label"), ParallelIcon.BUSY.getIcon()));
        }
        return mJMenu;
    }

    private static void addSelectProfileSubMenuList(PopupList popupList) {
        DefaultListModel defaultListModel = (DefaultListModel)popupList.getModel();
        final PopupList popupList2 = new PopupList(new DefaultListModel());
        ListItem listItem = ListItem.newSubList((String)"ParallelMenu.SelectClusterProfile", (String)sResUI.getString("hometab.parallel.setdefault.label"), null, (PopupListener)new PopupListener(){

            public void onPopupEvent(JComponent jComponent, PopupListener.PopupCallback popupCallback) {
                popupCallback.show((JComponent)popupList2);
            }
        });
        listItem.setAttribute((Attribute)ListItem.STYLE, (Object)ListStyle.ICON_TEXT_DESCRIPTION);
        listItem.getAttributes().setAttribute((Attribute)ListItem.DESCRIPTION, (Object)(sResUI.getString("hometab.parallel.setdefault.description") + SET_DEFAULT_TRAILING_SPACE));
        defaultListModel.addElement(listItem);
        ProfileDesktopMenuProvider.updateSetDefaultPopupList(popupList2);
        if (!ProfileDesktopMenuProvider.getProfileManager().isInitialized()) {
            ProfileDesktopMenuProvider.initializeProfileManagerIfNecessary();
            ProfileDesktopMenuProvider.getProfileManager().addPropertyChangeListener("Initialized", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ProfileDesktopMenuProvider.updateSetDefaultPopupList(popupList2);
                            OverlayManager overlayManager = OverlayManagers.get((Component)popupList2);
                            if (overlayManager != null) {
                                overlayManager.packOverlay((Component)popupList2);
                            }
                        }
                    });
                    ProfileDesktopMenuProvider.getProfileManager().removePropertyChangeListener(this);
                }
            });
        }
    }

    private static void updateSetDefaultPopupList(PopupList popupList) {
        ((DefaultListModel)popupList.getModel()).removeAllElements();
        if (!ProfileDesktopMenuProvider.getProfileManager().isInitialized()) {
            ProfileDesktopMenuProvider.createUpdatingListItem(popupList);
        } else {
            ProfileDesktopMenuProvider.createProfileListItems(popupList);
        }
    }

    private static void createProfileListItems(PopupList popupList) {
        String string = ProfileDesktopMenuProvider.getProfileManager().getDefaultProfile();
        List<String> list = ProfileDesktopMenuProvider.getSortedProfileNames();
        for (final String string2 : list) {
            String string3 = string2.equals(string) ? MessageFormat.format(sRes.getString("ProfileManager.DefaultProfile"), string2) : string2;
            MJAbstractAction mJAbstractAction = new MJAbstractAction(string3){

                public void actionPerformed(ActionEvent actionEvent) {
                    ProfileDesktopMenuProvider.getProfileManager().setDefaultProfile(string2);
                }
            };
            ProfileDesktopMenuProvider.addItemToPopupList(popupList, "ParallelMenu." + string2, string3, ListStyle.TEXT_ONLY, mJAbstractAction);
        }
    }

    private static void createUpdatingListItem(PopupList popupList) {
        ListItem listItem = ProfileDesktopMenuProvider.addItemToPopupList(popupList, "ParallelMenu.Updating", sResUI.getString("hometab.parallel.updating.label"), ListStyle.ICON_TEXT, null);
        listItem.getAttributes().setAttribute((Attribute)ListItem.ICON, (Object)ParallelIcon.BUSY.getIcon());
    }

    private static List<String> getSortedProfileNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Profile profile : ProfileDesktopMenuProvider.getProfileManager().getProfiles()) {
            String string = profile.getName();
            arrayList.add(string);
        }
        Collections.sort(arrayList, String.CASE_INSENSITIVE_ORDER);
        return arrayList;
    }

    public static ProfileManagerUI getProfileManagerUI() {
        if (sProfileManagerUI == null) {
            ProfileDesktopMenuProvider.initializeProfileManagerIfNecessary();
            ValidationManager validationManager = new ValidationManager((LoginDialogConsumer)new ValidationConsumer(){

                public boolean hasDisplay() {
                    return true;
                }

                public Component getInvoker() {
                    return sProfileManagerUI;
                }
            });
            validationManager.initialize();
            sProfileManagerUI = new ProfileManagerUI(ProfileDesktopMenuProvider.getProfileManager(), validationManager);
        }
        return sProfileManagerUI;
    }

    public static ProfileManager getProfileManager() {
        if (sProfileManager == null) {
            sProfileManager = new MatlabProfileManager();
        }
        return sProfileManager;
    }

    private static void initializeProfileManagerIfNecessary() {
        if (!ProfileDesktopMenuProvider.getProfileManager().isInitialized()) {
            ProfileDesktopMenuProvider.getProfileManager().initialize();
        }
    }

    public static void showProfileManagerUI() {
        if (ProfileDesktopMenuProvider.getProfileManagerUI().isVisible()) {
            ProfileDesktopMenuProvider.getProfileManagerUI().toFront();
        } else {
            ProfileDesktopMenuProvider.getProfileManagerUI().setLocationRelativeTo(null);
            ProfileDesktopMenuProvider.getProfileManagerUI().setVisible(true);
        }
    }

    private static void updateDefaultProfileMenu(JMenu jMenu) {
        jMenu.removeAll();
        String string = ProfileDesktopMenuProvider.getProfileManager().getDefaultProfile();
        List<String> list = ProfileDesktopMenuProvider.getSortedProfileNames();
        for (final String string2 : list) {
            String string3 = string2.equals(string) ? MessageFormat.format(sRes.getString("ProfileManager.DefaultProfile"), string2) : string2;
            MJMenuItem mJMenuItem = new MJMenuItem(string3);
            mJMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ProfileDesktopMenuProvider.getProfileManager().setDefaultProfile(string2);
                }
            });
            jMenu.add((JMenuItem)mJMenuItem);
        }
        jMenu.addSeparator();
        jMenu.add((JMenuItem)ProfileDesktopMenuProvider.getDiscoverMenuItem());
        jMenu.add(ProfileDesktopMenuProvider.getImportProfileMenuItem());
        if (jMenu.isPopupMenuVisible()) {
            jMenu.setPopupMenuVisible(false);
            jMenu.setPopupMenuVisible(true);
        }
    }

    private static MJMenuItem getDiscoverMenuItem() {
        return new MJMenuItem((Action)ProfileDesktopMenuProvider.createDiscoverClustersAction());
    }

    private static MJAbstractAction createDiscoverClustersAction() {
        return new MJAbstractAction(sResUI.getString("parallelmenu.discoverclusters.menuitem.label")){

            public void actionPerformed(ActionEvent actionEvent) {
                ProfileDesktopMenuProvider.getProfileManagerUI().showDiscoverClusterDialog();
            }
        };
    }

    private static ListItem addItemToPopupList(PopupList popupList, String string, String string2, ListStyle listStyle, final MJAbstractAction mJAbstractAction) {
        DefaultListModel defaultListModel = (DefaultListModel)popupList.getModel();
        final ListItem listItem = ListItem.newItem((String)string, (String)string2);
        listItem.setAttribute((Attribute)ListItem.STYLE, (Object)listStyle);
        defaultListModel.addElement(listItem);
        popupList.addListActionListener(new ListActionListener(){

            public void listItemSelected(ListActionEvent listActionEvent) {
                if (mJAbstractAction != null && listActionEvent.getListItem().equals((Object)listItem)) {
                    mJAbstractAction.actionPerformed(null);
                }
            }
        });
        return listItem;
    }

    static {
        sRes = ResourceBundle.getBundle("com.mathworks.toolbox.distcomp.ui.resources.RES_profile");
        sResUI = ResourceBundle.getBundle("com.mathworks.toolbox.distcomp.ui.resources.RES_ui");
    }
}

