/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.ui.jobmonitor;

import com.jidesoft.grid.SortableTable;
import com.jidesoft.grid.TableModelWrapper;
import com.jidesoft.swing.DefaultOverlayable;
import com.mathworks.common.icons.DialogIcon;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJCheckBox;
import com.mathworks.mwswing.MJComboBox;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJMenuItem;
import com.mathworks.mwswing.MJMultilineLabel;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.toolbox.distcomp.ui.UpdateChangeListener;
import com.mathworks.toolbox.distcomp.ui.UpdatePanel;
import com.mathworks.toolbox.distcomp.ui.jobmonitor.JobMonitorModel;
import com.mathworks.toolbox.distcomp.ui.jobmonitor.JobMonitorTableModel;
import com.mathworks.toolbox.distcomp.ui.jobmonitor.JobStateModel;
import com.mathworks.toolbox.distcomp.ui.jobmonitor.JobTableRowModel;
import com.mathworks.toolbox.distcomp.ui.jobmonitor.JobType;
import com.mathworks.toolbox.distcomp.ui.panel.StyleGuidePanel;
import com.mathworks.toolbox.distcomp.ui.resources.icons.ParallelIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public final class JobMonitorUI
extends StyleGuidePanel
implements PropertyChangeListener,
UpdateChangeListener {
    private JobMonitorModel fJobMonitorModel;
    private JMenuItem fCancelJobMenuItem;
    private JMenuItem fDeleteJobMenuItem;
    private MJAbstractAction fDeleteAction;
    private JMenuItem fShowJobDetailsMenuItem;
    private JMenuItem fShowErrorMessageMenuItem;
    private JMenuItem fShowDiaryMenuItem;
    private JMenuItem fCloseMatlabPoolMenuItem;
    private JMenuItem fFetchOutputsMenuItem;
    private JMenuItem fLoadVariableMenuItem;
    private JCheckBox fShowJobsFromAllUsers;
    private JComboBox fProfileCombobox;
    private JLabel fSelectProfileLabel;
    private DefaultOverlayable fOverlayTableScrollPane;
    private JobMonitorTableModel fJobMonitorTableModel;
    private SortableTable fJobsTable;
    private UpdatePanel fUpdatePanel;
    private MJMultilineLabel fErrorMessageLabel;
    private AtomicBoolean fIsUpdating = new AtomicBoolean(false);
    private static final ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.toolbox.distcomp.ui.resources.RES_ui");
    private static final String DELETE_ACTION_KEY = "delete";

    public JobMonitorUI() {
        this.fJobMonitorModel = new JobMonitorModel();
        this.fJobMonitorModel.addPropertyChangeListener(this);
        this.fJobMonitorModel.addUpdateChangeListener(this);
        this.createSelectProfileSection();
        this.createJobsTableSection();
        this.createUpdatePanelSection();
        this.addLine((JComponent[][])new JComponent[][]{{this.fSelectProfileLabel, this.fProfileCombobox, this.fShowJobsFromAllUsers}}, 0, 1);
        this.addLine((JComponent)this.fOverlayTableScrollPane, 8);
        this.addLine(this.fUpdatePanel.getComponent());
        this.fProfileCombobox.setName("SelectProfileCombobox");
        this.fShowJobsFromAllUsers.setName("ShowAllUserJobsCheckbox");
        this.fJobsTable.setName("JobsTable");
        this.fCancelJobMenuItem.setName("CancelJobMenuItem");
        this.fDeleteJobMenuItem.setName("DeleteJobMenuItem");
        this.fShowJobDetailsMenuItem.setName("ShowJobDetailsMenuItem");
        this.fShowErrorMessageMenuItem.setName("ShowErrorMessageMenuItem");
        this.fErrorMessageLabel.setName("JobsTableErrorMessage");
        this.fShowDiaryMenuItem.setName("ShowDiaryMenuItem");
        this.fCloseMatlabPoolMenuItem.setName("CloseMatlabPoolMenuItem");
        this.fFetchOutputsMenuItem.setName("FetchOutputsMenuItem");
        this.fLoadVariableMenuItem.setName("LoadVariableMenuItem");
        this.setName("JobMonitorUI");
    }

    private void createSelectProfileSection() {
        this.fProfileCombobox = new MJComboBox();
        this.fProfileCombobox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JobMonitorUI.this.fJobMonitorModel.updateCurrentProfile((String)JobMonitorUI.this.fProfileCombobox.getSelectedItem());
            }
        });
        this.fShowJobsFromAllUsers = new MJCheckBox(sRes.getString("jobmonitor.showall.checkbox"));
        this.fShowJobsFromAllUsers.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JobMonitorUI.this.fJobMonitorModel.setShowJobsFromAllUser(JobMonitorUI.this.fShowJobsFromAllUsers.isSelected());
            }
        });
        this.fSelectProfileLabel = new MJLabel(sRes.getString("jobmonitor.selectprofile.label"));
    }

    private void createUpdatePanelSection() {
        this.fUpdatePanel = new UpdatePanel(new Runnable(){

            @Override
            public void run() {
                JobMonitorUI.this.fJobMonitorModel.update();
            }
        }, UpdatePanel.UpdateFrequency.UPDATE_EVERY_5MIN);
        this.fJobMonitorModel.addUpdateChangeListener(this.fUpdatePanel);
    }

    private void createJobsTableSection() {
        this.fJobMonitorTableModel = new JobMonitorTableModel();
        this.fJobsTable = new SortableTable(this.fJobMonitorTableModel){

            public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
                Component component = super.prepareRenderer(tableCellRenderer, n, n2);
                if (n != -1) {
                    int n3 = JobMonitorUI.this.fJobsTable.getActualRowAt(n);
                    JobStateModel jobStateModel = (JobStateModel)JobMonitorUI.this.fJobMonitorTableModel.getValueAt(n3, 5);
                    String string = MessageFormat.format(sRes.getString("jobmonitor.statuscolumn.tooltip"), JobMonitorUI.this.fJobMonitorTableModel.getValueAt(n3, 0), jobStateModel.getFinishedTasksNoError(), jobStateModel.getFinishedTasksWithError(), jobStateModel.getRunningTasks(), jobStateModel.getPendingTasks());
                    if (component instanceof JComponent) {
                        JComponent jComponent = (JComponent)component;
                        jComponent.setToolTipText(string);
                    }
                }
                return component;
            }
        };
        this.fJobsTable.setDefaultRenderer(JobStateModel.class, (TableCellRenderer)new StatusRenderer());
        this.fJobsTable.setCellRendererManagerEnabled(false);
        this.fJobsTable.setCellEditorManagerEnabled(false);
        this.fJobsTable.setMultiColumnSortable(false);
        this.fJobsTable.setShowSortOrderNumber(false);
        this.fJobsTable.setSelectionMode(2);
        MJScrollPane mJScrollPane = new MJScrollPane((Component)this.fJobsTable);
        mJScrollPane.getViewport().setBackground(Color.WHITE);
        mJScrollPane.setPreferredSize(new Dimension((int)this.fJobsTable.getPreferredSize().getWidth(), (int)this.fJobsTable.getPreferredSize().getHeight() + (int)this.fJobsTable.getTableHeader().getPreferredSize().getHeight() + 4));
        this.fErrorMessageLabel = new MJMultilineLabel(sRes.getString("jobmonitor.jobtable.startnowmsg"), true);
        this.fErrorMessageLabel.setBackground(Color.WHITE);
        this.fErrorMessageLabel.setFont(this.fErrorMessageLabel.getFont().deriveFont(2));
        this.fErrorMessageLabel.addComponentListener((ComponentListener)new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                JobMonitorUI.this.resizeErrorMessageLabel();
            }

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
                JobMonitorUI.this.resizeErrorMessageLabel();
            }

            @Override
            public void componentShown(ComponentEvent componentEvent) {
                JobMonitorUI.this.resizeErrorMessageLabel();
            }
        });
        this.fOverlayTableScrollPane = new DefaultOverlayable((JComponent)mJScrollPane);
        this.fOverlayTableScrollPane.addOverlayComponent((JComponent)this.fErrorMessageLabel);
        this.fOverlayTableScrollPane.setOverlayVisible(true);
        this.createRightClickMenu();
    }

    private void resizeErrorMessageLabel() {
        FontMetrics fontMetrics = this.fErrorMessageLabel.getFontMetrics(this.fErrorMessageLabel.getFont());
        int n = fontMetrics.stringWidth(this.fErrorMessageLabel.getText()) + 10;
        int n2 = this.fOverlayTableScrollPane.getWidth() - 50;
        this.fErrorMessageLabel.setMaxWidth(Math.min(n, n2));
    }

    private void createRightClickMenu() {
        this.fCancelJobMenuItem = new MJMenuItem((Action)new MJAbstractAction(sRes.getString("jobmonitor.canel.menuitem")){

            public void actionPerformed(ActionEvent actionEvent) {
                List list = JobMonitorUI.this.getSelectedJobTableRows();
                JobMonitorUI.this.fJobMonitorModel.cancelJob(list);
            }
        });
        this.fDeleteAction = new MJAbstractAction(sRes.getString("jobmonitor.delete.menuitem")){

            public void actionPerformed(ActionEvent actionEvent) {
                List list = JobMonitorUI.this.getSelectedJobTableRows();
                JobMonitorUI.this.fJobMonitorModel.deleteJob(list);
            }
        };
        this.fDeleteJobMenuItem = new MJMenuItem((Action)this.fDeleteAction);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(127, 0);
        this.fJobsTable.getInputMap().put(keyStroke, DELETE_ACTION_KEY);
        this.fJobsTable.getActionMap().put(DELETE_ACTION_KEY, (Action)this.fDeleteAction);
        this.fShowJobDetailsMenuItem = new MJMenuItem((Action)new MJAbstractAction(sRes.getString("jobmonitor.showjobdetails.menuitem")){

            public void actionPerformed(ActionEvent actionEvent) {
                List list = JobMonitorUI.this.getSelectedJobTableRows();
                JobMonitorUI.this.fJobMonitorModel.showJobDetails((JobTableRowModel)list.get(0));
            }
        });
        this.fShowErrorMessageMenuItem = new MJMenuItem((Action)new MJAbstractAction(sRes.getString("jobmonitor.showerrors.menuitem")){

            public void actionPerformed(ActionEvent actionEvent) {
                List list = JobMonitorUI.this.getSelectedJobTableRows();
                JobMonitorUI.this.fJobMonitorModel.showErroredTasksInJob((JobTableRowModel)list.get(0));
            }
        });
        this.fShowDiaryMenuItem = new MJMenuItem((Action)new MJAbstractAction(sRes.getString("jobmonitor.showdiary.menuitem")){

            public void actionPerformed(ActionEvent actionEvent) {
                List list = JobMonitorUI.this.getSelectedJobTableRows();
                JobMonitorUI.this.fJobMonitorModel.showDiary((JobTableRowModel)list.get(0));
            }
        });
        this.fCloseMatlabPoolMenuItem = new MJMenuItem((Action)new MJAbstractAction(sRes.getString("jobmonitor.closematlabpool.menuitem")){

            public void actionPerformed(ActionEvent actionEvent) {
                JobMonitorUI.this.fJobMonitorModel.closeMATLABPool();
            }
        });
        this.fFetchOutputsMenuItem = new MJMenuItem((Action)new MJAbstractAction(sRes.getString("jobmonitor.fetchoutputs.menuitem")){

            public void actionPerformed(ActionEvent actionEvent) {
                List list = JobMonitorUI.this.getSelectedJobTableRows();
                JobMonitorUI.this.fJobMonitorModel.fetchOutput((JobTableRowModel)list.get(0));
            }
        });
        this.fLoadVariableMenuItem = new MJMenuItem((Action)new MJAbstractAction(sRes.getString("jobmonitor.loadvariables.menuitem")){

            public void actionPerformed(ActionEvent actionEvent) {
                List list = JobMonitorUI.this.getSelectedJobTableRows();
                JobMonitorUI.this.fJobMonitorModel.loadVariables((JobTableRowModel)list.get(0));
            }
        });
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                this.showPopup(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                this.showPopup(mouseEvent);
            }

            private void showPopup(MouseEvent mouseEvent) {
                if (!mouseEvent.isPopupTrigger()) {
                    return;
                }
                int n = JobMonitorUI.this.fJobsTable.rowAtPoint(mouseEvent.getPoint());
                int n2 = JobMonitorUI.this.fJobsTable.getActualRowAt(n);
                int[] nArray = JobMonitorUI.this.fJobsTable.getSelectedRows();
                boolean bl = false;
                for (int n3 : nArray) {
                    bl = bl || JobMonitorUI.this.fJobsTable.getActualRowAt(n3) == n2;
                }
                if (n2 != -1 && !bl) {
                    int n4 = JobMonitorUI.this.fJobsTable.getSortedRowAt(n2);
                    JobMonitorUI.this.fJobsTable.setRowSelectionInterval(n4, n4);
                }
                Object object = JobMonitorUI.this.generateRightClickMenu();
                ((JPopupMenu)object).show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        };
        this.fJobsTable.addMouseListener((MouseListener)mouseAdapter);
        this.fJobsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                int n = JobMonitorUI.this.fJobsTable.getActualRowAt(JobMonitorUI.this.fJobsTable.getSelectedRow());
                if (n == -1) {
                    return;
                }
                JobMonitorUI.this.updateRightClickMenuItems();
            }
        });
    }

    private JPopupMenu generateRightClickMenu() {
        MJPopupMenu mJPopupMenu = new MJPopupMenu();
        if (this.getSelectedJobTableRows().size() > 1) {
            mJPopupMenu.add(this.fDeleteJobMenuItem);
            return mJPopupMenu;
        }
        JobType jobType = this.getSelectedJobTableRows().get(0).getJobType();
        switch (jobType) {
            case BATCH_JOB_ON_SCRIPT: {
                mJPopupMenu.add(this.fCancelJobMenuItem);
                mJPopupMenu.add(this.fDeleteJobMenuItem);
                mJPopupMenu.addSeparator();
                mJPopupMenu.add(this.fShowJobDetailsMenuItem);
                mJPopupMenu.add(this.fShowErrorMessageMenuItem);
                mJPopupMenu.add(this.fShowDiaryMenuItem);
                mJPopupMenu.addSeparator();
                mJPopupMenu.add(this.fLoadVariableMenuItem);
                break;
            }
            case BATCH_JOB_ON_FUNCTION: {
                mJPopupMenu.add(this.fCancelJobMenuItem);
                mJPopupMenu.add(this.fDeleteJobMenuItem);
                mJPopupMenu.addSeparator();
                mJPopupMenu.add(this.fShowJobDetailsMenuItem);
                mJPopupMenu.add(this.fShowErrorMessageMenuItem);
                mJPopupMenu.add(this.fShowDiaryMenuItem);
                mJPopupMenu.addSeparator();
                mJPopupMenu.add(this.fFetchOutputsMenuItem);
                break;
            }
            case MATLABPOOL: 
            case CURRENT_INTERACTIVE_MATLABPOOL: {
                mJPopupMenu.add(this.fDeleteJobMenuItem);
                mJPopupMenu.add(this.fCloseMatlabPoolMenuItem);
                break;
            }
            default: {
                mJPopupMenu.add(this.fCancelJobMenuItem);
                mJPopupMenu.add(this.fDeleteJobMenuItem);
                mJPopupMenu.addSeparator();
                mJPopupMenu.add(this.fShowJobDetailsMenuItem);
                mJPopupMenu.add(this.fShowErrorMessageMenuItem);
                mJPopupMenu.addSeparator();
                mJPopupMenu.add(this.fFetchOutputsMenuItem);
            }
        }
        return mJPopupMenu;
    }

    private void updateRightClickMenuItems() {
        this.updateCancelMenuItem();
        this.updateDeleteMenuItem();
        this.updateCloseMatlabPoolMenuItem();
        this.updateShowDiaryMenuItem();
        this.updateShowJobDetailsMenuItem();
        this.updateShowErrorMessageMenuItem();
        this.updateLoadVariablesMenuItem();
        this.updateFetchOutputsMenuItem();
    }

    private void updateFetchOutputsMenuItem() {
        List<JobTableRowModel> list = this.getSelectedJobTableRows();
        boolean bl = !this.fIsUpdating.get() && list.size() == 1 && list.get(0).getJobStateModel().isDone() && !list.get(0).getJobStateModel().hasErrors();
        this.fFetchOutputsMenuItem.setEnabled(bl);
    }

    private void updateLoadVariablesMenuItem() {
        List<JobTableRowModel> list = this.getSelectedJobTableRows();
        boolean bl = !this.fIsUpdating.get() && list.size() == 1 && list.get(0).getJobStateModel().isDone() && !list.get(0).getJobStateModel().hasErrors();
        this.fLoadVariableMenuItem.setEnabled(bl);
    }

    private void updateShowErrorMessageMenuItem() {
        List<JobTableRowModel> list = this.getSelectedJobTableRows();
        boolean bl = !this.fIsUpdating.get() && list.size() == 1 && list.get(0).getJobStateModel().hasErrors();
        this.fShowErrorMessageMenuItem.setEnabled(bl);
    }

    private void updateShowJobDetailsMenuItem() {
        List<JobTableRowModel> list = this.getSelectedJobTableRows();
        boolean bl = !this.fIsUpdating.get() && list.size() == 1;
        this.fShowJobDetailsMenuItem.setEnabled(bl);
    }

    private void updateShowDiaryMenuItem() {
        List<JobTableRowModel> list = this.getSelectedJobTableRows();
        boolean bl = !this.fIsUpdating.get() && list.size() == 1 && (list.get(0).getJobStateModel().isRunning() || list.get(0).getJobStateModel().isDone());
        this.fShowDiaryMenuItem.setEnabled(bl);
    }

    private void updateCloseMatlabPoolMenuItem() {
        List<JobTableRowModel> list = this.getSelectedJobTableRows();
        boolean bl = !this.fIsUpdating.get() && list.size() == 1 && list.get(0).getJobType().equals((Object)JobType.CURRENT_INTERACTIVE_MATLABPOOL);
        this.fCloseMatlabPoolMenuItem.setEnabled(bl);
    }

    private void updateDeleteMenuItem() {
        boolean bl = this.fIsUpdating.get();
        boolean bl2 = !bl;
        this.fDeleteAction.setEnabled(bl2);
    }

    private void updateCancelMenuItem() {
        List<JobTableRowModel> list = this.getSelectedJobTableRows();
        boolean bl = !this.fIsUpdating.get() && list.size() == 1 && list.get(0).getJobStateModel().isRunning();
        this.fCancelJobMenuItem.setEnabled(bl);
    }

    private List<JobTableRowModel> getSelectedJobTableRows() {
        ArrayList<JobTableRowModel> arrayList = new ArrayList<JobTableRowModel>();
        int[] nArray = this.fJobsTable.getSelectedRows();
        if (nArray != null) {
            List<JobTableRowModel> list = this.fJobMonitorModel.isShowJobsFromAllUser() ? this.fJobMonitorModel.getAllUsersJobTableRows() : this.fJobMonitorModel.getIndividualUserJobTableRows();
            for (int n : nArray) {
                int n2 = this.fJobsTable.getActualRowAt(n);
                JobTableRowModel jobTableRowModel = list.get(n2);
                arrayList.add(jobTableRowModel);
            }
        }
        return arrayList;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("CurrentProfileChanged")) {
            ActionListener[] actionListenerArray;
            for (ActionListener actionListener : actionListenerArray = this.fProfileCombobox.getActionListeners()) {
                this.fProfileCombobox.removeActionListener(actionListener);
            }
            this.fProfileCombobox.setSelectedItem(this.fJobMonitorModel.getCurrentProfile());
            for (ActionListener actionListener : actionListenerArray) {
                this.fProfileCombobox.addActionListener(actionListener);
            }
        } else if (propertyChangeEvent.getPropertyName().equals("AllUsersJobTableRowsChanged")) {
            if (this.fJobMonitorModel.isShowJobsFromAllUser()) {
                List<JobTableRowModel> list = this.fJobMonitorModel.getAllUsersJobTableRows();
                this.fJobMonitorTableModel.updateTableData(list);
            }
        } else if (propertyChangeEvent.getPropertyName().equals("IndividualUserTableRowsChanged")) {
            if (!this.fJobMonitorModel.isShowJobsFromAllUser()) {
                List<JobTableRowModel> list = this.fJobMonitorModel.getIndividualUserJobTableRows();
                this.fJobMonitorTableModel.updateTableData(list);
            }
        } else if (propertyChangeEvent.getPropertyName().equals("ProfileListChanged")) {
            ActionListener[] actionListenerArray;
            this.fProfileCombobox.setModel(new DefaultComboBoxModel<Object>(this.fJobMonitorModel.getProfileList().toArray()));
            for (ActionListener actionListener : actionListenerArray = this.fProfileCombobox.getActionListeners()) {
                this.fProfileCombobox.removeActionListener(actionListener);
            }
            this.fProfileCombobox.setSelectedItem(this.fJobMonitorModel.getCurrentProfile());
            for (ActionListener actionListener : actionListenerArray) {
                this.fProfileCombobox.addActionListener(actionListener);
            }
        } else if (propertyChangeEvent.getPropertyName().equals("ShowJobsFromAllUserChanged")) {
            this.fShowJobsFromAllUsers.setSelected(this.fJobMonitorModel.isShowJobsFromAllUser());
            List<JobTableRowModel> list = this.fJobMonitorModel.isShowJobsFromAllUser() ? this.fJobMonitorModel.getAllUsersJobTableRows() : this.fJobMonitorModel.getIndividualUserJobTableRows();
            this.fJobMonitorTableModel.updateTableData(list);
        } else if (propertyChangeEvent.getPropertyName().equals("CancelJobErrored")) {
            String string = (String)propertyChangeEvent.getNewValue();
            String string2 = MessageFormat.format(sRes.getString("jobmonitor.errordialog.canceljob"), string);
            JobMonitorUI.showErrorDialog(string2);
        } else if (propertyChangeEvent.getPropertyName().equals("DeleteJobErrored")) {
            String string = (String)propertyChangeEvent.getNewValue();
            String string3 = MessageFormat.format(sRes.getString("jobmonitor.errordialog.destroyjob"), string);
            JobMonitorUI.showErrorDialog(string3);
        } else if (propertyChangeEvent.getPropertyName().equals("ShowJobDetailsErrored")) {
            String string = (String)propertyChangeEvent.getNewValue();
            String string4 = MessageFormat.format(sRes.getString("jobmonitor.errordialog.showjobdetails"), string);
            JobMonitorUI.showErrorDialog(string4);
        } else if (propertyChangeEvent.getPropertyName().equals("ShowErroredTasksErrored")) {
            String string = (String)propertyChangeEvent.getNewValue();
            String string5 = MessageFormat.format(sRes.getString("jobmonitor.errordialog.showerrors"), string);
            JobMonitorUI.showErrorDialog(string5);
        } else if (propertyChangeEvent.getPropertyName().equals("FetchOutputsErrored")) {
            String string = (String)propertyChangeEvent.getNewValue();
            String string6 = MessageFormat.format(sRes.getString("jobmonitor.errordialog.fetchoutputs"), string);
            JobMonitorUI.showErrorDialog(string6);
        } else if (propertyChangeEvent.getPropertyName().equals("LoadVariablesErrored")) {
            String string = (String)propertyChangeEvent.getNewValue();
            String string7 = MessageFormat.format(sRes.getString("jobmonitor.errordialog.loadvariables"), string);
            JobMonitorUI.showErrorDialog(string7);
        } else if (propertyChangeEvent.getPropertyName().equals("ShowDiaryErrored")) {
            String string = (String)propertyChangeEvent.getNewValue();
            String string8 = MessageFormat.format(sRes.getString("jobmonitor.errordialog.showdiary"), string);
            JobMonitorUI.showErrorDialog(string8);
        } else if (propertyChangeEvent.getPropertyName().equals("CloseMATLABPoolErrored")) {
            String string = (String)propertyChangeEvent.getNewValue();
            String string9 = MessageFormat.format(sRes.getString("jobmonitor.errordialog.closematlabpool"), string);
            JobMonitorUI.showErrorDialog(string9);
        } else if (propertyChangeEvent.getPropertyName().equals("RevertToDefaultProfile")) {
            String string = (String)propertyChangeEvent.getOldValue();
            String string10 = (String)propertyChangeEvent.getNewValue();
            String string11 = MessageFormat.format(sRes.getString("jobmonitor.errordialog.deletedprofile"), string, string10);
            JobMonitorUI.showErrorDialog(string11);
        } else if (propertyChangeEvent.getPropertyName().equals("MatlabError")) {
            String string = (String)propertyChangeEvent.getNewValue();
            this.fErrorMessageLabel.setText(string);
            this.resizeErrorMessageLabel();
            this.fOverlayTableScrollPane.setOverlayVisible(true);
            this.fOverlayTableScrollPane.setBounds(this.fOverlayTableScrollPane.getBounds());
        } else if (propertyChangeEvent.getPropertyName().equals("UpdateAborted")) {
            this.stopAutoUpdating();
        }
    }

    private static void showErrorDialog(final String string) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(null, string, sRes.getString("jobmonitor.errordialog.title"), 0);
            }
        }).start();
    }

    public void startAutoUpdating() {
        this.fUpdatePanel.startAutoUpdating();
    }

    public void stopAutoUpdating() {
        this.fUpdatePanel.stopAutoUpdating();
    }

    @Override
    public void updateStarted() {
        this.fIsUpdating.set(true);
        if (SwingUtilities.isEventDispatchThread()) {
            this.doUpdateStarted();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JobMonitorUI.this.doUpdateStarted();
                }
            });
        }
    }

    private void doUpdateStarted() {
        this.fErrorMessageLabel.setText("");
        this.fOverlayTableScrollPane.setOverlayVisible(false);
        this.updateRightClickMenuItems();
    }

    @Override
    public void updateFinished() {
        this.fIsUpdating.set(false);
        if (SwingUtilities.isEventDispatchThread()) {
            this.doUpdateDone();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JobMonitorUI.this.doUpdateDone();
                }
            });
        }
    }

    @Override
    public void updateCanceled() {
        this.fIsUpdating.set(false);
        if (SwingUtilities.isEventDispatchThread()) {
            this.doUpdateDone();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JobMonitorUI.this.doUpdateDone();
                }
            });
        }
    }

    private void doUpdateDone() {
        this.updateRightClickMenuItems();
    }

    public void forceUpdate() {
        this.fJobMonitorModel.update();
    }

    public void updateProfile(String string) {
        this.fJobMonitorModel.updateCurrentProfile(string);
    }

    private static class StatusRenderer
    extends DefaultTableCellRenderer {
        private StatusRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (object != null) {
                JobStateModel jobStateModel = (JobStateModel)object;
                jLabel.setText(jobStateModel.getState());
                if (((JobMonitorTableModel)((TableModelWrapper)jTable.getModel()).getActualModel()).hasAnyErrors()) {
                    if (jobStateModel.hasErrors()) {
                        jLabel.setIcon(DialogIcon.ERROR.getIcon());
                    } else {
                        jLabel.setIcon(ParallelIcon.BLANK.getIcon());
                    }
                } else {
                    jLabel.setIcon(null);
                }
            } else {
                jLabel.setText("");
                jLabel.setText(null);
            }
            return jLabel;
        }
    }
}

