/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.ui.profile;

import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.toolbox.distcomp.ui.model.Destroyable;
import com.mathworks.toolbox.distcomp.ui.panel.AbstractStyleGuidePanel;
import com.mathworks.toolbox.distcomp.ui.panel.StyleGuidePanel;
import com.mathworks.toolbox.distcomp.ui.profile.ValidationDetailsDialog;
import com.mathworks.toolbox.distcomp.ui.profile.model.Profile;
import com.mathworks.toolbox.distcomp.ui.profile.model.ValidationEventData;
import com.mathworks.toolbox.distcomp.ui.profile.model.ValidationListener;
import com.mathworks.toolbox.distcomp.ui.profile.model.ValidationManager;
import com.mathworks.toolbox.distcomp.ui.profile.model.ValidationResults;
import com.mathworks.toolbox.distcomp.ui.profile.model.ValidationStage;
import com.mathworks.toolbox.distcomp.ui.profile.model.ValidationStatus;
import com.mathworks.toolbox.distcomp.ui.resources.icons.ParallelIcon;
import com.mathworks.toolbox.distcomp.ui.widget.TablePanel;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.image.ImageObserver;
import java.util.EnumMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;

public final class ValidationPanel
extends StyleGuidePanel
implements ValidationListener,
Destroyable {
    private final Map<ValidationStage, ValidationResults> fStageResults;
    private Profile fProfile;
    private final String fSchedulerType;
    private final JLabel fOverallStatusLabel;
    private TablePanel fTablePanel;
    private JButton fValidateButton;
    private JButton fStopButton;
    private JButton fDetailsButton;
    private AbstractStyleGuidePanel fButtonPanel;
    private static final ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.toolbox.distcomp.ui.resources.RES_profile");
    private ValidationDetailsDialog fValidationDetailsDialog;

    public ValidationPanel(Profile profile, String string, ValidationManager validationManager) {
        this.fProfile = profile;
        this.fSchedulerType = string;
        this.fStageResults = new EnumMap<ValidationStage, ValidationResults>(ValidationStage.class);
        this.initializeStageResults();
        this.fValidationDetailsDialog = new ValidationDetailsDialog(this.fProfile.getName(), this.fSchedulerType, this.fStageResults);
        this.fOverallStatusLabel = new MJLabel();
        this.updateOverallStatusLabel(ValidationStatus.NOT_RUN);
        this.createValidationResultsTableSection();
        this.createButtonSection(validationManager);
        this.setFocusCycleRoot(true);
        this.addLine(new JComponent[][]{{new MJLabel(sRes.getString("ValidationPanel.OverallStatusLabel")), this.fOverallStatusLabel}});
        this.addLine((JComponent)((Object)this.fTablePanel));
        this.addLine((JComponent)((Object)this.fButtonPanel));
        this.addLine(new JPanel(), 8);
        this.fDetailsButton.setName("DetailsButton");
        this.fValidateButton.setName("ValidationButton");
        this.fStopButton.setName("StopButton");
        this.fOverallStatusLabel.setName("OveralStatusLabel");
    }

    private void createValidationResultsTableSection() {
        this.fTablePanel = new TablePanel(new ValidationStageResultsTableModel(this.fStageResults), "ValidationTable");
        this.fTablePanel.setCustomRenderer(0, new StageTableCellRenderer());
        this.fTablePanel.setCustomRenderer(1, new StatusTableCellRenderer());
    }

    private void createButtonSection(final ValidationManager validationManager) {
        this.fValidateButton = new MJButton((Action)new MJAbstractAction(sRes.getString("ProfileManager.ValidateAction")){

            public void actionPerformed(ActionEvent actionEvent) {
                ValidationPanel.this.fValidateButton.setEnabled(false);
                validationManager.validate(ValidationPanel.this.fProfile);
            }
        });
        this.fStopButton = new MJButton((Action)new MJAbstractAction(sRes.getString("ProfileManager.StopValidateAction")){

            public void actionPerformed(ActionEvent actionEvent) {
                validationManager.stopValidate();
            }
        });
        this.fButtonPanel = new StyleGuidePanel();
        this.fDetailsButton = new MJButton((Action)new MJAbstractAction(sRes.getString("ValidationPanel.ShowDetailsButton")){

            public void actionPerformed(ActionEvent actionEvent) {
                ValidationPanel.this.fValidationDetailsDialog.getComponent().setVisible(true);
            }
        });
        this.fButtonPanel.addLine((JComponent[][])new JComponent[][]{{null, this.fValidateButton, this.fDetailsButton}}, 0, 0);
    }

    private void updateButtonPanel(boolean bl) {
        if (bl) {
            this.fButtonPanel.removeAll();
            this.fButtonPanel.addLine((JComponent[][])new JComponent[][]{{null, this.fStopButton, this.fDetailsButton}}, 0, 0);
        } else {
            this.fValidateButton.setEnabled(true);
            this.fButtonPanel.removeAll();
            this.fButtonPanel.addLine((JComponent[][])new JComponent[][]{{null, this.fValidateButton, this.fDetailsButton}}, 0, 0);
        }
    }

    private void updateOverallStatusLabel(ValidationStatus validationStatus) {
        String string = validationStatus.getDisplayString();
        this.fOverallStatusLabel.setText(string);
        Icon icon = ValidationPanel.getStatusIcon(validationStatus);
        this.fOverallStatusLabel.setIcon(icon);
    }

    @Override
    public void handleValidationStarted(final ValidationEventData validationEventData) {
        if (validationEventData.getProfileName().equals(this.fProfile.getName())) {
            this.initializeStageResults();
            MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    ValidationPanel.this.updateOverallStatusLabel(validationEventData.getResults().getStatus());
                    ValidationPanel.this.updateButtonPanel(true);
                    ValidationPanel.this.fTablePanel.updateTable();
                    ValidationPanel.this.fValidationDetailsDialog.updateDetails(ValidationPanel.this.fProfile.getName(), ValidationPanel.this.fSchedulerType, ValidationPanel.this.fStageResults);
                }
            });
        }
    }

    @Override
    public void handleValidationFinished(final ValidationEventData validationEventData) {
        if (validationEventData.getResults().getStatus().equals((Object)ValidationStatus.STOPPED)) {
            this.updateStageResultsToStopped();
        }
        if (validationEventData.getProfileName().equals(this.fProfile.getName())) {
            MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    ValidationPanel.this.updateOverallStatusLabel(validationEventData.getResults().getStatus());
                    ValidationPanel.this.updateButtonPanel(false);
                    ValidationPanel.this.fTablePanel.updateTable();
                    ValidationPanel.this.fValidationDetailsDialog.updateDetails(ValidationPanel.this.fProfile.getName(), ValidationPanel.this.fSchedulerType, ValidationPanel.this.fStageResults);
                }
            });
        }
    }

    @Override
    public void handleValidationStageUpdated(ValidationEventData validationEventData) {
        if (validationEventData.getProfileName().equals(this.fProfile.getName())) {
            this.updateStageResults(validationEventData.getStage(), validationEventData.getResults());
            MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    ValidationPanel.this.fTablePanel.updateTable();
                    ValidationPanel.this.fValidationDetailsDialog.updateDetails(ValidationPanel.this.fProfile.getName(), ValidationPanel.this.fSchedulerType, ValidationPanel.this.fStageResults);
                }
            });
        }
    }

    private void initializeStageResults() {
        this.fStageResults.put(ValidationStage.PARCLUSTER, null);
        this.fStageResults.put(ValidationStage.INDEPENDENT_JOB, null);
        this.fStageResults.put(ValidationStage.COMMUNICATING_POOL_JOB, null);
        this.fStageResults.put(ValidationStage.COMMUNICATING_SPMD_JOB, null);
        this.fStageResults.put(ValidationStage.MATLABPOOL, null);
    }

    private void updateStageResults(ValidationStage validationStage, ValidationResults validationResults) {
        this.fStageResults.put(validationStage, validationResults);
    }

    private void updateStageResultsToStopped() {
        for (ValidationStage validationStage : this.fStageResults.keySet()) {
            ValidationResults validationResults = this.fStageResults.get((Object)validationStage);
            if (validationResults == null || !validationResults.getStatus().equals((Object)ValidationStatus.RUNNING)) continue;
            this.updateStageResults(validationStage, new ValidationResults(ValidationStatus.STOPPED, "Validation stopped", "", "", ""));
        }
    }

    private static Icon getStatusIcon(ValidationStatus validationStatus) {
        Icon icon = null;
        switch (validationStatus) {
            case NOT_RUN: {
                icon = ParallelIcon.NOT_RUN.getIcon();
                break;
            }
            case RUNNING: {
                icon = ParallelIcon.RUNNING.getIcon();
                break;
            }
            case PASSED: {
                icon = ParallelIcon.PASSED.getIcon();
                break;
            }
            case FAILED: {
                icon = ParallelIcon.FAILED.getIcon();
                break;
            }
            case SKIPPED: {
                icon = ParallelIcon.SKIPPED.getIcon();
                break;
            }
            case STOPPED: {
                icon = ParallelIcon.STOPPED.getIcon();
                break;
            }
            default: {
                assert (false) : "Unknown validation status = " + (Object)((Object)validationStatus);
                break;
            }
        }
        return icon;
    }

    @Override
    public void destroy() {
        this.fProfile = null;
    }

    private static final class StatusTableCellRenderer
    extends DefaultTableCellRenderer {
        private Icon fStatusRunningIcon;

        private StatusTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(final JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            ValidationStatus validationStatus = (ValidationStatus)((Object)object);
            String string = validationStatus.getDisplayString();
            Icon icon = ValidationPanel.getStatusIcon(validationStatus);
            if (this.fStatusRunningIcon == null) {
                this.fStatusRunningIcon = ParallelIcon.RUNNING.getIcon();
                ((ImageIcon)this.fStatusRunningIcon).setImageObserver(new ImageObserver(){

                    @Override
                    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
                        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                jTable.repaint();
                            }
                        });
                        return true;
                    }
                });
            }
            if (validationStatus.equals((Object)ValidationStatus.RUNNING)) {
                icon = this.fStatusRunningIcon;
            }
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            ((JLabel)component).setText(string);
            ((JLabel)component).setIcon(icon);
            return component;
        }
    }

    private static final class StageTableCellRenderer
    extends DefaultTableCellRenderer {
        private StageTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            ValidationStage validationStage = (ValidationStage)((Object)object);
            String string = validationStage.getDisplayString();
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            ((JLabel)component).setText(string);
            return component;
        }
    }

    private static final class ValidationStageResultsTableModel
    extends AbstractTableModel {
        private static final int STAGE_COLUMN = 0;
        private static final int STATUS_COLUMN = 1;
        private static final int DESCRIPTION_COLUMN = 2;
        private static final int PARCLUSTER_ROW = 0;
        private static final int INDEPENDENT_JOB_ROW = 1;
        private static final int COMMUNICATING_SPMD_JOB_ROW = 2;
        private static final int COMMUNICATING_POOL_JOB_ROW = 3;
        private static final int MATLABPOOL_ROW = 4;
        private Map<ValidationStage, ValidationResults> fStageResults;

        private ValidationStageResultsTableModel(Map<ValidationStage, ValidationResults> map) {
            this.fStageResults = map;
        }

        @Override
        public int getRowCount() {
            return this.fStageResults.size();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public String getColumnName(int n) {
            String string;
            if (n == 0) {
                string = sRes.getString("ValidationPanel.StageTableColumn");
            } else if (n == 1) {
                string = sRes.getString("ValidationPanel.StatusTableColumn");
            } else if (n == 2) {
                string = sRes.getString("ValidationPanel.DescriptionTableColumn");
            } else {
                assert (false) : "Unknown column index " + n;
                string = super.getColumnName(n);
            }
            return string;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            ValidationStage validationStage = null;
            if (n == 0) {
                validationStage = ValidationStage.PARCLUSTER;
            } else if (n == 1) {
                validationStage = ValidationStage.INDEPENDENT_JOB;
            } else if (n == 2) {
                validationStage = ValidationStage.COMMUNICATING_SPMD_JOB;
            } else if (n == 3) {
                validationStage = ValidationStage.COMMUNICATING_POOL_JOB;
            } else if (n == 4) {
                validationStage = ValidationStage.MATLABPOOL;
            }
            if (n2 == 0) {
                return validationStage;
            }
            ValidationResults validationResults = this.fStageResults.get((Object)validationStage);
            if (n2 == 1) {
                return validationResults != null ? validationResults.getStatus() : ValidationStatus.NOT_RUN;
            }
            if (n2 == 2) {
                return validationResults != null && !validationResults.getStatus().equals((Object)ValidationStatus.RUNNING) && !validationResults.getStatus().equals((Object)ValidationStatus.PASSED) ? validationResults.getDescription() : "";
            }
            assert (false) : "Unknown column index " + n2;
            return "";
        }
    }
}

