/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.ui.profile.model;

import com.mathworks.toolbox.distcomp.ui.model.DefaultValue;
import com.mathworks.toolbox.distcomp.ui.model.Destroyable;
import com.mathworks.toolbox.distcomp.ui.model.Property;
import java.util.Collections;
import java.util.List;

public final class Profile
implements Destroyable,
Comparable<Profile> {
    private String fName;
    private final List<Property> fProperties;
    public static final String DESCRIPTION_PROPERTY = "Description";
    private static final String SCHEDULER_COMPONENT_PROPERTY = "SchedulerComponent";
    private static final String PROJECT_COMPONENT_PROPERTY = "ProjectComponent";

    public Profile(String string, List<Property> list) {
        this.fName = string;
        this.fProperties = list;
    }

    public String getSchedulerComponent() {
        Property property = this.findProperty(SCHEDULER_COMPONENT_PROPERTY);
        return (String)property.getValue();
    }

    public void setSchedulerComponent(String string) {
        Property property = this.findProperty(SCHEDULER_COMPONENT_PROPERTY);
        property.setValue(string);
    }

    public String getProjectComponent() {
        Property property = this.findProperty(PROJECT_COMPONENT_PROPERTY);
        Object object = property.getValue();
        return object instanceof DefaultValue ? "" : (String)object;
    }

    public void setProjectComponent(String string) {
        Property property = this.findProperty(PROJECT_COMPONENT_PROPERTY);
        property.setValue(string);
    }

    public String getName() {
        return this.fName;
    }

    public void setName(String string) {
        this.fName = string;
    }

    public List<Property> getProperties() {
        return Collections.unmodifiableList(this.fProperties);
    }

    public Property findProperty(String string) {
        for (Property property : this.getProperties()) {
            if (!property.getPropertyInfo().getName().equals(string)) continue;
            return property;
        }
        return null;
    }

    @Override
    public void destroy() {
        for (Property property : this.fProperties) {
            property.destroy();
        }
        this.fProperties.clear();
    }

    @Override
    public int compareTo(Profile profile) {
        return this.getName().compareToIgnoreCase(profile.getName());
    }
}

