/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.ui.widget;

import com.mathworks.mwswing.MJFormattedTextField;
import com.mathworks.toolbox.distcomp.ui.ClickAwayFocusListener;
import com.mathworks.toolbox.distcomp.ui.model.DefaultValue;
import com.mathworks.toolbox.distcomp.ui.model.Property;
import com.mathworks.toolbox.distcomp.ui.widget.ConfigurablePropertyView;
import com.mathworks.toolbox.distcomp.ui.widget.GlassPaneTextContextMenu;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JPopupMenu;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;

public final class IntegerView
extends ConfigurablePropertyView {
    private static final String INF = "inf";
    private static final String EMPTY_VALUE = "";

    public IntegerView(Property property, String string) {
        super(property, IntegerView.createUI(property), string, true);
    }

    private static JComponent createUI(final Property property) {
        IntegerStringFormatter integerStringFormatter = new IntegerStringFormatter();
        final MJFormattedTextField mJFormattedTextField = new MJFormattedTextField((JFormattedTextField.AbstractFormatter)integerStringFormatter);
        int n = (int)mJFormattedTextField.getPreferredSize().getHeight();
        mJFormattedTextField.setMinimumSize(new Dimension(210, n));
        mJFormattedTextField.setMaximumSize(new Dimension(210, n));
        mJFormattedTextField.setSize(new Dimension(210, n));
        mJFormattedTextField.setPreferredSize(new Dimension(210, n));
        mJFormattedTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IntegerView.updatePropertyValue(property, mJFormattedTextField);
                mJFormattedTextField.getParent().requestFocus();
            }
        });
        mJFormattedTextField.addFocusListener((FocusListener)new ClickAwayFocusListener((JComponent)mJFormattedTextField, new Runnable(){

            @Override
            public void run() {
                IntegerView.updatePropertyValue(property, mJFormattedTextField);
            }
        }));
        mJFormattedTextField.addContextMenu((JPopupMenu)((Object)new GlassPaneTextContextMenu()));
        return mJFormattedTextField;
    }

    @Override
    void updateUI(JComponent jComponent, Object object) {
        ((JFormattedTextField)jComponent).setValue(object);
    }

    @Override
    void commitEdit() {
        Property property = this.getProperty();
        MJFormattedTextField mJFormattedTextField = (MJFormattedTextField)this.getActualComponent();
        IntegerView.updatePropertyValue(property, mJFormattedTextField);
    }

    private static void updatePropertyValue(Property property, MJFormattedTextField mJFormattedTextField) {
        block4: {
            try {
                mJFormattedTextField.commitEdit();
                Object object = mJFormattedTextField.getValue();
                if (EMPTY_VALUE.equals(object)) {
                    property.unsetValue();
                } else {
                    property.setValue(object);
                }
            }
            catch (ParseException parseException) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError((Object)parseException);
            }
        }
    }

    private static class IntStringFilter
    extends DocumentFilter {
        private IntStringFilter() {
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass filterBypass, int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (IntStringFilter.isDigit(string)) {
                filterBypass.insertString(n, string, attributeSet);
            } else if (n == 0 && string.equals("i")) {
                filterBypass.insertString(n, string, attributeSet);
            } else if (n == 1 && string.equals("n")) {
                filterBypass.insertString(n, string, attributeSet);
            } else if (n == 2 && string.equals("f")) {
                filterBypass.insertString(n, string, attributeSet);
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }

        @Override
        public void replace(DocumentFilter.FilterBypass filterBypass, int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
            if (IntStringFilter.isDigit(string)) {
                filterBypass.replace(n, n2, string, attributeSet);
            } else if (n == 0 && string.equals("i")) {
                filterBypass.replace(n, n2, string, attributeSet);
            } else if (n == 1 && string.equals("n")) {
                filterBypass.replace(n, n2, string, attributeSet);
            } else if (n == 2 && string.equals("f")) {
                filterBypass.replace(n, n2, string, attributeSet);
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }

        private static boolean isDigit(String string) {
            try {
                Integer.parseInt(string);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
    }

    private static class IntegerStringFormatter
    extends JFormattedTextField.AbstractFormatter {
        private IntStringFilter fIntStringFilter = new IntStringFilter();

        private IntegerStringFormatter() {
        }

        @Override
        public Object stringToValue(String string) throws ParseException {
            if (string == null) {
                return IntegerView.EMPTY_VALUE;
            }
            if ((string = string.trim()).length() == 0) {
                return IntegerView.EMPTY_VALUE;
            }
            try {
                return Double.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                return Double.POSITIVE_INFINITY;
            }
        }

        @Override
        public String valueToString(Object object) throws ParseException {
            if (object == null || object instanceof DefaultValue || object == IntegerView.EMPTY_VALUE) {
                return IntegerView.EMPTY_VALUE;
            }
            if (object.equals(Double.POSITIVE_INFINITY)) {
                return IntegerView.INF;
            }
            NumberFormat numberFormat = NumberFormat.getNumberInstance();
            numberFormat.setParseIntegerOnly(true);
            numberFormat.setGroupingUsed(false);
            return numberFormat.format(object);
        }

        @Override
        protected DocumentFilter getDocumentFilter() {
            return this.fIntStringFilter;
        }
    }
}

