/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.util.securesocket;

import com.mathworks.toolbox.distcomp.util.securesocket.SSLByteChannel;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SocketChannel;
import javax.net.ssl.SSLEngine;

public final class SSLSocketChannel
implements ByteChannel,
ScatteringByteChannel,
GatheringByteChannel {
    private final SocketChannel fSocketChannel;
    private final SSLByteChannel fSSLByteChannel;

    public SSLSocketChannel(SocketChannel socketChannel, SSLEngine sSLEngine) {
        this.fSocketChannel = socketChannel;
        this.fSSLByteChannel = new SSLByteChannel(socketChannel, sSLEngine);
    }

    public SelectableChannel getSelectableChannel() {
        return this.fSocketChannel;
    }

    @Override
    public long write(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        return this.fSSLByteChannel.write(byteBufferArray, n, n2);
    }

    @Override
    public long write(ByteBuffer[] byteBufferArray) throws IOException {
        return this.fSSLByteChannel.write(byteBufferArray);
    }

    @Override
    public int write(ByteBuffer byteBuffer) throws IOException {
        return this.fSSLByteChannel.write(byteBuffer);
    }

    @Override
    public long read(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        return this.fSSLByteChannel.read(byteBufferArray, n, n2);
    }

    @Override
    public long read(ByteBuffer[] byteBufferArray) throws IOException {
        return this.fSSLByteChannel.read(byteBufferArray);
    }

    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        return this.fSSLByteChannel.read(byteBuffer);
    }

    public String toString() {
        return "SSLSocketChannel{fSSLEngineManager=" + this.fSSLByteChannel + ", fSocketChannel=" + this.fSocketChannel + '}';
    }

    @Override
    public boolean isOpen() {
        return this.fSSLByteChannel.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.fSSLByteChannel.close();
    }

    public InetSocketAddress getRemoteSocketAddress() {
        return (InetSocketAddress)this.fSocketChannel.socket().getRemoteSocketAddress();
    }

    public InetSocketAddress getLocalSocketAddress() {
        return (InetSocketAddress)this.fSocketChannel.socket().getLocalSocketAddress();
    }
}

