/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.worker.matlab;

import com.mathworks.toolbox.distcomp.logging.DistcompLevel;
import com.mathworks.toolbox.distcomp.util.concurrent.SignalingAtomicBoolean;
import com.mathworks.toolbox.distcomp.worker.matlab.ImmediateShutdownInitiator;
import com.mathworks.toolbox.distcomp.worker.matlab.PackageInfo;
import com.mathworks.toolbox.distcomp.worker.matlab.ProcessShepherd;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class ScheduledShutdownInitiator
extends ImmediateShutdownInitiator {
    private final ScheduledExecutorService fMatlabShutdownTimerExecutor = Executors.newSingleThreadScheduledExecutor();
    private ScheduledFuture<?> fTimedShutdownTask = null;
    private AtomicBoolean fHaveValidTimedShutdownTask = new AtomicBoolean(false);
    private AtomicBoolean fDoNotAttemptScheduledShutdown = new AtomicBoolean(false);
    private SignalingAtomicBoolean fScheduledShutdownTaskIsRunning = new SignalingAtomicBoolean(false);

    public ScheduledShutdownInitiator(ProcessShepherd processShepherd) {
        super(processShepherd);
    }

    @Override
    public synchronized void scheduleMatlabShutdown(long l) {
        PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Creating scheduled shutdown timer task to shutdown MATLAB in " + l + " seconds");
        this.scheduleMatlabTimedShutdown(l);
    }

    @Override
    public synchronized boolean cancelScheduledShutdown() {
        return this.cancelAnyActiveMatlabTimedShutdown();
    }

    private Runnable makeTimedShutdownCallback() {
        return new Runnable(){

            @Override
            public void run() {
                ScheduledShutdownInitiator.this.fScheduledShutdownTaskIsRunning.set(true);
                if (!ScheduledShutdownInitiator.this.fDoNotAttemptScheduledShutdown.get()) {
                    if (!ScheduledShutdownInitiator.this.isShutdownInProgress()) {
                        ScheduledShutdownInitiator.this.shutdownMatlab();
                        ScheduledShutdownInitiator.this.fHaveValidTimedShutdownTask.set(false);
                        PackageInfo.LOGGER.log(DistcompLevel.TWO, "MATLAB shutdown because timeout reached");
                    }
                } else {
                    PackageInfo.LOGGER.log(DistcompLevel.SIX, "Scheduled shutdown: Task running but requested to skip MATLAB shutdown");
                }
                ScheduledShutdownInitiator.this.fScheduledShutdownTaskIsRunning.set(false);
            }
        };
    }

    private void scheduleMatlabTimedShutdown(long l) {
        if (this.cancelAnyActiveMatlabTimedShutdown()) {
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "Forced cancellation of already running shutdown timer task");
        }
        this.fScheduledShutdownTaskIsRunning.set(false);
        this.fDoNotAttemptScheduledShutdown.set(false);
        this.fTimedShutdownTask = this.fMatlabShutdownTimerExecutor.schedule(this.makeTimedShutdownCallback(), l, TimeUnit.SECONDS);
        this.fHaveValidTimedShutdownTask.set(true);
    }

    private boolean cancelAnyActiveMatlabTimedShutdown() {
        if (this.fHaveValidTimedShutdownTask.get()) {
            boolean bl = this.fTimedShutdownTask.cancel(false);
            this.fDoNotAttemptScheduledShutdown.set(true);
            if (bl) {
                this.waitForTimedShutdownTaskToCompleteIfNotAlreadyCancelled();
                return true;
            }
            this.fHaveValidTimedShutdownTask.set(false);
        }
        return false;
    }

    private void waitForTimedShutdownTaskToCompleteIfNotAlreadyCancelled() {
        try {
            this.fScheduledShutdownTaskIsRunning.awaitFalse();
            PackageInfo.LOGGER.log(DistcompLevel.TWO, "MATLAB scheduled shutdown task was cancelled (or completed normally)");
        }
        catch (InterruptedException interruptedException) {
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "Interrupt while waiting for scheduled shutdown task to complete");
            throw new RuntimeException(interruptedException);
        }
        finally {
            this.fHaveValidTimedShutdownTask.set(false);
        }
    }
}

