/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.workunit;

import com.mathworks.toolbox.distcomp.workunit.TaskAttemptIdentifier;
import com.mathworks.toolbox.distcomp.workunit.TaskImpl;
import java.io.Serializable;
import net.jini.id.Uuid;
import net.jini.id.UuidFactory;

public final class JobAndTaskIdentifier
implements Serializable {
    private final Uuid fJobID;
    private final TaskAttemptIdentifier fTaskAttempt;
    private final boolean fAreValid;

    public JobAndTaskIdentifier(Uuid uuid, TaskAttemptIdentifier taskAttemptIdentifier) {
        assert (uuid != null) : "jobID was null";
        assert (taskAttemptIdentifier != null) : "taskAttempt was null";
        this.fJobID = uuid;
        this.fTaskAttempt = taskAttemptIdentifier;
        this.fAreValid = true;
    }

    public JobAndTaskIdentifier(Uuid uuid, TaskImpl taskImpl) {
        assert (uuid != null) : "jobID was null";
        assert (taskImpl != null) : "task was null";
        this.fJobID = uuid;
        this.fTaskAttempt = new TaskAttemptIdentifier(taskImpl.getID(), taskImpl.getAttemptedNumberOfRetries());
        this.fAreValid = true;
    }

    public JobAndTaskIdentifier(Uuid uuid, Uuid uuid2) {
        assert (uuid != null) : "jobID was null";
        assert (uuid2 != null) : "taskID was null";
        this.fJobID = uuid;
        this.fTaskAttempt = new TaskAttemptIdentifier(uuid2);
        this.fAreValid = true;
    }

    public JobAndTaskIdentifier() {
        this.fJobID = UuidFactory.generate();
        this.fTaskAttempt = new TaskAttemptIdentifier(UuidFactory.generate());
        this.fAreValid = false;
    }

    public Uuid getJobID() {
        return this.fJobID;
    }

    public TaskAttemptIdentifier getTaskAttemptIdentifier() {
        return this.fTaskAttempt;
    }

    public boolean areValid() {
        return this.fAreValid;
    }

    public Uuid getTaskID() {
        return this.fTaskAttempt.getTaskID();
    }

    public boolean isSameJob(JobAndTaskIdentifier jobAndTaskIdentifier) {
        return jobAndTaskIdentifier != null && this.fAreValid && jobAndTaskIdentifier.fAreValid && this.fJobID.equals((Object)jobAndTaskIdentifier.fJobID);
    }

    public boolean isSameTaskAttempt(JobAndTaskIdentifier jobAndTaskIdentifier) {
        return this.isSameJob(jobAndTaskIdentifier) && this.fTaskAttempt.isSameAttempt(jobAndTaskIdentifier.fTaskAttempt);
    }

    public String toString() {
        if (this.areValid()) {
            return "JobAndTaskIdentifier{fJobID=" + this.fJobID + ", fTaskAttempt=" + this.fTaskAttempt + '}';
        }
        return "Invalid JobAndTaskIdentifier";
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof JobAndTaskIdentifier)) {
            return false;
        }
        JobAndTaskIdentifier jobAndTaskIdentifier = (JobAndTaskIdentifier)object;
        return !this.fAreValid && !jobAndTaskIdentifier.fAreValid || this.fJobID.equals((Object)jobAndTaskIdentifier.fJobID) && this.fTaskAttempt.equals(jobAndTaskIdentifier.fTaskAttempt);
    }

    public int hashCode() {
        return this.fJobID.hashCode() ^ this.fTaskAttempt.hashCode();
    }
}

