/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.workunit;

import com.mathworks.toolbox.distcomp.distcompobjects.ListenerInfo;
import com.mathworks.toolbox.distcomp.mjs.datastore.LargeData;
import com.mathworks.toolbox.distcomp.workunit.DistcompListenableInfo;
import com.mathworks.toolbox.distcomp.workunit.JobInfo;
import com.mathworks.toolbox.distcomp.workunit.TaskInfo;
import java.util.Date;

public abstract class WorkUnitInfo
extends DistcompListenableInfo {
    protected String fName;
    protected long fTimeout = Long.MAX_VALUE;
    protected long fNum;
    protected int fState = 0;
    protected long fCreateTime = -1L;
    protected long fStartTime = -1L;
    protected long fFinishTime = -1L;
    protected long fRunningDuration = 0L;

    protected WorkUnitInfo() {
    }

    protected WorkUnitInfo(String string, long l, long l2, int n, long l3, long l4, long l5, long l6, ListenerInfo[] listenerInfoArray) {
        super(listenerInfoArray);
        this.fName = string;
        this.fTimeout = l;
        this.fNum = l2;
        this.fState = n;
        this.fCreateTime = l3;
        this.fStartTime = l4;
        this.fFinishTime = l5;
        this.fRunningDuration = l6;
    }

    protected WorkUnitInfo(long l) {
        this.fStartTime = l;
    }

    protected WorkUnitInfo(String string, long l, ListenerInfo[] listenerInfoArray) {
        super(listenerInfoArray);
        this.fName = string;
        this.fTimeout = l;
    }

    public String getName() {
        return this.fName;
    }

    public long getTimeout() {
        return this.fTimeout;
    }

    public long getNum() {
        return this.fNum;
    }

    public int getState() {
        return this.fState;
    }

    public Date getCreateTime() {
        return this.fCreateTime == -1L ? null : new Date(this.fCreateTime);
    }

    public Date getStartTime() {
        return this.fStartTime == -1L ? null : new Date(this.fStartTime);
    }

    public Date getFinishTime() {
        return this.fFinishTime == -1L ? null : new Date(this.fFinishTime);
    }

    public long getRunningDuration() {
        return this.fRunningDuration;
    }

    public void setCreateTime(long l) {
        this.fCreateTime = l;
    }

    public void setFinishTime(long l) {
        this.fFinishTime = l;
    }

    public void setRunningDuration(long l) {
        this.fRunningDuration = l;
    }

    public void setName(String string) {
        this.fName = string;
    }

    public void setNum(long l) {
        this.fNum = l;
    }

    public void setStartTime(long l) {
        this.fStartTime = l;
    }

    public void setState(int n) {
        this.fState = n;
    }

    public void setTimeout(long l) {
        this.fTimeout = l;
    }

    public static LargeData[] getWorkUnitInfoLargeDataItems(WorkUnitInfo[] workUnitInfoArray) {
        LargeData[] largeDataArray;
        if (workUnitInfoArray instanceof JobInfo[]) {
            JobInfo[] jobInfoArray = (JobInfo[])workUnitInfoArray;
            largeDataArray = new LargeData[2 * workUnitInfoArray.length];
            for (int i = 0; i < jobInfoArray.length; ++i) {
                largeDataArray[i] = jobInfoArray[i].getFileDepData();
                largeDataArray[i + jobInfoArray.length] = jobInfoArray[i].getJobScopeData();
            }
        } else if (workUnitInfoArray instanceof TaskInfo[]) {
            TaskInfo[] taskInfoArray = (TaskInfo[])workUnitInfoArray;
            largeDataArray = new LargeData[5 * workUnitInfoArray.length];
            for (int i = 0; i < taskInfoArray.length; ++i) {
                largeDataArray[i] = taskInfoArray[i].getInputData();
                largeDataArray[i + taskInfoArray.length] = taskInfoArray[i].getMLFunction();
                largeDataArray[i + 2 * taskInfoArray.length] = taskInfoArray[i].getOutputData();
                largeDataArray[i + 3 * taskInfoArray.length] = taskInfoArray[i].getCommandWindowOutput();
                largeDataArray[i + 4 * taskInfoArray.length] = taskInfoArray[i].getLogOutput();
            }
        } else {
            throw new IllegalArgumentException("Can only get large data items for jobInfo or taskInfo objects");
        }
        return largeDataArray;
    }

    public static void setWorkUnitInfoLargeDataItems(WorkUnitInfo[] workUnitInfoArray, LargeData[] largeDataArray) {
        if (workUnitInfoArray instanceof JobInfo[]) {
            JobInfo[] jobInfoArray = (JobInfo[])workUnitInfoArray;
            for (int i = 0; i < jobInfoArray.length; ++i) {
                jobInfoArray[i].setFileDepData(largeDataArray[i]);
                jobInfoArray[i].setJobScopeData(largeDataArray[i + jobInfoArray.length]);
            }
        } else if (workUnitInfoArray instanceof TaskInfo[]) {
            TaskInfo[] taskInfoArray = (TaskInfo[])workUnitInfoArray;
            for (int i = 0; i < taskInfoArray.length; ++i) {
                taskInfoArray[i].setInputData(largeDataArray[i]);
                taskInfoArray[i].setMLFunction(largeDataArray[i + taskInfoArray.length]);
                taskInfoArray[i].setOutputData(largeDataArray[i + 2 * taskInfoArray.length]);
                taskInfoArray[i].setCommandWindowOutput(largeDataArray[i + 3 * taskInfoArray.length]);
                taskInfoArray[i].setLogOutput(largeDataArray[i + 4 * taskInfoArray.length]);
            }
        } else {
            throw new IllegalArgumentException("Can only get large data items for jobInfo or taskInfo objects");
        }
    }
}

