/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseElement;
import org.netbeans.editor.InvalidMarkException;
import org.netbeans.editor.Mark;
import org.netbeans.editor.Utilities;

public class LeafElement
extends BaseElement {
    protected Mark startMark;
    protected Mark endMark;
    protected boolean bol;
    protected boolean eol;

    public LeafElement(BaseDocument baseDocument, BaseElement baseElement, AttributeSet attributeSet, int n, int n2, boolean bl, boolean bl2) {
        super(baseDocument, baseElement, attributeSet);
        this.bol = bl;
        this.eol = bl2;
        try {
            this.startMark = new Mark(true);
            this.endMark = new Mark(false);
            this.startMark.insert(baseDocument, n);
            this.endMark.insert(baseDocument, n2);
        }
        catch (BadLocationException badLocationException) {
            Utilities.annotateLoggable(badLocationException);
        }
        catch (InvalidMarkException invalidMarkException) {
            throw new IllegalStateException(invalidMarkException.toString());
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.startMark.remove();
            this.endMark.remove();
        }
        catch (InvalidMarkException invalidMarkException) {
            // empty catch block
        }
        super.finalize();
    }

    @Override
    public final Mark getStartMark() {
        return this.startMark;
    }

    @Override
    public final int getStartOffset() {
        try {
            return this.startMark.getOffset();
        }
        catch (InvalidMarkException invalidMarkException) {
            return 0;
        }
    }

    @Override
    public final Mark getEndMark() {
        return this.endMark;
    }

    @Override
    public final int getEndOffset() {
        try {
            return this.endMark.getOffset();
        }
        catch (InvalidMarkException invalidMarkException) {
            return 0;
        }
    }

    public final boolean isBOL() {
        return this.bol;
    }

    public final boolean isEOL() {
        return this.eol;
    }

    @Override
    public int getElementIndex(int n) {
        return -1;
    }

    @Override
    public int getElementCount() {
        return 0;
    }

    @Override
    public Element getElement(int n) {
        return null;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    public String toString() {
        return "startOffset=" + this.getStartOffset() + ", endOffset=" + this.getEndMark();
    }
}

