/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.util.HashMap;
import org.netbeans.editor.TokenCategory;
import org.netbeans.editor.TokenContext;

public final class TokenContextPath {
    private static final HashMap registry = new HashMap(199);
    private TokenContext[] contexts;
    private TokenContextPath parent;
    private TokenContextPath base;
    private String namePrefix;
    private final HashMap tokenNameCache = new HashMap();
    private final HashMap replaceStartCache = new HashMap();

    static synchronized TokenContextPath get(TokenContext[] tokenContextArray) {
        if (tokenContextArray == null || tokenContextArray.length == 0) {
            throw new IllegalArgumentException("Contexts must be valid and non-empty.");
        }
        ArrayMatcher arrayMatcher = new ArrayMatcher(tokenContextArray);
        TokenContextPath tokenContextPath = (TokenContextPath)registry.get(arrayMatcher);
        if (tokenContextPath == null) {
            tokenContextPath = new TokenContextPath(tokenContextArray);
            registry.put(arrayMatcher, tokenContextPath);
        }
        return tokenContextPath;
    }

    private TokenContextPath(TokenContext[] tokenContextArray) {
        this.contexts = tokenContextArray;
        if (tokenContextArray.length == 1) {
            this.base = this;
        }
    }

    public TokenContext[] getContexts() {
        return this.contexts;
    }

    public int length() {
        return this.contexts.length;
    }

    public TokenContextPath getParent() {
        if (this.parent == null && this.contexts.length > 1) {
            TokenContext[] tokenContextArray = new TokenContext[this.contexts.length - 1];
            System.arraycopy(this.contexts, 0, tokenContextArray, 0, this.contexts.length - 1);
            this.parent = TokenContextPath.get(tokenContextArray);
        }
        return this.parent;
    }

    public TokenContextPath getBase() {
        if (this.base == null) {
            this.base = this.getParent().getBase();
        }
        return this.base;
    }

    public boolean contains(TokenContextPath tokenContextPath) {
        if (tokenContextPath == this) {
            return true;
        }
        if (this.contexts.length > 1) {
            return this.getParent().contains(tokenContextPath);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TokenContextPath replaceStart(TokenContextPath tokenContextPath) {
        if (this.contexts.length < tokenContextPath.contexts.length) {
            throw new IllegalArgumentException("byPath=" + tokenContextPath + " is too long.");
        }
        HashMap hashMap = this.replaceStartCache;
        synchronized (hashMap) {
            TokenContextPath tokenContextPath2 = (TokenContextPath)this.replaceStartCache.get(tokenContextPath);
            if (tokenContextPath2 == null) {
                TokenContext[] tokenContextArray = (TokenContext[])this.contexts.clone();
                for (int i = tokenContextPath.contexts.length - 1; i >= 0; --i) {
                    tokenContextArray[i] = tokenContextPath.contexts[i];
                }
                tokenContextPath2 = TokenContextPath.get(tokenContextArray);
                this.replaceStartCache.put(tokenContextPath, tokenContextPath2);
            }
            return tokenContextPath2;
        }
    }

    public String getNamePrefix() {
        if (this.namePrefix == null) {
            this.namePrefix = this.contexts.length == 1 ? this.contexts[0].getNamePrefix() : (this.contexts[this.contexts.length - 1].getNamePrefix() + this.getParent().getNamePrefix()).intern();
        }
        return this.namePrefix;
    }

    public String getFullTokenName(TokenCategory tokenCategory) {
        return this.getFullTokenName(tokenCategory.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFullTokenName(String string) {
        String string2;
        HashMap hashMap = this.tokenNameCache;
        synchronized (hashMap) {
            string2 = (String)this.tokenNameCache.get(string);
            if (string2 == null) {
                string2 = (this.getNamePrefix() + string).intern();
                this.tokenNameCache.put(string, string2);
            }
        }
        return string2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("|");
        for (int i = 0; i < this.contexts.length; ++i) {
            String string = this.contexts[i].getClass().getName();
            string = string.substring(string.lastIndexOf(46) + 1);
            stringBuffer.append('<');
            stringBuffer.append(string);
            stringBuffer.append('>');
        }
        stringBuffer.append('|');
        return stringBuffer.toString();
    }

    private static final class ArrayMatcher {
        private int hash;
        private TokenContext[] contexts;

        ArrayMatcher(TokenContext[] tokenContextArray) {
            this.contexts = tokenContextArray;
        }

        public int hashCode() {
            int n = this.hash;
            if (n == 0) {
                for (int i = this.contexts.length - 1; i >= 0; --i) {
                    n = n * 31 + this.contexts[i].hashCode();
                }
                this.hash = n;
            }
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof ArrayMatcher) {
                ArrayMatcher arrayMatcher = (ArrayMatcher)object;
                if (this.contexts.length == arrayMatcher.contexts.length) {
                    for (int i = this.contexts.length - 1; i >= 0; --i) {
                        if (this.contexts[i].equals(arrayMatcher.contexts[i])) continue;
                        return false;
                    }
                    return true;
                }
            }
            return false;
        }
    }
}

