/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.html;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JList;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.SyntaxSupport;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.CompletionQuery;
import org.netbeans.editor.ext.ExtFormatter;
import org.netbeans.editor.ext.html.HTMLCompletionResultItemPaintComponent;
import org.netbeans.editor.ext.html.HTMLSettingsDefaults;
import org.netbeans.editor.ext.html.HTMLSyntaxSupport;
import org.netbeans.editor.ext.html.HTMLTokenContext;
import org.netbeans.editor.ext.html.SyntaxElement;
import org.netbeans.editor.ext.html.dtd.DTD;

public class HTMLCompletionQuery
implements CompletionQuery {
    private static boolean lowerCase;
    private static final HTMLCompletionQuery DEFAULT;

    public static HTMLCompletionQuery getDefault() {
        return DEFAULT;
    }

    @Override
    public CompletionQuery.Result query(JTextComponent jTextComponent, int n, SyntaxSupport syntaxSupport) {
        Class clazz = Utilities.getKitClass(jTextComponent);
        BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
        return this.query(jTextComponent, clazz, baseDocument, n, syntaxSupport);
    }

    /*
     * Unable to fully structure code
     */
    CompletionQuery.Result query(JTextComponent var1_1, Class var2_2, BaseDocument var3_3, int var4_4, SyntaxSupport var5_5) {
        if (var2_2 != null) {
            HTMLCompletionQuery.lowerCase = SettingsUtil.getBoolean(var2_2, "completion-lower-case", HTMLSettingsDefaults.defaultCompletionLowerCase);
        }
        if (var3_3.getLength() == 0) {
            return null;
        }
        var6_6 = (HTMLSyntaxSupport)var5_5.get(HTMLSyntaxSupport.class);
        if (var6_6 == null) {
            return null;
        }
        var7_7 = var6_6.getDTD();
        if (var7_7 == null) {
            return null;
        }
        try {
            block62: {
                block60: {
                    block61: {
                        var8_8 = null;
                        var9_10 = null;
                        var10_11 = false;
                        var8_8 = var6_6.getTokenChain(var4_4, var4_4 + 1);
                        if (var8_8 == null) break block60;
                        var9_10 = var8_8.getPrevious();
                        if (var9_10 == null) break block61;
                        var11_12 = var9_10;
                        var12_14 = var11_12.getImage();
                        if (var11_12 == null) ** GOTO lbl-1000
                        if (HTMLSyntaxSupport.isTag(var11_12) && var11_12.getTokenID().getNumericID() == 6) {
                            for (var13_15 = var12_14.length() - 1; var13_15 > -1 && !Character.isLetter(var12_14.charAt(var13_15)); --var13_15) {
                            }
                        } else lbl-1000:
                        // 2 sources

                        {
                            var13_15 = -1;
                        }
                        block7: do {
                            if (var11_12.getTokenID() != HTMLTokenContext.TAG_OPEN && var11_12.getTokenID() != HTMLTokenContext.TAG_CLOSE) continue;
                            var12_14 = var11_12.getImage();
                            for (var14_17 = 0; var14_17 < var12_14.length(); ++var14_17) {
                                var15_18 = var12_14.charAt(var14_17);
                                if (!Character.isLetter((char)var15_18)) continue;
                                var13_15 = var14_17;
                                continue block7;
                            }
                        } while ((var11_12 = var11_12.getPrevious()) != null && var13_15 == -1);
                        HTMLCompletionQuery.lowerCase = var11_12 != null && var13_15 != -1 ? Character.isUpperCase(var12_14.charAt(var13_15)) == false : true;
                    }
                    var10_11 = var8_8.getOffset() < var4_4;
                    break block62;
                }
                var9_10 = var6_6.getTokenChain(var4_4 - 1, var4_4);
            }
            v0 = var11_13 = var9_10 == null && var10_11 == false;
            if (var11_13) {
                return null;
            }
            var12_14 = null;
            var13_16 = null;
            var14_17 = 1;
            var15_18 = 0;
            var16_19 = null;
            if (var10_11) {
                var12_14 = var8_8.getTokenID();
                var16_19 = var8_8.getImage().substring(0, var4_4 - var8_8.getOffset());
                var15_18 = var8_8.getOffset();
            } else {
                var12_14 = var9_10.getTokenID();
                var16_19 = var9_10.getImage().substring(0, var4_4 - var9_10.getOffset());
                var15_18 = var9_10.getOffset();
            }
            if ((var12_14 == HTMLTokenContext.TEXT || var12_14 == HTMLTokenContext.VALUE) && var16_19.endsWith("&")) {
                var13_16 = this.translateCharRefs(var4_4 - var14_17, var14_17, var7_7.getCharRefList(""));
            } else if (var12_14 == HTMLTokenContext.CHARACTER) {
                if (var10_11 || !var16_19.endsWith(";")) {
                    var14_17 = var4_4 - var15_18;
                    var13_16 = this.translateCharRefs(var4_4 - var14_17, var14_17, var7_7.getCharRefList(var16_19.substring(1)));
                }
            } else if (var12_14 == HTMLTokenContext.TAG_OPEN) {
                var14_17 = var4_4 - var15_18 + 1;
                var13_16 = this.translateTags(var15_18 - 1, var14_17, var7_7.getElementList(var16_19));
                if (var13_16.size() == 1 && var16_19.equals(var18_23 = (var17_20 = (TagItem)var13_16.get(0)).getItemText())) {
                    var19_28 = 10;
                    if (var4_4 + var19_28 > var3_3.getLength()) {
                        var19_28 = var3_3.getLength() - var4_4;
                    }
                    if ((var20_31 = var6_6.getTokenChain(var4_4, var4_4 + var19_28)) != null && var20_31.getTokenID().getNumericID() == 2 && (var20_31 = var20_31.getNext()) != null && (var20_31.getTokenID().getNumericID() == 5 || var20_31.getTokenID().getNumericID() == 6)) {
                        var13_16 = null;
                    }
                }
            } else if (var12_14 != HTMLTokenContext.BLOCK_COMMENT && var16_19.endsWith("<")) {
                var13_16 = this.translateTags(var4_4 - var14_17, var14_17, var7_7.getElementList(""));
            } else if (var12_14 == HTMLTokenContext.TEXT && var16_19.endsWith("</")) {
                var14_17 = 2;
                var13_16 = var6_6.getPossibleEndTags(var4_4, "");
            } else if (var12_14 == HTMLTokenContext.TAG_OPEN_SYMBOL && var16_19.endsWith("</")) {
                var14_17 = 2;
                var13_16 = var6_6.getPossibleEndTags(var4_4, "");
            } else if (var12_14 == HTMLTokenContext.TAG_CLOSE) {
                var14_17 = var4_4 - var15_18;
                var13_16 = var6_6.getPossibleEndTags(var4_4, var16_19);
            } else if (var12_14 == HTMLTokenContext.TAG_CLOSE_SYMBOL) {
                var13_16 = var6_6.getAutocompletedEndTag(var4_4);
            } else if (var12_14 == HTMLTokenContext.WS || var12_14 == HTMLTokenContext.ARGUMENT) {
                var17_21 = null;
                try {
                    var17_21 = var6_6.getElementChain(var4_4);
                    if (var17_21 == null || var17_21.getType() == 4 && ">".equals(var17_21.getText())) {
                        var17_21 = var6_6.getElementChain(var4_4 - 1);
                    }
                }
                catch (BadLocationException var18_24) {
                    return null;
                }
                if (var17_21 == null) {
                    return null;
                }
                if (var17_21.getType() == 4) {
                    var18_25 = (SyntaxElement.Tag)var17_21;
                    var19_29 = var18_25.getName().toUpperCase();
                    var20_32 = var7_7.getElement(var19_29);
                    if (var20_32 == null) {
                        return null;
                    }
                    var21_34 = var12_14 == HTMLTokenContext.ARGUMENT ? var16_19 : "";
                    var14_17 = var21_34.length();
                    var22_36 = var20_32.getAttributeList(var21_34);
                    var23_38 = var18_25.getAttributes();
                    v1 = var24_40 = var8_8 == null ? null : var8_8.getImage();
                    if (var24_40 == null) {
                        var24_40 = "";
                    }
                    var13_16 = new ArrayList<E>();
                    for (DTD.Attribute var26_43 : var22_36) {
                        var27_44 = var26_43.getName();
                        if (!var27_44.equals(var21_34) && (var23_38.contains(var27_44.toUpperCase()) || var23_38.contains(var27_44.toLowerCase())) && (!var24_40.equals(var27_44) || var21_34.length() <= 0)) continue;
                        var13_16.add(var26_43);
                    }
                    var13_16 = this.translateAttribs(var4_4 - var14_17, var14_17, var13_16, var20_32);
                }
            } else if (var12_14 == HTMLTokenContext.VALUE || var12_14 == HTMLTokenContext.OPERATOR || var12_14 == HTMLTokenContext.WS && (var10_11 != false ? var9_10 : var9_10.getPrevious()).getTokenID() == HTMLTokenContext.OPERATOR) {
                var17_22 = null;
                try {
                    var17_22 = var6_6.getElementChain(var4_4);
                }
                catch (BadLocationException var18_26) {
                    return null;
                }
                if (var17_22 == null) {
                    return null;
                }
                if (var17_22.getType() == 2 && (var17_22 = var17_22.getPrevious()) == null) {
                    return null;
                }
                if (var17_22.getType() == 4) {
                    var18_27 = (SyntaxElement.Tag)var17_22;
                    var19_30 = var18_27.getName().toUpperCase();
                    var20_33 = var7_7.getElement(var19_30);
                    if (var20_33 == null) {
                        return null;
                    }
                    for (var21_35 = var9_10; var21_35 != null && var21_35.getTokenID() != HTMLTokenContext.ARGUMENT; var21_35 = var21_35.getPrevious()) {
                    }
                    if (var21_35 == null) {
                        return null;
                    }
                    var22_37 = var21_35.getImage().toLowerCase();
                    var23_39 = var20_33.getAttribute(var22_37);
                    if (var23_39 == null || var23_39.getType() != 1) {
                        return null;
                    }
                    if (var12_14 != HTMLTokenContext.VALUE) {
                        var14_17 = 0;
                        var13_16 = this.translateValues(var4_4 - var14_17, var14_17, var23_39.getValueList(""));
                    } else {
                        var14_17 = var4_4 - var15_18;
                        var24_41 = null;
                        if (var16_19 != null && var16_19.length() > 0) {
                            if (var16_19.substring(0, 1).equals("'")) {
                                var24_41 = "'";
                            }
                            if (var16_19.substring(0, 1).equals("\"")) {
                                var24_41 = "\"";
                            }
                        }
                        var13_16 = this.translateValues(var4_4 - var14_17, var14_17, var23_39.getValueList(var24_41 == null ? var16_19 : var16_19.substring(1)), var24_41);
                    }
                }
            }
            if (var13_16 == null) {
                return null;
            }
            return new HTMLCompletionResult(var1_1, "Results for DOCTYPE " + var7_7.getIdentifier(), var13_16, var4_4, var14_17);
        }
        catch (BadLocationException var8_9) {
            var8_9.printStackTrace();
            return null;
        }
    }

    List translateCharRefs(int n, int n2, List list) {
        ArrayList<CharRefItem> arrayList = new ArrayList<CharRefItem>(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = ((DTD.CharRef)iterator.next()).getName();
            arrayList.add(new CharRefItem(string, n, n2, string));
        }
        return arrayList;
    }

    List translateTags(int n, int n2, List list) {
        ArrayList<TagItem> arrayList = new ArrayList<TagItem>(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = ((DTD.Element)iterator.next()).getName();
            arrayList.add(new TagItem(string, n, n2, string));
        }
        return arrayList;
    }

    List translateAttribs(int n, int n2, List list, DTD.Element element) {
        ArrayList<HTMLResultItem> arrayList = new ArrayList<HTMLResultItem>(list.size());
        String string = element.getName() + "#";
        for (DTD.Attribute attribute : list) {
            String string2 = attribute.getName();
            switch (attribute.getType()) {
                case 0: {
                    arrayList.add(new BooleanAttribItem(string2, n, n2, attribute.isRequired(), string + string2));
                    break;
                }
                case 1: {
                    arrayList.add(new SetAttribItem(string2, n, n2, attribute.isRequired(), string + string2));
                    break;
                }
                case 2: {
                    arrayList.add(new PlainAttribItem(string2, n, n2, attribute.isRequired(), string + string2));
                }
            }
        }
        return arrayList;
    }

    List translateValues(int n, int n2, List list) {
        return this.translateValues(n, n2, list, null);
    }

    List translateValues(int n, int n2, List list, String string) {
        if (list == null) {
            return new ArrayList(0);
        }
        ArrayList<ValueItem> arrayList = new ArrayList<ValueItem>(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            arrayList.add(new ValueItem(((DTD.Value)iterator.next()).getName(), n, n2, string));
        }
        return arrayList;
    }

    static {
        DEFAULT = new HTMLCompletionQuery();
    }

    public static class HTMLCompletionResult
    extends CompletionQuery.DefaultResult {
        private int substituteOffset;

        public HTMLCompletionResult(JTextComponent jTextComponent, String string, List list, int n, int n2) {
            super(jTextComponent, string, list, n, n2);
            this.substituteOffset = n - n2;
        }

        public int getSubstituteOffset() {
            return this.substituteOffset;
        }
    }

    private static class ValueItem
    extends HTMLResultItem {
        private String quotationChar = null;

        public ValueItem(String string, int n, int n2, String string2) {
            this(string, n, n2);
            this.quotationChar = string2;
        }

        public ValueItem(String string, int n, int n2) {
            super(string, n, n2);
        }

        @Override
        public CharSequence getInsertPrefix() {
            if (this.quotationChar == null) {
                return super.getInsertPrefix();
            }
            return this.quotationChar + super.getInsertPrefix();
        }

        @Override
        Color getPaintColor() {
            return Color.magenta;
        }

        @Override
        public boolean substituteText(JTextComponent jTextComponent, int n, int n2, boolean bl) {
            String string;
            BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
            boolean bl2 = false;
            try {
                string = baseDocument.getText(jTextComponent.getCaretPosition(), 1);
                bl2 = "\"".equals(string);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            string = this.quotationChar == null ? this.baseText : this.quotationChar + this.baseText + (bl2 ? "" : this.quotationChar);
            this.replaceText(jTextComponent, string);
            return !bl;
        }
    }

    private static class PlainAttribItem
    extends HTMLResultItem {
        boolean required;

        public PlainAttribItem(String string, int n, int n2, boolean bl) {
            super(string, n, n2);
            this.required = bl;
        }

        public PlainAttribItem(String string, int n, int n2, boolean bl, String string2) {
            super(string, n, n2, string2);
            this.required = bl;
        }

        @Override
        Color getPaintColor() {
            return this.required ? Color.red : Color.green.darker();
        }

        @Override
        public boolean substituteText(JTextComponent jTextComponent, int n, int n2, boolean bl) {
            this.replaceText(jTextComponent, this.baseText + "=\"\"");
            Caret caret = jTextComponent.getCaret();
            caret.setDot(caret.getDot() - 1);
            return false;
        }
    }

    private static class BooleanAttribItem
    extends HTMLResultItem {
        boolean required;

        public BooleanAttribItem(String string, int n, int n2, boolean bl) {
            super(string, n, n2);
            this.required = bl;
        }

        public BooleanAttribItem(String string, int n, int n2, boolean bl, String string2) {
            super(string, n, n2, string2);
            this.required = bl;
        }

        @Override
        Color getPaintColor() {
            return this.required ? Color.red : Color.green.darker();
        }

        @Override
        public boolean substituteText(JTextComponent jTextComponent, int n, int n2, boolean bl) {
            this.replaceText(jTextComponent, bl ? this.baseText + " " : this.baseText);
            return false;
        }
    }

    private static class SetAttribItem
    extends HTMLResultItem {
        boolean required;

        public SetAttribItem(String string, int n, int n2, boolean bl) {
            super(string, n, n2);
            this.required = bl;
        }

        public SetAttribItem(String string, int n, int n2, boolean bl, String string2) {
            super(string, n, n2, string2);
            this.required = bl;
        }

        @Override
        Color getPaintColor() {
            return this.required ? Color.red : Color.green.darker();
        }

        @Override
        String getPaintText() {
            return this.baseText;
        }

        @Override
        public String getItemText() {
            return this.baseText;
        }

        @Override
        public boolean substituteText(JTextComponent jTextComponent, int n, int n2, boolean bl) {
            this.replaceText(jTextComponent, this.baseText + "=\"\"");
            Caret caret = jTextComponent.getCaret();
            caret.setDot(caret.getDot() - 1);
            return false;
        }
    }

    private static class TagItem
    extends HTMLResultItem {
        public TagItem(String string, int n, int n2) {
            super(string, n, n2);
        }

        public TagItem(String string, int n, int n2, String string2) {
            super(string, n, n2, string2);
        }

        @Override
        public boolean substituteText(JTextComponent jTextComponent, int n, int n2, boolean bl) {
            this.replaceText(jTextComponent, "<" + this.baseText + (bl ? " >" : ">"));
            if (bl) {
                Caret caret = jTextComponent.getCaret();
                caret.setDot(caret.getDot() - 1);
            }
            return !bl;
        }

        @Override
        Color getPaintColor() {
            return Color.blue;
        }

        @Override
        public String getItemText() {
            return "<" + this.baseText + ">";
        }
    }

    private static class CharRefItem
    extends HTMLResultItem {
        public CharRefItem(String string, int n, int n2) {
            super(string, n, n2);
            this.baseText = string;
        }

        public CharRefItem(String string, int n, int n2, String string2) {
            super(string, n, n2, string2);
            this.baseText = string;
        }

        @Override
        Color getPaintColor() {
            return Color.red.darker();
        }

        @Override
        public CharSequence getSortText() {
            String string = this.getItemText();
            return string.endsWith(";") ? string.substring(0, string.length() - 1) : string;
        }

        @Override
        public String getItemText() {
            return "&" + this.baseText + ";";
        }
    }

    static class EndTagItem
    extends HTMLResultItem {
        private int order = 0;

        public EndTagItem(String string, int n, int n2) {
            super(string, n, n2);
        }

        public EndTagItem(String string, int n, int n2, String string2) {
            super(string, n, n2, string2);
        }

        public EndTagItem(String string, int n, int n2, String string2, int n3) {
            this(string, n, n2, string2);
            this.order = n3;
        }

        @Override
        public CharSequence getSortText() {
            return this.getSortText(this.order);
        }

        private String getSortText(int n) {
            int n2 = n > 100 ? 0 : (n > 10 ? 1 : 2);
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < n2; ++i) {
                stringBuffer.append('0');
            }
            stringBuffer.append("" + n);
            return stringBuffer.toString();
        }

        @Override
        Color getPaintColor() {
            return Color.blue;
        }

        @Override
        public String getItemText() {
            return "</" + this.baseText + ">";
        }

        @Override
        public boolean substituteText(JTextComponent jTextComponent, int n, int n2, boolean bl) {
            return super.substituteText(jTextComponent, n, n2, bl);
        }

        @Override
        protected void reformat(JTextComponent jTextComponent, String string) {
            try {
                BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                ExtFormatter extFormatter = (ExtFormatter)baseDocument.getFormatter();
                int[] nArray = extFormatter.getReformatBlock(jTextComponent, string);
                if (nArray != null) {
                    nArray[0] = Utilities.getRowStart(baseDocument, nArray[0]);
                    nArray[1] = Utilities.getRowEnd(baseDocument, nArray[1]);
                    extFormatter.reformat(baseDocument, nArray[0], nArray[1], true);
                }
            }
            catch (BadLocationException badLocationException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static class AutocompleteEndTagItem
    extends EndTagItem {
        public AutocompleteEndTagItem(String string, int n) {
            this(string, n, true);
        }

        public AutocompleteEndTagItem(String string, int n, boolean bl) {
            super(string, n, 0);
            if (!bl) {
                this.baseText = string;
            }
        }

        @Override
        boolean replaceText(JTextComponent jTextComponent, String string) {
            boolean bl = super.replaceText(jTextComponent, string);
            if (bl) {
                jTextComponent.setCaretPosition(this.offset);
            }
            return bl;
        }

        @Override
        protected void reformat(JTextComponent jTextComponent, String string) {
            try {
                BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                ExtFormatter extFormatter = (ExtFormatter)baseDocument.getFormatter();
                int n = jTextComponent.getCaretPosition();
                extFormatter.reformat(baseDocument, Utilities.getRowStart(baseDocument, n), Utilities.getRowEnd(baseDocument, n), true);
            }
            catch (BadLocationException badLocationException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        public CharSequence getInsertPrefix() {
            return null;
        }
    }

    public static abstract class HTMLResultItem
    implements CompletionQuery.ResultItem {
        String baseText;
        int offset;
        int length;
        String helpID;
        boolean shift = false;
        private HTMLCompletionResultItemPaintComponent component;
        private static final int HTML_ITEMS_SORT_PRIORITY = 20;
        protected int selectionStartOffset = -1;
        protected int selectionEndOffset = -1;
        public static final String COMPLETION_SUBSTITUTE_TEXT = "completion-substitute-text";
        static int substituteOffset = -1;

        public HTMLResultItem(String string, int n, int n2) {
            this.baseText = lowerCase ? string.toLowerCase() : string.toUpperCase();
            this.offset = n;
            this.length = n2;
            this.helpID = null;
        }

        public HTMLResultItem(String string, int n, int n2, String string2) {
            this(string, n, n2);
            this.helpID = string2;
        }

        public int getSortPriority() {
            return 20;
        }

        public CharSequence getSortText() {
            return this.getItemText();
        }

        public CharSequence getInsertPrefix() {
            return this.getItemText();
        }

        public Component getPaintComponent(boolean bl) {
            HTMLCompletionResultItemPaintComponent.StringPaintComponent stringPaintComponent = new HTMLCompletionResultItemPaintComponent.StringPaintComponent(this.getPaintColor());
            stringPaintComponent.setSelected(bl);
            stringPaintComponent.setString(this.getItemText());
            return stringPaintComponent;
        }

        public int getPreferredWidth(Graphics graphics, Font font) {
            Component component = this.getPaintComponent(false);
            return component.getPreferredSize().width;
        }

        public void render(Graphics graphics, Font font, Color color, Color color2, int n, int n2, boolean bl) {
            Component component = this.getPaintComponent(bl);
            component.setFont(font);
            component.setForeground(color);
            component.setBackground(color2);
            component.setBounds(0, 0, n, n2);
            ((HTMLCompletionResultItemPaintComponent)component).paintComponent(graphics);
        }

        protected Object getAssociatedObject() {
            return this.getItemText();
        }

        public int getSubstituteOffset() {
            return substituteOffset;
        }

        public int getImportance() {
            return 0;
        }

        public void processKeyEvent(KeyEvent keyEvent) {
            this.shift = keyEvent.getKeyCode() == 10 && keyEvent.getID() == 401 && keyEvent.isShiftDown();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean replaceText(JTextComponent jTextComponent, String string) {
            BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
            baseDocument.atomicLock();
            try {
                String string2 = baseDocument.getText(this.offset, baseDocument.getLength() - this.offset < string.length() ? baseDocument.getLength() - this.offset : string.length());
                if (!string.equals(string2)) {
                    baseDocument.remove(this.offset, this.length);
                    baseDocument.insertString(this.offset, string, null);
                } else {
                    int n = jTextComponent.getCaret().getDot() + string.length() - this.length;
                    jTextComponent.setCaretPosition(n < baseDocument.getLength() ? n : baseDocument.getLength());
                }
            }
            catch (BadLocationException badLocationException) {
                boolean bl = false;
                return bl;
            }
            finally {
                baseDocument.atomicUnlock();
            }
            return true;
        }

        protected void reformat(JTextComponent jTextComponent, String string) {
        }

        @Override
        public boolean substituteCommonText(JTextComponent jTextComponent, int n, int n2, int n3) {
            String string = this.getItemText().substring(0, n3);
            boolean bl = this.replaceText(jTextComponent, string);
            this.reformat(jTextComponent, string);
            return bl;
        }

        @Override
        public boolean substituteText(JTextComponent jTextComponent, int n, int n2, boolean bl) {
            String string = this.getItemText();
            boolean bl2 = this.replaceText(jTextComponent, string);
            this.reformat(jTextComponent, string);
            return bl2;
        }

        @Override
        public Component getPaintComponent(JList jList, boolean bl, boolean bl2) {
            Component component = this.getPaintComponent(bl);
            if (component == null) {
                return null;
            }
            if (bl) {
                component.setBackground(jList.getSelectionBackground());
                component.setForeground(jList.getSelectionForeground());
            } else {
                component.setBackground(jList.getBackground());
                component.setForeground(jList.getForeground());
            }
            component.getAccessibleContext().setAccessibleName(this.getItemText());
            component.getAccessibleContext().setAccessibleDescription(this.getItemText());
            return component;
        }

        String getPaintText() {
            return this.getItemText();
        }

        abstract Color getPaintColor();

        @Override
        public String getItemText() {
            return this.baseText;
        }

        public String getHelpID() {
            return this.helpID;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            String string = this.getClass().getName();
            string = string.substring(string.lastIndexOf(46) + 1);
            stringBuffer.append(string);
            stringBuffer.append('(');
            stringBuffer.append(this.getItemText());
            stringBuffer.append(';');
            stringBuffer.append(this.getSubstituteOffset());
            stringBuffer.append(';');
            stringBuffer.append(this.getHelpID());
            stringBuffer.append(')');
            return stringBuffer.toString();
        }
    }
}

