/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.fl.i18n;

import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;

public class XMLResourceBundleControl
extends ResourceBundle.Control {
    @Override
    public List<String> getFormats(String string) {
        return Collections.singletonList("xml");
    }

    @Override
    public List<Locale> getCandidateLocales(String string, Locale locale) {
        return Collections.singletonList(locale);
    }

    @Override
    public Locale getFallbackLocale(String string, Locale locale) {
        return null;
    }

    @Override
    public ResourceBundle newBundle(String string, Locale locale, String string2, ClassLoader classLoader, boolean bl) {
        assert (string2.equals("xml"));
        if (string == null) {
            throw new IllegalArgumentException("'catalogID' cannot be null");
        }
        if (locale == null) {
            throw new IllegalArgumentException("'locale' cannot be null");
        }
        return new XMLResourceBundle(string, locale);
    }

    private static native Locale nativeLoadMessageCatalog(String var0, String var1);

    private static native String nativeGetMessageFromCatalog(String var0, String var1, String var2);

    private static native String[] nativeGetKeysFromCatalog(String var0, String var1);

    static {
        System.loadLibrary("nativei18n");
    }

    private static class XMLResourceBundle
    extends ResourceBundle {
        private final String messageCatalogName;
        private final Locale messageCatalogLocale;
        private final Locale obtainedMessageCatalogLocale;

        XMLResourceBundle(String string, Locale locale) {
            this.messageCatalogName = string;
            this.messageCatalogLocale = locale;
            this.obtainedMessageCatalogLocale = XMLResourceBundleControl.nativeLoadMessageCatalog(this.messageCatalogName, this.messageCatalogLocale.toString());
        }

        @Override
        protected Object handleGetObject(String string) {
            try {
                return XMLResourceBundleControl.nativeGetMessageFromCatalog(this.messageCatalogName, string, this.messageCatalogLocale.toString());
            }
            catch (Exception exception) {
                return null;
            }
        }

        @Override
        public Enumeration<String> getKeys() {
            String[] stringArray;
            try {
                stringArray = XMLResourceBundleControl.nativeGetKeysFromCatalog(this.messageCatalogName, this.messageCatalogLocale.toString());
            }
            catch (Exception exception) {
                stringArray = new String[]{};
            }
            return Collections.enumeration(Arrays.asList(stringArray));
        }

        @Override
        public Locale getLocale() {
            return this.obtainedMessageCatalogLocale;
        }
    }
}

