/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolstrip;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.mathworks.desktop.attr.Attribute;
import com.mathworks.desktop.attr.AttributeChangeEvent;
import com.mathworks.desktop.client.BasicClient;
import com.mathworks.desktop.client.Client;
import com.mathworks.desktop.client.ClientCollection;
import com.mathworks.desktop.client.ClientCollectionListener;
import com.mathworks.desktop.client.UniqueClientCollection;
import com.mathworks.desktop.overlay.AnchorPosition;
import com.mathworks.desktop.overlay.Overlay;
import com.mathworks.desktop.overlay.OverlayConstraints;
import com.mathworks.desktop.overlay.OverlayManager;
import com.mathworks.desktop.overlay.OverlayManagers;
import com.mathworks.toolstrip.Toolstrip;
import com.mathworks.toolstrip.ToolstripTab;
import com.mathworks.toolstrip.impl.ToolstripHeaderPanel;
import com.mathworks.toolstrip.plaf.TSLookAndFeel;
import com.mathworks.toolstrip.plaf.ToolstripHeaderUI;
import com.mathworks.toolstrip.plaf.ToolstripTheme;
import com.mathworks.util.Disposable;
import com.mathworks.util.Disposer;
import com.mathworks.util.logger.Log;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class DefaultToolstrip
extends BasicClient
implements Toolstrip,
ClientCollectionListener<ToolstripTab> {
    private static final Log LOG = Log.getInstance((String)"com.mathworks.toolstrip.DefaultToolstrip");
    public static final String TOOLSTRIP_EDGE_PROPERTY_KEY = "toolstrip-edge";
    public static final String TOOLSTRIP_COMPONENT_NAME = "toolstrip";
    public static final String TOOLSTRIP_PROPERTY_KEY = "toolstrip";
    private final ClientCollection<ToolstripTab> fModel = new UniqueClientCollection();
    private ContentPanel fContentPanel;
    private ToolstripHeaderPanel fHeaderPanel;
    private final List<JComponent> fExtraComponents = new ArrayList<JComponent>();
    private Overlay fPopup;

    @Inject
    public DefaultToolstrip() {
        this("toolstrip");
    }

    public DefaultToolstrip(String string) {
        super(string);
        this.fModel.addClientCollectionListener((ClientCollectionListener)this);
    }

    @NotNull
    protected JComponent createComponent() {
        TopLevelPanel topLevelPanel = new TopLevelPanel();
        this.fContentPanel = new ContentPanel();
        this.fHeaderPanel = new ToolstripHeaderPanel(this);
        for (JComponent jComponent : this.fExtraComponents) {
            this.addExtraComponent(jComponent);
        }
        if (!((Boolean)this.getAttribute((Attribute)NO_TABS)).booleanValue()) {
            topLevelPanel.add((Component)this.fHeaderPanel, "North");
        }
        for (int i = 0; i < this.fModel.size(); ++i) {
            this.fHeaderPanel.addTab(i, (ToolstripTab)this.fModel.get(i));
        }
        this.updateContent(topLevelPanel);
        topLevelPanel.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                Window window = SwingUtilities.windowForComponent(hierarchyEvent.getComponent());
                if (window instanceof RootPaneContainer) {
                    ((RootPaneContainer)((Object)window)).getRootPane().putClientProperty("toolstrip", DefaultToolstrip.this);
                }
            }
        });
        return topLevelPanel;
    }

    private void updateContent(JComponent jComponent) {
        Disposer.dispose((Disposable)this.fPopup);
        switch ((Toolstrip.State)((Object)this.getAttribute((Attribute)STATE))) {
            case COLLAPSED: {
                jComponent.remove(this.fContentPanel);
                break;
            }
            case EXPANDED_AS_POPUP: {
                OverlayManager overlayManager = OverlayManagers.get((Component)jComponent);
                if (overlayManager == null) break;
                jComponent.remove(this.fContentPanel);
                if (!this.fContentPanel.isContentSet()) {
                    this.setCurrentTabContent();
                }
                this.fContentPanel.setSizeFromParent(jComponent);
                this.fPopup = overlayManager.addOverlay((Component)this.fContentPanel, OverlayConstraints.popup((Component)this.fHeaderPanel, (AnchorPosition)AnchorPosition.SOUTHWEST, (int)0, (int)0, (int)-1, (int)this.fContentPanel.getHeight()));
                Disposer.register((Disposable)new Disposable(){

                    public void dispose() {
                        DefaultToolstrip.this.fPopup = null;
                        if (DefaultToolstrip.this.getAttribute((Attribute)Toolstrip.STATE) == Toolstrip.State.EXPANDED_AS_POPUP) {
                            DefaultToolstrip.this.setAttribute((Attribute)Toolstrip.STATE, (Object)Toolstrip.State.COLLAPSED);
                        }
                    }
                }, (Disposable)this.fPopup);
                break;
            }
            case EXPANDED: {
                if (!jComponent.isAncestorOf(this.fContentPanel)) {
                    jComponent.add((Component)this.fContentPanel, "Center");
                }
                this.setCurrentTabContent();
            }
        }
    }

    private void setCurrentTabContent() {
        ToolstripTab toolstripTab = (ToolstripTab)this.getModel().get(this.getCurrentTab());
        if (toolstripTab != null) {
            this.setContent(toolstripTab);
        }
    }

    public void clientAdded(ClientCollectionListener.Added<ToolstripTab> added) {
        ToolstripTab toolstripTab = (ToolstripTab)added.getClient();
        Toolstrip toolstrip = toolstripTab.getToolstrip();
        if (toolstrip != null) {
            toolstrip.getModel().remove((Client)toolstripTab);
        }
        Preconditions.checkNotNull((Object)toolstripTab.getAttribute(Client.TITLE), (Object)"TITLE attribute is required, but missing");
        toolstripTab.setToolstrip(this);
        if (this.isComponentCreated()) {
            this.fHeaderPanel.addTab(added.getIndex(), toolstripTab);
            if (this.getCurrentTab().equals(toolstripTab.getName())) {
                this.setContent(toolstripTab);
            }
            this.refresh();
        }
    }

    public void clientRemoved(ClientCollectionListener.Removed<ToolstripTab> removed) {
        ToolstripTab toolstripTab = (ToolstripTab)removed.getClient();
        Preconditions.checkArgument((toolstripTab.getToolstrip() == this ? 1 : 0) != 0, (String)"Attempt to remove tab '%s' from wrong toolstrip", (Object[])new Object[]{toolstripTab.getName()});
        toolstripTab.setToolstrip(null);
        if (this.isComponentCreated()) {
            this.fHeaderPanel.removeTab(removed.getIndex(), toolstripTab);
            if (this.getCurrentTab().equals(toolstripTab.getName())) {
                if (this.getModel().size() == 0) {
                    this.fContentPanel.setContent(new JPanel());
                } else {
                    this.setAttribute(SELECTED_TAB, ((ToolstripTab)this.getModel().get(Math.max(removed.getIndex() - 1, 0))).getName());
                }
            }
            this.refresh();
        }
    }

    public void clientMoved(ClientCollectionListener.Moved<ToolstripTab> moved) {
        ToolstripTab toolstripTab = (ToolstripTab)moved.getClient();
        Preconditions.checkArgument((toolstripTab.getToolstrip() == this ? 1 : 0) != 0, (String)"Attempt to move tab '%s' within wrong toolstrip", (Object[])new Object[]{toolstripTab.getName()});
        if (this.isComponentCreated()) {
            Component component = this.fHeaderPanel.getComponent(moved.getIndex());
            this.fHeaderPanel.remove(moved.getIndex());
            this.fHeaderPanel.add(component, moved.getDstIndex());
            this.refresh();
        }
    }

    private void setContent(ToolstripTab toolstripTab) {
        this.fContentPanel.setContent(toolstripTab.getComponent());
    }

    public JComponent getContentPanel() {
        return this.fContentPanel;
    }

    public int getHeaderHeight() {
        return this.fHeaderPanel.getHeight();
    }

    public int getContentHeight() {
        return this.fContentPanel.getHeight();
    }

    @Override
    public void addActionsPanel(JComponent jComponent) {
        this.addTabNeighbor(jComponent, 4);
    }

    @Override
    public void addTabNeighbor(JComponent jComponent, int n) {
        jComponent.putClientProperty(TOOLSTRIP_EDGE_PROPERTY_KEY, n);
        this.fExtraComponents.add(jComponent);
        if (this.isComponentCreated()) {
            this.addExtraComponent(jComponent);
            this.fHeaderPanel.revalidate();
            this.fHeaderPanel.repaint();
        }
    }

    @Override
    public JComponent[] getTabNeighbors(int n) {
        ArrayList<JComponent> arrayList = new ArrayList<JComponent>(this.fExtraComponents.size());
        for (JComponent jComponent : this.fExtraComponents) {
            Integer n2 = (Integer)jComponent.getClientProperty(TOOLSTRIP_EDGE_PROPERTY_KEY);
            if (n2 == null || n2 != n) continue;
            arrayList.add(jComponent);
        }
        return arrayList.toArray(new JComponent[arrayList.size()]);
    }

    private void addExtraComponent(JComponent jComponent) {
        this.fHeaderPanel.add(jComponent);
    }

    @Override
    public void removeTabNeighbor(JComponent jComponent) {
        this.fExtraComponents.remove(jComponent);
        if (this.isComponentCreated()) {
            this.fHeaderPanel.remove(jComponent);
            this.fHeaderPanel.revalidate();
            this.fHeaderPanel.repaint();
        }
    }

    @Override
    public void removeActionsPanel(JComponent jComponent) {
        this.removeTabNeighbor(jComponent);
    }

    protected void processAttributeChange(AttributeChangeEvent attributeChangeEvent) {
        Attribute attribute = attributeChangeEvent.getAttribute();
        if (attribute == SELECTED_TAB) {
            if (this.isComponentCreated()) {
                ToolstripTab toolstripTab = (ToolstripTab)this.getModel().get((String)attributeChangeEvent.getNewValue());
                if (toolstripTab != null) {
                    this.setContent(toolstripTab);
                } else {
                    LOG.warn("Selected missing tab %s", new Object[]{attributeChangeEvent.getNewValue()});
                }
                this.refresh();
            }
        } else if (attribute == STATE) {
            if (this.isComponentCreated()) {
                this.updateContent(this.getComponent());
                this.refresh();
            }
        } else if (attribute == COLLAPSABLE) {
            if (this.isComponentCreated()) {
                if (((Boolean)attributeChangeEvent.getNewValue()).booleanValue()) {
                    if (((Boolean)this.getAttribute((Attribute)NO_TABS)).booleanValue()) {
                        this.setAttribute((Attribute)COLLAPSABLE, false);
                        throw new IllegalArgumentException("Attribute COLLAPSIBLE cannot be set to true while toolstrip is in NO_TABS state");
                    }
                } else {
                    this.setAttribute((Attribute)STATE, (Object)Toolstrip.State.EXPANDED);
                }
                this.refresh();
            }
        } else if (attribute == NO_TABS && this.isComponentCreated()) {
            if (((Boolean)attributeChangeEvent.getNewValue()).booleanValue()) {
                if (((Boolean)this.getAttribute((Attribute)COLLAPSABLE)).booleanValue()) {
                    this.setAttribute((Attribute)NO_TABS, false);
                    throw new IllegalArgumentException("Attribute NO_TABS cannot be set to true while toolstrip is in COLLAPSIBLE state");
                }
                this.getComponent().remove(this.fHeaderPanel);
            } else if (this.fHeaderPanel.getParent() == null) {
                this.getComponent().add((Component)this.fHeaderPanel, "North");
            }
            this.refresh();
        }
    }

    @Override
    @NotNull
    public String getCurrentTab() {
        String string = (String)this.getAttribute(SELECTED_TAB);
        return string == null ? "" : string;
    }

    @Override
    public boolean setCurrentTab(@NotNull String string) {
        boolean bl;
        boolean bl2 = bl = this.getModel().get(string) != null;
        if (bl) {
            this.setAttribute(SELECTED_TAB, string);
        }
        return bl;
    }

    @Override
    @NotNull
    public ClientCollection<ToolstripTab> getModel() {
        return this.fModel;
    }

    static {
        TSLookAndFeel.install();
    }

    public class ContentPanel
    extends JPanel {
        private int fToolstripHeight;
        private Dimension fSizeFromParent;

        private ContentPanel() {
            super(null);
            this.setOpaque(false);
            this.fToolstripHeight = ToolstripTheme.getInstance().getToolstripHeight();
            this.setName("toolstrip.content");
            this.enableEvents(16L);
        }

        void setContent(JComponent jComponent) {
            this.removeAll();
            this.add(jComponent);
            this.revalidate();
            this.repaint();
        }

        @Override
        public void paint(Graphics graphics) {
            super.paint(graphics);
            if (((Toolstrip.State)((Object)DefaultToolstrip.this.getAttribute((Attribute)Toolstrip.STATE))).equals((Object)Toolstrip.State.EXPANDED_AS_POPUP)) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                Point point = this.getLocation();
                graphics2D.setPaint(new GradientPaint(point.x, this.fSizeFromParent.height - 10, Color.DARK_GRAY, point.x, this.fSizeFromParent.height, Color.WHITE));
                graphics2D.fillRect(point.x, this.fSizeFromParent.height - 10, this.fSizeFromParent.width, this.fSizeFromParent.height);
            }
        }

        public boolean isContentSet() {
            return this.getComponentCount() > 0;
        }

        public void setSizeFromParent(JComponent jComponent) {
            this.fSizeFromParent = new Dimension(jComponent.getWidth(), this.fToolstripHeight + 10);
            this.setSize(this.fSizeFromParent);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(this.getParent().getWidth(), this.fToolstripHeight);
        }

        @Override
        public void layout() {
            if (this.getComponentCount() > 0) {
                Component component;
                int n = this.getWidth();
                int n2 = this.fToolstripHeight;
                int n3 = 0;
                if (this.getComponentCount() > 1) {
                    component = this.getComponent(0);
                    Dimension dimension = component.getPreferredSize();
                    component.setBounds(n - dimension.width, n2 - dimension.height, dimension.width, dimension.height);
                    ++n3;
                }
                component = this.getComponent(n3);
                component.setBounds(0, 0, n, n2);
            }
        }
    }

    private class TopLevelPanel
    extends JPanel {
        private TopLevelPanel() {
            super(new BorderLayout());
            this.setFocusable(false);
        }

        @Override
        public void addNotify() {
            super.addNotify();
            ((ToolstripHeaderUI)DefaultToolstrip.this.fHeaderPanel.getUI()).enableMnemonics();
        }

        @Override
        public void removeNotify() {
            ((ToolstripHeaderUI)DefaultToolstrip.this.fHeaderPanel.getUI()).disableMnemonics();
            super.removeNotify();
        }
    }
}

