/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolstrip.components.gallery.popupview;

import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.PopupMenuCustomizer;
import com.mathworks.toolstrip.accessories.TSContextMenuContributor;
import com.mathworks.toolstrip.components.gallery.GalleryResources;
import com.mathworks.toolstrip.components.gallery.model.Category;
import com.mathworks.toolstrip.components.gallery.model.GalleryModel;
import com.mathworks.toolstrip.components.gallery.model.Item;
import com.mathworks.toolstrip.components.gallery.popupview.GalleryPopupView;
import com.mathworks.toolstrip.components.gallery.popupview.GallerySelectionModel;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

abstract class CategoryContentPanel
extends MJPanel
implements TSContextMenuContributor {
    protected final Category fCategory;
    protected final GalleryModel fModel;
    protected final GallerySelectionModel fSelectionModel;
    protected final PopupMenuCustomizer fMenuCustomizer;
    protected Runnable fFavoritesAnimation;

    CategoryContentPanel(Category category, GalleryModel galleryModel, GallerySelectionModel gallerySelectionModel, PopupMenuCustomizer popupMenuCustomizer, Runnable runnable) {
        this.fCategory = category;
        this.fModel = galleryModel;
        this.fSelectionModel = gallerySelectionModel;
        this.fMenuCustomizer = popupMenuCustomizer;
        this.fFavoritesAnimation = runnable;
    }

    abstract void setActionListener(ActionListener var1);

    abstract void setCloseListener(ActionListener var1);

    abstract Item getItemAtPoint(Point var1);

    void setDragEnabled(boolean bl) {
    }

    public abstract void dispose();

    abstract Component getComponentForItem(Item var1);

    abstract Item getNextItem(Item var1);

    abstract Item getPreviousItem(Item var1);

    @Override
    public void contributeToToolsripContextMenu(JPopupMenu jPopupMenu, MouseEvent mouseEvent) {
        Point point = SwingUtilities.convertPoint(mouseEvent.getComponent(), mouseEvent.getPoint(), (Component)((Object)this));
        Item item = this.getItemAtPoint(point);
        if (item != null) {
            TSContextMenuContributor tSContextMenuContributor;
            jPopupMenu.insert((Action)((Object)new FavoriteAction(item)), 0);
            Action action = item.getAction();
            if (action != null && (tSContextMenuContributor = (TSContextMenuContributor)action.getValue("toolstrip-context-menu-contributor")) != null) {
                tSContextMenuContributor.contributeToToolsripContextMenu(jPopupMenu, mouseEvent);
            }
        }
        if (this.fMenuCustomizer != null) {
            this.fMenuCustomizer.customize(jPopupMenu);
        }
        jPopupMenu.putClientProperty("retain-overlays", true);
    }

    private class FavoriteAction
    extends MJAbstractAction {
        private Item iItem;

        FavoriteAction(Item item) {
            this.iItem = item;
            if (CategoryContentPanel.this.fModel.isFavorite(item)) {
                this.setComponentName("RemoveFavorite");
                this.putValue("Name", GalleryResources.getString("favorite.remove.menuitem"));
            } else {
                this.setComponentName("RemoveFavorite");
                this.putValue("Name", GalleryResources.getString("favorite.add.menuitem"));
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (CategoryContentPanel.this.fModel.isFavorite(this.iItem)) {
                if (CategoryContentPanel.this.fFavoritesAnimation instanceof GalleryPopupView.FavoriteAnimation) {
                    ((GalleryPopupView.FavoriteAnimation)((Object)CategoryContentPanel.this.fFavoritesAnimation)).setItem(this.iItem);
                    ((GalleryPopupView.FavoriteAnimation)((Object)CategoryContentPanel.this.fFavoritesAnimation)).setMoveTo(false);
                    CategoryContentPanel.this.fFavoritesAnimation.run();
                }
            } else if (CategoryContentPanel.this.fFavoritesAnimation instanceof GalleryPopupView.FavoriteAnimation) {
                ((GalleryPopupView.FavoriteAnimation)((Object)CategoryContentPanel.this.fFavoritesAnimation)).setItem(this.iItem);
                ((GalleryPopupView.FavoriteAnimation)((Object)CategoryContentPanel.this.fFavoritesAnimation)).setMoveTo(true);
                CategoryContentPanel.this.fFavoritesAnimation.run();
            }
        }
    }
}

