/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolstrip.factory;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.mathworks.mwswing.ChildAction;
import com.mathworks.toolstrip.components.popups.ListItem;
import com.mathworks.toolstrip.factory.TSFactory;
import com.mathworks.toolstrip.factory.TSToolSet;
import com.mathworks.toolstrip.factory.TSToolSetContents;
import com.mathworks.util.Pair;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Action;

public class ContextTargetingManager {
    public static final String TOOL_NAME_KEY = "toolName";
    public static final String PROPERTIES_TO_INJECT_KEY = "properties-to-set";
    private final ListMultimap<String, ActionTrigger> fNameToTriggerMap = ArrayListMultimap.create();
    private final Deque<RestoreData> fRestoreList = new ArrayDeque<RestoreData>();
    private final HashMap<String, Action> fContextActionMap = new HashMap();
    private List<TSToolSet> fContextToolSets = new ArrayList<TSToolSet>();

    public void register(String string, AbstractButton abstractButton) {
        this.register(string, new ButtonTrigger(abstractButton));
    }

    public void register(String string, ListItem listItem) {
        this.register(string, new ListItemTrigger(listItem));
    }

    private void register(String string, ActionTrigger actionTrigger) {
        Action action;
        this.fNameToTriggerMap.put((Object)string, (Object)actionTrigger);
        Action action2 = this.fContextActionMap.get(string);
        if (action2 != null && (action = actionTrigger.getAction()) != null) {
            this.fRestoreList.add(new RestoreData(action, actionTrigger, string));
            actionTrigger.setAction(ContextTargetingManager.mergeActions(action2, action));
        }
    }

    public void unregister(String string, AbstractButton abstractButton) {
        this.unregister(string, new ButtonTrigger(abstractButton));
    }

    public void unregister(String string, ListItem listItem) {
        this.unregister(string, new ListItemTrigger(listItem));
    }

    private void unregister(String string, ActionTrigger actionTrigger) {
        this.fNameToTriggerMap.remove((Object)string, (Object)actionTrigger);
    }

    public void inject(List<Action> list) {
        if (!this.fRestoreList.isEmpty()) {
            this.restore();
        }
        if (!this.fContextToolSets.isEmpty()) {
            this._inject(ContextTargetingManager.getCommonActions(this.fContextToolSets));
        }
        this._inject(list);
    }

    public void restore() {
        Iterator<RestoreData> iterator = this.fRestoreList.descendingIterator();
        while (iterator.hasNext()) {
            RestoreData restoreData = iterator.next();
            ContextTargetingManager.restoreAction(restoreData.iInjectedTrigger, restoreData.iOriginalAction);
        }
        this.fRestoreList.clear();
        this.fContextActionMap.clear();
    }

    private static void restoreAction(ActionTrigger actionTrigger, Action action) {
        Action action2 = actionTrigger.getAction();
        actionTrigger.setAction(action);
        if (action2 instanceof TaggedChildAction) {
            ((ChildAction)action2).setParent(null);
        }
    }

    public void setContextToolSets(List<TSToolSet> list) {
        this.removeToolSets();
        if (list != null) {
            this.fContextToolSets.addAll(list);
            this._inject(ContextTargetingManager.getCommonActions(this.fContextToolSets));
        }
    }

    private void _inject(List<Action> list) {
        for (Action action : list) {
            String string = ContextTargetingManager.getToolName(action);
            this.fContextActionMap.put(string, action);
            for (ActionTrigger actionTrigger : this.fNameToTriggerMap.get((Object)string)) {
                Action action2 = actionTrigger.getAction();
                if (action2 == null) continue;
                this.fRestoreList.add(new RestoreData(action2, actionTrigger, string));
                actionTrigger.setAction(ContextTargetingManager.mergeActions(action, action2));
            }
        }
    }

    private void removeToolSets() {
        if (!this.fContextToolSets.isEmpty()) {
            Iterator<RestoreData> iterator = this.fRestoreList.descendingIterator();
            while (iterator.hasNext()) {
                RestoreData restoreData = iterator.next();
                Action action = restoreData.iInjectedTrigger.getAction();
                if (action instanceof TaggedChildAction) {
                    action = ((ChildAction)action).getParent();
                }
                if (!ContextTargetingManager.toolSetsHaveAction(this.fContextToolSets, action, restoreData.iToolName)) continue;
                ContextTargetingManager.restoreAction(restoreData.iInjectedTrigger, restoreData.iOriginalAction);
                this.fContextActionMap.remove(restoreData.iToolName);
                iterator.remove();
            }
            this.fContextToolSets.clear();
        }
    }

    Action getContextualAction(String string, Action action) {
        Action action2 = this.fContextActionMap.get(string);
        return action2 == null ? action : ContextTargetingManager.mergeActions(action2, action);
    }

    Pair<TSToolSetContents.Tool, Map<String, TSToolSet>> contributeTo(TSToolSetContents.Tool tool, Map<String, TSToolSet> map) {
        TSToolSetContents.Tool tool2 = tool;
        Map<String, TSToolSet> map2 = map;
        for (TSToolSet tSToolSet : this.fContextToolSets) {
            TSToolSetContents.Tool tool3 = tool2;
            tool2 = tSToolSet.getContents().contributeTo(tool2);
            if (tool2 == tool3) continue;
            if (map2 == map) {
                map2 = new HashMap<String, TSToolSet>(map);
            }
            map2.put(tSToolSet.getName(), tSToolSet);
        }
        return new Pair((Object)tool2, map2);
    }

    private static Action mergeActions(Action action, Action action2) {
        String[] stringArray = (String[])action.getValue(PROPERTIES_TO_INJECT_KEY);
        List<String> list = stringArray != null ? Arrays.asList(stringArray) : Collections.EMPTY_LIST;
        TaggedChildAction taggedChildAction = new TaggedChildAction(action);
        if (!list.contains("Name")) {
            taggedChildAction.putValue("Name", action2.getValue("Name"));
        }
        if (!list.contains("SmallIcon")) {
            taggedChildAction.putValue("SmallIcon", action2.getValue("SmallIcon"));
        }
        if (!list.contains("ShortDescription")) {
            taggedChildAction.putValue("ShortDescription", action2.getValue("shortcut-free-description"));
        }
        if (!list.contains("buttonIcon")) {
            taggedChildAction.putValue("buttonIcon", ChildAction.NULL_VALUE);
        }
        taggedChildAction.putValue("ComponentName", ChildAction.NULL_VALUE);
        return taggedChildAction;
    }

    public static void setToolName(Action action, String string) {
        action.putValue(TOOL_NAME_KEY, string);
    }

    public static String getToolName(Action action) {
        return (String)action.getValue(TOOL_NAME_KEY);
    }

    public static void setPropertiesToInject(Action action, String ... stringArray) {
        action.putValue(PROPERTIES_TO_INJECT_KEY, stringArray);
    }

    private static List<Action> getCommonActions(Collection<TSToolSet> collection) {
        ArrayList<Action> arrayList = new ArrayList<Action>();
        for (TSToolSet tSToolSet : collection) {
            for (Map.Entry<String, Action> entry : tSToolSet.getActions()) {
                String string = entry.getKey();
                TSToolSetContents.Tool tool = tSToolSet.getContents().getTool(string);
                if (tool == null || !tool.isCommon()) continue;
                Action action = entry.getValue();
                ContextTargetingManager.setToolName(action, string);
                arrayList.add(action);
            }
        }
        return arrayList;
    }

    private static boolean toolSetsHaveAction(Collection<TSToolSet> collection, Action action, String string) {
        for (TSToolSet tSToolSet : collection) {
            if (action != tSToolSet.getAction(string)) continue;
            return true;
        }
        return false;
    }

    private static class TaggedChildAction
    extends ChildAction {
        TaggedChildAction(Action action) {
            super(action);
        }
    }

    private static class ListItemTrigger
    implements ActionTrigger {
        private final ListItem iItem;

        private ListItemTrigger(ListItem listItem) {
            this.iItem = listItem;
        }

        @Override
        public void setAction(Action action) {
            this.iItem.getAttributes().setAttribute(TSFactory.ACTION_ATTRIBUTE, (Object)action);
        }

        @Override
        public Action getAction() {
            return (Action)this.iItem.getAttributes().getAttribute(TSFactory.ACTION_ATTRIBUTE);
        }

        public boolean equals(Object object) {
            return object instanceof ListItemTrigger && ((ListItemTrigger)object).iItem == this.iItem;
        }

        public int hashCode() {
            return this.iItem.hashCode();
        }
    }

    private static class ButtonTrigger
    implements ActionTrigger {
        private final AbstractButton iButton;

        private ButtonTrigger(AbstractButton abstractButton) {
            this.iButton = abstractButton;
        }

        @Override
        public void setAction(Action action) {
            this.iButton.setAction(action);
        }

        @Override
        public Action getAction() {
            return this.iButton.getAction();
        }

        public boolean equals(Object object) {
            return object instanceof ButtonTrigger && ((ButtonTrigger)object).iButton == this.iButton;
        }

        public int hashCode() {
            return this.iButton.hashCode();
        }
    }

    private static class RestoreData {
        private final Action iOriginalAction;
        private final ActionTrigger iInjectedTrigger;
        private final String iToolName;

        RestoreData(Action action, ActionTrigger actionTrigger, String string) {
            this.iOriginalAction = action;
            this.iInjectedTrigger = actionTrigger;
            this.iToolName = string;
        }
    }

    private static interface ActionTrigger {
        public void setAction(Action var1);

        public Action getAction();
    }
}

